#pragma once

#include "Player_Common.h"

enum eCOMMU_LIFE
{
	eCOMMU_LIFE_REST = 1,
	eCOMMU_LIFE_PARTY,
	eCOMMU_LIFE_TRADE,
	eCOMMU_LIFE_STREETSTALL,
	eCOMMU_LIFE_DUEL,
	eCOMMU_LIFE_ENHANCED,
	eCOMMU_LIFE_PUTCARD,
	eCOMMU_LIFE_TAROT,
	eCOMMU_LIFE_STREETSTALL_FIND,	///  ˻
	eCOMMU_LIFE_TITLE,
	eCOMMU_LIFE_ITEMMIX,
};

#ifdef _CLIENT
	struct sCommunitySkillInfo
	{
		unsigned long	mIndex;			/// з ȣ
		unsigned char	mType;			/// Ÿ 0:Ȱ, 1:
		unsigned long	mRoleIndex;		/// type  ɾ 
		unsigned long	mIconIndex;		/// ųâ ǥ  ȣ
		unsigned long	mCommandIndex[5];	/// ä ɾ ε ( interface msg )
		unsigned long	mTooltipIndex;	///  ε ( tooltip msg )

		///  ǥ ġ
		unsigned int	mPosX;
		unsigned int	mPosY;

		float			mAnimationTime[eGENDER_MAX * eRACE_MAX];	/// 
	};
#else
	struct sCommunitySkillInfo
	{
		unsigned long	mIndex;			/// з ȣ
		unsigned char	mType;			/// Ÿ 0:Ȱ, 1:
//		unsigned long	mRoleIndex;		/// type  ɾ 
//		unsigned long	mIconIndex;		/// ųâ ǥ  ȣ
//		unsigned long	mCommandIndex[5];	/// ä ɾ ε ( interface msg )
//		unsigned long	mTooltipIndex;	///  ε ( tooltip msg )

		///  ǥ ġ
//		unsigned int	mPosX;
//		unsigned int	mPosY;

		float			mAnimationTime[eGENDER_MAX * eRACE_MAX];	/// 
	};
#endif


class cCommunityScript
{
public:
	static cCommunityScript*	 mpCommunityScript;

public:
	cCommunityScript();
	~cCommunityScript();

	///	ʱȭ
	bool					Init();
	/// ü  ޸ 
	void					Release();

	enum
	{
		COMMUNITY_LIFE = 0,
		COMMUNITY_EMOTE,
	};

	typedef tPointerHashMap<unsigned long, void*> cComHashMap;
	inline cComHashMap* GetComSkillMap() { return &mComSkillMap; }

	sCommunitySkillInfo* GetCommunityInfo( unsigned long idx );

	float GetEmotingMaintainTime( unsigned long commIndex, unsigned char race, unsigned char gender );

protected:

	/// data loading
#ifdef _CLIENT
	bool CommunitySkillScriptLoad_Client();
#endif
	bool CommunitySkillScriptLoad_Server();

protected:
	cComHashMap		mComSkillMap;
};

inline 
sCommunitySkillInfo* cCommunityScript::GetCommunityInfo( unsigned long idx )
{
	return (sCommunitySkillInfo*)mComSkillMap.GetAt( idx );
}

inline 
float cCommunityScript::GetEmotingMaintainTime( unsigned long commIndex, unsigned char race, unsigned char gender )
{
	sCommunitySkillInfo* pInfo = GetCommunityInfo( commIndex );
	if( pInfo == 0 )
		return 0.0f;
	if( pInfo->mType == 0 )
		return 0.0f;

	unsigned int key = race * eGENDER_MAX + gender;
	if( key >= eGENDER_MAX * eRACE_MAX )
	{
		assert(0);
		return 0.0f;
	}

	return pInfo->mAnimationTime[race * eGENDER_MAX + gender];
}

#define COMMUNITYSCRIPT cCommunityScript::mpCommunityScript