#include "stdafx.h"
#include "GameFile.h"


cGameFile::cGameFile()
{
	mfp = NULL;
	mMode = eFILE_MODE_TXT;
}

cGameFile::~cGameFile()
{
	CloseGameFile();
}

/* ------------------------------------------------------------------
* Լ̸ :	
*      :	
* ǻ :	
* ------------------------------------------------------------------ */
bool cGameFile::OpenGameFile( const char* pfilename, int mode /* = eFILE_MODE_TXT  */ )
{
	mMode = mode;
	switch( mMode )
	{
	case eFILE_MODE_TXT:
		{
            mfp = fopen( pfilename, "r" );
			if( !mfp )	return false;
		}
		break;
	case eFILE_MODE_BIN:
		break;
	}

	return true;
}

/* ------------------------------------------------------------------
 * Լ̸ :	
 *      :	
 * ǻ :	
 * ------------------------------------------------------------------ */
void cGameFile::CloseGameFile()
{
	if( mfp )
	{
		switch( mMode )
		{
		case eFILE_MODE_TXT:
			{
				fclose( mfp );
			}
			break;
		case eFILE_MODE_BIN:
			break;
		}
	}

	mfp = NULL;
	mMode = eFILE_MODE_TXT;
}

/* ------------------------------------------------------------------
 * Լ̸ :	
 *      :	
 * ǻ :	
 * ------------------------------------------------------------------ */
int cGameFile::GetInt()
{
	return atoi( GetString() );
}

/* ------------------------------------------------------------------
 * Լ̸ :	
 *      :	
 * ǻ :	
 * ------------------------------------------------------------------ */
short cGameFile::GetShort()
{
	return (short)atoi( GetString() );
}

/* ------------------------------------------------------------------
 * Լ̸ :	
 *      :	
 * ǻ :	
 * ------------------------------------------------------------------ */
char cGameFile::GetBYTE()
{
	return (char)atoi( GetString() );
}

/* ------------------------------------------------------------------
 * Լ̸ :	
 *      :	
 * ǻ :	
 * ------------------------------------------------------------------ */
bool cGameFile::GetBOOL()
{
	return atoi( GetString() )?true:false;
}

/* ------------------------------------------------------------------
 * Լ̸ :	
 *      :	
 * ǻ :	
 * ------------------------------------------------------------------ */
unsigned short cGameFile::GetWORD()
{
	return (unsigned short)atoi( GetString() );
}

/* ------------------------------------------------------------------
 * Լ̸ :	
 *      :	
 * ǻ :	
 * ------------------------------------------------------------------ */
unsigned long cGameFile::GetDWORD()
{
	return (unsigned long)atoi( GetString() );
}

/* ------------------------------------------------------------------
 * Լ̸ :	
 *      :	
 * ǻ :	
 * ------------------------------------------------------------------ */
float cGameFile::GetFloat()
{
	return (float)atof( GetString() );
}

/* ------------------------------------------------------------------
 * Լ̸ :	
 *      :	
 * ǻ :	
 * ------------------------------------------------------------------ */
double cGameFile::GetDouble()
{
	return (double)atof( GetString() );
}

/* ------------------------------------------------------------------
 * Լ̸ :	
 *      :	
 * ǻ :	
 * ------------------------------------------------------------------ */
char* cGameFile::GetString()
{
	static char buf[512] = {0,};

	switch( mMode )
	{
	case eFILE_MODE_TXT:
		{
			fscanf( mfp, "%s", buf );
		}
		break;
	case eFILE_MODE_BIN:
		{

		}
		break;
	}

	return buf;
}

/* ------------------------------------------------------------------
 * Լ̸ :	
 *      :	
 * ǻ :	
 * ------------------------------------------------------------------ */
/*
char* cGameFile::GetStringInQuotation()
{
	static char buf[512] = {0,};
	int c = 0;

	switch( mMode )
	{
	case eFILE_MODE_TXT:
		{
			int count = 0;
			while( (c = fgetc(mfp)) != '"' )
			{
				count++;
				if(count > 1000)
				{
					assert(0 && "Do script file " 
				}
			}
			int i = 0;
			while( !feof(mfp) )
			{
				buf[i] = (char)fgetc( mfp );
				if( buf[i] == '"' )
				{
					buf[i] = 0;
					fgetc( mfp );
					return buf;
				}
				++i;
			}
		}
		break;
	}

	return buf;
}
*/

/* ------------------------------------------------------------------
 * Լ̸ :	
 *      :	
 * ǻ :	
 * ------------------------------------------------------------------ */
bool cGameFile::IsEOF()
{
	switch( mMode )
	{
	case eFILE_MODE_TXT:	
		{
			return feof(mfp)?true:false;
		}
		break;
	case eFILE_MODE_BIN:
		break;
	}
	return TRUE;
}

/* --------------------------------------------------------------------------
* Լ̸ : GetLineX
*      :   (ּ ó Ҷ)
* ǻ :
*---------------------------------------------------------------------------*/
void cGameFile::GetLineX(char * pBuf, int len)
{
	switch( mMode )
	{
	case eFILE_MODE_TXT:	
		{
			fgets(pBuf, len, mfp);
		}
		break;
	case eFILE_MODE_BIN:
		break;
	}

}