/* ==========================================================================
*      : Guild_Common.h
*      : 
*    : 谡
*    : 2008-10-31
* ǻ :
*===========================================================================*/
#pragma once
#pragma pack(push,1)

#include "CommonDefines.h"
#include "CommonNetworkMsgStruct.h"
#include "Item_Common.h"
#include "sqltypes.h"

#define	MAX_GUILD	50				///  ִ  
#define	GUILDLIMIT_LEVEL	10		/// 带   ִ 
#define	GUILDLIMIT_MONEY	10000	/// 带   ִ ݾ
#define MARK_WIDTH	24
#define MARK_HEIGHT	24
#define MARK_BPP	32
#define MARK_HEADER_SIZE	18		/// 
#define TGA_EXTENSION		26		/// TGA   Ȯ κ
#define MARK_SIZE	(MARK_WIDTH*MARK_HEIGHT*(MARK_BPP/8) + MARK_HEADER_SIZE + TGA_EXTENSION)

///  
enum eGUILD_POSITION
{
	eGUILD_NONE  = 0,
	eGUILD_MASTER,			/// 
	eGUILD_SUBMASTER,		///  
	eGUILD_ELDER,			/// 
	eGUILD_UPPERHOUSE,		///  ǿ
	eGUILD_LOWERHOUSE,		/// Ͽ ǿ
	eGUILD_GENERAL,			/// Ϲ
};

//  
struct sGuildInfo
{
	long		idx;									//  ε
	wchar_t		name[MAX_GUILDNAME_BUFFER_SIZE];		// 
	long		masterIndex;							//  ε
	wchar_t		masterName[MAX_NAME_BUFFER_SIZE];		// 
	wchar_t		notice[MAX_GUILD_NOTICE_BUFFER_SIZE];	//  
	char		position;								//  
	long		markIndex;								// 帶ũε
};

//   
struct sGuildUserInfo
{
	long		characterIdx;				// ĳ ε
	wchar_t		name[MAX_NAME_BUFFER_SIZE];	// ĳ͸
	char		level;						// 
	long		job;						// ĳ 
	short		mapnum;						//  ȣ
	char		position;					// 
	DWORD		channelNum;					// ä ȣ
};

// ð  
struct sGuildUserUpdate
{
	long		characterIdx;				// ĳ ε
	char		level;						// 
	long		job;						// ĳ 
	short		mapnum;						//  ȣ
	DWORD		channelNum;					// ä ȣ
};

///   
struct MSG_RES_GUILD_CREATEDATA : MSGROOT
{
	long		idx;								//  ε
	wchar_t		name[MAX_GUILDNAME_BUFFER_SIZE];	// 
};

///   
struct MSG_SYN_GUILD_LIST : MSGROOT
{
	long			rowCount;						//  
	sGuildInfo		data;							//  
	sGuildUserInfo	table[1];						//   Ʈ
};

#define ERROR_GUILD_ADD_SUCCESS			0	//  -  û 
#define ERROR_GUILD_ADD_FAIL			1	// 
#define ERROR_GUILD_ADD_REQUEST			2	//  - ̹ û
#define ERROR_GUILD_ADD_NOTEXIST		3	//  - 밡  
#define ERROR_GUILD_ADD_HAVEGUILD		4	//  - 밡 ̹  
#define ERROR_GUILD_ADD_MAXGUILD		5	//  -  ο 
#define ERROR_GUILD_ADD_REFUSE			6	//  - ʴ 
#define ERROR_GUILD_ADD_STATUSHERO		7	//  - û  ƴ
#define ERROR_GUILD_ADD_STATUS			8	//  -  ûޱ   ƴ

///  ʴ û
struct MSG_REQ_GUILD_ADD : MSGROOT 
{
	wchar_t name[MAX_NAME_BUFFER_SIZE];				//  ʴ 
};

struct MSG_RES_GUILD_ADD : MSG_ERROR
{};

/// ʴ 
struct MSG_SYN_GUILD_ADD : MSGROOT
{
	wchar_t name[MAX_NAME_BUFFER_SIZE];				// ʴ 
	wchar_t guildName[MAX_GUILDNAME_BUFFER_SIZE];	// ʴ 
};

#define ERROR_GUILD_ADDREPLY_SUCCESS		0	//  - 
#define ERROR_GUILD_ADDREPLY_FAIL			1	// 
#define ERROR_GUILD_ADDREPLY_REFUSE			2	// ʴ 

/// ʴ 亯 
struct MSG_REQ_GUILD_REPLY : MSGROOT
{
	char	reply;					// 0 : , 1 : 
};

struct MSG_RES_GUILD_REPLY : MSG_ERROR 
{};

/// ű԰   
struct MSG_SYN_GUILD_USERADD : MSGROOT
{
	sGuildUserInfo		user;				/// ߰  
};

#define ERROR_GUILD_OUT_SUCCESS		0		//  - Ż
#define ERROR_GUILD_OUT_FAIL		1		// 
#define ERROR_GUILD_OUT_MASTER		2		//  -  Ż Ұ

//  Ż û
struct MSG_REQ_GUILD_OUT : MSGROOT
{};

struct MSG_RES_GUILD_OUT : MSG_ERROR
{};

struct MSG_SYN_GUILD_OUT : MSGROOT
{
	unsigned long	characterIdx;			// Ż ε
};

#define ERROR_GUILD_CUT_SUCCESS		0		//  - Ż
#define ERROR_GUILD_CUT_FAIL		1		// 
#define ERROR_GUILD_CUT_MASTER		2		//  - 常 ߹ 

//  ߹ û
struct MSG_REQ_GUILD_CUT : MSGROOT
{
	unsigned long	characterIdx;			// ߹ ε
};

struct MSG_RES_GUILD_CUT : MSG_ERROR
{};

struct MSG_SYN_GUILD_CUT : MSGROOT			// ڽ ߹
{};

struct MSG_SYN_GUILD_USERCUT : MSGROOT
{
	unsigned long	characterIdx;			// ߹ ε
};

#define ERROR_GUILD_DELETE_SUCCESS		0		//  - ü
#define ERROR_GUILD_DELETE_FAIL			1		// 
#define ERROR_GUILD_DELETE_MASTER		2		//  - 常 ü 
#define ERROR_GUILD_DELETE_USEREXIST	3		//  -  

//  ü û
struct MSG_REQ_GUILD_DELETE : MSGROOT
{};

struct MSG_RES_GUILD_DELETE : MSG_ERROR
{};

/// ð 
struct MSG_SYN_GUILD_UPDATE : MSGROOT
{
	long				rowCount;				//  
	sGuildUserUpdate	table[1];				//    Ʈ
};

#define ERROR_GUILD_GIVEPOSITION_SUCCESS	0		//  
#define ERROR_GUILD_GIVEPOSITION_FAIL		1		// 
#define ERROR_GUILD_GIVEPOSITION_POSITION	2		//  -  

//   
struct MSG_REQ_GUILD_GIVEPOSITION : MSGROOT
{
	unsigned long		characterIdx;			//  ε
	char				position;				// 
};

struct MSG_RES_GUILD_GIVEPOSITION : MSG_ERROR
{};

struct MSG_SYN_GUILD_GIVEPOSITION : MSGROOT
{
	unsigned long		characterIdx;			//  ε
	char				position;				// 
};

#define ERROR_GUILD_NOTICE_SUCCESS	0		//  
#define ERROR_GUILD_NOTICE_FAIL		1		// 

//   
struct MSG_REQ_GUILD_NOTICE : MSGROOT
{
	wchar_t			notice[MAX_GUILD_NOTICE_BUFFER_SIZE];	//  
};

struct MSG_RES_GUILD_NOTICE : MSG_ERROR
{};

struct MSG_SYN_GUILD_NOTICE : MSGROOT
{
	wchar_t			notice[MAX_GUILD_NOTICE_BUFFER_SIZE];	//  

	unsigned long GetMsgLength( ) { return sizeof(MSG_SYN_GUILD_NOTICE) - sizeof(notice) + ::wcslen(notice)*sizeof(wchar_t); }
};

#define ERROR_GUILDMARK_UPDATE_SUCCESS  0		// 
#define ERROR_GUILDMARK_UPDATE_FAIL		1		// 
#define ERROR_GUILDMARK_UPDATE_POSITION 2		// ѽ

//  ũ 
struct MSG_REQ_GUILDMARK_UPDATE : MSGROOT
{
	BYTE		mark[MARK_SIZE];		/// 帶ũ 
};

struct MSG_RES_GUILDMARK_UPDATE : MSG_ERROR
{};

struct MSG_SYN_GUILDMARK_UPDATE : MSGROOT
{
	unsigned long	markIndex;			/// ŵ 帶ũ ε
};

#define ERROR_GUILDMARK_SEND_SUCCESS	0		// 
#define ERROR_GUILDMARK_SEND_FAIL		1		// 

//  ũ send û
struct MSG_REQ_GUILDMARK_SEND : MSGROOT
{
	unsigned long	guildIndex;			///  ε
};

struct MSG_RES_GUILDMARK_SEND : MSG_ERROR
{
	unsigned long	guildIndex;				///  ε
	unsigned long	markIndex;				/// 帶ũε
	BYTE			mark[MARK_SIZE];		/// 帶ũ
};

//--------------------------------------------------------------------
// GAME SYN

///  
struct MSG_SYN_POSTGUILD_CREATE : MSGROOT
{
	long			idx;									//  ε
	wchar_t			name[MAX_GUILDNAME_BUFFER_SIZE];		// 
	wchar_t			masterName[MAX_NAME_BUFFER_SIZE];		// 
	unsigned long	masterIndex;						    //  ε

	// master 
	char			level;						// 
	long			job;						// ĳ 
	short			mapnum;						//  ȣ
	char			position;					// 
};

///  
struct MSG_SYN_POSTGUILD_DELETE : MSGROOT
{
	long			idx;					///  ε
};

///   ߰
struct MSG_SYN_POSTGUILD_USERADD : MSGROOT
{
	long			idx;						//  ε
	unsigned long	characterIdx;			    //  ε
	wchar_t			name[MAX_NAME_BUFFER_SIZE];	// 
	char			level;						// 
	long			job;						// ĳ 
	short			mapnum;						//  ȣ
	char			position;					// 
};

///  
struct MSG_SYN_POSTGUILD_USERCUT : MSGROOT
{
	long			idx;						//  ε
	unsigned long	characterIdx;			    //  ε
};

///  Ż
struct MSG_SYN_POSTGUILD_USEROUT : public MSG_SYN_POSTGUILD_USERCUT
{
	long			idx;						//  ε
	unsigned long	characterIdx;			    //  ε
};

///  ο
struct MSG_SYN_POSTGUILD_GIVEPOSITION : MSGROOT
{
	long			idx;						//  ε
	unsigned long	characterIdx;			    //  ε
	char			position;					// 
};

///  ũ 
struct MSG_SYN_POSTGUILD_UPDATEMARK : MSGROOT
{
	long			idx;					//  ε
	unsigned long	markIndex;				/// 帶ũε
	BYTE			mark[MARK_SIZE];		/// 帶ũ
};

///  
struct MSG_SYN_POSTGUILD_NOTICE : MSGROOT
{
	long			idx;									//  ε
	wchar_t			notice[MAX_GUILD_NOTICE_BUFFER_SIZE];	//  

	unsigned long GetMsgLength( ) { return sizeof(MSG_SYN_POSTGUILD_NOTICE) - sizeof(notice) + ::wcslen(notice)*sizeof(wchar_t); }
};

///  ä
struct MSG_SYN_POSTGUILD_CHAT : MSGROOT
{
	long			idx;								//  ε
	sInventory		inventory;							//  
	wchar_t			Name[MAX_NAME_BUFFER_SIZE];			//  ÷̾ ̸
	wchar_t			Message[MAX_CHAT_BUFFER_SIZE];		// ޼

	//  ޼ ũ
	unsigned long GetMsgLength( ) { return sizeof(MSG_SYN_POSTGUILD_CHAT) - sizeof(Message) + ::wcslen(Message)*sizeof(wchar_t); }
};

/// ä 
struct MSG_SYN_POSTGUILD_CHANNEL : MSGROOT
{
	long			idx;						//  ε
	unsigned long	characterIdx;			    //  ε
	DWORD			channelNum;					// ä ȣ
};

///    
struct MSG_SYN_POSTGUILD_UPDATE : MSGROOT
{
	long				idx;					//  ε
	unsigned long		characterIdx;			//  ε
	char				level;					// 
	long				job;					// ĳ 
};

// TB_NOTE
struct tbNOTE
{
	long             idx;					// ȣ
	TIMESTAMP_STRUCT registerDate;			// 
	wchar_t          characterName[ 17 ];	// ĳ ̸
	wchar_t          message[ 200 ];		// ޽
	long             remainTime;			//  ð
	long			 startTime;				// ð
	long			 retValue;				// 
};

///  
struct MSG_SYN_POSTGUILD_NOTESEND : MSGROOT
{
	long    characterIdx2[50];					// ޴ ĳ(ȣ)
	long    rowCount;							//   
	tbNOTE	table[1];							//  
};

struct sGuildConnect
{
	unsigned long guildIdx;
	unsigned long characterIdx;
};

///    ȭ
struct MSG_SYN_POSTGUILD_CONNECT : MSGROOT
{
	DWORD			reqChannelNum;				// û ä ȣ
	long			rowCount;					//
	sGuildConnect	table[1];					//  
};
#pragma pack(pop)
