// Include files
#include "StdAfx.h"
#include "iocontextpool.h"
#include "criticalSectionLock.h"
#include <stdio.h>

// Local definitions
#define SetLeft(P,L)    { (P)->left  = L; if (L) (L)->parent = P; }
#define SetRight(P,R)   { (P)->right = R; if (R) (R)->parent = P; }

// Global data

// cIoContextPool Constructor
cIoContextPool::cIoContextPool(u_long bufferLength) : mBufferLength(bufferLength)
{
	// Critical Section ʱȭ Ѵ.
	InitializeCriticalSection( &mCs );

	// Pool Usage Pointer
	mPagedPoolUsage         = NULL;
	mNonPagedPoolUsage      = NULL;

	// ޸ ī.
	mQuotaPagedPoolUsage    = 0;
	mQuotaNonPagedPoolUsage = 0;
	mWorkingSetSize         = 0;
}

// ~cIoContextPool Destructor.
cIoContextPool::~cIoContextPool(void)
{
	// cIoContextPool .
	Shutdown( );

	// Critical Section .
	DeleteCriticalSection( &mCs );
}

// DefaultWorkingSize Method
bool cIoContextPool::DefaultWorkingSize(DWORD workingSize)
{
	cCSLock       lock( &mCs );                     // Critical Section
	PerIoContext* temp = NULL;

	try
	{
		while ( workingSize > 0 )
		{
			temp = GetPool( );

				if ( temp == NULL ) throw false;    // Socket Context غ.

			workingSize--;
		}
		throw true;
	}
	catch ( bool boolean )
	{
		while ( mPagedPoolUsage != NULL )
		{
			ReleasePool( mPagedPoolUsage );
		}
		return boolean;
	}
}

// GetProcessMemoryInfo Method.
void cIoContextPool::GetProcessMemoryInfo(SIZE_T& quotaPagedPoolUsage, SIZE_T& quotaNonPagedPoolUsage, SIZE_T& workingSetSize)
{
	cCSLock lock( &mCs );
	quotaPagedPoolUsage    = mQuotaPagedPoolUsage;
	quotaNonPagedPoolUsage = mQuotaNonPagedPoolUsage;
	workingSetSize         = mWorkingSetSize;
}

// Shutdown Method
void cIoContextPool::Shutdown( )
{
	cCSLock       lock( &mCs );
	PerIoContext* prev;
	PerIoContext* next;
	PerIoContext* temp;

	// Pool Usage Shutdown - PagedPoolUsage
	while ( mPagedPoolUsage != NULL )
	{
		prev               = mPagedPoolUsage->prev;
		next               = mPagedPoolUsage->next;
		temp               = mPagedPoolUsage;

		mPagedPoolUsage    = mPagedPoolUsage->next;
		FreeIoContext( &temp );
		mQuotaPagedPoolUsage--;
	}
	// Pool Usage Shutdown - NonPagedPoolUsage
	while ( mNonPagedPoolUsage != NULL )
	{
		prev               = mNonPagedPoolUsage->prev;
		next               = mNonPagedPoolUsage->next;
		temp               = mNonPagedPoolUsage;

		mNonPagedPoolUsage = mNonPagedPoolUsage->next;
		FreeIoContext( &temp );
		mQuotaNonPagedPoolUsage--;
	}
}

// AllocIoContext Method - I/O Context Ѵ.
PerIoContext* cIoContextPool::AllocIoContext( )
{
	PerIoContext* perIoContext = (PerIoContext*)GlobalAlloc( GPTR, sizeof(PerIoContext) );

	if ( perIoContext != NULL )
	{
		ZeroMemory( &perIoContext->wsaOverlapped, sizeof(WSAOVERLAPPED) );          // overlapped I/O    ü
		perIoContext->socket        = INVALID_SOCKET;                               // Ŭ̾Ʈ , PerSocketContext 
		ZeroMemory( &perIoContext->addr, sizeof(SOCKADDR_IN) );                     // Ŭ̾Ʈ ּ ü
		perIoContext->buffer        = (char*)GlobalAlloc( GPTR, mBufferLength );    // ޸𸮸 ҴѴ. - GPTR  0 ʱȭȴ.
		perIoContext->offset        = 0;                                            //  
		perIoContext->length        = mBufferLength;                                //  
		perIoContext->requestType   = IOCP_REQUEST_READ;                            // Request Type
		perIoContext->requestResult = IOCP_REQUEST_SUCCESS;                         // Request Result
		perIoContext->iParam        = 0;                                            // i Param
		perIoContext->lParam        = 0;                                            // l Param
		perIoContext->prev          = NULL;                                         // Ʈ  - 
		perIoContext->next          = NULL;                                         // Ʈ  - 

		// I/O Context::Buffer  - , mWorkingSetSize . н, I/O Context .
		(perIoContext->buffer != NULL) ? mWorkingSetSize++ : FreeIoContext( &perIoContext );
	}

	if ( perIoContext == NULL )
	{
		throw "Error - PerIoContext* cIoContextPool::AllocIoContext( ) is null.";
	}

	return perIoContext;
}

// FreeIoContext Method - I/O Context Ѵ.
void cIoContextPool::FreeIoContext(PerIoContext** perIoContext)
{
	if ( (*perIoContext) != NULL )
	{
		if ( (*perIoContext)->buffer != NULL )
		{
			GlobalFree( (*perIoContext)->buffer );
			(*perIoContext)->buffer = NULL;
		}
		GlobalFree( (*perIoContext) );
		(*perIoContext) = NULL;

		// mWorkingSetSize .
		mWorkingSetSize--;
	}
}

// AttachPool Method
void cIoContextPool::AttachPool(PerIoContext** pool, PerIoContext* perIoContext)
{
	if ( (*pool) != NULL )
	{
		(*pool)->prev = perIoContext;

		perIoContext->prev = NULL;
		perIoContext->next = (*pool);
	}
	(*pool) = perIoContext;
}

// DetachPool Method
void cIoContextPool::DetachPool(PerIoContext** pool, PerIoContext* perIoContext)
{
	PerIoContext* prev = perIoContext->prev;
	PerIoContext* next = perIoContext->next;

	if ( prev == NULL && next == NULL )
	{
		(*pool) = NULL;
	}
	else if ( prev == NULL && next != NULL )
	{
		next->prev = NULL;
		(*pool) = next;
	}
	else if ( prev != NULL && next == NULL )
	{
		prev->next = NULL;
	}
	else if ( prev != NULL && next != NULL )
	{
		prev->next = next;
		next->prev = prev;
	}

	perIoContext->prev = NULL;
	perIoContext->next = NULL;
}

// GetPool Method
PerIoContext* cIoContextPool::GetPool( )
{
	PerIoContext* perIoContext = mNonPagedPoolUsage;

	if ( perIoContext != NULL )
	{
		//  ȵ Ǯ 뷮 .
		DetachPool( &mNonPagedPoolUsage, perIoContext );
		mQuotaNonPagedPoolUsage--;
	}
	else
	{
		//     Ѵ.
		perIoContext = AllocIoContext( );
	}

	if ( perIoContext != NULL )
	{
		//   Ǯ 뷮 .
		AttachPool( &mPagedPoolUsage, perIoContext );
		mQuotaPagedPoolUsage++;
	}

	return perIoContext;
}

// ReleasePool Method
void cIoContextPool::ReleasePool(PerIoContext* perIoContext, bool deleteIoContext)
{
	//   Ǯ 뷮 .
	DetachPool( &mPagedPoolUsage, perIoContext );
	mQuotaPagedPoolUsage--;

	if ( deleteIoContext != true )
	{
		//  ȵ Ǯ 뷮 .
		AttachPool( &mNonPagedPoolUsage, perIoContext );
		mQuotaNonPagedPoolUsage++;
	}
	else
	{
		//  .
		FreeIoContext( &perIoContext );
	}
}

// GetIoContext Method - Ʈ HEAD Ѱش.
// ReleaseIoContext Բ LIFO ̷. LIFO Context Switching ּȭ ϱ  
PerIoContext* cIoContextPool::GetIoContext( )
{
	cCSLock       lock( &mCs );
	PerIoContext* perIoContext = GetPool( );
	return perIoContext;
}
PerIoContext* cIoContextPool::GetIoContext(SOCKET socket, u_long request)
{
	cCSLock       lock( &mCs );
	PerIoContext* perIoContext = GetPool( );

	if ( perIoContext != NULL )
	{
		perIoContext->socket      = socket;
		perIoContext->requestType = request;
	}

	return perIoContext;
}
PerIoContext* cIoContextPool::GetIoContext(SOCKET socket, u_long request, SOCKADDR_IN addr)
{
	cCSLock       lock( &mCs );
	PerIoContext* perIoContext = GetPool( );

	if ( perIoContext != NULL )
	{
		perIoContext->socket      = socket;
		perIoContext->addr        = addr;
		perIoContext->requestType = request;
	}

	return perIoContext;
}

// ReleaseIoContext Method - Ʈ HEAD ȸѴ.
// GetIoContext Բ LIFO ̷. LIFO Context Switching ּȭ ϱ  
void cIoContextPool::ReleaseIoContext(PerIoContext* perIoContext, bool deleteIoContext, DWORD* errorPtr)
{
	u_long offset = perIoContext->offset + perIoContext->InternalHigh;  //  .

	if ( offset > perIoContext->length )
		throw "Error - void cIoContextPool::ReleaseIoContext( ) is overflow.";

	if ( deleteIoContext != true && errorPtr != NULL )
	{
		if ( offset <= perIoContext->length )
		{
			u_long len = perIoContext->length - offset;                  //  .
			char*  buf = perIoContext->buffer + offset;                  //  .

			while ( len > 0 )
			{
				if ( (*buf) != 0 )
				{
					(*errorPtr)++;      // ó.
					(*buf) = 0;			// ʱȭ.
				}
				buf++;
				len--;
			}
		}
		else
			(*errorPtr) = (DWORD)(-1);  // ɰ .
	}

	ZeroMemory( &perIoContext->wsaOverlapped, sizeof(WSAOVERLAPPED) );      // Overlapped ʱȭ.
	perIoContext->socket        = INVALID_SOCKET;                           //  ʱȭ.
	ZeroMemory( &perIoContext->addr, sizeof(SOCKADDR_IN) );                 // ּ ʱȭ.
	ZeroMemory( perIoContext->buffer, offset );                             // ޸ ʱȭ.
	perIoContext->offset        = 0;                                        //  ʱȭ.
	perIoContext->Internal      = 0;                                        //  ʱȭ.
	perIoContext->InternalHigh  = 0;                                        //  ʱȭ.
	perIoContext->requestType   = IOCP_REQUEST_READ;                        // 䱸 ʱȭ.
	perIoContext->requestResult = IOCP_REQUEST_SUCCESS;                     //  ʱȭ.
	perIoContext->iParam        = 0;                                        // Ķ ʱȭ.
	perIoContext->lParam        = 0;                                        // Ķ ʱȭ.

	cCSLock lock( &mCs );
	ReleasePool( perIoContext, deleteIoContext );
}
