/* ====================================================================
 *      :	ioContextPool.h
 *      :	
 *    :	ö
 *    :	04/11/17
 * ǻ :	
 * =================================================================== */
#ifndef __IO_CONTEXT_POOL_H__
#define __IO_CONTEXT_POOL_H__

//#ifndef WINVER
//#define WINVER          0x0500
//#endif
//
//#ifndef _WIN32_WINNT
//#define _WIN32_WINNT    0x0500
//#endif

#ifndef IO_CONTEXT_VER
#define IO_CONTEXT_VER 0x0001
#else
#if defined(IO_CONTEXT_VER) && (IO_CONTEXT_VER < 0x0001)
#error IO_CONTEXT_VER setting conflicts
#endif
#endif

#pragma once

#include <winsock2.h>
#include <windows.h>
#include "criticalsectionlock.h"

#define DEF_TCP_PACKET_SIZE 65535
#define HAL_TCP_PACKET_SIZE 32767

// UDP  Packet size 65,535
// IPv4 Header size     60
// UDP  Header size      8
#define MAX_UDP_PACKET_SIZE 65467				// 65,535 - 60 - 8 = 65,467

#ifndef PER_IO_CONTEXT
#define PER_IO_CONTEXT

enum IOCP_REQUESTTYPE
{
	IOCP_REQUEST_READ = 0,                      // б()
	IOCP_REQUEST_WRITE,                         // (۽)
	IOCP_REQUEST_CALLBACK,                      // ݹ
};

enum IOCP_REQUESTRESULT
{
	IOCP_REQUEST_SUCCESS = 0,                   // 
	IOCP_REQUEST_ERROR,                         // 
};

struct PerIoContext
{
	WSAOVERLAPPED        wsaOverlapped;         // overlapped I/O    ü
	SOCKET               socket;                // Ŭ̾Ʈ 
	SOCKADDR_IN          addr;                  // Ŭ̾Ʈ ּ

	char*                buffer;                // / 
	u_long               offset;                //  
	u_long               length;                //  

	u_long               Internal;              //  
	u_long               InternalHigh;          //  

	u_long               requestType;           // Request Type
	u_long               requestResult;         // Request Result

	UINT_PTR             iParam;                // i param
	ULONG_PTR            lParam;                // l Param

	struct PerIoContext* prev;                  // Ʈ  - 
	struct PerIoContext* next;                  // Ʈ  - 
};

#endif // PER_IO_CONTEXT


#define MAX_IO_CONTEXT_BUFFER_LEN 65535

struct IoContextBuffer
{
	PerIoContext* buffer[MAX_IO_CONTEXT_BUFFER_LEN];
	long          offset;
};

class cIoContextPool
{
protected:
	CRITICAL_SECTION mCs;                     // ȭ 
	u_long           mBufferLength;           //  ũ

	PerIoContext*    mPagedPoolUsage;         //   Ǯ   - overlapped I/O 
	PerIoContext*    mNonPagedPoolUsage;      //  ȵ Ǯ - overlapped I/O 

	SIZE_T           mQuotaPagedPoolUsage;    //    Ǯ   - 뷮
	SIZE_T           mQuotaNonPagedPoolUsage; //   ȵ Ǯ - 뷮
	SIZE_T           mWorkingSetSize;         //  ۾ ũ.

protected:
	PerIoContext*    AllocIoContext         ( );
	void             FreeIoContext          ( PerIoContext** perIoContext );

protected:
	void             AttachPool             ( PerIoContext** pool, PerIoContext* perIoContext );
	void             DetachPool             ( PerIoContext** pool, PerIoContext* perIoContext );

	PerIoContext*    GetPool                ( );
	void             ReleasePool            ( PerIoContext* perIoContext, bool deleteIoContext=false );

public:
	cIoContextPool(u_long bufferLength=DEF_TCP_PACKET_SIZE);

	bool             DefaultWorkingSize     ( DWORD workingSize );
	void             GetProcessMemoryInfo   ( SIZE_T& quotaPagedPoolUsage, SIZE_T& quotaNonPagedPoolUsage, SIZE_T& workingSetSize );
	void             Shutdown               ( );

	PerIoContext*    GetPagedPoolUsage      ( ) { return mPagedPoolUsage; }

	PerIoContext*    GetIoContext           ( );
	PerIoContext*    GetIoContext           ( SOCKET socket, u_long request );
	PerIoContext*    GetIoContext           ( SOCKET socket, u_long request, SOCKADDR_IN addr );
	void             ReleaseIoContext       ( PerIoContext* perIoContext, bool deleteIoContext=false, DWORD* errorPtr=NULL );

public:
	virtual ~cIoContextPool(void);
};

#endif // __IO_CONTEXT_POOL_H__