/* ====================================================================
 *      :	
 *      :	
 *    :	ö
 *    :	2007.06.25
 * ǻ :	
 * =================================================================== */
#pragma once
#pragma pack(push,1)

#include "BaseObject_Common.h"
#include "CommonDefines.h"
#include "CommonNetworkMsgStruct.h"

#define MAX_OWNER				6		// ִ   
#define MAX_ITEMS				30		// ִ   

#define ITEM_VALID_DISTANCE		100.f	//  ݱ ȿŸ
#define MAX_ITEM_EXCHANGE		15		// ִ ŷ 

enum eItemSellType
{
	ItemSellNone = 0,	// ǸźҰ
	ItemSellMoney,		// ӸӴ
	ItemSellPvp,		//  Ʈ
	ItemSellTarot,		//  Ʈ
};
enum eItemBuyType
{
	ItemBuyNone = 0,	// ǸźҰ
	ItemBuyMoney,		// ӸӴ
	ItemBuyPvp,			//  Ʈ
	ItemBuyTarot,		//  Ʈ
};

enum eItemActiveWeapon
{
	ItemActiveFront = 0,	// Ȱ  - Front.
	ItemActiveBack,			// "             - Back.
	ItemActiveMax,

	ItemActiveSwitch = 1,
};

enum eItemExchangeStatus
{
	ItemExchangeNone = 0,
	ItemExchangeAsk,
	ItemExchangeBegin,
	ItemExchangeOk,
	ItemExchangeEnd,
};


#define STALL_TITLE_LEN			50						//  ŸƲ 
#define MAX_STALL_TITLE_LEN		(STALL_TITLE_LEN+1)		//  ŸƲ ִ(NULL )
#define MAX_STALL_GUEST			10						//  ԽƮ(GEUST) ο
#define MAX_STALL_ITEM			10						//    

enum eStallSellItemStatus
{
	StallSellItemNone = 0,	// Ͼȵ
	StallSellItemStart,		// ǸŽ
	StallSellItemPause,		// ǸϽ
};


#ifndef __ITEM_TYPE__
#define __ITEM_TYPE__

enum ITEM_TYPE
{
	ITEM_WEAPON    = 0,					// 
		ITEM_WEAPON_SWORD = 0,			// Ѽհ
		ITEM_WEAPON_BLADE,				// հ
		ITEM_WEAPON_DUAL,				// ̵
		ITEM_WEAPON_CUTTER,				//   
		ITEM_WEAPON_GUN,				// ,
		ITEM_WEAPON_STAFF,				// 
		ITEM_WEAPON_SHIELD,				// 

	ITEM_WEAR      = 1,					// 
		ITEM_WEAR_HEAD = 0,				// Ӹ
		ITEM_WEAR_UPPER,				// 
		ITEM_WEAR_LOWER,				// 
		ITEM_WEAR_HANDS,				// 
		ITEM_WEAR_FEET,					// 
		ITEM_WEAR_ONEPIECE,				// ǽ

	ITEM_ACCESSORY  = 2,				// ׼
		ITEM_ACCESSORY_EARRING = 0,		// Ͱ
		ITEM_ACCESSORY_NECKLACE,		// 
		ITEM_ACCESSORY_BROOCH,			// ġ
		ITEM_ACCESSORY_BRACELET,		// 
		ITEM_ACCESSORY_RING,			// 

	ITEM_ETC1       = 3,				// Ҹȭ
		ITEM_ETC1_POTION = 0,			// 
		ITEM_ETC1_MISC,					// ȭ
		ITEM_ETC1_QUEST,				// Ʈ
		ITEM_ETC1_CHANGE,				// ü
		ITEM_ETC1_MIXSKILL,				//  
		ITEM_ETC1_TITLE,				// ȣĪ
		ITEM_ETC1_RECIPE,				// 
		ITEM_ETC1_RECIPEGROUP,			// (׷)
		ITEM_ETC1_SKILLRESET,			// ų ʱȭ

	ITEM_MATERIAL   = 4,				// 
		ITEM_MATERIAL_SKILL = 0,		// ų
		ITEM_MATERIAL_CLOTH,			// ʰ
		ITEM_MATERIAL_LEATHER,			// 
		ITEM_MATERIAL_METAL,			// ݼ
		ITEM_MATERIAL_JEWEL,			// 
		ITEM_MATERIAL_MISC,				// ȭ
		ITEM_MATERIAL_MAP,				// ̵ֹ
		ITEM_MATERIAL_VEHICLE,			// Ż

	ITEM_QUEST      = 5,				// Ʈ
	ITEM_ETC2       = 6,				// Ϲȭ
	ITEM_SPREAD     = 7,				// 

	ITEM_CARD       = 8,				// ī
		ITEM_CARD_TAROT = 0,			// ī-Ÿ()
		ITEM_CARD_COMMON,				// ī-Ҹ
		ITEM_CARD_EQUIP_C,				// ī-ĳ
		ITEM_CARD_EQUIP_A,				// ī-AŸ
		ITEM_CARD_EQUIP_B,				// ī-BŸ
		ITEM_CARD_EQUIP_AB,				// ī-ABŸ
		ITEM_CARD_EQUIP_O,				// ī-OŸ
		ITEM_CARD_ENHANCE_WEAPON_LV1,	// ī-Ⱝȭ
		ITEM_CARD_ENHANCE_WEAPON_LV2,	// ī-Ⱝȭ
		ITEM_CARD_ENHANCE_WEAPON_LV3,	// ī-Ⱝȭ
		ITEM_CARD_ENHANCE_WEAPON_LV4,	// ī-Ⱝȭ
		ITEM_CARD_ENHANCE_WEAPON_LV5,	// ī-Ⱝȭ
		ITEM_CARD_ENHANCE_WEAR_LV1,		// ī-ȭ
		ITEM_CARD_ENHANCE_WEAR_LV2,		// ī-ȭ
		ITEM_CARD_ENHANCE_WEAR_LV3,		// ī-ȭ
		ITEM_CARD_ENHANCE_WEAR_LV4,		// ī-ȭ
		ITEM_CARD_ENHANCE_WEAR_LV5,		// ī-ȭ

	ITEM_MONSTER    = 9,				// ī
		ITEM_MONSTER_UNKNOWN = 0,		// -̺з
		ITEM_MONSTER_HUMAN,				// -ΰ
		ITEM_MONSTER_ANIMAL,			// -
		ITEM_MONSTER_PLANT,				// -Ĺ
		ITEM_MONSTER_INSECT,			// -
		ITEM_MONSTER_ELF,				// -
		ITEM_MONSTER_UNDEAD,			// -𵥵
		ITEM_MONSTER_GIANT,				// -
		ITEM_MONSTER_DRAGON,			// -

	ITEM_COIN		= 10,				// 
		ITEM_COIN_GOLD = 0,				// -
		ITEM_COIN_SILVER,				// -
		ITEM_COIN_COPPER,				// -

	ITEM_UNKNOWN   = 11,
};

#endif // __ITEM_TYPE__


#ifndef __ITEM_TARGET_TYPE__

#define ITEM_TARGET_NONE		0x00	// Ұ
#define ITEM_TARGET_MYSELF		0x01	// ÷̾ ڽ
#define ITEM_TARGET_MONSTER		0x02	// 
#define ITEM_TARGET_PLAYER		0x04	// ٸ ÷̾
#define ITEM_TARGET_PARTY		0x08	// Ƽ

#endif // __ITEM_TARGET_TYPE__


#ifndef __ITEM_TOOLTIP__

/// ÷ (  
enum eTooltipType
{
	eTOOLTIP_MALL,		/// 
	eTOOLTIP_ETC,		/// ȭ
	eTOOLTIP_NORMAL,	/// Ϲ
	eTOOLTIP_MAGIC,		/// 
	eTOOLTIP_RARE,		/// 
	eTOOLTIP_UNIQUE,	/// ũ
	eTOOLTIP_EPIC,		/// 
	eTOOLTIP_REGEND,	/// 

	eTOOLTIP_NONE, 
};

#endif __ITEM_TOOLTIP__


#ifndef __ITEM_LIMIT__

enum ITEM_RACE
{
	ITEM_RACE_HUMAN = 0,				// ΰ
	ITEM_RACE_BEAST,					// 
	ITEM_RACE_ELF,						// 
	ITEM_RACE_ALL,						// 
};

enum ITEM_GENDER
{
	ITEM_GENDER_MALE = 0,				// 
	ITEM_GENDER_FEMALE,					// 
	ITEM_GENDER_ALL,					// 
};

enum ITEM_JOB
{
	ITEM_JOB_FIGHTER = 1000,			//  
	ITEM_JOB_MAGE    = 2000,			//  
	ITEM_JOB_RANGER  = 3000,			//  
	ITEM_JOB_SHAMAN  = 4000,			//    
	ITEM_JOB_WARRIOR = 5000,			//  
	ITEM_JOB_THIEF   = 6000,			//    
	ITEM_JOB_ALL     = 0,				//    - (Ѿ)
};

#endif // __ITEM_LIMIT__


#ifndef __ITEM_ENHANCED__

#define MIN_ITEM_ENHANCED		1		//  ȭ ȿܰ (0~15, 0ϰ ȭ)
#define MAX_ITEM_ENHANCED		15		//  ȭ ȿܰ (0~15, 0ϰ ȭ)

enum ITEM_ENHANCED_LEVEL
{
	ITEM_ENHANCED_LV1_BEGIN = 0,
	ITEM_ENHANCED_LV1_END   = ITEM_ENHANCED_LV1_BEGIN + 3,

	ITEM_ENHANCED_LV2_BEGIN,
	ITEM_ENHANCED_LV2_END   = ITEM_ENHANCED_LV2_BEGIN + 2,

	ITEM_ENHANCED_LV3_BEGIN,
	ITEM_ENHANCED_LV3_END   = ITEM_ENHANCED_LV3_BEGIN + 2,

	ITEM_ENHANCED_LV4_BEGIN,
	ITEM_ENHANCED_LV4_END   = ITEM_ENHANCED_LV4_BEGIN + 2,

	ITEM_ENHANCED_LV5_BEGIN,
	ITEM_ENHANCED_LV5_END   = ITEM_ENHANCED_LV5_BEGIN + 2,
};

enum ITEM_ENHANCED_TYPE
{
	ITEM_ENHANCED_NONE=0,				// 
	ITEM_ENHANCED_PHYSIC_ATTACK,		// ݷ
	ITEM_ENHANCED_MAGIC_ATTACK,			// ݷ
	ITEM_ENHANCED_PHYSIC_DEFENSE,		// 
	ITEM_ENHANCED_MAGIC_DEFENSE,		// 
};

#endif // __ITEM_ENHANCED__


#ifndef __ITEM_CARD_SLOT__

#define ITEM_CARD_SLOT_NONE	0			// 
#define ITEM_CARD_SLOT_A	1			// A
#define ITEM_CARD_SLOT_B	2			// B
#define ITEM_CARD_SLOT_AB	3			// AB
#define ITEM_CARD_SLOT_O	4			// O

enum ITEM_CARD_SLOT
{
	ITEM_CARD_SLOT_1 = 1,
	ITEM_CARD_SLOT_2,
	ITEM_CARD_SLOT_3,
	ITEM_CARD_SLOT_4,
	ITEM_CARD_SLOT_5
};

#define MIN_CARD_SLOT	ITEM_CARD_SLOT_1	// ī彽 ּ
#define MAX_CARD_SLOT	ITEM_CARD_SLOT_5	// ī彽 ִ

#endif // __ITEM_CARD_SLOT__


#ifndef __ITEM_CHANGE__

#define MIN_ITEM_CHANGE			1			// ּ ȯ .
#define MAX_ITEM_CHANGE			3			// ִ ȯ .

#define MAX_ITEM_CHANGE_RATE	10			// ִ  ȯ(Ȯ).
#define MAX_ITEM_CHANGE_DATA	40			// ִ  ȯ(ε&).

#endif // __ITEM_CHANGE__


#ifndef __INVENTORY_NUMBER__
#define __INVENTORY_NUMBER__

#define MIN_INVENTORY				0

enum INVENTORY_NUMBER
{
	// INVENTORY_WEAR_TYPE
	INVENTORY_WEAR_BEGIN = MIN_INVENTORY,

		INVENTORY_WEAR_HAT = INVENTORY_WEAR_BEGIN,
		INVENTORY_WEAR_BODY1,
		INVENTORY_WEAR_BODY2,
		INVENTORY_WEAR_HAND,
		INVENTORY_WEAR_FOOT,

		INVENTORY_WEAR_EARRING,
		INVENTORY_WEAR_NECKLACE,
		INVENTORY_WEAR_BROOCH,
		INVENTORY_WEAR_BRACELET,
		INVENTORY_WEAR_RING,

		INVENTORY_WEAR_CARD1,
		INVENTORY_WEAR_CARD2,
		INVENTORY_WEAR_CARD3,

	INVENTORY_WEAR_END = INVENTORY_WEAR_CARD3,

	// INVENTORY_HAND_TYPE
	INVENTORY_HAND_BEGIN,

		INVENTORY_HAND_LEFT1 = INVENTORY_HAND_BEGIN,
		INVENTORY_HAND_RIGHT1,

		INVENTORY_HAND_LEFT2,
		INVENTORY_HAND_RIGHT2,

	INVENTORY_HAND_END = INVENTORY_HAND_RIGHT2,

	// INVENTORY_AVATAR - ȣ( )
	INVENTORY_AVATAR_BEGIN,
	INVENTORY_AVATAR_END = INVENTORY_AVATAR_BEGIN + 15,

	// INVENTORY_BAG_TYPE
	INVENTORY_BAG0_BEGIN,
	INVENTORY_BAG0_END = INVENTORY_BAG0_BEGIN + 24,

	INVENTORY_BAG1_BEGIN,
	INVENTORY_BAG1_END = INVENTORY_BAG1_BEGIN + 24,

	INVENTORY_BAG2_BEGIN,
	INVENTORY_BAG2_END = INVENTORY_BAG2_BEGIN + 24,

	INVENTORY_BAG3_BEGIN,
	INVENTORY_BAG3_END = INVENTORY_BAG3_BEGIN + 24,

	// INVENTORY_MALL_TYPE
	INVENTORY_MALL_BEGIN,
	INVENTORY_MALL_END = INVENTORY_MALL_BEGIN + 24,

	// INVENTORY_QUEST_TYPE
	INVENTORY_QUEST_BEGIN,
	INVENTORY_QUEST_END = INVENTORY_QUEST_BEGIN + 24,

	// INVENTORY_WAREHOUSE_TYPE - Ϲ
	INVENTORY_WAREHOUSE0_BEGIN,
	INVENTORY_WAREHOUSE0_END = INVENTORY_WAREHOUSE0_BEGIN + 49,

	INVENTORY_WAREHOUSE1_BEGIN,
	INVENTORY_WAREHOUSE1_END = INVENTORY_WAREHOUSE1_BEGIN + 49,

	// INVENTORY_WAREHOUSE_TYPE -  
	INVENTORY_WAREHOUSE2_BEGIN,
	INVENTORY_WAREHOUSE2_END = INVENTORY_WAREHOUSE2_BEGIN + 49,

	INVENTORY_WAREHOUSE3_BEGIN,
	INVENTORY_WAREHOUSE3_END = INVENTORY_WAREHOUSE3_BEGIN + 49,

	// INVENTORY_COLLECTION_TYPE - ȣ( )
	INVENTORY_COLLECTION_BEGIN,

		INVENTORY_TAROT_BEGIN = INVENTORY_COLLECTION_BEGIN,
		INVENTORY_TAROT_END   = INVENTORY_TAROT_BEGIN + 21,

		INVENTORY_SPREAD_BEGIN,
		INVENTORY_SPREAD_END  = INVENTORY_SPREAD_BEGIN + 4,

	INVENTORY_COLLECTION_END = INVENTORY_COLLECTION_BEGIN + 99
};

#define INVENTORY_EQUIP_NONE		(-1)
#define INVENTORY_EQUIP_BEGIN		INVENTORY_WEAR_BEGIN
#define INVENTORY_EQUIP_END			INVENTORY_HAND_END

#define INVENTORY_BAG_NONE          (-1)
#define INVENTORY_BAG_BEGIN			INVENTORY_BAG0_BEGIN
#define INVENTORY_BAG_END			INVENTORY_BAG3_END

#define INVENTORY_CHARACTER_BEGIN	INVENTORY_WEAR_BEGIN
#define INVENTORY_CHARACTER_END		INVENTORY_BAG3_END

#define INVENTORY_WAREHOUSE_NONE     (-1)
#define INVENTORY_WAREHOUSE_BEGIN	INVENTORY_WAREHOUSE0_BEGIN
#define INVENTORY_WAREHOUSE_END		INVENTORY_WAREHOUSE1_END

#define MAX_INVENTORY				INVENTORY_COLLECTION_END

#endif // __INVENTORY_NUMBER__


struct sInventory
{
	unsigned long  idx;								// κ丮 ȣ
	unsigned long  ItemIndex;						//   ε
	unsigned short number;							//  ȣ (ε)
	unsigned short count;							//  
	unsigned char  enhanced;						//  ȭܰ (0~15)
	unsigned long  cardSlot1;						// ī彽1
	unsigned long  cardSlot2;						// ī彽2
	unsigned long  cardSlot3;						// ī彽3
	unsigned long  cardSlot4;						// ī彽4
	unsigned long  cardSlot5;						// ī彽5
	unsigned char  seal;							//   (0/1ε)
};

struct sInventoryCooltime
{
	unsigned long ItemIndex;						//   ε
	unsigned long cooltime2;						// ׷ Ÿ ε
	unsigned long cooltime;							// Ÿ ð
	unsigned long cooltime1;						// Ÿ ð
};


#ifndef __ITEM_ABILITY_OPT__

//  ȹ  - ȹ  
enum ITEM_ABILITY_OPT
{
	ITEM_OPT_NONE=0,						// 
	ITEM_OPT_STR,							// 
	ITEM_OPT_DEX,							// ø
	ITEM_OPT_CON,							// ü
	ITEM_OPT_INT,							// 
	ITEM_OPT_WIS,							// 
	ITEM_OPT_ALL,							// (,ø,ü,,)

	ITEM_OPT_PLUS_PHYSIC_ATTACK=101,		// ݷ
	ITEM_OPT_PLUS_MAGIC_ATTACK,				// ݷ
	ITEM_OPT_PLUS_PHYSIC_DEFENSE,			// 
	ITEM_OPT_PLUS_MAGIC_DEFENSE,			// 
	ITEM_OPT_PLUS_PHYSIC_ATTACK_RATE,		// ߷
	ITEM_OPT_PLUS_MAGIC_ATTACK_RATE,		// ߷
	ITEM_OPT_PLUS_PHYSIC_CRITICAL,			// ũƼ
	ITEM_OPT_PLUS_MAGIC_CRITICAL,			// ũƼ
	ITEM_OPT_PLUS_DOD,						// ȸ
	ITEM_OPT_PLUS_WEI,						// 
	ITEM_OPT_PLUS_MAX_HP,					// ִ뷮 HP
	ITEM_OPT_PLUS_MAX_MP,					// ִ뷮 MP
	ITEM_OPT_PLUS_MOV,						// ̵
	ITEM_OPT_PLUS_HP,						// HP ȸ
	ITEM_OPT_PLUS_MP,						// MP ȸ

	ITEM_OPT_PERCENT_PHYSIC_ATTACK=201,		// ݷ
	ITEM_OPT_PERCENT_MAGIC_ATTACK,			// ݷ
	ITEM_OPT_PERCENT_PHYSIC_DEFENSE,		// 
	ITEM_OPT_PERCENT_MAGIC_DEFENSE,			// 
	ITEM_OPT_PERCENT_PHYSIC_ATTACK_RATE,	// ߷
	ITEM_OPT_PERCENT_MAGIC_ATTACK_RATE,		// ߷
	ITEM_OPT_PERCENT_PHYSIC_CRITICAL,		// ũƼ
	ITEM_OPT_PERCENT_MAGIC_CRITICAL,		// ũƼ
	ITEM_OPT_PERCENT_DOD,					// ȸ
	ITEM_OPT_PERCENT_WEI,					// 
	ITEM_OPT_PERCENT_MAX_HP,				// ִ뷮 HP
	ITEM_OPT_PERCENT_MAX_MP,				// ִ뷮 MP
	ITEM_OPT_PERCENT_MOV,					// ̵
	ITEM_OPT_PERCENT_HP,					// HP ȸ
	ITEM_OPT_PERCENT_MP,					// MP ȸ

	ITEM_OPT_PERCENT_DRAIN_HP = 301,		// HP 
	ITEM_OPT_PERCENT_DRAIN_MP,				// MP 
	ITEM_OPT_PERCENT_SKILL_HEAL_INC,		// ų  ȸ 
	ITEM_OPT_PERCENT_DAMAGE_DEC,			//  /
	ITEM_OPT_PERCENT_DAMAGE_REF,			//  ݻ
};

#endif // __ITEM_ABILITY_OPT__


//    Ƽ - ũƮ  
struct sEquipAbility
{
	// ⺻  .
	short mPhysicDefense;							// :
	short mMagicDefense;							// :
	short mAttackRange;								//  Ÿ
	short mAttackSpeed;								//  ӵ

	short mPhysicMinAttack;							// :ּҰݷ
	short mPhysicMaxAttack;							// :ִݷ
	short mMagicMinAttack;							// :ּҰݷ
	short mMagicMaxAttack;							// :ִݷ

	short mPhysicAttackRate;						// :ݷ
	short mMagicAttackRate;							// :ݷ
	short mPhysicCritical;							// :ũƼ
	short mMagicCritical;							// :ũƼ

	// ɼ  .
	short mOptStr;									// :
	short mOptDex;									// :ø
	short mOptCon;									// :ü
	short mOptInt;									// :
	short mOptWis;									// :

	// ɼ  - Plus
	short mOptPlusPhysicAttack;						// ݷ
	short mOptPlusMagicAttack;						// ݷ
	short mOptPlusPhysicDefense;					// 
	short mOptPlusMagicDefense;						// 
	short mOptPlusPhysicAttackRate;					// ߷
	short mOptPlusMagicAttackRate;					// ߷
	short mOptPlusPhysicCritical;					// ũƼ
	short mOptPlusMagicCritical;					// ũƼ
	short mOptPlusDod;								// ȸ
	short mOptPlusWei;								// 
	short mOptPlusMaxHp;							// ִ뷮 HP
	short mOptPlusMaxMp;							// ִ뷮 MP
	short mOptPlusMov;								// ̵
	short mOptPlusHp;								// HP ȸ
	short mOptPlusMp;								// MP ȸ

	// ɼ  - Percent
	short mOptPercentPhysicAttack;					// ݷ
	short mOptPercentMagicAttack;					// ݷ
	short mOptPercentPhysicDefense;					// 
	short mOptPercentMagicDefense;					// 
	short mOptPercentPhysicAttackRate;				// ߷
	short mOptPercentMagicAttackRate;				// ߷
	short mOptPercentPhysicCritical;				// ũƼ
	short mOptPercentMagicCritical;					// ũƼ
	short mOptPercentDod;							// ȸ
	short mOptPercentWei;							// 
	short mOptPercentMaxHp;							// ִ뷮 HP
	short mOptPercentMaxMp;							// ִ뷮 MP
	short mOptPercentMov;							// ̵
	short mOptPercentHp;							// HP ȸ
	short mOptPercentMp;							// MP ȸ

	// ɼ  - Etc
	short mOptPercentDrainHp;						// HP 
	short mOptPercentDrainMp;						// MP 
	short mOptPercentSkillHealInc;					// ų  ȸ 
	short mOptPercentDamageDec;						//  /
	short mOptPercentDamageRef;						//  ݻ
};

//    
#define MAX_DISJOINT_ITEM	6

struct eDisjointItem
{
	long  itemDefineIndex;
	short inventoryCount;
};

struct MSG_REQ_INVENTORY : public MSGROOT
{};
struct MSG_RES_INVENTORY : public MSGROOT
{
	eItemActiveWeapon activeWeapon;					// Ȱ (0 Front, 1Back).
	long              RowCount;						// 
	sInventory        Inventory[1];					// κ丮
};

struct MSG_REQ_INVENTORY_COOLTIME : public MSGROOT
{};
struct MSG_RES_INVENTORY_COOLTIME : public MSGROOT
{
	long               RowCount;					// 
	sInventoryCooltime InventoryCooltime[1];		// κ丮 Ÿ
};

/*--  ̵(κ丮)
*/
#define ERROR_ITEM_MOV_INVENTORY_SUCCESS		0	// 
#define ERROR_ITEM_MOV_INVENTORY_FAIL			1   // 
#define ERROR_ITEM_MOV_INVENTORY_NOTYET			2   // DBó
#define ERROR_ITEM_MOV_INVENTORY_MERGE			3	// 

struct MSG_REQ_ITEM_MOV_INVENTORY : public MSGROOT
{
	unsigned short number1;							// [in] ̵ 
	unsigned short number2;							// [in] ̵ 
};
struct MSG_RES_ITEM_MOV_INVENTORY : public MSG_ERROR
{};


#define ERROR_ITEM_MERGE_INVENTORY_SUCCESS		0	// 
#define ERROR_ITEM_MERGE_INVENTORY_FAIL			1   // 

struct MSG_RES_ITEM_MERGE_INVENTORY : public MSG_ERROR
{};

/*--  (κ丮)
*/
#define ERROR_ITEM_USE_INVENTORY_SUCCESS		0	// 
#define ERROR_ITEM_USE_INVENTORY_FAIL			1	// 
#define ERROR_ITEM_USE_INVENTORY_NOTYET			2   // DBó
#define ERROR_ITEM_USE_INVENTORY_COOLTIME		3	// Ÿ 
#define ERROR_ITEM_USE_INVENTORY_TITLE			4	// ȣĪ 

struct MSG_REQ_ITEM_USE_INVENTORY : public MSGROOT
{
	unsigned long  targetType;						//  Ÿ   'sObject '
	unsigned long  targetIndex;						//  ε "
	unsigned short number;							// κ丮 ȣ
};
struct MSG_RES_ITEM_USE_INVENTORY : public MSG_ERROR
{};


/*--  (κ丮)
*/
#define ERROR_ITEM_DEL_INVENTORY_SUCCESS		0	// 
#define ERROR_ITEM_DEL_INVENTORY_FAIL			1   // 
#define ERROR_ITEM_DEL_INVENTORY_NOTYET			2   // DBó

struct MSG_REQ_ITEM_DEL_INVENTORY : public MSGROOT
{
	unsigned short number;							// κ丮 ȣ
};
struct MSG_RES_ITEM_DEL_INVENTORY : public MSG_ERROR
{};


/*--  Ī/빫⸸ (κ丮)
*/
#define ERROR_ITEM_SWI_INVENTORY_SUCCESS		0	// 
#define ERROR_ITEM_SWI_INVENTORY_FAIL			1   // 
#define ERROR_ITEM_SWI_INVENTORY_NOTYET			2   // DBó

struct MSG_REQ_ITEM_SWI_INVENTORY : MSGROOT
{};
struct MSG_RES_ITEM_SWI_INVENTORY : MSG_ERROR
{
	eItemActiveWeapon activeWeapon;					// Ȱ (0 Front, 1Back).
};


/*--  (κ丮)
*/
#define ERROR_ITEM_DIVIDE_INVENTORY_SUCCESS		0	// 
#define ERROR_ITEM_DIVIDE_INVENTORY_FAIL		1	// 
#define ERROR_ITEM_DIVIDE_INVENTORY_NOTYET		2   // DBó

struct MSG_REQ_ITEM_DIVIDE_INVENTORY : MSGROOT
{
	unsigned short number1;							// κ丮 ȣ()
	unsigned short number2;							// κ丮 ȣ()
	unsigned short divide;							// 
};

struct MSG_RES_ITEM_DIVIDE_INVENTORY : MSG_ERROR
{
	unsigned long RowCount;							//   
	sInventory    Inventory[1];						// κ丮

	//  ޼ ũ
	unsigned long GetMsgLength( ) { return sizeof(MSG_RES_ITEM_DIVIDE_INVENTORY) - sizeof(Inventory) + (RowCount * sizeof(sInventory)); }
};


/*--  ȭ(κ丮)
*/

/// MSG_REQ_ITEM_ENHANCED_START = MSGROOT

#define ERROR_ITEM_ENHANCED_START_SUCCESS		0	// 
#define ERROR_ITEM_ENHANCED_START_FAIL			1	// 
/// MSG_RES_ITEM_ENHANCED_START = MSG_ERROR

struct MSG_SYN_ITEM_ENHANCED_START : public MSGROOT
{
	unsigned long	mCharacterIdx;
};


struct MSG_REQ_ITEM_ENHANCED_END : MSGROOT
{
	unsigned short number1;							// κ丮 ȣ(ȭ)
	unsigned short number2;							// κ丮 ȣ(Ҹ)
};

#define ERROR_ITEM_ENHANCED_END_SUCCESS	0	// 
#define ERROR_ITEM_ENHANCED_END_FAIL		1	// 
#define ERROR_ITEM_ENHANCED_END_NOTYET	2	// DBó

struct MSG_RES_ITEM_ENHANCED_END : MSG_ERROR
{
	sInventory Inventory[2];						// κ丮 (0ȭ/1ȭī)
};

struct MSG_SYN_ITEM_ENHANCED_END : public MSG_ERROR
{
	unsigned long	mCharacterIdx;
};

/// MSG_REQ_ITEM_ENHANCED_CANCEL = MSGROOT
#define ERROR_ITEM_ENHANCED_CANCEL_SUCCESS	0	/// 
#define ERROR_ITEM_ENHANCED_CANCEL_FAIL		1	/// 
/// MSG_RES_ITEM_ENHANCED_CANCEL = MSG_ERROR

struct MSG_SYN_ITEM_ENHANCED_CANCEL : MSGROOT
{
	unsigned long	mCharacterIdx;
};

/*--  (κ丮)
*/
#define ERROR_ITEM_DISJOINT_INVENTORY_SUCCESS	0	// 
#define ERROR_ITEM_DISJOINT_INVENTORY_FAIL		1	// 
#define ERROR_ITEM_DISJOINT_INVENTORY_NOTYET	2	// DBó

struct MSG_REQ_ITEM_DISJOINT_INVENTORY : MSGROOT
{
	unsigned short number;							// κ丮 ȣ()
};
struct MSG_RES_ITEM_DISJOINT_INVENTORY : MSG_ERROR
{
	unsigned long RowCount;							//   
	sInventory    Inventory[1];						// κ丮

	//  ޼ ũ
	unsigned long GetMsgLength( ) { return sizeof(MSG_RES_ITEM_DISJOINT_INVENTORY) - sizeof(Inventory) + (RowCount * sizeof(sInventory)); }
};


/*--  ī(κ丮)
*/
#define ERROR_ITEM_PUT_CARD_INVENTORY_SUCCESS	0	// 
#define ERROR_ITEM_PUT_CARD_INVENTORY_FAIL		1	// 
#define ERROR_ITEM_PUT_CARD_INVENTORY_NOTYET	2	// DBó

struct MSG_REQ_ITEM_PUT_CARD_INVENTORY : MSGROOT
{
	unsigned short number1;							// κ丮 ȣ()
	unsigned char  cardSlot;						// κ丮 ī彽 ȣ(1~5)
	unsigned short number2;							// κ丮 ȣ(ī)
};
struct MSG_RES_ITEM_PUT_CARD_INVENTORY : MSG_ERROR
{
	sInventory Inventory;							// κ丮
};


/*--  ü(κ丮)
*/
#define ERROR_ITEM_CHANGE_INVENTORY_SUCCESS		0	// 
#define ERROR_ITEM_CHANGE_INVENTORY_FAIL		1	// 
#define ERROR_ITEM_CHANGE_INVENTORY_NOTYET		2	// DBó

struct MSG_REQ_ITEM_CHANGE_INVENTORY : MSGROOT
{
	unsigned short number;							// κ丮 ȣ
};
struct MSG_RES_ITEM_CHANGE_INVENTORY : MSG_ERROR
{
	unsigned long RowCount;							//   
	sInventory    Inventory[1];						// κ丮

	//  ޼ ũ
	unsigned long GetMsgLength( ) { return sizeof(MSG_RES_ITEM_CHANGE_INVENTORY) - sizeof(Inventory) + (RowCount * sizeof(sInventory)); }
};


/*-- ŷ-ڰ
*/
#define ERROR_ITEM_EXCHANGE_ASK_SUCCESS			0	//  - û 
#define ERROR_ITEM_EXCHANGE_ASK_FAIL			1	//  -  ų ΰ
#define ERROR_ITEM_EXCHANGE_ASK_EXIST			2	//  - ̹ ŷ
#define ERROR_ITEM_EXCHANGE_ASK_DISTANCE		3	//  - Ÿ
#define ERROR_ITEM_EXCHANGE_ASK_OPTIONREFUSE	4	//  -  źλ
#define ERROR_ITEM_EXCHANGE_ASK_REPLAY			5	// 亯û

struct MSG_REQ_ITEM_EXCHANGE_ASK : MSGROOT
{
	sObject mTarget;								// ŷ  ĳ
};
struct MSG_RES_ITEM_EXCHANGE_ASK : MSG_ERROR
{
	unsigned long characterIdx;						// ŷ û ĳ - ERROR_ITEM_EXCHANGE_ASK_REPLAY ϶...
};


#define TYPE_ITEM_EXCHANGE_REP_ACCEPT			0	// ¶
#define TYPE_ITEM_EXCHANGE_REP_REJECT			1	// 

#define ERROR_ITEM_EXCHANGE_REP_SUCCESS			0	//  Ǵ û ¶
#define ERROR_ITEM_EXCHANGE_REP_FAIL			1	//  Ǵ û 
#define ERROR_ITEM_EXCHANGE_REP_NOTEXIST		2	//  

struct MSG_REQ_ITEM_EXCHANGE_REP : MSGROOT
{
	BYTE type;									// 亯
};
struct MSG_RES_ITEM_EXCHANGE_REP : MSG_ERROR
{};


struct MSG_RES_ITEM_EXCHANGE_BEGIN : MSGROOT
{};


#define TYPE_ITEM_EXCHANGE_ADD_ITEM				0	// ŷ
#define TYPE_ITEM_EXCHANGE_ADD_MONEY			1	// ŷ  

#define ERROR_ITEM_EXCHANGE_ADD_SUCCESS			0	// 
#define ERROR_ITEM_EXCHANGE_ADD_FAIL			1	// 

struct MSG_REQ_ITEM_EXCHANGE_ADD : MSGROOT
{
	BYTE type;									// (/ݾ)
	union
	{
		unsigned short number;					// κ丮 ȣ (ε)
		unsigned long  money;					// ݾ
	};
};
struct MSG_RES_ITEM_EXCHANGE_ADD : MSG_ERROR
{};
struct MSG_SYN_ITEM_EXCHANGE_ADD : MSGROOT
{
	BYTE type;									// (/ݾ)
	union
	{
		sInventory     inventory;				// κ丮
		unsigned long  money;					// ݾ
	};
};


#define ERROR_ITEM_EXCHANGE_DEL_SUCCESS			0	// 
#define ERROR_ITEM_EXCHANGE_DEL_FAIL			1	// 

struct MSG_REQ_ITEM_EXCHANGE_DEL : MSGROOT
{
	unsigned short number;						// κ丮 ȣ (ε)
};
struct MSG_RES_ITEM_EXCHANGE_DEL : MSG_ERROR
{};
struct MSG_SYN_ITEM_EXCHANGE_DEL : MSGROOT
{
	sInventory inventory;						// κ丮
};


#define ERROR_ITEM_EXCHANGE_OK_SUCCESS			0	// 
#define ERROR_ITEM_EXCHANGE_OK_FAIL				1	// 
#define ERROR_ITEM_EXCHANGE_OK_PLAYER			2	// 

struct MSG_REQ_ITEM_EXCHANGE_OK : MSGROOT
{};
struct MSG_RES_ITEM_EXCHANGE_OK : MSG_ERROR
{};


#define ERROR_ITEM_EXCHANGE_RETRY_SUCCESS		0	// 
#define ERROR_ITEM_EXCHANGE_RETRY_FAIL			1	// 
#define ERROR_ITEM_EXCHANGE_RETRY_PLAYER		2	// 

struct MSG_REQ_ITEM_EXCHANGE_RETRY : MSGROOT
{};
struct MSG_RES_ITEM_EXCHANGE_RETRY : MSG_ERROR
{};


#define ERROR_ITEM_EXCHANGE_CANCEL_SUCCESS		0	// 
#define ERROR_ITEM_EXCHANGE_CANCEL_FAIL			1	// 
#define ERROR_ITEM_EXCHANGE_CANCEL_PLAYER		2	// 

struct MSG_REQ_ITEM_EXCHANGE_CANCEL : MSGROOT
{};
struct MSG_RES_ITEM_EXCHANGE_CANCEL : MSG_ERROR
{};


#define ERROR_ITEM_EXCHANGE_END_SUCCESS			0	// 
#define ERROR_ITEM_EXCHANGE_END_FAIL			1	// 
#define ERROR_ITEM_EXCHANGE_END_WAIT			2	// 

struct MSG_REQ_ITEM_EXCHANGE_END : MSGROOT
{};
struct MSG_RES_ITEM_EXCHANGE_END : MSG_ERROR
{
	unsigned long RowCount;							//   
	sInventory    Inventory[1];						// κ丮

	//  ޼ ũ
	unsigned long GetMsgLength( ) { return sizeof(MSG_RES_ITEM_EXCHANGE_END) - sizeof(Inventory) + (RowCount * sizeof(sInventory)); }
};


/*-- -Ǹ
*/
#define ERROR_ITEM_STALL_SELL_SEARCH_SUCCESS	0	// 
#define ERROR_ITEM_STALL_SELL_SEARCH_FAIL		1	// 
#define ERROR_ITEM_STALL_SELL_SEARCH_NOTYET		2   // DBó

struct MSG_REQ_ITEM_STALL_SELL_SEARCH : MSGROOT
{
	unsigned long itemDefineIndex;					//  ε
	unsigned char enhanced;							// ȭܰ
};
struct MSG_RES_ITEM_STALL_SELL_SEARCH : MSG_ERROR
{
	long rowCount;								//   
	struct {
		unsigned long  idx;						// ȣ
		wchar_t	       characterName[ 17 ];		// Ǹ ĳ ̸
		unsigned long  price;					// ǸŰ
		unsigned short mapNumber;				// ʹȣ
		float          xPos;					// Xġ
		float          yPos;					// Yġ
	} table[ 1 ];
};


#define ERROR_ITEM_STALL_SELL_OPEN_SUCCESS		0	// 
#define ERROR_ITEM_STALL_SELL_OPEN_FAIL			1	// 
#define ERROR_ITEM_STALL_SELL_OPEN_EXIST		2	// ̹ 

struct MSG_REQ_ITEM_STALL_SELL_OPEN : MSGROOT
{
	wchar_t title[ MAX_STALL_TITLE_LEN ];			// 
};
struct MSG_RES_ITEM_STALL_SELL_OPEN : MSG_ERROR
{};
struct MSG_SYN_ITEM_STALL_SELL_OPEN : MSGROOT
{
	unsigned long characterIdx;						// ĳ ȣ
	wchar_t       title[ MAX_STALL_TITLE_LEN ];		// 
};


#define ERROR_ITEM_STALL_SELL_CLOSE_SUCCESS		0	// 
#define ERROR_ITEM_STALL_SELL_CLOSE_FAIL		1	// 

struct MSG_REQ_ITEM_STALL_SELL_CLOSE : MSGROOT
{};
struct MSG_RES_ITEM_STALL_SELL_CLOSE : MSG_ERROR
{};
struct MSG_SYN_ITEM_STALL_SELL_CLOSE : MSGROOT
{
	unsigned long characterIdx;						// ĳ ȣ
};


#define ERROR_ITEM_STALL_SELL_RENAME_SUCCESS	0	// 
#define ERROR_ITEM_STALL_SELL_RENAME_FAIL		1	// 

struct MSG_REQ_ITEM_STALL_SELL_RENAME : MSGROOT
{
	wchar_t title[ MAX_STALL_TITLE_LEN ];			// 
};
struct MSG_RES_ITEM_STALL_SELL_RENAME : MSG_ERROR
{};
struct MSG_SYN_ITEM_STALL_SELL_RENAME : MSGROOT
{
	unsigned long characterIdx;						// ĳ ȣ
	wchar_t       title[ MAX_STALL_TITLE_LEN ];		// 
};


#define ERROR_ITEM_STALL_SELL_ADD_SUCCESS		0	// 
#define ERROR_ITEM_STALL_SELL_ADD_FAIL			1	// 

struct MSG_REQ_ITEM_STALL_SELL_ADD : MSGROOT
{
	unsigned short number;							// κ丮 ȣ(Գѹ)
	unsigned long  price;							// ǸŰ
};
struct MSG_RES_ITEM_STALL_SELL_ADD : MSG_ERROR
{};
struct MSG_SYN_ITEM_STALL_SELL_ADD : MSGROOT
{
	sInventory inventory;							// κ丮
	unsigned long price;							// ǸŰ
};


#define ERROR_ITEM_STALL_SELL_DEL_SUCCESS		0	// 
#define ERROR_ITEM_STALL_SELL_DEL_FAIL			1	// 

struct MSG_REQ_ITEM_STALL_SELL_DEL : MSGROOT
{
	unsigned short number;							// κ丮 ȣ(Գѹ)
};
struct MSG_RES_ITEM_STALL_SELL_DEL : MSG_ERROR
{};
struct MSG_SYN_ITEM_STALL_SELL_DEL : MSGROOT
{
	sInventory inventory;							// κ丮
};


#define ERROR_ITEM_STALL_SELL_MOD_SUCCESS		0	// 
#define ERROR_ITEM_STALL_SELL_MOD_FAIL			1	// 

struct MSG_REQ_ITEM_STALL_SELL_MOD : MSGROOT
{
	unsigned short number;							// κ丮 ȣ(Գѹ)
};
struct MSG_RES_ITEM_STALL_SELL_MOD : MSG_ERROR
{};
struct MSG_SYN_ITEM_STALL_SELL_MOD : MSGROOT
{
	sInventory inventory;							// κ丮
};

struct MSG_RES_ITEM_STALL_SELL_COM : MSGROOT
{
	wchar_t characterName[ 17 ];					//  ̸
	sInventory inventory;							// κ丮
};

struct MSG_SYN_ITEM_STALL_SELL_DAT : MSGROOT
{
	sInventory    inventory;						// κ丮
	unsigned long price;							// 
};


#define ERROR_ITEM_STALL_SELL_JOIN_SUCCESS		0	// 
#define ERROR_ITEM_STALL_SELL_JOIN_FAIL			1	// 
#define ERROR_ITEM_STALL_SELL_JOIN_OVER			2	// -ο

struct sStallSellData
{
	eStallSellItemStatus status;					// 
	sInventory           inventory;					// κ丮
	unsigned long        price;						// 
};

struct MSG_REQ_ITEM_STALL_SELL_JOIN : MSGROOT
{
	sObject mTarget;								// Ÿ
};
struct MSG_RES_ITEM_STALL_SELL_JOIN : MSG_ERROR
{
	wchar_t        title[ MAX_STALL_TITLE_LEN ];	// 

	BYTE           rowCount;						//   
	sStallSellData stallSellData[1];

	//  ޼ ũ
	unsigned long GetMsgLength( ) { return sizeof(MSG_RES_ITEM_STALL_SELL_JOIN) - sizeof(stallSellData) + (rowCount * sizeof(sStallSellData)); }
};


#define ERROR_ITEM_STALL_SELL_LEAVE_SUCCESS		0	// 
#define ERROR_ITEM_STALL_SELL_LEAVE_FAIL		1	// 
#define ERROR_ITEM_STALL_SELL_LEAVE_CLOSED		2	// 

struct MSG_REQ_ITEM_STALL_SELL_LEAVE : MSGROOT
{};
struct MSG_RES_ITEM_STALL_SELL_LEAVE : MSG_ERROR
{};


#define ERROR_ITEM_STALL_SELL_GET_SUCCESS		0	// 
#define ERROR_ITEM_STALL_SELL_GET_FAIL			1	// 

struct MSG_REQ_ITEM_STALL_SELL_GET : MSGROOT
{
	unsigned short number;							// Źȣ
	unsigned short count;							// 
};
struct MSG_RES_ITEM_STALL_SELL_GET : MSG_ERROR
{
	BYTE       RowCount;							//   
	sInventory Inventory;							// κ丮
};


/*--  &
*/
struct sItemDrop
{
	unsigned long idx;								// ȣ
	float         xPos;								// X ġ
	float         yPos;								// Y ġ
};
struct sItemData
{
	unsigned long  itemDefineIndex;					//   ε
	unsigned short count;							// 
};

// NM_ITEM_DROP_IN_SYN & NM_ITEM_SIGHT_IN_RES 
struct MSG_ITEM_INFO : MSGROOT
{
	unsigned long owner[ MAX_OWNER ];				//   
	unsigned long timeToOwn;						//    ð(1/1000s)

	sItemDrop     itemDrop;              			//   
};
// NM_ITEM_DROP_OUT_SYN & NM_ITEM_SIGHT_OUT_RES 
struct MSG_ITEMIDX : MSGROOT
{
	unsigned long idx;								// ȣ
};


#define ERROR_ITEM_GET_OPEN_SUCCESS		0			// 
#define ERROR_ITEM_GET_OPEN_FAIL		1			// 
#define ERROR_ITEM_GET_OPEN_OWN         2           //  -  
#define ERROR_ITEM_GET_OPEN_DISTANCE    3           //  -    
#define ERROR_ITEM_GET_OPEN_EXIST       4           //  -  

// NM_ITEM_GET_OPEN_REQ 
struct MSG_REQ_ITEM_GET_OPEN : public MSGROOT
{
	unsigned long idx;								// ȣ
};
// NM_ITEM_GET_OPEN_RES 
struct MSG_RES_ITEM_GET_OPEN : public MSG_ERROR
{
	BYTE          rowCount;							//   
	sItemData     itemData[1];                      //  

	//  ޼ ũ
	unsigned long GetMsgLength() { return sizeof(MSG_RES_ITEM_GET_OPEN) - sizeof(itemData) + (rowCount * sizeof(sItemData)); }
};
// MSG_SYN_ITEM_GET_OPEN 
struct MSG_SYN_ITEM_GET_OPEN : public MSGROOT
{
	unsigned long characterIdx;						// ĳ ȣ
};


#define ERROR_ITEM_GET_CLOSE_SUCCESS	0			// 
#define ERROR_ITEM_GET_CLOSE_FAIL       1           // 

// NM_ITEM_GET_CLOSE_REQ 
struct MSG_REQ_ITEM_GET_CLOSE : public MSGROOT
{};
// NM_ITEM_GET_CLOSE_RES 
struct MSG_RES_ITEM_GET_CLOSE : public MSG_ERROR
{};
// NM_ITEM_GET_CLOSE_SYN 
struct MSG_SYN_ITEM_GET_CLOSE : public MSGROOT
{
	unsigned long characterIdx;						// ĳ ȣ
};


#define ITEM_GET_ALL					(-1)		// ݱ
#define ERROR_ITEM_GET_SUCCESS			0			// 
#define ERROR_ITEM_GET_FAIL				1			// 
#define ERROR_ITEM_GET_AUTO				2			// ڵ

// NM_ITEM_GET_REQ 
struct MSG_REQ_ITEM_GET : public MSGROOT
{
	unsigned long itemIndexOrInd;					//   ε Ǵ ݱ
};
// NM_ITEM_GET_RES
struct MSG_RES_ITEM_GET : public MSG_ERROR
{
	BYTE       RowCount;							//   
	sInventory Inventory[1];						// κ丮

	//  ޼ ũ
	unsigned long GetMsgLength( ) { return sizeof(MSG_RES_ITEM_GET) - sizeof(Inventory) + (RowCount * sizeof(sInventory)); }
};

// NM_ITEM_GET_LEAVE_RES 
struct MSG_RES_ITEM_GET_LEAVE : public MSGROOT
{
	BYTE          rowCount;							//   
	sItemData     itemData[1];						//  

	//  ޼ ũ
	unsigned long GetMsgLength() { return sizeof(MSG_RES_ITEM_GET_LEAVE) - sizeof(itemData) + (rowCount * sizeof(sItemData)); }
};

// NM_ITEM_GATHERING_OPEN_RES 
struct MSG_RES_ITEM_GATHERING_OPEN : public MSG_RES_ITEM_GET_OPEN
{};

// NM_ITEM_USE_RES 
struct MSG_RES_ITEM_USE : public MSGROOT
{
	sInventory inventory;							// κ丮
};

// NM_ITEM_REWARD_RES 
struct MSG_RES_ITEM_REWARD : public MSGROOT
{
	BYTE       rowCount;							//   
	sInventory inventory[1];						// κ丮

	//  ޼ ũ
	unsigned long GetMsgLength( ) { return sizeof(MSG_RES_ITEM_REWARD) - sizeof(inventory) + (rowCount * sizeof(inventory)); }
};

// NM_ITEM_MAKESKILL_RES , NM_ITEM_RECIPE_RES 
struct MSG_RES_MAKESKILL_ITEM : public MSGROOT
{
	sInventory inventory;						// κ丮
};

// NM_ITEM_TAKE_RES 
struct MSG_RES_ITEM_TAKE : public MSGROOT
{
	BYTE       rowCount;							//   
	sInventory inventory[1];						// κ丮

	//  ޼ ũ
	unsigned long GetMsgLength( ) { return sizeof(MSG_RES_ITEM_TAKE) - sizeof(inventory) + (rowCount * sizeof(inventory)); }
};


#define ERROR_ITEM_GET_QUEST_SUCCESS	0			// 
#define ERROR_ITEM_GET_QUEST_FAIL		1			// 

// NM_ITEM_GET_QUEST_RES 
struct MSG_RES_ITEM_GET_QUEST : public MSG_ERROR
{
	sInventory Inventory;							// κ丮
};


#define ERROR_ITEM_COLLECT_SUCCESS	0				// 
#define ERROR_ITEM_COLLECT_FAIL		1				// 
#define ERROR_ITEM_COLLECT_NOTYET	2				// DBó

// NM_ITEM_COLLECT_REG_REQ 
struct MSG_REQ_ITEM_COLLECT : public MSGROOT
{
	unsigned short number1;							// [in] ̵ 
	unsigned short number2;							// [in] ̵ 
};

struct MSG_RES_ITEM_COLLECT : public MSG_ERROR
{};


// NM_ITEM_MIXED_RES 
struct MSG_RES_ITEM_MIXED : public MSGROOT
{
	BYTE       rowCount;							//   
	sInventory inventory[1];						// κ丮

	//  ޼ ũ
	unsigned long GetMsgLength( ) { return sizeof(MSG_RES_ITEM_MIXED) - sizeof(inventory) + (rowCount * sizeof(inventory)); }
};

#pragma pack(pop)
