/* ==========================================================================
*      : MakeSkill_Common.h
*      : 
*    : ڰ
*    : 2009-01-05
* ǻ :
*===========================================================================*/
#pragma once

#include "CommonNetworkMsgStruct.h"

#pragma pack(push,1)

const int MAKESKILL_MAKE_ITEM_CNT = 3;
const int MAKESKILL_GROUP_MAX = 100000;

/// unsigned char
enum eMAKESKILL
{
	eMAKESKILL_COOK = 1,	/// 丮
	eMAKESKILL_PAINTCARD,	/// ī׸
};

/// ų
struct sMakeSkillScript
{
	unsigned long		mRecipeIdx;								/// idx
	unsigned char		mMakeSkill;								///   eMAKESKILL
	unsigned long		mType;									/// з Ÿ
	unsigned long		mGroupIdx;								///  ׷
	unsigned long		mMakeItemIdx[MAKESKILL_MAKE_ITEM_CNT];	/// ϼ 
	unsigned char		mMakeCnt[MAKESKILL_MAKE_ITEM_CNT];		/// ϼ 
	unsigned short		mMakeRate[MAKESKILL_MAKE_ITEM_CNT];		///  Ȯ()
	unsigned long		mMakeTime;								/// սð
	unsigned long		mNextMakeTime;							/// սð

	/// tArray<sMaterialScript*>
	tArray<void*>*		mpMaterial;								/// 

	sMakeSkillScript()
	{
		memset( this, 0, sizeof(sMakeSkillScript) );
	}
};

/// 
struct sMaterialScript
{
    unsigned long		mItemIdx;	/// 
	unsigned char		mItemCnt;	/// 
};


struct sRecipeInfo
{
	unsigned long		mRecipeIdx;
	unsigned long		mCoolTime;
};

struct sRecipeGroupInfo
{
	unsigned long		mRecipeIdx;
	unsigned char		mMakeSkill;
};

/// ų
struct MSG_RES_MAKESKILL_LIST : public MSGROOT
{
	unsigned short	mCount;
	sRecipeInfo		mRecipeInfo[1];

	unsigned long	GetMsgLength() { return sizeof(MSG_RES_MAKESKILL_LIST) - sizeof(mRecipeInfo) + 
		(mCount * sizeof(sRecipeInfo)); } 
};

const int ERROR_MAKESKILL_SUCCESS = 0;
const int ERROR_MAKESKILL_NOTHAVE = 1;
const int ERROR_MAKESKILL_ALREADY = 2;
const int ERROR_MAKESKILL_DBUSED = 3;
const int ERROR_MAKESKILL_ITEM = 4;
const int ERROR_MAKESKILL_STATE = 5;
const int ERROR_MAKESKILL_NOTEMPTY = 6;
const int ERROR_MAKESKILL_SCRIPT = 7;
const int ERROR_MAKESKILL_DBERROR = 8;

struct MSG_REQ_MAKESKILL_ADD : public MSGROOT
{
	unsigned short	mSlotNum;				/// κ ȣ
};

struct MSG_RES_MAKESKILL_ADD : public MSG_ERROR
{
	unsigned char	mMakeSkill;
};

struct MSG_REQ_MAKESKILL_DELETE : public MSGROOT
{
	unsigned char	mMakeSkill;
};

struct MSG_RES_MAKESKILL_DELETE : public MSG_ERROR
{
	unsigned char	mMakeSkill;
};

struct MSG_REQ_MAKESKILL_RECIPE_ADD : public MSG_REQ_MAKESKILL_ADD
{};

struct MSG_RES_MAKESKILL_RECIPE_ADD : public MSG_ERROR
{
	unsigned long		mCount;
	sRecipeGroupInfo	mGroupInfo[1];

	unsigned long	GetMsgLength() { return sizeof(MSG_RES_MAKESKILL_RECIPE_ADD) - sizeof(mGroupInfo) + (mCount * sizeof(sRecipeGroupInfo)); } 
};


struct MSG_REQ_MAKESKILL_ITEMMIX_START : public MSGROOT
{
	unsigned char	mMakeSkill;
	unsigned long	mRecipeIdx;
};

const int ERROR_MAKESKILL_START_SUCCESS = 0;
const int ERROR_MAKESKILL_START_SCRIPT = 1;
const int ERROR_MAKESKILL_START_COOLTIME = 2;
const int ERROR_MAKESKILL_START_HAVESKILL = 3;
const int ERROR_MAKESKILL_START_STATE = 4;
const int ERROR_MAKESKILL_START_DBERROR = 5;
/// MSG_REQ_MAKESKILL_ITEMMIX_START = MSG_ERROR

struct MSG_SYN_MAKESKILL_ITEMMIX_START : public MSGROOT
{
	unsigned long	mCharacterIdx;
};


/// MSG_REQ_MAKESKILL_ITEMMIX_END : public MSGROOT

const int ERROR_MAKESKILL_END_SUCCESS = 0;
const int ERROR_MAKESKILL_END_ITEM = 1;
const int ERROR_MAKESKILL_END_STATE = 2;
const int ERROR_MAKESKILL_END_TIME = 3;

/// MSG_RES_MAKESKILL_ITEMMIX_END : public MSG_ERROR

struct MSG_SYN_MAKESKILL_ITEMMIX_END : public MSG_ERROR
{
	unsigned long	mCharacterIdx;
};


struct MSG_SYN_MAKESKILL_ITEMMIX_CANCEL : public MSGROOT
{
	unsigned long	mCharacterIdx;
};

#pragma pack(pop)
