#pragma once

#include "ModeInfo.h"

//typedef tPointerList<void*> cModeInfoList;
typedef tPointerArray<void*> cModeInfoArr;

///
class cMode
{
public:
	cMode() {}
	virtual ~cMode();

	///
	inline unsigned long GetModeIndex() { return mModeIndex; }
	void SetModeIndex( unsigned long modeIdx )	{ mModeIndex = modeIdx; }

	///
	inline cModeInfoArr* GetInitModeInfoArr()			{ return &mInitModeInfoArr; }
	inline cModeInfoArr* GetProcessModeInfoArr()		{ return &mProcessModeInfoArr; }
	inline cModeInfoArr* GetConditionModeInfoArr()	{ return &mConditionModeInfoArr; }
	inline cModeInfoArr* GetCheckSkillModeInfoArr()	{ return &mCheckSkillModeInfoArr; }

	///
	void PushInitData( sModeInfoBase* pBase, bool bProcess = false );
	void PushConditionData( sModeInfoBase* pBase );
	void PushCheckSkill( sModeInfoBase* pBase );

protected:
	unsigned long mModeIndex;

	/// init info
	cModeInfoArr	mInitModeInfoArr;

	/// server
	/// process list
	cModeInfoArr	mProcessModeInfoArr;

	/// mode change check list
	cModeInfoArr	mConditionModeInfoArr;

	/// use skill check list
	cModeInfoArr	mCheckSkillModeInfoArr;
};


//////////////////////////////////////////////////////////////////////////
///
class cParser;

class cModeAgent
{
public:
	cModeAgent();
	virtual ~cModeAgent();

	bool LoadFile( unsigned long monsterIdx );

	inline cMode* GetMode( unsigned long modeIdx ) { return (cMode*)mModeMap.GetAt( modeIdx); }

#ifdef _CLIENT
	inline sModeObj* GetModeObject( unsigned short modeObjIdx ) { return (sModeObj*)mModeObjMap.GetAt( modeObjIdx); }
#endif

protected:
	bool LoadHeader( cParser& parser );
	bool LoadMode( cMode* mode, cParser& parser, unsigned long *orderNumMon, unsigned long *orderNumTotem );

	unsigned int GetLinkIndex( cString str );

protected:

#ifdef _CLIENT
	///  ü 
	typedef tPointerHashMap<unsigned short,void*> cModeObjMap;
	cModeObjMap	mModeObjMap;
#endif

	/// 
	typedef tPointerHashMap<unsigned long, void*> cModeMap;
	cModeMap	mModeMap;
};