#pragma once

//////////////////////////////////////////////////////////////////////////
// Mode used resource object
enum eMODEOBJ_KIND
{
	eMODEOBJ_EFFECT = 0,	/// Ʈ ü(nif)
	eMODEOBJ_SOUND,		///  ü
};

#ifdef _CLIENT
struct sModeObj
{
	eMODEOBJ_KIND	kind;
	cString			file;

	/// effect  
	NiMatrix3		rot;
	float			scale;

	/// sound  
	unsigned long	soundListIndex;

	sModeObj()
	{
		rot = NiMatrix3::IDENTITY;
		scale = 1.0f;
	}
};
#endif


//////////////////////////////////////////////////////////////////////////
// Mode Info
enum eMODEINFO_TYPE
{
	eMODEINFO_APPLYBUFF = 0,
	eMODEINFO_GENMONSTER,
	eMODEINFO_GENTOTEM,
	eMODEINFO_SPEECH,
	eMODEINFO_MODESTATE,
	eMODEINFO_AGGRO,
	eMODEINFO_MODEINITSKILL,
	eMODEINFO_APPLYRESOURCE,
	eMODEINFO_MODECHANGE,
	eMODEINFO_USESKILL,

	eMODEINFO_MAX,
};

///

struct sCoditionInfo
{
	unsigned char conType;
	unsigned long conValue;
};

struct sModeInfoBase
{
	eMODEINFO_TYPE	type;

	sModeInfoBase()
	{
	}
};

struct sModeBuff : public sModeInfoBase
{
	unsigned long	mApplyBuffIdx;
	bool			mModeDel;
};

struct sModeGenMonster : public sModeInfoBase
{
	unsigned long	mGenMonsterIdx;
	
	unsigned long	mOrderNum;

	unsigned char	mCount;

	unsigned long	mGenRange;

	bool			mLoop;
	unsigned long	mDelayTime;
};

struct sModeGenTotem : public sModeInfoBase
{
	unsigned long	mGenTotemIdx;

	unsigned long	mOrderNum;

	unsigned char	mCount;

	unsigned long	mGenRange;

	bool			mLoop;
	unsigned long	mDelayTime;
};

struct sModeSpeech : public sModeInfoBase
{
	unsigned long	mSpeechIdx;
};

struct sModeState : public sModeInfoBase
{
	unsigned long	mAnimationIdx;

	unsigned long	mMaintainTime;
};

struct sModeResource : public sModeInfoBase
{
	unsigned short	mModeObjIdx;
	bool			mLoop;
	bool			mFollow;
	unsigned char	mLinkPos;

	NiPoint3		mVar;
};

struct sModeAggro : public sModeInfoBase
{
};

struct sModeChange : public sModeInfoBase
{
	unsigned long	mModeIdx;

	sCoditionInfo	mCondition[2];
};

struct sModeSkill : public sModeInfoBase
{
	unsigned long	mSkillIdx;

	unsigned long	mModeDelayTime;

	unsigned short	mActionPer;

	sCoditionInfo	mCondition[2];
};

struct sModeInitSkill : public sModeInfoBase
{
};