#include "StdAfx.h"
#include "MonsterScript.h"

#include "Monster_Common.h"

#include "Token.h"
#include "Parser.h"
#include "Lexer.h"
#include "FileLoader.h"
#include "Tokenizer.h"

#include "Mode.h"

#include "Stage_Common.h"
#include "BaseObject.h"

#ifdef _CLIENT
#include "GameResourceManager.h"
#else
#include "Drop_Common.h"
#endif




cMonsterScript* cMonsterScript::mpMonsterScript = NULL;



cMonsterScript::cMonsterScript(void)
{

	/// ̱
	if( mpMonsterScript )
	{
		assert(NULL);
	}
	else
	{
		mpMonsterScript = this;
	}

	mpMonsterMap = new cPointHashMap( 999 );
	mpMonsterModeAgentMap = new cPointHashMap( 999 );
	mpRegenMonsterMap = new cPointHashMap( 999 );
	mpRegenGroupMap = new cPointHashMap( 999 );
	mpModelNumberMap = new cPointHashMap( 100 );
	mpMonsterTalkMap = new cPointHashMap( 999 );
	mpRegenSwitchGroup = new cPointHashMap( 100 );
	//mpMonsterCourseMoveMap = new cPointHashMap( 999 );
}



bool cMonsterScript::Init( )
{

	///   Ʈ ε
	if( !LoadMonsterList() )
	{
		assert(NULL);
		return false;
	}


#ifndef _CLIENT

	for( unsigned short mapNumber = MAP_MIN ; mapNumber <= MAP_MAX ; ++mapNumber )
	{
		/// ʿ ġ  ε
		if( !LoadRegenMonsterlist( mapNumber ) )
		{
			assert(NULL);
			return false;
		}
	}

	/////   ġ̵ ε
	//if( !LoadMonsterCourseMove() )
	//{
	//	assert(NULL);
	//	return false;
	//}

	if( LoadMonsterTalkList() == false )
	{
		assert(NULL);
		return false;
	}

#endif

	return true;

}



void cMonsterScript::Release()
{
	ReleaseRegenSwitchGroup();
	ReleaseMonsterTalk();
	ReleaseModelNumber();
	ReleaseRegenGroup();
	ReleaseRegenMonster();
	ReleaseMonsterMode();
	ReleaseMonsterList();

	SAFE_DELETE( mpRegenSwitchGroup );
	SAFE_DELETE( mpMonsterTalkMap );
	SAFE_DELETE( mpModelNumberMap );
	SAFE_DELETE( mpRegenGroupMap );
	SAFE_DELETE( mpRegenMonsterMap );
	SAFE_DELETE( mpMonsterModeAgentMap );
	SAFE_DELETE( mpMonsterMap );

	//mpMonsterCourseMoveMap = new cPointHashMap( 999 );

	//ReleaseCourseMove();
}



bool cMonsterScript::LoadMonsterList()
{

	cFileLoader loader;
	cString pathName = "./Script/Resource/MonsterList.txt";

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load MonsterList.txt" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	sMonsterScript* pList = NULL;
	while( tokenizer.IsEnd() == false )
	{
		pList = new sMonsterScript;

		//  index
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mMonsterClassIdx = str.ToInt();

		///  ̸Idx
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mNameIdx = str.ToInt();

#ifdef _CLIENT
		///  ̸
		_stprintf( pList->mName, _T( "%s" ), GAMERESOURCEMAN->GetMonsterName( pList->mNameIdx ) ); 
#else
		///  ̸
		_stprintf( pList->mName, _T( "" ) ); 
#endif

		/// kfmidx
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mKfmIdx = str.ToInt();

		/// ̸ ̰
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mNameHeight = str.ToInt();

		///
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mKind = (unsigned char)str.ToInt();

		/// Ӽ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mType = (unsigned char)str.ToInt();

		/// 
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mLevel = (unsigned char)str.ToInt();

		/// HP
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mMaxHp = str.ToInt();

		/// MP
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mMaxMp = str.ToInt();

		/// expȹ淮
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mExp = str.ToInt();

		/// sxpȹ淮
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mSxp = str.ToInt();

		/// 
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mDef = (unsigned short)str.ToInt();

		/// 
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mMdef = (unsigned short)str.ToInt();

		/// ȸ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mAvoid = (unsigned short)str.ToInt();

		/// þ߹
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mSeekRange = str.ToInt();

		/// 
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mImportance = (unsigned char)str.ToInt();

		/// ũ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mMonsterScale = str.ToFloat();

		/// ع -  
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mMonsterFixSize = str.ToFloat();

		/// ൿ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mFreeMoveRange = str.ToInt();

		/// ൿ()
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mActionStopRatio = (unsigned short)str.ToInt();

		/// ൿ(ȱ)
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mActionWalkRatio = (unsigned short)str.ToInt();

		/// ൿ(ٱ)
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mActionRunRatio = (unsigned short)str.ToInt();

		/// ð
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mActionStopTime = str.ToInt();

		/// ̵ӵ(ȱ)
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mActionWalkSpd = str.ToInt();

		/// ̵ӵ(ٱ,)
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mActionRunSpd = str.ToInt();

		/// 
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mIsPrecedeAttack = str.ToInt() == 1 ? true : false;

		/// ð
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mFollowTime = str.ToInt();

		/// Ÿ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mFollowRange = str.ToInt();

		/// 
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mEscapeType = (unsigned char)str.ToInt();

		/// Ȯ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mEscapePer = (unsigned char)str.ToInt();

		/// ȸ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mIsRecovery = str.ToInt() == 1 ? true : false;

		/// ȸ۽ð
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mRecoveryTime = str.ToInt();

		/// ؽ   
		if( mpMonsterMap->Insert( pList->mMonsterClassIdx, pList ) == false )
		{
			assert(0);
			goto ERR;
		}

		LoadMonsterMode( pList->mMonsterClassIdx );
	}

	return true;

ERR:
	delete pList;
	return false;

}


sMonsterScript* cMonsterScript::GetMonsterListInfo( unsigned long monsterIdx )
{
	return (sMonsterScript*)mpMonsterMap->GetAt( monsterIdx );
}



void cMonsterScript::ReleaseMonsterList()
{
	if( mpMonsterMap )
	{
		sMonsterScript* pInfo = NULL;
		cPointHashMap::cIterator i = mpMonsterMap->Begin();
		cPointHashMap::cIterator end = mpMonsterMap->End();

		cPointHashMap* pDropMap = NULL;
		cPointHashMap::cIterator q;
		cPointHashMap::cIterator qEnd;

		for( ; i != end; ++i )
		{
			pInfo = (sMonsterScript*)((*i).mSecond);
			if( pInfo )
			{
#ifndef _CLIENT
				sDropQType* pDropQ;
				cAryVoid* pAry;

				/// Ʈ   
				pDropMap = pInfo->mpQuestItemDropMap;
				if( pDropMap != NULL )
				{
					q = pDropMap->Begin();
					qEnd = pDropMap->End();
					for( ; q != qEnd; ++q )
					{
						pAry = (cAryVoid*)((*q).mSecond);
						if( pAry == NULL )
							continue;

						for( unsigned long j = 0 ; j < pAry->GetSize() ; ++j )
						{
							pDropQ = (sDropQType*)(*pAry)[j];
							delete pDropQ;
						}					
						pAry->Clear();
						SAFE_DELETE( pAry );
					}
					pDropMap->Clear();
					SAFE_DELETE( pDropMap );
				}
#endif

				///   
				delete pInfo;
				pInfo = NULL;
			}
		}
		mpMonsterMap->Clear();
	}
}



bool cMonsterScript::LoadRegenMonsterlist( unsigned short mapnum )
{
	cFileLoader loader;
	cString pathName;
	pathName.Format( "./Script/Resource/MonsterRegen%d.txt", mapnum );
	unsigned long insertIdx = 1;

	if( loader.Open( pathName, true ) == false )
	{
		///   ϸ 
		return true;
	}

	if( loader.GetSize() == 0 )
		return true;

	/// Ľ
	cTokenizer tok( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n\"", pathName.Cstr() );
	cString str;

	unsigned short groupNumber = 0;

	sRegenGroupScript* pGroupList = NULL;
	sRegenScript* pList = NULL;
	cHashSet* pMondelNumberHashSet = new cHashSet;

	float direction = 0;

	while( tok.IsEnd() == false )
	{
		/// ȣ ù ׷ȣ
		tok.GetNext( &str );
		groupNumber = (unsigned short)str.ToInt();

		/// ׷ ȣ ʳѹ ڸ ħϴ° 
		if( MAPNUMBER_UNIT <= groupNumber )
		{
			assert(NULL);
			goto ERR;
		}

		/// ʺ  ϱ ׷ ѹ
		groupNumber = ( mapnum * MAPNUMBER_UNIT ) + groupNumber;

		/// ׷ ȣ  ׸ 
		tok.GetNext( &str );
		if( str != '{' )
		{
			assert( 0 && "wrong script" );
			goto ERR;
		}

		/// ׷  
		pGroupList = new sRegenGroupScript;

		pGroupList->mGroupIdx = groupNumber;
		/// ۽ Ǵ ׷ 
		tok.GetNext( &str );
		pGroupList->mServerOnRegen = str.ToInt() == 0 ? true : false;	
		/// ׷      ׷ȣ
		tok.GetNext( &str );
		pGroupList->mRegenGroupIdx = ( mapnum * MAPNUMBER_UNIT ) + str.ToInt();		
		///  ׷ Ͱ  ۼƼ  ΰ 
		tok.GetNext( &str );
		pGroupList->mRegenPer = (unsigned char)str.ToInt();
		tok.GetNext( &str );
		pGroupList->mRegenRange = str.ToInt();
		tok.GetNext( &str );
		pGroupList->mRegenTime = str.ToInt();
		///  ׷ȣ
		tok.GetNext( &str );
		pGroupList->mMapGroupIdx = str.ToInt();
		/// ä  üũ
		tok.GetNext( &str );
		pGroupList->mChannelCheck = str.ToInt() == 0 ? true : false;	

		///  ׷   
		if( pGroupList->mMapGroupIdx != 0 )
		{
			cArray* pSwitchGroup = (cArray*)mpRegenSwitchGroup->GetAt( pGroupList->mMapGroupIdx );
			if( pSwitchGroup == NULL )
			{
				pSwitchGroup = new cArray;
				if( mpRegenSwitchGroup->Insert( pGroupList->mMapGroupIdx, pSwitchGroup ) == false )
					goto ERR;
			}

			pSwitchGroup->PushBack( groupNumber );
		}


		while( tok.IsEnd() == false )
		{
			tok.GetNext( &str );
			if( str == "}" )
				break;

			///     
			pList = new sRegenScript;

			///   ȣ
			pList->mMonsterClassIdx = str.ToInt();
			tok.GetNext( &str );
			pList->mRegenX = str.ToFloat();
			tok.GetNext( &str );
			pList->mRegenY = str.ToFloat();
			tok.GetNext( &str );

			direction = str.ToFloat();
			if( direction > 999.9 )
				direction = S_ToRadian( direction );

			pList->mDirection = direction;

			tok.GetNext( &str );
			pList->mRegenTime = str.ToInt();
			tok.GetNext( &str );
			pList->mRegenLifeTime = str.ToInt();

			pList->mMapNumber = mapnum;
			pList->mGroupNumber = groupNumber;

			///  ȣ ʳѹ ڸ ħϴ° 
			if( MAPNUMBER_UNIT <= insertIdx )
			{
				assert(NULL);
				goto ERR;
			}

			pList->mRegenIdx = ( mapnum * MAPNUMBER_UNIT ) + insertIdx;

			///  ε     ϱ ʹȣ  ȣ 
			if( mpRegenMonsterMap->Insert( ( mapnum * MAPNUMBER_UNIT ) + insertIdx, pList ) == false )
			{
				assert(NULL);
				goto ERR;
			}

			/// ׷   ȣ 
			pGroupList->mMonsterAry.PushBack( ( mapnum * MAPNUMBER_UNIT ) + insertIdx );

			///  ܵ ȣ 
			++insertIdx;

			/// Ŭ̾Ʈ loadstage  Ÿ о;    
			if( pMondelNumberHashSet->GetCount( pList->mMonsterClassIdx ) == 0 )
			{
				pMondelNumberHashSet->Insert( pList->mMonsterClassIdx );
			}
		}

		/// ׷쿡 شϴ   Ȯ
		if( pGroupList->mMonsterAry.GetSize() == 0 )
		{
			assert(NULL);
			goto ERR;
		}

		/// ׷  ߰
		if( mpRegenGroupMap->Insert( groupNumber, pGroupList ) == false )
		{
			assert(NULL);
			goto ERR;
		}
	}

	/// ʿ شϴ   ؽ 
	if( mpModelNumberMap->Insert( mapnum, pMondelNumberHashSet ) == false )
	{
		assert(NULL);
		goto ERR;
	}

	return true;

ERR:
	delete pList;
	delete pGroupList;
	return false;
}



sRegenScript* cMonsterScript::GetRegenMonsterInfo( unsigned long monsterIdx )
{
	return (sRegenScript*)mpRegenMonsterMap->GetAt( monsterIdx );
}



sRegenGroupScript* cMonsterScript::GetRegenGroupInfo( unsigned long groupIdx )
{
	return (sRegenGroupScript*)mpRegenGroupMap->GetAt( groupIdx );
}



void cMonsterScript::ReleaseRegenMonster()
{
	if( mpRegenMonsterMap )
	{
		sRegenScript* pInfo = NULL;
		cPointHashMap::cIterator i = mpRegenMonsterMap->Begin();
		cPointHashMap::cIterator end = mpRegenMonsterMap->End();
		for( ; i != end; ++i )
		{
			pInfo = (sRegenScript*)((*i).mSecond);
			if( pInfo )
			{
				delete pInfo;
				pInfo = NULL;
			}
		}
		mpRegenMonsterMap->Clear();
	}

}



void cMonsterScript::ReleaseRegenGroup()
{
	if( mpRegenGroupMap )
	{
		sRegenGroupScript* pInfo = NULL;
		cPointHashMap::cIterator i = mpRegenGroupMap->Begin();
		cPointHashMap::cIterator end = mpRegenGroupMap->End();
		for( ; i != end; ++i )
		{
			pInfo = (sRegenGroupScript*)(*i).mSecond;
			if( pInfo )
			{
				SAFE_DELETE(pInfo);
			}
		}
		mpRegenGroupMap->Clear();
	}
}



void cMonsterScript::ReleaseModelNumber()
{
	if( mpModelNumberMap )
	{
		cHashSet* pInfo = NULL;
		cPointHashMap::cIterator i = mpModelNumberMap->Begin();
		cPointHashMap::cIterator end = mpModelNumberMap->End();
		for( ; i != end; ++i )
		{
			pInfo = (cHashSet*)(*i).mSecond;
			if( pInfo )
			{
				SAFE_DELETE(pInfo);
			}
		}
		mpModelNumberMap->Clear();
	}
}



bool cMonsterScript::LoadMonsterTalkList()
{
	cFileLoader loader;
	cString pathName = "./Script/Resource/MonsterSpeech.txt";

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load MonsterSpeech.txt" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	sMonsterTalk* pList = NULL;
	sMonsterTalk** pArray = NULL;
	while( tokenizer.IsEnd() == false )
	{
		pList = new sMonsterTalk;

		//  index
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		unsigned long monsterClassIdx = str.ToInt();

		/// Ȳ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		eMONSTER_TALK_STATE talk = (eMONSTER_TALK_STATE)str.ToInt();

		if( talk >= eMONSTERTALK_MAX )				{ goto ERR; }

		/// ǥ 
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mViewType = (unsigned char)str.ToInt();

		///  ǥ Ȯ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mViewPercent = (unsigned char)str.ToInt();

		///  ǥ üũ ð
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mCheckTime = str.ToInt();

		///  ε
		for( unsigned long i = 0 ; i < MONSTER_TALK_SIZE ; ++i )
		{
			if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
			pList->mTalkIdx[i] = str.ToInt();
		}

		pArray = (sMonsterTalk**)mpMonsterTalkMap->GetAt( monsterClassIdx );
		if( pArray == NULL )
		{
			sMonsterTalk** arry = new sMonsterTalk*[eMONSTERTALK_MAX];
			memset( arry, 0, sizeof(sMonsterTalk*) * eMONSTERTALK_MAX );

			pArray = arry;

			/// ؽ   
			if( mpMonsterTalkMap->Insert( monsterClassIdx, pArray ) == false )
			{
				assert(NULL);
				goto ERR;
			}
		}

		if( pArray[talk] != NULL )
		{
			assert(NULL);
			goto ERR;
		}

		pArray[talk] = pList;
	}

	return true;

ERR:
	delete pList;
	return false;
}


sMonsterTalk* cMonsterScript::GetMonsterTalkInfo( unsigned long monsterClassIdx, unsigned char state )
{
	if( state >= eMONSTERTALK_MAX )
	{
		assert(NULL);
		return NULL;
	}

	sMonsterTalk** pArray = (sMonsterTalk**)mpMonsterTalkMap->GetAt( monsterClassIdx );
	if( pArray == NULL )
		return NULL;

	return pArray[state];		
}


void cMonsterScript::ReleaseMonsterTalk()
{
	if( mpMonsterTalkMap )
	{
		/// mMonsterDramaturgyInfoMap Clear
		cPointHashMap::cIterator i = mpMonsterTalkMap->Begin();
		cPointHashMap::cIterator end = mpMonsterTalkMap->End();
		for( ; i != end; ++i )
		{
			sMonsterTalk** pInfo = (sMonsterTalk**)((*i).mSecond);
			for( unsigned int j = 0 ; j < eMONSTERTALK_MAX ; ++j )
				SAFE_DELETE( pInfo[j] );

			SAFE_DELETE_ARRAY( pInfo );
		}
		mpMonsterTalkMap->Clear();
	}
}

void cMonsterScript::LoadMonsterMode( unsigned long monsterIdx )
{
	cModeAgent* modeAgent = new cModeAgent;
	if( modeAgent == 0 )
	{
		assert(0);
		return;
	}

	if( modeAgent->LoadFile( monsterIdx ) == false )
	{
		delete modeAgent;
		return;
	}

	if( mpMonsterModeAgentMap->Insert( monsterIdx, modeAgent ) == false )
	{
		assert(0);
		delete modeAgent;
		return;
	}
}

void cMonsterScript::ReleaseMonsterMode()
{
	if( mpMonsterModeAgentMap )
	{
		/// 
		cPointHashMap::cIterator i = mpMonsterModeAgentMap->Begin();
		cPointHashMap::cIterator end = mpMonsterModeAgentMap->End();
		for( ; i != end; ++i )
		{
			cModeAgent* agent = (cModeAgent*)((*i).mSecond);
			SAFE_DELETE( agent );
		}
		mpMonsterModeAgentMap->Clear();
	}
}

cModeAgent* cMonsterScript::GetMonsterModeAgent( unsigned long monsterIdx )
{
	return (cModeAgent*)mpMonsterModeAgentMap->GetAt( monsterIdx );
}

void cMonsterScript::ReleaseRegenSwitchGroup()
{
	if( mpRegenSwitchGroup )
	{
		/// mpRegenSwitchGroup Clear
		cPointHashMap::cIterator i = mpRegenSwitchGroup->Begin();
		cPointHashMap::cIterator end = mpRegenSwitchGroup->End();
		for( ; i != end; ++i )
		{
			cArray* pInfo = (cArray*)((*i).mSecond);
			SAFE_DELETE( pInfo );
		}
		mpRegenSwitchGroup->Clear();
	}
}