/* ==========================================================================
*      : NpcScript.h
*      : 
*    : ڰ
*    : 2007-04-25
* ǻ :
*===========================================================================*/
#pragma once
#include "Lexer.h"

struct sNPCList;
struct sNPCRegen;
struct sNpcFuncData;

//////////////////////////////////////////////////////
/// Npc ū Ÿ
enum
{
	/// Npc ȭ
	eTOKEN_NPC_TELLING = 100,

	/// 
	eTOKEN_STORE,
	eTOKEN_WAREHOUSE,
	eTOKEN_SKILLSTORE,
	eTOKEN_DISJOINT,
	eTOKEN_GUILD,
	eTOKEN_TAROT,

	eTOKEN_NONE,
};

class cParser;

class cNPCScript
{
public:

	static cNPCScript*	 mpNPCScript;

public:

	cNPCScript();
	virtual ~cNPCScript();

	bool						Init();
	void						Release();


	/*--------------- NPC Ʈ ---------------*/
	/// ũƮ ε
	bool						LoadNPCList();
	///  ȸ
	sNPCList*					GetNPCList( unsigned long idx );
	///  
	void						ReleaseNPCList();
	/// ؽ ͸ ѱ
	const tPointerHashMap<unsigned long, sNPCList*>* GetNPCListMap() { return (tPointerHashMap<unsigned long, sNPCList*>*)mpNPCListMap; }

	
	/*--------------- NPC  Ʈ ---------------*/
	/// ũƮ ε
	bool						LoadNPCRegen( unsigned short mapNumber );
	///  ȸ
	sNPCRegen*					GetNPCRegen( unsigned long idx );
	/// NPC   ޸ 
	void						ReleaseNPCRegen();
	///  Ʈ ؽ ͸ ѱ
	const tPointerHashMap<unsigned long, sNPCRegen*>* GetNPCRegenMap() { return (tPointerHashMap<unsigned long, sNPCRegen*>*)mpNPCRegenMap; }


	/*---------------   ---------------*/
	///   
	tHashSet<unsigned long>*	GetNpcModelNumber( unsigned long map ) { return (tHashSet<unsigned long>*)mpModelNumberMap->GetAt( map ); }
	///   
	void						ReleaseModelNumber();

	/*---------------   ---------------*/
	/// ũƮ ε
	bool						LoadNPCStore();
	/// ũƮ ׸ ε
	unsigned long				LoadNpcStoreDetail( cParser& parser, sNpcFuncData* data );
	///  ȸ
	bool						IsHaveNpcFunc( unsigned long classIdx, unsigned int func );

	sNpcFuncData*				GetNpcFuncData( unsigned long classIdx );

private:

	typedef tPointerHashMap<unsigned int, void*> cPointHashMap;

	///  Ʈ
	typedef tPointerHashSet<unsigned long> cHashSet;

	/// NPC Ʈ
	//typedef tPointerHashMap<unsigned int, sNPCList*> cNPCListMap;
	cPointHashMap*				mpNPCListMap;

	/// NPC Ʈ
	//typedef tPointerHashMap<unsigned int, sNPCRegen*> cNPCRegenMap;
	cPointHashMap*				mpNPCRegenMap;

	/// ʺ  ѹ ؽ
	// typedef tPointerHashMap<unsigned long, cHashSet*> cModelNumberMap;
	cPointHashMap*				mpModelNumberMap;


	/// npc  (,â...)eNpcFunc
	//typedef tHashMap<unsigned long, unsigned long> cHashMap;
	//cHashMap*					mpNpcStore;

	/// npc  (,â...) (sNpcFuncData)
	typedef tPointerHashMap<unsigned long, void*> cNpcFuncMap;
	cNpcFuncMap*		mpNpcFuncMap;
};

/// Npc  м
class cNpcStore : public cLexer
{
public:
	cNpcStore( const char* buffer, unsigned int size );
};

#define NPCSCRIPT cNPCScript::mpNPCScript
