/* ==========================================================================
*      : Npc_Common.h
*      : 
*    : ڰ
*    : 2007-04-25
* ǻ :
*===========================================================================*/

#pragma once
#pragma pack(push,1)

#include "CommonNetworkMsgStruct.h"
#include "Item_common.h"
#include "Quest_Common.h"

#define NPC_VALID_DISTANCE		100.0f
#define NPC_FUNC_MAX			5			//  npc   ִ ִ  

/// npc ȭ 
enum eNPC_TALK_TYPE
{
	eNPCTALK_OPEN = 0,			/// NPCȭ 
	eNPCTALK_SKILLADD,			/// ų 
	eNPCTALK_ITEMBUY,			/// item 
	eNPCTALK_ITEMSELL,			/// item ȱ
	eNPCTALK_INVENTORY,			/// â 
	eNPCTALK_QUESTADD,			/// Ʈ ߰
	eNPCTALK_QUESTREWARD,		/// Ʈ 
	eNPCTALK_GUILDCREATE,		///  
	eNPCTALK_NPCTAROT,			/// NPC ¢
};

/// Npc 
enum eNpcFunc
{
	NPC_FUNC_NULL = 0,
	NPC_FUNC_STORE,
	NPC_FUNC_WAREHOUSE,
	NPC_FUNC_SKILLSTORE,
	NPC_FUNC_ITEMDISJOINT,		///  
	NPC_FUNC_GUILD,				/// 
	NPC_FUNC_TAROT,				/// Ÿ
};

struct sNPCList
{
	unsigned long	mNpcClassIdx;	/// NPC 
	TCHAR			mName[32];		/// NPC ̸
	TCHAR			mJobName[32];	/// JOB ̸
	//unsigned long	mNpcJobIdx;		/// NPC  ε
	unsigned int	mModelIndex;	/// NPC  ȣ
	unsigned long	mJobIconIndexLarge;	///  ε - ū
	unsigned long	mJobIconIndexSmall;	///  ε - 
};

struct sNPCRegen
{
	unsigned long	mNpcClassIdx;	/// NPC 
	unsigned short	mMapNumber;		/// ʹȣ
	float			mPosX;			/// Xǥ
	float			mPosY;			/// Yǥ
	float			mDirection;		/// 
};

/// NPC ü 
struct sNpcData
{
	unsigned long	mNpcIdx;		/// ε
	unsigned int	mNpcClassIdx;	/// ȣ
	unsigned short	mMapNumber;		/// ʹȣ
	float			mPosX;			/// ǥ
	float			mPosY;
	float			mDirection;		/// 

	eNpcQuestStatus	mQuestStatus;
};

/// NPC Func 
struct sNpcFuncData
{
	int				mFuncCount;		///  
	unsigned long	mFunc[5];		/// npc store Ÿ
	unsigned long	mTarotPrice;	/// 
};

/// NPC ü
struct MSG_NPC_INFO : public MSGROOT
{
	unsigned long	mCount;			/// NPC 
	sNpcData		mNpcInfo[1];	/// NPC 

	///  ޼ ũ
	unsigned long GetMsgLength() { return sizeof(MSG_NPC_INFO) - sizeof(mNpcInfo) + (mCount * sizeof(sNpcData)); }
};

/// NPC IDX
struct MSG_NPCIDX : public MSGROOT
{
	unsigned long	mNpcIdx;
};


#define ERROR_NPC_OPEN_SUCCESS		0	/// 
#define ERROR_NPC_OPEN_RANGE		1	/// Ÿ 
#define ERROR_NPC_OPEN_PLAYERSTATE	2	/// ÷̾  
#define ERROR_NPC_OPEN_NPC			3	/// npc ȭ ° Ʋ
#define ERROR_NPC_OPEN_DEALLIST		4	/// npc ʴ 
#define ERROR_NPC_OPEN_ALREADY		5	/// ȭ npc ٽ û 


struct MSG_REQ_NPC_OPEN : public MSGROOT
{
	unsigned long	mNpcIdx;
};

struct MSG_RES_NPC_OPEN : public MSG_ERROR
{
	unsigned long	mNpcIdx;
	float			mPosX;
	float			mPosY;
};

struct MSG_SYN_NPC_OPEN : public MSG_ERROR
{
	unsigned long	mCharacterIdx;
	float			mPosX;
	float			mPosY;
};

struct MSG_SYN_NPC_CLOSE : public MSG_ERROR
{
	unsigned long	mCharacterIdx;
};

// â ̿ Ա 
#define ERROR_NPC_DEPOSIT_SUCCESS	0	// 
#define ERROR_NPC_DEPOSIT_FAIL		1   // 
#define ERROR_NPC_DEPOSIT_NPC		2   // npc 

struct MSG_REQ_NPC_DEPOSIT : public MSGROOT
{
	unsigned long npcIdx;
	unsigned long money;
};
struct MSG_RES_NPC_DEPOSIT : public MSG_ERROR
{};

// â ̿ 
#define ERROR_NPC_WITHDRAW_SUCCESS	0	// 
#define ERROR_NPC_WITHDRAW_FAIL		1   // 
#define ERROR_NPC_WITHDRAW_NPC		2   // npc 

struct MSG_REQ_NPC_WITHDRAW : public MSGROOT
{
	unsigned long npcIdx;
	unsigned long money;
};
struct MSG_RES_NPC_WITHDRAW : public MSG_ERROR
{};

/// ų
const unsigned char SKILL_ADD_ERR_SUCCESS = 0;
const unsigned char	SKILL_ADD_ERR_DBERROR = 1;
const unsigned char SKILL_ADD_ERR_PLAYER = 2;
const unsigned char SKILL_ADD_ERR_SCRIPT = 3;
const unsigned char SKILL_ADD_ERR_MAPINSERT = 4;

const unsigned char SKILL_ADD_ERR_MONEY = 101;			/// ݾ 
const unsigned char SKILL_ADD_ERR_SP = 102;				/// skill point 
const unsigned char SKILL_ADD_ERR_SKILLSTEP = 103;		/// ų  ܰ 
const unsigned char SKILL_ADD_ERR_LEARNSKILL = 104;		///   ų 
const unsigned char SKILL_ADD_ERR_LEARNSTEP = 105;		///   ų ܰ 
const unsigned char SKILL_ADD_ERR_RACE = 106;			///  
const unsigned char SKILL_ADD_ERR_JOB = 107;			///  
const unsigned char SKILL_ADD_ERR_LEVEL = 108;			///  
const unsigned char SKILL_ADD_ERR_ALREADY = 109;		/// ̹  ų ٽ 
const unsigned char SKILL_ADD_ERR_NPC = 110;			/// npc ȭ  ȸ
const unsigned char SKILL_ADD_ERR_JOBSP = 111;			///  SP 

struct MSG_RES_NPC_SKILL_ADD : public MSGROOT
{
	unsigned long	mSkillClassIdx;
	unsigned char	mSkillStep;
};

struct MSG_REQ_NPC_SKILL_ADD : public MSGROOT
{
	unsigned long	mSkillClassIdx;
	unsigned char	mSkillStep;
	unsigned long	mNpcIdx;
};


/*--  κ -> â
*/
#define ERROR_ITEM_MOV2_INVENTORY_SUCCESS		0	// 
#define ERROR_ITEM_MOV2_INVENTORY_MONEY			1	// ݾ׺
#define ERROR_ITEM_MOV2_INVENTORY_FAIL			2	// 
#define ERROR_ITEM_MOV2_INVENTORY_NOTYET		3	// DBó
#define ERROR_ITEM_MOV2_INVENTORY_NPC			4	// npc 

struct MSG_REQ_NPC_ITEM_MOV2_INVENTORY : MSGROOT
{
	unsigned long  npcIdx;							// NPC ȣ
	unsigned short number1;							// κ丮 ȣ()
	unsigned short number2;							// κ丮 ȣ()
	unsigned short count;							// 
};
struct MSG_RES_NPC_ITEM_MOV2_INVENTORY : MSG_ERROR
{
	unsigned long RowCount;							//   
	sInventory    Inventory[1];						// κ丮

	//  ޼ ũ
	unsigned long GetMsgLength( ) { return sizeof(MSG_RES_NPC_ITEM_MOV2_INVENTORY) - sizeof(Inventory) + (RowCount * sizeof(sInventory)); }
};

/*--  ȱ(κ丮)
*/
#define ERROR_ITEM_SELL_SUCCESS					0	// 
#define ERROR_ITEM_SELL_FAIL					1	// 
#define ERROR_ITEM_SELL_NOTYET					2   // DBó
#define ERROR_ITEM_SELL_NPC						3	// npc 

struct MSG_REQ_NPC_ITEM_SELL : MSGROOT
{
	unsigned long  npcIdx;							// NPC ȣ
	unsigned short inventoryNumber;					// κ丮 ȣ
	unsigned short count;							// 
};

struct MSG_RES_NPC_ITEM_SELL : MSG_ERROR
{
	BYTE       rowCount;							//   
	sInventory inventory[1];						// κ丮

	//  ޼ ũ
	unsigned long GetMsgLength( ) { return sizeof(MSG_RES_NPC_ITEM_SELL) - sizeof(inventory) + (rowCount * sizeof(sInventory)); }
};


/*--  (κ丮)
*/
#define ERROR_ITEM_BUY_SUCCESS					0	// 
#define ERROR_ITEM_BUY_MONEY					1	// ݾ׺
#define ERROR_ITEM_BUY_PVP_POINT				2	// Ʈ 
#define ERROR_ITEM_BUY_TAROT_POINT				3	// ŸƮ 
#define ERROR_ITEM_BUY_FAIL						4	// 
#define ERROR_ITEM_BUY_NOTYET					5	// DBó
#define ERROR_ITEM_BUY_NPC						6	// npc 

struct MSG_REQ_NPC_ITEM_BUY : MSGROOT
{
	unsigned long  npcIdx;							// NPC ȣ
	unsigned long  itemDefineIndex;					//  ε
	unsigned short count;							// 
};

struct MSG_RES_NPC_ITEM_BUY : MSG_ERROR
{
	BYTE       rowCount;							//   
	sInventory inventory[1];						// κ丮

	//  ޼ ũ
	unsigned long GetMsgLength( ) { return sizeof(MSG_RES_NPC_ITEM_BUY) - sizeof(inventory) + (rowCount * sizeof(sInventory)); }
};

#define ERROR_QUEST_COMPLETE_SUCCESS		0	//  -  Ϸ û 
#define ERROR_QUEST_COMPLETE_NOTYET			1	//  - DB 
#define ERROR_QUEST_COMPLETE_FAIL			2	//  - 
#define ERROR_QUEST_COMPLETE_POSSIBLE		3	//  - Ϸ ƴ
#define ERROR_QUEST_COMPLETE_TAKE			4	//  -  ȸ 
#define ERROR_QUEST_COMPLETE_NPC			5	//  - NPC 
#define ERROR_QUEST_COMPLETE_TIME			6	//  - ð 
#define ERROR_QUEST_COMPLETE_ALREADY		7	//  - ̹ Ϸ Ʈ

/// Ʈ  Ϸ
struct MSG_REQ_NPC_QUEST_COMPLETE : MSGROOT
{
	int			  arrayIdx;					// Ʈ ϳ ε
	unsigned long questIndex;
	unsigned long npcIndex;
};

struct MSG_RES_NPC_QUEST_COMPLETE : MSG_ERROR
{
	int			arrayIdx;
	char		status;					/// (2:Ϸ, 4:)
};

#define ERROR_QUEST_REWARD_SUCCESS			0	//  - Ϸ û 
#define ERROR_QUEST_REWARD_NOTYET			1	//  - DB 
#define ERROR_QUEST_REWARD_FAIL				2	//  - 
#define ERROR_QUEST_REWARD_ITEM				3	//  -    
#define ERROR_QUEST_REWARD_MONEY			4   //  -  ݾ  
#define ERROR_QUEST_REWARD_COUNT			5	//  - ð 
#define ERROR_QUEST_REWARD_NPC				6	//  - NPC 
#define ERROR_QUEST_REWARD_COMPLETE			7	//  - Ϸ ƴ

/// Ʈ  
struct MSG_REQ_NPC_QUEST_REWARD : MSGROOT
{
	int			  arrayIdx;					// Ʈ ϳ ε
	unsigned long questIndex;
	unsigned long npcIndex;
	long		  rowCount;
	sRewardData	  table[5];					/// ú 
};

struct MSG_RES_NPC_QUEST_REWARD : MSG_ERROR
{};

struct sNpcQuestStatus
{
	unsigned long	npcIdx;		
	unsigned char	status;				///  eNpcQuestStatus
};

// Ʈ   
struct MSG_RES_NPC_QUESTSTATUS : public MSGROOT
{
	unsigned long	rowCount;			/// NPC 
	sNpcQuestStatus table[1];
};

#define ERROR_QUESTLIST_SUCCESS			0	//  - Ϸ û 
#define ERROR_QUESTLIST_FAIL			1	//  - 

struct MSG_RES_NPC_QUESTLIST : public MSG_ERROR
{
	unsigned long	npcId;
	unsigned long	rowCount;
	unsigned long	questIdxList[1];	/// ű  Ʈ 
};

// Ʈ űԸƮ ߼ û
struct MSG_REQ_NPC_QUESTLIST_RESEND : MSGROOT
{
	unsigned long npcIndex;
};

#define ERROR_NPC_GUILD_CREATE_SUCESS		0	// 
#define ERROR_NPC_GUILD_CREATE_FAIL			1	// 
#define ERROR_NPC_GUILD_CREATE_CONDITION	2	//  -   ȵ (, ݾ)
#define ERROR_NPC_GUILD_CREATE_ALREADY		3	//  - ̹  
#define ERROR_NPC_GUILD_CREATE_ERRORNAME	4	//  -  ų 12 
#define ERROR_NPC_GUILD_CREATE_EXISTNAME	5	//  -  ߺ
#define ERROR_NPC_GUILD_CREATE_NPC			6	//  - NPC 

/// 
struct MSG_REQ_NPC_GUILD_CREATE :MSGROOT
{
	unsigned long	npcIndex;
	wchar_t			name[MAX_GUILDNAME_BUFFER_SIZE];	/// 
	unsigned long   GetMsgLength( ) { return sizeof(MSG_REQ_NPC_GUILD_CREATE) - sizeof(name) + wcslen(name)*sizeof(wchar_t); }
};

struct MSG_RES_NPC_GUILD_CREATE : MSG_ERROR
{};

/// NPC  
struct MSG_REQ_NPC_TAROT_OPEN : MSGROOT
{};

struct MSG_RES_NPC_TAROT_OPEN : MSG_ERROR
{
	unsigned long	fortuneData;			///  Ʈ
};

#define ERROR_NPC_TAROT_CLOSE_SUCESS	0	// 
#define ERROR_NPC_TAROT_CLOSE_FAIL		1	// 

/// NPC  ݱ
struct MSG_REQ_NPC_TAROT_CLOSE : MSGROOT
{};

struct MSG_RES_NPC_TAROT_CLOSE : MSG_ERROR
{};

#define ERROR_NPC_TAROT_JOIN_SUCESS		0	// 
#define ERROR_NPC_TAROT_JOIN_FAIL		1	// 
#define ERROR_NPC_TAROT_JOIN_MONEY		2	//  - ݾ׺
#define ERROR_NPC_TAROT_JOIN_ONCE		3	//  - Ϸ翡 ѹ 

/// NPC  
struct MSG_REQ_NPC_TAROT_JOIN : MSGROOT
{
	unsigned long	npcIndex;				// npc ε
};

struct MSG_RES_NPC_TAROT_JOIN : MSG_ERROR
{};

#define ERROR_NPC_TAROT_FORTUNE_SUCESS		0	// 
#define ERROR_NPC_TAROT_FORTUNE_FAIL		1	// 
#define ERROR_NPC_TAROT_FORTUNE_ONCE		2	//  - Ϸ翡 ѹ 

///  
struct MSG_REQ_NPC_TAROT_FORTUNE : MSGROOT
{
	short			fortuneProp;			//  Ӽ
};

struct MSG_RES_NPC_TAROT_FORTUNE : MSG_ERROR
{};


#pragma pack(pop)
