#include "gamesrv.h"

#include "StdAfx.h"
#include "PvPScript.h"
#include "Tokenizer.h"

cPvPScript* cPvPScript::mpPvPScript = NULL;


cPvPScript::cPvPScript(void)
{

	/// ̱
	if( !mpPvPScript )
	{
		mpPvPScript = this;
	}

}

cPvPScript::~cPvPScript(void)
{
	Release();
}


bool cPvPScript::Init()
{
	Release();

	if( LoadDMInfo() == false )
		return false;

	if( LoadMemberGive() == false )
		return false;

	return true;
}


void cPvPScript::Release()
{
	///
	cHashMap::cIterator i = mDMInfoMap.Begin();
	cHashMap::cIterator iend = mDMInfoMap.End();
	for( ; i!=iend; i++ )
	{
		cArray* pAry = (cArray*)(*i).mSecond;
		if( pAry )
		{
			for( unsigned long i = 0 ; pAry->GetSize() > i ; ++i )
			{
				sDMInfo* pDMInfo = (sDMInfo*)(*pAry)[i];
				SAFE_DELETE( pDMInfo );
			}
			pAry->Clear();

			SAFE_DELETE( pAry );
		}
	}
	mDMInfoMap.Clear();

	///
	i = mDMMemberGiveMap.Begin();
	iend = mDMMemberGiveMap.End();
	for( ; i!=iend; i++ )
	{
		sDMMemberGive* info = (sDMMemberGive*)(*i).mSecond;
		SAFE_DELETE(info);
	}
	mDMMemberGiveMap.Clear();
}

bool cPvPScript::LoadDMInfo()
{
	cFileLoader loader;
	cString pathName = "./Script/resource/PVP_Map.txt";

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load PVP_Character.txt" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	sDMInfo* pDMInfo = 0;
	while( tokenizer.IsEnd() == false )
	{
		pDMInfo = new sDMInfo;

        //  
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pDMInfo->mType = static_cast<unsigned char>(str.ToInt());

		// ʹȣ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pDMInfo->mMapNumber = (unsigned short)str.ToInt();

		// ּ 
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pDMInfo->mMinLevel = static_cast<unsigned char>(str.ToInt());

		// ִ 
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pDMInfo->mMaxLevel = static_cast<unsigned char>(str.ToInt());

		// kill-Ϲ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pDMInfo->mKillPoint = str.ToInt();

		// kill-
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pDMInfo->mLeaderKillPoint = str.ToInt();

		// death
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pDMInfo->mDeathPoint = str.ToInt();

		// ڱ⼼Ʈ-¸
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pDMInfo->mWinMyForcePoint = str.ToInt();

		// ͼƮ-¸
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pDMInfo->mWinFamilyForcePoint = str.ToInt();

		// ڱ⼼Ʈ-й
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pDMInfo->mLoseMyForcePoint = str.ToInt();

		//   Ʈ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pDMInfo->mLoseCheckPoint = str.ToInt();

		// ڱ⼼ģе-¸
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pDMInfo->mWinMyForceFriendly = str.ToInt();

		// ͼģе-¸
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pDMInfo->mWinFamilyForceFriendly = str.ToInt();

		// ڱ⼼ģе-й
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pDMInfo->mLoseMyForceFriendly = str.ToInt();

		//  ģе Ʈ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pDMInfo->mLoseCheckFriendly = str.ToInt();

		cArray* pAry = (cArray*)mDMInfoMap.GetAt( pDMInfo->mType );
		if( pAry == 0 )
		{
			pAry = new cArray;
			if( mDMInfoMap.Insert( pDMInfo->mType, pAry) == false )
			{
				assert(0);
				delete pAry;
				goto ERR;
			}
		}
		pAry->PushBack( pDMInfo );
	}

	return true;

ERR:
	SAFE_DELETE(pDMInfo);
	return false;
}

bool cPvPScript::LoadMemberGive()
{
	cFileLoader loader;
	cString pathName = "./Script/resource/PVP_Character.txt";

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load PVP_Character.txt" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	sDMMemberGive* giveInfo = 0;
	while( tokenizer.IsEnd() == false )
	{
		sDMMemberGive* giveInfo = new sDMMemberGive;

		// ĳ 
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		giveInfo->mLevel = static_cast<unsigned char>(str.ToInt());

		//  -¸
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		giveInfo->mWinMoney = str.ToInt();

		//  -й
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		giveInfo->mLoseMoney = str.ToInt();

		// EXP -¸(%)
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		giveInfo->mWinExp = str.ToInt();

		// EXP -й(%)
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		giveInfo->mLoseExp = str.ToInt();

		// SXP -¸(%)
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		giveInfo->mWinSxp = str.ToInt();

		// SXP -й(%)
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		giveInfo->mLoseSxp = str.ToInt();

		if( mDMMemberGiveMap.Insert( giveInfo->mLevel, giveInfo ) == false )
		{
			assert(0);
			goto ERR;
		}
	}

	return true;

ERR:
	SAFE_DELETE( giveInfo );
	return false;
}


sDMInfo* cPvPScript::GetDmInfo( unsigned char type, unsigned char level )
{
	sDMInfo* pDMInfo = NULL;
	cArray* pAry = (cArray*)mDMInfoMap.GetAt( type );
	if( pAry != NULL )
	{
		for( unsigned long i = 0 ; pAry->GetSize() > i ; ++i )
		{
			pDMInfo = (sDMInfo*)(*pAry)[i];

			if( pDMInfo == NULL )
				continue;

			if( pDMInfo->mMinLevel <= level && pDMInfo->mMaxLevel >= level )
                return pDMInfo;
		}
	}

	return NULL;
}


sDMMemberGive* cPvPScript::GetMemberGive( unsigned char level )
{
	return (sDMMemberGive*)mDMMemberGiveMap.GetAt( level );
}