/* ==========================================================================
*      : QuestDefine.h
*      : ƮũƮ
*    : 谡
*    : 2008-01-18
* ǻ :
*===========================================================================*/
#pragma once
#include "Quest_Common.h"

///   (  ε, (Ÿ, ) )
/// (  Ʈ ä )
struct sDuty
{
	eDutyType dutyType;
	unsigned long targetIdx;
	unsigned int count;

	sDuty::sDuty()
	{
		dutyType = eDUTY_NONE;
		targetIdx = 0;
		count = 0;
	}
};

/// Ʈ ӹ
class cQuestDuty
{
	friend class cQuestManager;

public:
	cQuestDuty() {}
	~cQuestDuty() {}

public:
    /// 
	sDuty mDuty[MAX_DUTY];
};

/// Ʈ     
class cQuestLimit
{
	friend class cQuestManager;

public:
	cQuestLimit();

public:
	///  
	unsigned long mLimitBuff[QUEST_BUFF_MAX];

	///  
	unsigned long mLimitDeBuff[QUEST_BUFF_MAX];

	///    ()
	unsigned long mLimitEquipItem[QUEST_ITEM_MAX];

	/// ѽðŸ ( 0 :, 1:ǽð, 2:ӽð )
	unsigned char mTimeType;

	/// ѽð
	unsigned long mTime;

	/// ̵ ε
	unsigned long mMapChangeIndex;

	/// ȯ  ȣ
	unsigned long mMonsterClassIndex;
	unsigned int mMonsterCount;
	unsigned long mMonsterTime;

	/// Ʈ ο ִ  
	sQuestItem mGiveItem[QUEST_ITEM_MAX];
};

inline cQuestLimit::cQuestLimit()
: mTime(0)
, mTimeType(0)
, mMapChangeIndex(0)
, mMonsterClassIndex(0)
, mMonsterCount(0)
, mMonsterTime(0)
{
	memset( &mLimitBuff, 0, sizeof(mLimitBuff) );
	memset( &mLimitDeBuff, 0, sizeof(mLimitDeBuff) );
	memset( &mLimitEquipItem, 0, sizeof(mLimitEquipItem) );
	memset( &mGiveItem, 0, sizeof(mGiveItem) );
}

/// Ʈ Ϸ( , , Ϸ )
class cQuestEnd
{
	friend class cQuestManager;

public:
	cQuestEnd();

public:
	///  
	unsigned long mEndBuff[QUEST_BUFF_MAX];

	///  
	unsigned long mEndDeBuff[QUEST_BUFF_MAX];

	/// ̵ ε
	unsigned long mMapChangeIndex;

	///    
	sQuestItem mTakeItem[QUEST_ITEM_MAX];
};

inline cQuestEnd::cQuestEnd()
: mMapChangeIndex(0)
{
	memset( &mEndBuff, 0, sizeof(mEndBuff) );
	memset( &mEndDeBuff, 0, sizeof(mEndDeBuff) );
	memset( &mTakeItem, 0, sizeof(mTakeItem) );
}

/// Ʈ 
class cQuestReward
{
	friend class cQuestManager;

public:
	cQuestReward();

public:
	/// ġ
	unsigned int mExp;

	/// ų ġ
	unsigned int mSxp;

	/// ݾ
	unsigned long mMoney;

	/// ųƮ
	unsigned int mSkillPoint;

	/// ε 
	unsigned short mChangeJobIndex;

	///  (eFORCE_TYPE)
	unsigned char mForceType;

	/// ȣĪ
	unsigned long mGiveTitleIndex;

	/// 
	unsigned long mRewardBuff[QUEST_BUFF_MAX];

	///  ε, 
	sQuestItem mRewardItem[QUEST_ITEM_MAX];
};

inline
cQuestReward::cQuestReward()
: mExp(0)
, mSxp(0)
, mMoney(0)
, mSkillPoint(0)
, mChangeJobIndex(0)
, mForceType(0)
, mGiveTitleIndex(0)
{
	for( unsigned int i = 0; i < QUEST_BUFF_MAX; ++i )
		mRewardBuff[i] = 0;

	for( unsigned int i = 0; i < QUEST_ITEM_MAX; ++i )
	{
		mRewardItem[i].itemIndex = 0;
		mRewardItem[i].count = 0;
	}
}

/// Ʈ н
class cQuestFail
{
	friend class cQuestManager;

public:
	cQuestFail();

public:
	/// н 
	unsigned long mFailBuff[QUEST_BUFF_MAX];

	/// н 
	unsigned long mFailDeBuff[QUEST_BUFF_MAX];
};

inline
cQuestFail::cQuestFail()
{
	for( unsigned int i = 0; i < QUEST_BUFF_MAX; ++i )
	{
		mFailBuff[i] = 0;
		mFailDeBuff[i] = 0;
	}
}

/// Ʈ 
class cQuestDefine
{
	friend class cQuestManager;

public:
	cQuestDefine();
	~cQuestDefine();

public:
	/// Ʈ ε
	unsigned long mIndex;

	/// Ʈ
	unsigned long mTitleIndex;
	
	///  ؽƮ ε
	unsigned long mDestIndex;

	///  ڿ ټ
	unsigned int mDestLineNum;

	/// Ʈ Ÿ
	unsigned char mType;

	/// ݺ Ÿ 
	unsigned char mRepeatType;

	/// ׷ȣ 
	unsigned short mGroup;

	/// ο npc ε
	unsigned long mGiveNpcIndex;

	///  npc ε
	unsigned long mTakeNpcIndex;

	///   ε 
	unsigned long mTakeMapIndex;

	/// ú   
	short mSelectCount;

	/// Ʈ   ǥÿ 
	unsigned int mLevel;

	/// Ʈ ӹ 
	cQuestDuty* mQuestDuty;

	/// Ʈ ⺻ 
	cQuestReward* mDefaultReward;

	/// Ʈ  
	cQuestReward* mSelectReward;

	/// Ʈ  
	cQuestLimit* mQuestLimit;

	/// Ʈ  (Ϸ,,)
	cQuestEnd*	mQuestEnd;

	/// Ʈ н 
	cQuestFail* mQuestFail;

	/// Ϸ  ˻ Ʈ
	__int64 mComplete;
};

inline
cQuestDefine::cQuestDefine()
: mTitleIndex(0)
, mDestIndex(0)
, mDestLineNum(0)
, mType( eQUEST_NORMAL )
, mRepeatType( eQUEST_CHALLENGE )
, mGroup(0)
, mGiveNpcIndex(0)
, mTakeNpcIndex(0)
, mTakeMapIndex(ULONG_MAX)
, mSelectCount(0)
, mQuestDuty(0)
, mDefaultReward(0)
, mSelectReward(0)
, mQuestLimit(0)
, mQuestEnd(0)
, mQuestFail(0)
, mComplete(0)
, mLevel(1)
{
}

inline 
cQuestDefine::~cQuestDefine()
{
	SAFE_DELETE( mQuestDuty );
	SAFE_DELETE( mDefaultReward );
	SAFE_DELETE( mSelectReward );
	SAFE_DELETE( mQuestLimit );
	SAFE_DELETE( mQuestFail );
	SAFE_DELETE( mQuestEnd );
}
