/* ==========================================================================
*      : SkillScript.h
*      : 
*    : ڰ
*    : 2007-06-07
* ǻ :
*===========================================================================*/
#pragma once
#include "Skill_Common.h"
#include "Lexer.h"
#include "Parser.h"

class cSkillTree
{
public:
	cSkillTree()
	{
		mIconCount = 0;
		mIconList = 0;
	}
	~cSkillTree()
	{
		SAFE_DELETE_ARRAY(mIconList);
	}

	struct sTreeIcon
	{
		unsigned int	skillIdx;
		unsigned int	uiPosX;
		unsigned int	uiPosY;
	};

	cString			mImageName;

	unsigned int	mIconCount;

	sTreeIcon*		mIconList;
};

class cSkillTreeLexer : public cLexer
{
public:
	cSkillTreeLexer( const char* buffer, unsigned int size );

	enum
	{
		/// ڻ
		eTOKEN_SKILLTREE = 100,
		eTOKEN_IMAGEFILE,
		eTOKEN_JOBIDX,
		eTOKEN_SKILLPOS,
	};
};

typedef tPointerHashMap<unsigned long, void*> cSkillHashMap;

class cSkillScript
{
public:

	static cSkillScript*	 mpSkillScript;

public:

	///  Ҹ
	cSkillScript(void);
	~cSkillScript(void) {}

	///	ʱȭ
	bool					Init();
	/// ü  ޸ 
	void					Release();

	/// ų  ˷
	sPlayerSkillBaseInfo*	GetPlayerSkillInfo( unsigned long skillNumber );
	sMonsterSkillScript*	GetMonsterSkillInfo( unsigned long monsterClassIdx, eMONSTERATTACK_TYPE attackType );

	cSkillHashMap*			GetMonsterSkillTotalMap();
	void*					GetMonsterBaseSkillArr( unsigned long monsterClassIdx );

	/// ȿ  ˷
	sInfluenceScript*		GetInfluenceInfo( unsigned long influenceClassIdx );

	bool					IsCastSkill( unsigned long skillIdx, unsigned long skillStep );

	/// index ÷̾    üũ
	bool					IsPlayerSkillJob( unsigned long skillJobIdx, unsigned long playerJob );

	tArray<unsigned long>*	GetFreeSkill( unsigned long jobstep ) { return (tArray<unsigned long>*)mFreeSkillMap.GetAt(jobstep); }

	tPointerHashMap<unsigned long, void*>* GetPlayerSkillInfoMap() { return &mPlayerSkillInfoMap; }

	/// ų Ҽ ִ  迭 
	tArray<unsigned long>*	GetPlayerSkillJob( unsigned long jobIdx );

	/// ȿ ε
	bool					InfluenceLoad();

	tArray<unsigned long>*	GetStoreJobList( unsigned long npcIdx );
	cSkillTree*				GetSkillTree( unsigned long jobIdx );

private:

	/// ų  ε.
	bool					PlayerSkillScriptLoad();
	bool					MonsterSkillScriptLoad();

	/// ų ܰ ε.
	bool					PlayerSkillStepLoad();

	/// ų / ڵ ε
	bool					PlayerSkillJobScriptLoad();

	void					PlayerFreeSkillList();

	/// ų  npc 
	bool					LoadSkillStoreData( const cString& pathName );
	bool					LoadSkillTree( const cString& pathName );
	bool					LoadTree( cParser& parser, cSkillTree* pTree );

private:

	typedef tArray<void*>	cArray;

	///÷̾ų̺ <ũƮ  ų Index, ų >
	///typedef tPointerHashMap<unsigned long,sSkillScript*> cPlayerSkillInfoMap;
	cSkillHashMap			mPlayerSkillInfoMap;

	///ͽų̺ <ũƮ  ų Index, ų >
	///typedef tPointerHashMap<unsigned long, tArray<sMonsterSkillScript*>> cMonsterSkillInfoMap;
//	cSkillHashMap			mMonsterSkillInfoMap;

	cSkillHashMap			mMonsterBaseSkillMap;
	cSkillHashMap			mMonsterSkillTotalMap;


	/// ų / ڵ
	///typedef tPointerHashMap<unsigned long, tArray<unsigned short>*> cSkillJobMap;
	cSkillHashMap			mSkillJobMap;

	/// ÷̾ ȿ 
	///typedef tPointerHashMap<unsigned long, sInfluenceScript*> cPlayerInfluenceMap;
	cSkillHashMap			mInfluenceMap;

	cSkillHashMap			mFreeSkillMap;

	/// npc Idx , joblist
	typedef	tPointerHashMap<unsigned long, void*> cSkillStoreMap;
	cSkillStoreMap			mSkillStoreMap;

	typedef	tPointerHashMap<unsigned long, void*> cSkillTreeMap;
	cSkillTreeMap		mSkillTreeMap;

};

inline tArray<unsigned long>* cSkillScript::GetStoreJobList( unsigned long npcIdx )
{
	return (tArray<unsigned long>*)mSkillStoreMap.GetAt( npcIdx );
}

inline cSkillTree*	cSkillScript::GetSkillTree( unsigned long jobIdx )
{
	return (cSkillTree*)mSkillTreeMap.GetAt( jobIdx );
}

#define SKILLSCRIPT cSkillScript::mpSkillScript
