#include "StdAfx.h"
#include "TotemScript.h"

#include "Totem_Common.h"


#include "Token.h"
#include "Parser.h"
#include "Lexer.h"
#include "FileLoader.h"
#include "Tokenizer.h"


cTotemScript* cTotemScript::mpTotemScript = NULL;



cTotemScript::cTotemScript(void)
{

	/// ̱
	if( mpTotemScript )
	{
		assert(NULL);
	}
	else
	{
		mpTotemScript = this;
	}

	mpTotemMap = new cPointHashMap( 100 );
}



bool cTotemScript::Init( )
{

	///   ε
	if( !LoadTotemList() )
	{
		assert(NULL);
		return false;
	}

	return true;

}

void cTotemScript::Release()
{
	if( mpTotemMap )
	{
		cPointHashMap::cIterator k = mpTotemMap->Begin();
		cPointHashMap::cIterator kend = mpTotemMap->End();
		for( ; k != kend; ++k )
		{
			delete (sTotemScript*)(k->mSecond);
		}
		mpTotemMap->Clear();

		delete mpTotemMap;
		mpTotemMap = 0;
	}
}

bool cTotemScript::LoadTotemList()
{

	cFileLoader loader;
	cString pathName = "./Script/Resource/SkillList_Trap.txt";

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load TotemList.txt" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	sTotemScript* pList = NULL;
	while( tokenizer.IsEnd() == false )
	{
		pList = new sTotemScript;

		///  ȣ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mTotemIdx = str.ToInt();

		///  ȿ ȣ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mInfluenceIdx = str.ToInt();

		/// ϸ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mFileName = str;

		/// / 
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mDependent = str.ToInt() == 0 ? true : false;

		/// ð
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mContinuanceTime = str.ToInt();		

		/// ֱ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mApplyTime = str.ToInt();		

		/// Ÿ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mAttackerRange = (unsigned short)str.ToInt();

		/// 
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pList->mApplyRange = (unsigned short)str.ToInt();

		/// ؽ   
		if( mpTotemMap->Insert( pList->mTotemIdx, pList ) == false )
		{
			assert(0);
			goto ERR;
		}
	}

	return true;

ERR:
	delete pList;
	return false;

}



sTotemScript* cTotemScript::GetTotemInfo( unsigned long totemIdx )
{
	return (sTotemScript*)mpTotemMap->GetAt( totemIdx );
}
