// Include
#include "gamesrv.h"
#include <conio.h>

// Local definitions
#define SafeDelete(P)       if (P!=NULL) { delete(P);      (P)=NULL; } // memory ϰ 
#define SafeCloseHandle(P)  if (P!=NULL) { CloseHandle(P); (P)=NULL; } // handle ϰ 

#define ODBC_DSN_ACCOUNT	"IRIS_MEMBERDB"
#define ODBC_DSN_GAME		"IRIS_GAMEDB"

#define ODBC_UID			"irisdb"			// local test
#define ODBC_PWD			"ehdwjq10aks!"		// local test

//#define ODBC_UID			"gamedev"			// IDC test
//#define ODBC_PWD			"qldhxpa%whdk"		// IDC test

// Global data
cGameSrv* g_gameSrv    = NULL;
bool      g_verbose    = false;
bool      g_fps        = false;
bool      g_packet     = false;


// GenerateDump Prototype
//  1. Ӽ < C/C++ < Ϲ <    = α׷ ͺ̽(/Zi)
//  2. SetUnhandledExceptionFilter( Exception_Minidump );
//  3. exceptionPointers->ExceptionRecord->ExceptionCode winbase.h and winnt.h 
//     (EXCEPTION_ACCESS_VIOLATION ... CONTROL_C_EXIT )
//
//  : DBGHELP.DLL   ּ 5.1.2600.0 ̻̾ Ѵ.
//        (MiniDumpWriteDump Լ DBGHELP.DLL  )
#include <dbghelp.h>

#pragma comment(lib, "dbghelp.lib")

LONG __stdcall GenerateDump(EXCEPTION_POINTERS* exceptionPointers)
{
	char fileName[MAX_PATH];
	GetModuleFileName( NULL, fileName, sizeof(fileName) );

	char* ext = strrchr( fileName, '.' );
	strcpy( ext ? ext : fileName+strlen( fileName ), ".dmp" );

	char temp[256];
	wsprintf( temp, "Exception 0x%08XL arised", exceptionPointers->ExceptionRecord->ExceptionCode );
	printf( "%s[%s]\n", fileName, temp );

	HANDLE process   = GetCurrentProcess( );
	DWORD  processID = GetCurrentProcessId( );
	HANDLE file      = CreateFile( fileName, GENERIC_READ|GENERIC_WRITE, 0, NULL, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL );

	MINIDUMP_EXCEPTION_INFORMATION expParam;

	expParam.ThreadId          = GetCurrentThreadId( );
	expParam.ExceptionPointers = exceptionPointers;
	expParam.ClientPointers    = TRUE;

	MiniDumpWriteDump( process, processID, file, (MINIDUMP_TYPE)(MiniDumpWithDataSegs | MiniDumpWithFullMemory | MiniDumpWithHandleData), &expParam, NULL, NULL );

	if ( g_gameSrv != NULL )
	{
		char  message[2048];
		VOID* msgBuf;

		if ( ErrorCode2String( &msgBuf, exceptionPointers->ExceptionRecord->ExceptionCode ) )
		{
			sprintf( message, "Exception Code:0x%08X %s", exceptionPointers->ExceptionRecord->ExceptionCode, msgBuf );
			g_gameSrv->PostServerEvent( message );
			LocalFree( msgBuf );
		}
	}

	return EXCEPTION_EXECUTE_HANDLER;
}

// ErrorCode2String Method
//
//	 ڵ带 ޽ ȯѴ.
//
//	msgBuf    :޽ ( LocalFree Ͽ ش.)
//	lastError :ڵ
//	priLangId :primary language identifier
//	subLangId :sublanguage identifier
//
//	ڸ޽  Ʒ  Ѵ.
//
//	Primary language identifier : Sublanguage identifier : Meaning 
//	LANG_NEUTRAL                  SUBLANG_NEUTRAL          Language neutral  
//	LANG_NEUTRAL                  SUBLANG_DEFAULT          User default language
//	LANG_NEUTRAL                  SUBLANG_SYS_DEFAULT      System default language 
DWORD ErrorCode2String(VOID** msgBuf, DWORD lastError, WORD priLangId, WORD subLangId)
{
	HMODULE module = NULL; // default to system source
	DWORD   bufferLength;
	DWORD   flags;

	flags = FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_IGNORE_INSERTS | FORMAT_MESSAGE_FROM_SYSTEM;

	// If lastError is in the network range, load the message source.
	//  lastError NERR_BASE  MAX_NERR ϰ, netmsg.dll 
	// ޽ Ѵ. (NERR_BASE, MAX_NERR lmerr.h Ͽ )
	if ( lastError >= NERR_BASE && lastError <= MAX_NERR )
	{
		module = LoadLibraryEx( "netmsg.dll", NULL, LOAD_LIBRARY_AS_DATAFILE );
		if ( module != NULL )
		{
			flags |= FORMAT_MESSAGE_FROM_HMODULE;
		}
	}

	// If lastError is in the Exception Code range, load the message source.
	//  lastError 0xC0000000L  Ŭ, ntdll.dll ޽ Ѵ.
	// (winbase.h, winnt.h Ͽ )
	if ( lastError > 0xC0000000L )
	{
		module = LoadLibraryEx( "ntdll.dll", NULL, LOAD_LIBRARY_AS_DATAFILE );
		if ( module != NULL )
		{
			flags |= FORMAT_MESSAGE_FROM_HMODULE;
		}
	}

	// Call FormatMessage() to allow for message text to be acquired
	// from the system or from the supplied module handle. module to
	// get message from (NULL == system)
	bufferLength = FormatMessage( flags, module, lastError, MAKELANGID(priLangId, subLangId), (LPTSTR)msgBuf, 0, NULL );

	// If we loaded a message source, unload it.
	if ( module != NULL )
	{
		FreeLibrary( module );
	}
	return bufferLength;
}

// ConsolCtrlHandler Prototype - Windows Command Processor  Լ.
BOOL WINAPI ConsolCtrlHandler(DWORD opcode)
{
	if ( g_gameSrv )
		return g_gameSrv->ConsolCtrlHandler( opcode );
	else
		return FALSE;
}

// main Prototype (This method is the standard Windows program entry point.)
int main(int argc, char* argv[])
{
	SetUnhandledExceptionFilter( GenerateDump );

	cGameSrv* gameSrv = NULL;

	gameSrv = new cGameSrv( );
	gameSrv->ConsoleRun( argc, argv );

	SafeDelete( gameSrv );
	return 0L;
}

// ServiceCtrlHandler Prototype - Windows Service  Լ.
void WINAPI ServiceCtrlHandler(DWORD opcode)
{
	if ( g_gameSrv )
		g_gameSrv->ServiceCtrlHandler( opcode );
}

// ServiceMain Prototype (This method is the entry point for a service.)
void WINAPI ServiceMain(DWORD argc, LPTSTR* argv)
{
	cGameSrv* gameSrv = NULL;

	gameSrv = new cGameSrv( );
	gameSrv->ServiceRun( argc, argv );

	SafeDelete( gameSrv );
}

// cGameSrv Constructor.
cGameSrv::cGameSrv(void) : mSqlAccount(NULL), mSqlGame(NULL), mSender(NULL), mRecver(NULL), mGameProcess(NULL), mVerbose(NULL)
{
	g_gameSrv    = this;

	mCompanyName = TEXT( "EYA INTERACTIVE" );
	mServiceName = TEXT( "GameServer" );
	mDisplayName = TEXT( "EYA INTERACTIVE - GAME SERVER" );
	mDescription = TEXT( "Copyright(c) 2009 EYA INTERACTIVE Corporation All rights reserved" );
	mUserName    = NULL;
	mRunService  = false;
	mVersion     = MAKEWORD(1, 0);

	mServerNo = 0;
	mChannelNo = 0;
	memset( mServerAddr,          0, sizeof(mServerAddr)          );
	memset( mServerBroadcastRecv, 0, sizeof(mServerBroadcastRecv) );
	memset( mServerBroadcastSend, 0, sizeof(mServerBroadcastSend) );
	memset( mServerFirewall,      0, sizeof(mServerFirewall)      );
}

// ~cGameSrv Destructor.
cGameSrv::~cGameSrv(void)
{
	// cGameProcess Ŭ .
	SafeDelete( mGameProcess );

	// cRecver Ŭ .
	SafeDelete( mRecver );

	// cSender Ŭ .
	SafeDelete( mSender );

	// cSQLGame Ŭ .
	SafeDelete( mSqlGame );

	// cSQLAccount Ŭ .
	SafeDelete( mSqlAccount );

	// cVerbose Ŭ .
	SafeDelete( mVerbose );

	g_gameSrv = NULL;
}

// InstallService Method -  ġ Լ.
bool cGameSrv::InstallService(LPCTSTR binaryPathName, DWORD startType)
{
	SC_HANDLE           hManager(NULL);
	SC_HANDLE           hService(NULL);
	bool                retValue(false);

	SERVICE_DESCRIPTION scDesc;

	// Open a handle to the SC Manager database.
	hManager = OpenSCManager( NULL, NULL, SC_MANAGER_ALL_ACCESS );
	if ( hManager != NULL )
	{
		// The function creates a service object and adds it to the specified service control manager database.
		hService = CreateService( hManager,                  // handle to SCM database
								  mServiceName,              // name of service to start
								  mDisplayName,              // display name
								  SERVICE_ALL_ACCESS,        // type of access to service
								  SERVICE_WIN32_OWN_PROCESS, // type of service
								  startType,                 // when to start service
								  SERVICE_ERROR_NORMAL,      // severity of service failure
								  binaryPathName,            // name of binary file
								  NULL,                      // name of load ordering group
								  NULL,                      // tag identifier
								  NULL,                      // array of dependency names
								  NULL,                      // account name
								  NULL );                    // account password
		if ( hService != NULL )
		{
			// Success CreateService
			retValue = true;

			// The function changes the optional configuration parameters of a service.
			scDesc.lpDescription = mDescription;
			ChangeServiceConfig2( hService, SERVICE_CONFIG_DESCRIPTION, &scDesc );

			// Close the handle to the service.
			CloseServiceHandle( hService );
		}
		else
		{
			// ޽  - CreateService.
			VOID* msgBuf;
			if ( ErrorCode2String( &msgBuf ) )
			{
				printf( "\nCreateService (%d): %s\n", GetLastError( ), (char*)msgBuf );
				LocalFree( msgBuf );
			}
		}
	}
	return retValue;
}

// UninstallService Method -   Լ.
bool cGameSrv::UninstallService()
{
	SC_HANDLE hManager(NULL);
	SC_HANDLE hService(NULL);
	bool      retValue(false);

	// Open a handle to the SC Manager database.
	hManager = OpenSCManager( NULL, NULL, SC_MANAGER_ALL_ACCESS );
	if ( hManager != NULL )
	{
		// Open a handle to the service.
		hService = OpenService( hManager, mServiceName, SERVICE_ALL_ACCESS );
		if ( hService != NULL )
		{
			// The function marks the specified service for deletion from the service control manager database.
			if ( DeleteService( hService ) != 0 )
			{
				// Success DeleteService
				retValue = true;
			}
			else
			{
				// ޽  - DeleteService
				VOID* msgBuf;
				if ( ErrorCode2String( &msgBuf ) )
				{
					printf( "\nDeleteService (%d): %s\n", GetLastError( ), (char*)msgBuf );
					LocalFree( msgBuf );
				}
			}

			// Close the handle to the service.
			CloseServiceHandle( hService );
		}
		else
		{
			// ޽  - OpenService
			VOID* msgBuf;
			if ( ErrorCode2String( &msgBuf ) )
			{
				printf( "\nOpenService (%d): %s\n", GetLastError( ), (char*)msgBuf );
				LocalFree( msgBuf );
			}
		}
	}
	return retValue;
}

// ErrorInsert Method
int cGameSrv::ErrorInsert(char* msg)
{
	printf( "%s\n", msg );
	printf( "Ϸ ƹ Ű ʽÿ...\n" );
	_getch( );
	return 1;
}

// ConsolCtrlHandler Method
BOOL cGameSrv::ConsolCtrlHandler(DWORD opcode)
{
    switch ( opcode ) 
	{
	case CTRL_C_EVENT:
	case CTRL_BREAK_EVENT:
	case CTRL_CLOSE_EVENT:
	case CTRL_LOGOFF_EVENT:
	case CTRL_SHUTDOWN_EVENT:
		Destroy( );
		return TRUE;

	default:
		// unknown type--better pass it on.
		return FALSE;
	}
}

// ConsoleRun Method
void cGameSrv::ConsoleRun(DWORD argc, LPTSTR* argv)
{
	char  fullPath[MAX_PATH];
	char* fileName;

	GetFullPathName( argv[0], MAX_PATH, fullPath, &fileName );

	if ( argc < 2 )
	{
		// 뼳.
		printf( "USAGE:\n" );
		printf( "      %s [/INSTALL | /UNINSTALL | /INSERT | /UPDATE |\n", fileName );
		printf( "      /VER | /TEST -VERBOSE -FPS -PACKET]\n\n" );

		// 1.  μ  带 SCM(Service Control Manager) ѱ Լ.
		//     Լ θ  Service Control Dispatcher 尡 ȴ.
		//
		//	 2.  α׷ ۵Ǹ, SCM StartServiceCtrlDispatcher Ҹ ٸ ȴ.
		//     StartServiceCtrlDispatcher ϸ,  SCM  ϸ, 񽺰  ϵ ʴ´.
		//         Լ ѱ ڰ ServiceMain ̶  ִ.
		//
		//	 !. SERVICE_TABLE_ENTRY ؾ߸ ServiceMain ȣ ȴ.
		SERVICE_TABLE_ENTRY DispatchTable[]=
		{
			{ mServiceName, (LPSERVICE_MAIN_FUNCTION)ServiceMain },
			{ NULL,         (LPSERVICE_MAIN_FUNCTION)NULL        }
		};

		printf( "StartServiceCtrlDispatcher being called.\n" );
		printf( "This may take several seconds.  Please wait.\n" );

 		if ( !StartServiceCtrlDispatcher( DispatchTable ) )
		{
			VOID* msgBuf;
			if ( ErrorCode2String( &msgBuf ) )
			{
				printf( "\nStartServiceCtrlDispatcher (%d): %s\n", GetLastError( ), (char*)msgBuf );
				LocalFree( msgBuf );
			}
		}
	}
	else if ( !_stricmp( argv[1], "/INSTALL" ) )
	{
		// 񽺷 ġ õմϴ.
		printf( "\nInstallation to your service is initiated.\n" );

		if ( InstallService( fullPath ) )
		{
			// 񽺷 ġ Ϸ Ͽϴ.
			printf( "\nInstallation to your service is completed.\n" );
		}
		else
		{
			// 񽺷 ġ Ϸ  Ͽϴ.
			printf( "\nInstallation to your service is not completed.\n" );
		}
	}
	else if ( !_stricmp( argv[1], "/UNINSTALL" ) )
	{
		// 񽺷  õմϴ.
		printf( "\nDeleting your service is initiated.\n" );

		if ( UninstallService( ) )
		{
			// 񽺷  Ϸ Ͽϴ.
			printf( "\nDeleting your service is completed.\n" );
		}
		else
		{
			// 񽺷  Ϸ  Ͽϴ.
			printf( "\nDeleting our service is not completed.\n" );
		}
	}
	else if ( !_stricmp( argv[1], "/VER" ) )
	{
		//   .
		printf( "Company Name: %s\n", mCompanyName );
		printf( "Service Name: %s\n", mServiceName );
		printf( "Display Name: %s\n", mDisplayName );
		printf( "Description : %s\n", mDescription );
		printf( "Version     : %d.%d\n", (mVersion>>8), (mVersion&0xff) );
	}
	else if ( !_stricmp( argv[1], "/INSERT" ) )
	{
		// 켱 1. cSQLGame .
		cSQLGame*    sqlGame    = new cSQLGame( );
		cFileSystem* fileSystem = new cFileSystem( );
		int          errorCount = 0;

		printf( "\n--- INSERT : %s ---------------------\n", mServiceName );

		if ( sqlGame->ConsoleInsertInit( ) )
			printf( "\nSQLGame ʱȭ &  ε .\n" );
		else
			errorCount += ErrorInsert( "SQLGame ʱȭ &  ε !!!" );

		if ( sqlGame->InsertItemDefine( ODBC_DSN_GAME, ODBC_UID, ODBC_PWD ) )
			printf( "\nTB_ITEM_DEFINE Է¸ Ϸ Ͽϴ.\n" );
		else
			errorCount += ErrorInsert( "TB_ITEM_DEFINE Է¸ Ϸ  Ͽϴ!!!" );

		if ( sqlGame->InsertItemAbility( ODBC_DSN_GAME, ODBC_UID, ODBC_PWD ) )
			printf( "\nTB_ITEM_ABILITY Է¸ Ϸ Ͽϴ.\n" );
		else
			errorCount += ErrorInsert( "TB_ITEM_ABILITY Է¸ Ϸ  Ͽϴ!!!" );

		if ( sqlGame->InsertItemLimit( ODBC_DSN_GAME, ODBC_UID, ODBC_PWD ) )
			printf( "\nTB_ITEM_LIMIT Է¸ Ϸ Ͽϴ.\n" );
		else
			errorCount += ErrorInsert( "TB_ITEM_LIMIT Է¸ Ϸ  Ͽϴ!!!" );

		if ( sqlGame->InsertItemCard( ODBC_DSN_GAME, ODBC_UID, ODBC_PWD ) )
			printf( "\nTB_ITEM_CARD Է¸ Ϸ Ͽϴ.\n" );
		else
			errorCount += ErrorInsert( "TB_ITEM_CARD Է¸ Ϸ  Ͽϴ!!!" );

		if ( sqlGame->InsertItemCardSlot( ODBC_DSN_GAME, ODBC_UID, ODBC_PWD ) )
			printf( "\nTB_ITEM_CARD_SLOT Է¸ Ϸ Ͽϴ.\n" );
		else
			errorCount += ErrorInsert( "TB_ITEM_CARD_SLOT Է¸ Ϸ  Ͽϴ!!!" );

		if ( sqlGame->InsertItemTarot( ODBC_DSN_GAME, ODBC_UID, ODBC_PWD ) )
			printf( "\nTB_ITEM_TAROT Է¸ Ϸ Ͽϴ.\n" );
		else
			errorCount += ErrorInsert( "TB_ITEM_TAROT Է¸ Ϸ  Ͽϴ!!!" );

		if ( sqlGame->InsertItemTarotResult( ODBC_DSN_GAME, ODBC_UID, ODBC_PWD ) )
			printf( "\nTB_ITEM_TAROT_RESULT Է¸ Ϸ Ͽϴ.\n" );
		else
			errorCount += ErrorInsert( "TB_ITEM_TAROT_RESULT Է¸ Ϸ  Ͽϴ!!!" );

		if ( sqlGame->InsertItemSpread( ODBC_DSN_GAME, ODBC_UID, ODBC_PWD ) )
			printf( "\nTB_ITEM_SPREAD Է¸ Ϸ Ͽϴ.\n" );
		else
			errorCount += ErrorInsert( "TB_ITEM_SPREAD Է¸ Ϸ  Ͽϴ!!!" );

		if ( sqlGame->InsertItemDisjoint( ODBC_DSN_GAME, ODBC_UID, ODBC_PWD ) )
			printf( "\nTB_ITEM_DISJOINT Է¸ Ϸ Ͽϴ.\n" );
		else
			errorCount += ErrorInsert( "TB_ITEM_DISJOINT Է¸ Ϸ  Ͽϴ!!!" );

		if ( sqlGame->InsertItemEnhanced( ODBC_DSN_GAME, ODBC_UID, ODBC_PWD ) )
			printf( "\nTB_ITEM_ENHANCED Է¸ Ϸ Ͽϴ.\n" );
		else
			errorCount += ErrorInsert( "TB_ITEM_ENHANCED Է¸ Ϸ  Ͽϴ!!!" );

		if ( sqlGame->InsertItemEnhancedRate( ODBC_DSN_GAME, ODBC_UID, ODBC_PWD ) )
			printf( "\nTB_ITEM_ENHANCED_RATE Է¸ Ϸ Ͽϴ.\n" );
		else
			errorCount += ErrorInsert( "TB_ITEM_ENHANCED_RATE Է¸ Ϸ  Ͽϴ!!!" );

		if ( sqlGame->InsertItemChange( ODBC_DSN_GAME, ODBC_UID, ODBC_PWD ) )
			printf( "\nTB_ITEM_CHANGE Է¸ Ϸ Ͽϴ.\n" );
		else
			errorCount += ErrorInsert( "TB_ITEM_CHANGE Է¸ Ϸ  Ͽϴ!!!" );

		if ( sqlGame->InsertDefaultItems( ODBC_DSN_GAME, ODBC_UID, ODBC_PWD ) )
			printf( "\nTB_DEFAULT_ITEMS Է¸ Ϸ Ͽϴ.\n" );
		else
			errorCount += ErrorInsert( "TB_DEFAULT_ITEMS Է¸ Ϸ  Ͽϴ!!!" );

		if ( sqlGame->InsertSkillPC( ODBC_DSN_GAME, ODBC_UID, ODBC_PWD ) )
			printf( "\nTB_SKILLLIST_PC Է¸ Ϸ Ͽϴ.\n" );
		else
			errorCount += ErrorInsert( "TB_SKILLLIST_PC Է¸ Ϸ  Ͽϴ!!!" );

		if ( sqlGame->InsertDefaultSkill( ODBC_DSN_GAME, ODBC_UID, ODBC_PWD ) )
			printf( "\nTB_DEFAULT_SKILL Է¸ Ϸ Ͽϴ.\n" );
		else
			errorCount += ErrorInsert( "TB_DEFAULT_SKILL Է¸ Ϸ  Ͽϴ!!!" );

		/// Ʈ  ε
		if ( sqlGame->InsertQuestData( ODBC_DSN_GAME, ODBC_UID, ODBC_PWD ) )
			printf( "\nTB_QUEST Է¸ Ϸ Ͽϴ.\n" );
		else
			errorCount += ErrorInsert( "TB_QUEST Է¸ Ϸ  Ͽϴ!!!" );

		sqlGame->ConsoleInsertRelease( );

		printf( "\n--------------------- Ϸ ---------------------\n" );
		printf( "\nINSERT - %d \n", errorCount );
		printf( "\nϷ ƹ Ű ʽÿ..." );
		_getch( );

		SafeDelete( fileSystem );
		SafeDelete( sqlGame );
	}
	else if ( !_stricmp( argv[1], "/UPDATE" ) )
	{
	}
	else if ( !_stricmp( argv[1], "/TEST" ) )
	{
		DWORD status;
		DWORD error;

		if ( SetConsoleCtrlHandler( ::ConsolCtrlHandler, TRUE ) != 0 )
		{
			// ׽Ʈ ɼ ˻.
			for ( DWORD i = 2; i < argc; i++ )
			{
				if ( !_stricmp( argv[ i ], "-VERBOSE" ) )
				{
					g_verbose = true;
				}
				else if ( !_stricmp( argv[ i ], "-FPS" ) )
				{
					g_fps = true;
				}
				else if ( !_stricmp( argv[ i ], "-PACKET" ) )
				{
					g_packet = true;
				}				
			}

			// ֿܼ ׽Ʈ.
			status = Initialization( argc, argv, &error );
			if ( status == NO_ERROR )
			{
				printf( "\nStart %s / Test\n", mDisplayName );
				Run( );
				printf( "\nStop %s / Test\n", mDisplayName );
			}
			else
			{
				printf( "\nInitialize fail %s\n", mDisplayName );
			}
			SetConsoleCtrlHandler( ::ConsolCtrlHandler, FALSE );
		}
	}
}

// ServiceCtrlHandler Method
void cGameSrv::ServiceCtrlHandler(DWORD opcode)
{
	switch ( opcode )
	{
	case SERVICE_CONTROL_STOP:
		// Notifies a service that it should stop.
		mServiceStatus.dwWin32ExitCode = 0;
		mServiceStatus.dwCurrentState  = SERVICE_STOPPED;
		mServiceStatus.dwCheckPoint    = 0;
		mServiceStatus.dwWaitHint      = 0;
		// Updates the service control manager's status information for the calling service.
		SetServiceStatus( mServiceStatusHandle, &mServiceStatus );
		//  ڵ Destroy Լ .
		Destroy( );
		return;
	case SERVICE_CONTROL_PAUSE:
		// Notifies a service that it should pause.
		mServiceStatus.dwCurrentState = SERVICE_PAUSED;
		break;
	case SERVICE_CONTROL_CONTINUE:
		// Notifies a paused service that it should resume.
		mServiceStatus.dwCurrentState = SERVICE_RUNNING;
		break;
	case SERVICE_CONTROL_INTERROGATE:
		// Notifies a service that it should report its current status information to the service control manager.
		break;
	case SERVICE_CONTROL_SHUTDOWN:
		// Notifies a service that the system is shutting down so the service can perform cleanup tasks.
		break;
	case SERVICE_CONTROL_PARAMCHANGE:
		// Notifies a service that its startup parameters have changed. The service should reread its startup parameters.
		break;
	case SERVICE_CONTROL_NETBINDADD:
		// Notifies a network service that there is a new component for binding. The service should bind to the new component.
		break;
	case SERVICE_CONTROL_NETBINDREMOVE:
		// Notifies a network service that a component for binding has been removed.
		// The service should reread its binding information and unbind from the removed component.
		break;
	case SERVICE_CONTROL_NETBINDENABLE:
		// Notifies a network service that a disabled binding has been enabled.
		// The service should reread its binding information and add the new binding.
		break;
	case SERVICE_CONTROL_NETBINDDISABLE:
		// Notifies a network service that one of its bindings has been disabled.
		// The service should reread its binding information and remove the binding.
		break;
	}
	// Updates the service control manager's status information for the calling service.
	SetServiceStatus( mServiceStatusHandle, &mServiceStatus );
}

// ServiceRun Method
void cGameSrv::ServiceRun(DWORD argc, LPTSTR* argv)
{
	DWORD status;
	DWORD error;

	mServiceStatus.dwServiceType             = SERVICE_WIN32;
	mServiceStatus.dwCurrentState            = SERVICE_START_PENDING;
	mServiceStatus.dwControlsAccepted        = SERVICE_ACCEPT_STOP;
	mServiceStatus.dwWin32ExitCode           = 0;
	mServiceStatus.dwServiceSpecificExitCode = 0;
	mServiceStatus.dwCheckPoint              = 0;
	mServiceStatus.dwWaitHint                = 0;

	//   óڸ Ѵ. - н 0 ȯ Ѵ.
	mServiceStatusHandle = RegisterServiceCtrlHandler( mServiceName, ::ServiceCtrlHandler );
	if ( mServiceStatusHandle == (SERVICE_STATUS_HANDLE)0 )
		return;

	// Initialization code goes here.
	// - ʱȭ  ڵ ServiceInitialization Լ 
	// - н NO_ERROR(0) ƴ  ȯ.
	status = Initialization( argc, argv, &error );	

	// Handle error condition - ʱȭ    ڵ(status) ǥ ش.
	if ( status != NO_ERROR )
	{
		mServiceStatus.dwCurrentState            = SERVICE_STOPPED;
		mServiceStatus.dwCheckPoint              = 0;
		mServiceStatus.dwWaitHint                = 0;
		mServiceStatus.dwWin32ExitCode           = status;
		mServiceStatus.dwServiceSpecificExitCode = error;

		// Updates the service control manager's status information for the calling service.
		if ( SetServiceStatus( mServiceStatusHandle, &mServiceStatus ) == FALSE )
			return;
	}

	// Initialization complete - report running status.
	// - ʱȭ Ϸ -  ¸ (RUNNING) .
	mServiceStatus.dwCurrentState = SERVICE_RUNNING;
	mServiceStatus.dwCheckPoint   = 0;
	mServiceStatus.dwWaitHint     = 0;

	// Updates the service control manager's status information for the calling service.
	if ( SetServiceStatus( mServiceStatusHandle, &mServiceStatus ) == FALSE )
		return;

	// Run -  .
	Run( );
}

// Initialization Method (Stub initialization function.)
// . Ŭ   
DWORD cGameSrv::Initialization(DWORD /*argc*/, LPTSTR* /*argv*/, DWORD* /*error*/)
{
	// WINSOCK2 ʱȭ ( 2.2).
	if ( LOBYTE( m_wsaData.wVersion ) != 2 || HIBYTE( m_wsaData.wVersion ) != 2 )
		return 1L;

	// Ÿ̸  Ų.
	timeBeginPeriod( 1 );

	//  .
	DWORD userNameSize   = 0;
	DWORD userNameRetVal = 0;

	userNameRetVal = GetUserName( mUserName, &userNameSize );

	if ( userNameRetVal == 0 && GetLastError( ) == ERROR_INSUFFICIENT_BUFFER )
	{
		mUserName      = (TCHAR*)GlobalAlloc( GPTR, userNameSize );
		userNameRetVal = GetUserName( mUserName, &userNameSize );
	}
	if ( userNameRetVal == 0 && GetLastError( ) == ERROR_INSUFFICIENT_BUFFER )
	{
		if ( g_verbose == true )
		{
			VOID* msgBuf;
			if ( ErrorCode2String( &msgBuf ) )
			{
				printf( "\nGetUserName (%d): %s\n", GetLastError( ), (char*)msgBuf );
				LocalFree( msgBuf );
			}
		}
		return 1L;
	}

	// ȣƮ .
	if ( GetLocalHostInfo( ) == false )
	{
		if ( g_verbose == true )
		{
			VOID* msgBuf;
			if ( ErrorCode2String( &msgBuf ) )
			{
				printf( "\nGetNetworkParams (%d): %s\n", GetLastError( ), (char*)msgBuf );
				LocalFree( msgBuf );
			}
		}
		return 1L;
	}

	//  & ȣƮ .
	if ( g_verbose == true )
	{
		printf( "\n" );
		printf( "User Name............: %s \n", mUserName );
		printf( "Host Name............: %s \n", mFixedInfo->HostName );
		printf( "NetBIOS Scope ID.....: %s \n", mFixedInfo->ScopeId );
		printf( "IP Routing Enabled...: %s \n", (mFixedInfo->EnableRouting ? "YES" : "NO") );
		printf( "WINS Proxy Enabled...: %s \n", (mFixedInfo->EnableProxy ? "YES" : "NO") );
		printf( "\n" );
	}

	// ȯ .
	SC_HANDLE              manager = NULL;
	SC_HANDLE              service = NULL;
	LPQUERY_SERVICE_CONFIG config  = NULL; 
	DWORD                  bytesNeeded; 

	// ȯ .
	TCHAR                  filename[MAX_PATH]="\0";
	TCHAR                  directory[MAX_PATH]="\0";

	// Open a handle to the SC Manager database.
	manager = OpenSCManager( NULL, NULL, SC_MANAGER_ALL_ACCESS );
	if ( manager != NULL )
	{
		// Open a handle to the service.
		service = OpenService( manager, mServiceName, SERVICE_ALL_ACCESS );
		if ( service != NULL )
		{
			if ( QueryServiceConfig( service, config, 0, &bytesNeeded ) == FALSE )
			{
				config = (LPQUERY_SERVICE_CONFIG)LocalAlloc( LPTR, bytesNeeded );
				QueryServiceConfig( service, config, bytesNeeded, &bytesNeeded );
			}
			if ( config != NULL )
			{
				char drive[_MAX_DRIVE];
				char dir[_MAX_DIR];
				char fname[_MAX_FNAME];
				_splitpath( config->lpBinaryPathName, drive, dir, fname, NULL );

				// ϰ .
				if ( g_verbose == true )
				{
					printf( "Binary Path Name.....: %s%s%s \n", drive, dir, fname      );
					printf( "Service Start Name...: %s \n", config->lpServiceStartName );
					printf( "Display Name.........: %s \n", config->lpDisplayName      );
				}

				sprintf( directory, "%s%s", drive, dir );
				sprintf( filename, "%s%s.cfg", directory, fname );

				LocalFree( config );
			}
			CloseServiceHandle( service );
		}
		else
			return 1L;
	}
	else
		return 1L;

	FILE* stream = fopen( filename, "rt" );
	char  buffer[MAX_PATH];
	if ( stream != NULL )
	{
		fscanf( stream, "%s", buffer );
		if ( stricmp( buffer, "SERVER_NO:" ) == 0 )
			fscanf( stream, "%d", &mServerNo );
		else
			return 1L;

		fscanf( stream, "%s", buffer );
		if ( stricmp( buffer, "CHANNEL_NO:" ) == 0 )
			fscanf( stream, "%d", &mChannelNo );
		else
			return 1L;

		fscanf( stream, "%s", buffer );
		if ( stricmp( buffer, "GAME_SERVER_ADDRESS(IPv4):" ) == 0 )
			fscanf( stream, "%s", mServerAddr );
		else
			return 1L;

		fscanf( stream, "%s", buffer );
		if ( stricmp( buffer, "GAME_BROADCAST_RECV(IPv4):" ) == 0 )
			fscanf( stream, "%s", mServerBroadcastRecv );
		else
			return 1L;

		fscanf( stream, "%s", buffer );
		if ( stricmp( buffer, "GAME_BROADCAST_SEND(IPv4):" ) == 0 )
			fscanf( stream, "%s", mServerBroadcastSend );
		else
			return 1L;

		fscanf( stream, "%s", buffer );
		if ( stricmp( buffer, "GAME_FIREWALL(IPv4):" ) == 0 )
			fscanf( stream, "%s", mServerFirewall );
		else
			return 1L;

		fclose( stream );
	}
	else
		return 1L;

	/*-- ODBC-DNS & WINSOCK2 ʱȭ. --*/

	// ۾ 丮 .
	if ( SetCurrentDirectory( directory ) == false )
		return 1L;

	// 켱 1. cSender Ŭ .
	mSender = new cSender( );
	if ( mSender->Initialize( mServerBroadcastSend ) == false )
		return 1L;

	// 켱 2. cSQLAccount .
	mSqlAccount = new cSQLAccount( );
	if ( mSqlAccount->Initialize( ODBC_DSN_ACCOUNT, ODBC_UID, ODBC_PWD, 2, 32768 ) == false )
		return 1L;

	// 켱 2. cSQLGame .
	mSqlGame = new cSQLGame( );
	if ( mSqlGame->Initialize( ODBC_DSN_GAME, ODBC_UID, ODBC_PWD, 4, 32768 ) == false )
		return 1L;

	// 켱 3. cGameProcess .
	mGameProcess = new cGameProcess( mServerNo, mChannelNo, (strlen( mServerFirewall ) ? mServerFirewall : mServerAddr) );
	if ( mGameProcess->Initialize( mServerAddr, T_GAME_CPORT, 4, 16384 ) == false )
		return 1L;

	// 켱 4. cRecver Ŭ .
	mRecver = new cRecver( );
	if ( mRecver->Initialize( mServerBroadcastRecv, U_GAME_SPORT ) == false )
		return 1L;

	mVerbose = new cVerbose( );
	if ( mVerbose == NULL )
		return 1L;

	return 0L;
}

// Destroy Method
// . Ŭ   .
void cGameSrv::Destroy(void)
{
	// 켱 1. cRecver .
	mRecver->Shutdown( );

	// 켱 2. cGameProcess .
	mGameProcess->Shutdown( );

	// 켱 3. cSQLAccount .
	mSqlAccount->Shutdown( );

	// 켱 3. cSQLGame .
	mSqlGame->Shutdown( );

	// 켱 4. cSender .
	mSender->Shutdown( );

	// ޸ .
	if ( mUserName != NULL )
	{
		GlobalFree( mUserName );
		mUserName = NULL;
	}

	// .
	mRunService = false;
}

// PostServerEvent Method
bool cGameSrv::PostServerEvent(char* message)
{
	if ( mSender != NULL )
	{
		return mSender->PostServerEvent( message );
	}
	return false;
}

// Run Method
void cGameSrv::Run(void)
{
	DWORD currentTick;
	DWORD elapsedTick;

	// 񽺰  .
	mRunService = true;
	while ( mRunService )
	{
		currentTick = GetTickCount( );

		// ð 16(ms) - CPU ȭ  &  ȭ.
		elapsedTick = GetTickCount( ) - currentTick;
		if ( elapsedTick < 100 )
		{
			Sleep( (100 - elapsedTick) );
		}
	}
}
