/* ====================================================================
 *      :	gameSrv.h
 *      :	
 *    :	ö
 *    :	06/12/21
 * ǻ :	
 * =================================================================== */
#ifndef __GAME_SERVER_H__
#define __GAME_SERVER_H__

//#ifndef WINVER
//#define WINVER          0x0500
//#endif
//
//#ifndef _WIN32_WINNT
//#define _WIN32_WINNT    0x0500
//#endif

#ifndef WSA_STARTUP_VER
#define WSA_STARTUP_VER 0x0002
#endif

#pragma once

// 2     - link "ws2_32.lib"
#include <winsock2.h>
//  
#include <windows.h>
#include <winerror.h>
#include <lmerr.h>
#include <stdio.h>

#include "wsastartup.h"


#ifndef __DEFAULT_DEFINE__
#define __DEFAULT_DEFINE__

#define	DEFAULT_SQL_ACCOUNT		0x1000 // SQL Account  Request default type
#define	DEFAULT_SQL_GAME		0x2000 // SQL Game     "
#define	DEFAULT_GAME_PROCESS	0x4000 // Game Process "

#endif // __DEFAULT_DEFINE__


#include "sqlaccount.h"
#include "sqlgame.h"
#include "sender.h"
#include "recver.h"
#include "gameprocess.h"
#include "verbose.h"

class cGameSrv : public cWSAStartup
{
private:
//    ȯ溯.
	SERVICE_STATUS_HANDLE mServiceStatusHandle;
	SERVICE_STATUS        mServiceStatus;

	TCHAR*                mCompanyName;
	TCHAR*                mServiceName;
	TCHAR*                mDisplayName;
	TCHAR*                mDescription;
	TCHAR*                mUserName;
	bool                  mRunService;
	WORD                  mVersion;

private:
// ȯ溯
	DWORD                  mServerNo;
	DWORD                  mChannelNo;
	TCHAR                  mServerAddr[MAX_PATH];
	TCHAR                  mServerBroadcastRecv[MAX_PATH];
	TCHAR                  mServerBroadcastSend[MAX_PATH];
	TCHAR                  mServerFirewall[MAX_PATH];

private:
// Ŭ.
	cSQLAccount*          mSqlAccount;
	cSQLGame*             mSqlGame;
	cSender*              mSender;
	cRecver*              mRecver;
	cGameProcess*         mGameProcess;
	cVerbose*             mVerbose;

private:
//   ޼ҵ.
	bool                  InstallService     ( LPCTSTR binaryPathName, DWORD startType = SERVICE_DEMAND_START );
	bool                  UninstallService   ( void );

private:
// α׷  ޼ҵ.
	DWORD                 Initialization     ( DWORD argc, LPTSTR* argv, DWORD* error );
	void                  Destroy            ( void );
	void                  Run                ( void );

private:
// Command Line  ޼ҵ.
	int                   ErrorInsert        ( char* msg );

public:
// Ŭ    ޼ҵ.
	cGameSrv(void);

	BOOL                  ConsolCtrlHandler  ( DWORD opcode );
	void                  ConsoleRun         ( DWORD argc, LPTSTR* argv );

	void                  ServiceCtrlHandler ( DWORD opcode );
	void                  ServiceRun         ( DWORD argc, LPTSTR* argv );

public:
// Ŭ  ޼ҵ.
	TCHAR*                GetServiceName     ( ) { return mServiceName; }
	TCHAR*                GetHostName        ( ) { return mFixedInfo->HostName; }

	cSQLAccount*          GetSQLAccount      ( ) { return mSqlAccount; }
	cSQLGame*             GetSQLGame         ( ) { return mSqlGame; }
	cSender*              GetSender          ( ) { return mSender; }
	cRecver*              GetRecver          ( ) { return mRecver; }
	cGameProcess*         GetGameProcess     ( ) { return mGameProcess; }

	bool                  PostServerEvent    ( char* message );

public:
// Ŭ ı ޼ҵ.
	virtual ~cGameSrv(void);
};

DWORD ErrorCode2String ( VOID** msgBuf, DWORD lastError = GetLastError(), WORD priLangId = LANG_NEUTRAL, WORD subLangId = SUBLANG_DEFAULT );

extern cGameSrv* g_gameSrv;
extern bool      g_verbose;
extern bool      g_fps;
extern bool      g_packet;

#endif // __GAME_SERVER_H__