/* ====================================================================
 *      :	gameSrvDefines.h
 *      :	
 *    :	ö
 *    :	06/26/07
 * ǻ :	
 * =================================================================== */
#ifndef __GAME_SERVER_DEFINES_H__
#define __GAME_SERVER_DEFINES_H__

#include "Item_Common.h"
#include "Skill_Common.h"
#include "Guild_Common.h"

#pragma once

#pragma pack(1) // 1Byte  

struct TB_ITEM_DEFINE
{
	long    idx;							// ȣ
	long    idxAbility;						// ̺ ȣ -      ( ÷)
	long    idxLimit;						// ̺ ȣ -      ( ÷)
	long    idxCard;						// ̺ ȣ - ī     ( ÷)
	long    idxCardSlot;					// ̺ ȣ - ī彽 ( ÷)
	long    idxTarot;						// ̺ ȣ - Ÿ     ( ÷)
	long    idxEnhanced;					// ̺ ȣ -     ȭ ( ÷)
	long    idxEnhancedRate;				// ̺ ȣ - ȭȮ ( ÷)
	long    idxDisjoint;					// ̺ ȣ -      ( ÷)
	long    idxChange;						// ̺ ȣ -     ȯ ( ÷)
	long    index;							// ȹ:зȣ
	wchar_t name[51];						// ̸
	BYTE    type;							// (ȹ)
	BYTE    subType;						// (׸)
	short   weight;							// 
	short   capacity;						// Ѽ
	long    sellType;						// ǸŹ(ȹ)
	long    sellPrice;						// ǸŰ
	long    buyType;						// Թ(ȹ)
	long    buyPrice;						// ԰
	long    present;						// 
	long    maxPresent;						// ִ 
	long    maxInventory;					// ɰ
	BYTE    exchange;						// ڰŷ (0ŷ/1ŷҰ)
	long    abilityIndex;					// ȹ:зȣ
	long    limitIndex;						// ȹ:зȣ
	long    cardIndex;						// ȹ:зȣ
	long    cardSlotIndex;					// ȹ:зȣ
	long    tarotIndex;						// ȹ:зȣ
	long    spreadIndex;					// ȹ:зȣ
	long    enhancedIndex;					// ȹ:зȣ
	long    enhancedRateIndex;				// ȹ:зȣ
	long    disjointIndex;					// ȹ:зȣ
	long    changeIndex;					// ȹ:зȣ
	long    titleIndex;						// ȹ:зȣ
//	wchar_t desc[1];						// ()
	BYTE    apply;							// 뿩(0̻/1/2)
};

struct TB_ITEM_ABILITY
{
	long  idx;								// ȣ
	long  index;							// ȹ:зȣ
	short def_class;						// 
	BYTE  range_type;						// 
	BYTE  target_type;						// ȿŸ
	short use_range;						// Ÿ
	short p_def;							// :
	short m_def;							// :
	short atk_range;						//  Ÿ
	short atk_spd;							//  ӵ
	long  cool_time1;						//  Ÿ
	long  cool_time2;						// ׷  Ÿ
	short min_p_atk;						// :ּҰݷ
	short max_p_atk;						// :ִݷ
	short min_m_atk;						// :ּҰݷ
	short max_m_atk;						// :ִݷ

	short opt01_index;						// ɼ01ε(ȹ)
	short opt01_value;						// ɼ01ȿ(ȹ)
	short opt02_index;						// ɼ02ε(ȹ)
	short opt02_value;						// ɼ02ȿ(ȹ)
	short opt03_index;						// ɼ03ε(ȹ)
	short opt03_value;						// ɼ03ȿ(ȹ)
	short opt04_index;						// ɼ04ε(ȹ)
	short opt04_value;						// ɼ04ȿ(ȹ)
	short opt05_index;						// ɼ05ε(ȹ)
	short opt05_value;						// ɼ05ȿ(ȹ)
	short opt06_index;						// ɼ06ε(ȹ)
	short opt06_value;						// ɼ06ȿ(ȹ)
	short opt07_index;						// ɼ07ε(ȹ)
	short opt07_value;						// ɼ07ȿ(ȹ)
	short opt08_index;						// ɼ08ε(ȹ)
	short opt08_value;						// ɼ08ȿ(ȹ)
	short opt09_index;						// ɼ09ε(ȹ)
	short opt09_value;						// ɼ09ȿ(ȹ)
	short opt10_index;						// ɼ10ε(ȹ)
	short opt10_value;						// ɼ10ȿ(ȹ)

	long  influence_idx;					// ųȿ
};

struct TB_ITEM_COOLTIME1
{
	TB_ITEM_COOLTIME1* next;				// ׷  Ÿ
	long               itemDefineIdx;		// ̺ ȣ
	long               itemDefineIndex;		// ȹ:зȣ
	long               cooltime;			//  Ÿ
};
struct TB_ITEM_COOLTIME2
{
	long               idx;					// ȣ
	TB_ITEM_COOLTIME1* cooltime1;			//  Ÿ
};

struct TB_ITEM_LIMIT
{
	long idx;								// ȣ
	long index;								// ȹ:зȣ
	BYTE charRace;							// ĳ:
	BYTE charGender;						// ĳ:
	long charJob;							// ĳ:
	BYTE charLevel;							// ĳ:
	BYTE pvpOnly;							// (0/1)
};

struct TB_ITEM_CARD
{
	long idx;								// ȣ
	long index;								// ȹ:зȣ
	long episode;							// 
	long number;							// īȣ
	BYTE level;								// ͵
	BYTE type;								// īз
	BYTE subType;							// ġ
};

struct TB_ITEM_CARD_SLOT
{
	long idx;								// ȣ
	long index;								// ȹ:зȣ
	BYTE slot1;								// ī彽1(0/1A/2B/3AB/4O)
	BYTE slot2;								// ī彽2(0/1A/2B/3AB/4O)
	BYTE slot3;								// ī彽3(0/1A/2B/3AB/4O)
	BYTE slot4;								// ī彽4(0/1A/2B/3AB/4O)
	BYTE slot5;								// ī彽5(0/1A/2B/3AB/4O)
};

struct TB_ITEM_TAROT
{
	long idx;								// ȣ
	long index;								// ȹ:зȣ
	long number;							// ȣ
	BYTE level;								// 
	long strValue;							// ġ
	long invValue;							// ġ
	long prop;								// Ӽ
	long episode;							// Ǽҵ()
};

struct TB_ITEM_TAROT_RESULT
{
	long idx;								// ȣ
	long index;								// ȹ:зȣ
	long min_value;							// ּҰ
	long max_value;							// ִ밪
	long influence_idx1;					// ųȿ
	long influence_idx2;					// ųȿ
	long influence_idx3;					// ųȿ
};

struct TB_ITEM_SPREAD
{
	long  idx;								// ȣ
	long  index;							// ȹ:зȣ
	BYTE  axisArray;						// ǥ ε
	short xPos;								// Xǥ
	short yPos;								// Yǥ
	BYTE  dir;								// 
	char  calc[2];							// 
	short value;							// ġ
};

struct TB_ITEM_ENHANCED
{
	long idx;								// ȣ
	long index;								// ȹ:зȣ
	BYTE enhanced1;							// Ӽ1(0,1ݷ,2ݷ,3,4)
	BYTE enhanced2;							// Ӽ1(0,1ݷ,2ݷ,3,4)
	union {
		char  strPlus[260];					// (1~15ܰ) - ڿ ','  
		short IndPlus[MAX_ITEM_ENHANCED];	// (1~15ܰ) -  迭(ڿ ȯϿ ٽ  ؾ߸ Ѵ)
	};
};

struct TB_ITEM_ENHANCED_RATE
{
	long idx;								// ȣ
	long index;								// ȹ:зȣ
	union {
		struct {
			char   success [260];
			char   down    [260];
			char   destruct[260];
		} str;								// //ı(1~15ܰ) - ڿ ','  
		struct {
			double success [MAX_ITEM_ENHANCED];
			double down    [MAX_ITEM_ENHANCED];
			double destruct[MAX_ITEM_ENHANCED];
		} ind;								// //ı(1~15ܰ) -  迭(ڿ ȯϿ ٽ  ؾ߸ Ѵ)
	};
};

struct TB_ITEM_DISJOINT
{
	long  idx;								// ȣ
	long  index;							// ȹ:зȣ
	long  price;							// 
	long  itemDefineIndex1;					// 1(TB_ITEM_DEFINE::INDEX)
	short inventoryCount1;					// κ丮  1
	long  itemDefineIndex2;					// 2(TB_ITEM_DEFINE::INDEX)
	short inventoryCount2;					// κ丮  2
	long  itemDefineIndex3;					// 3(TB_ITEM_DEFINE::INDEX)
	short inventoryCount3;					// κ丮  3
	long  itemDefineIndex4;					// 4(TB_ITEM_DEFINE::INDEX)
	short inventoryCount4;					// κ丮  4
	long  itemDefineIndex5;					// 5(TB_ITEM_DEFINE::INDEX)
	short inventoryCount5;					// κ丮  5
	long  itemDefineIndex6;					// 6(TB_ITEM_DEFINE::INDEX)
	short inventoryCount6;					// κ丮  6
};

struct TB_ITEM_CHANGE
{
	long  idx;
	long  index;
	long  minMoney;
	long  maxMoney;
	union {
		struct {
			char rate [400];				// Ȯ
			char index[400];				// ȹ:зȣ
			char count[400];				// 
		} str;								// ȯ (ȹ:зȣ/).
		struct {
			float rate [ MAX_ITEM_CHANGE_RATE ];
			long  index[ MAX_ITEM_CHANGE_DATA ];
			short count[ MAX_ITEM_CHANGE_DATA ];
		} ind;								// ȯ (ȹ:зȣ/).
	};
};

struct TB_CHARACTER
{
	long    idx;							// ĳ ε
	wchar_t name[17];						// ĳ ̸
	char    level;							// ĳ 
	char    race;							// ĳ 
	char    gender;							// ĳ 
	long    job;							// ĳ 

	long    hair;							// ĳ 
	long    face;							// ĳ 

	long    hat;							//  
	long    body1;							//  
	long    body2;							//  
	long    hand;							//  
	long    foot;							//  

	long    earring;						//  ׼
	long    necklace;						//  ׼
	long    brooch;							//  ׼
	long    bracelet;						//  ׼
	long    ring;							//  ׼

	long    leftHand;						//  
	char    leftHandEnhanced;				//   ȭ
	long    rightHand;						//  
	char    rightHandEnhanced;				//   ȭ

	char    activeWeapon;					// Ȱ  (0 Front, 1 Back)

	short   mapNum;							// ĳ (ġ)
	float   xPos;							// ĳ X ǥ
	float   yPos;							// ĳ Y ǥ

	long    exp;							// ĳ ġ
	long	HP;								// ĳ HP
	long	MP;								// ĳ MP

	char    skillLevel;						// ų 
	long    skillPointRemain;				// ų Ʈ
	long	skillPointTotal;				// ų  ȹ淮
	long    skillExp;						// ų ġ

	long    tarotPoint;						// Ÿ Ʈ

	__int64 money;							// ݾ
	__int64 deposit;						// ġݾ

	long    option1;						// ɼ1

	unsigned char	mForceType;
	unsigned long	mPvPPoint;
	unsigned long	mFirePoint;
	unsigned long	mFireFriendly;
	unsigned long	mWaterPoint;
	unsigned long	mWaterFriendly;
	unsigned long	mWindPoint;
	unsigned long	mWindFriendly;
	unsigned long	mEarthPoint;
	unsigned long	mEarthFriendly;

	unsigned long	mTitleIndex;			// õ ȣĪε

	unsigned long	mGuildIndex;			//  ε
	unsigned char	mGuildPosition;			// 峻 

	unsigned char	mMakeSkill1;			//  
	unsigned char	mMakeSkill2;

	char    standIdx;						// ĳ 
};

struct TB_DEFAULT_ITEMS
{
	long  characterJob;
	long  itemDefineIndex;
	short inventoryNumber;
	short inventoryCount;
};

enum eInventoryApply
{
	InventoryApplyNone =0,					// κ丮    - ⺻.
	InventoryApplyRemoved,					// κ丮  - Database  Է.
	InventoryApplyExchange,					// κ丮    - GameServer .
	InventoryApplyStallSell,				// κ丮    - GameServer .
	InventoryApplyGetAuto,					// κ丮 ڵ - GameServer .
};

struct TB_INVENTORY
{
	long  idx;								// ȣ
	long  itemDefineIdx;					//   ȣ
	long  itemDefineIndex;					//   ε
	short number;							// ȣ(ε)
	short count;							// 
	BYTE  enhanced;							// ȭܰ(0~15 )
	long  cardSlot1;						// ī彽1
	long  cardSlot2;						// ī彽2
	long  cardSlot3;						// ī彽3
	long  cardSlot4;						// ī彽4
	long  cardSlot5;						// ī彽5
	BYTE  seal;								// (0/1ε)
	BYTE  apply;							// 뿩
};

struct TB_INVENTORY_COOLTIME
{
	long itemDefineIndex;					//   ε
	long cooltime2;							// Ÿ ׷ ε
	long cooltime1;							// Ÿ( ð ms)
	long cooltime;							// Ÿ(ð ms)
};

typedef tbNOTE TB_NOTE;

struct TB_FRIEND
{
	long           idx;						// ȣ
	long           characterIdx;			// ĳ ȣ
	wchar_t        characterName[ 17 ];		// ĳ ̸
	char           race;					// ĳ 
	char           gender;					// ĳ 
	char           level;					// ĳ 
	unsigned long  job;						// ĳ (ePLAYER_JOB)
	unsigned short mapNum;					// ĳ (ġ)
	BYTE           gameIn;					// ӻ(0Ӿȵ/1)
	BYTE           status;					// ϻ(0ϿϷ/1Ͻû)
	BYTE           block;					// ܻ(0ܾ/1)
};

struct TB_STALL_SELL
{
	long idx;								// ȣ
	long characterIdx;						// ĳ ȣ
	long price;								// Ǹ 
};

struct TB_SHORTCUT
{
	char binary[500];						// (500BYTE)
};

struct TB_CHARACTER_SKILL
{
	unsigned long	mSkillIdx;				// ų ε
	unsigned char	mSkillStep;				// ų ܰ
	long			mEndCoolTime;			// Ÿ  ð
};

struct TB_RECIPE_COOLTIME
{
	unsigned long	mMakeSkill;				// սų
	unsigned long	mRecipeIdx;				// 
	unsigned long	mLeftCoolTime;			// Ÿ
};

struct TB_GUILDMARK
{
	BYTE binary[2348];						// (2348BYTE) - 24 * 24 * (32/8) + 18 + 26
};

// ȿ
typedef sInfluence TB_CHARACTER_INFLUENCE;


/// Ʈ 
struct TB_QUEST_PROGRESS
{
	long    idx;						// [In]  db ε
	long    questIdx;					// [In]  Ʈ ȣ
	__int64 check;						// [In]  
	long	startTime;					// ð ˻ 
	long	restTime;					// [Out] ð
	char	status;						// [Out] Ʈ (0:, 2:Ϸ, 4:)
	long    retvalue;					// [Out] 
};

/// ȣĪ 
struct TB_TITLE
{
	long	idx;						// [In] db ε
	long	titleIdx;					// [In] ȣĪ ε
};

///  
struct TB_GUILD
{			
	long	idx;						// [Out]  ȣ(ε)
	wchar_t name[13];					// [Out] 
	long	masterIndex;				// [Out]  ε
	wchar_t masterName[17];				// [Out] 
	wchar_t notice[41];					// [Out]  
	long	markIdx;					// [Out] ũ ε
	BYTE	mark[2348];					// [Out] ũ - 24 * 24 * (32/8) + 18 + 26 (ũ + Ȯ)
	char	apply;						// [Out]  
};

///   
struct TB_GUILD_USER
{			
	long	characterIdx;				// [Out] ĳ ε
	wchar_t name[17];					// [Out] ĳ͸
	char	level;						// [Out] 
	long    job;						// [Out] ĳ 
	short	mapnum;						// [Out]  ȣ
	char	position;					// [Out] 
	DWORD	channelNum;					//  ä ȣ
	bool	sendInfo;					//  ÷
};

/// ų
struct TB_MAKESKILL
{			
	unsigned long	mMakeSkill;			// [Out] ų
	unsigned long	mRecipeIdx;			// [Out] idx
	unsigned long	mCoolTime;			// [Out] Ÿ
};

#pragma pack( ) // 1Byte  

#endif // __GAME_SERVER_DEFINES_H__
