/* ==========================================================================
*      : AIManager.h
*      : ai
*    : ڰ
*    : 2007-11-13
* ǻ : 
*===========================================================================*/

#pragma once

#include "BaseObject_Common.h"
#include "Monster_Common.h"
#include "Gathering_Common.h"
#include "IndexGenerator.h"

const int AI_REGEN_PROCESS_DELAY = 100;

class cNaviField;
class cPathFinder;
class cMonster;
class cGathering;

struct sRegenGroupScript;

enum eACTION_ID;
enum eACTION_CHANGE;
enum ePathfindresult;
enum eACTION_GAT_ID;
enum eACTION_GAT_CHANGE;

struct sRegenMonster
{
	unsigned long		mObjectIdx;
	unsigned long		mRegenIdx;
	unsigned long		mRegenTime;
	bool				mDie;
};

struct sRegenGroup
{
	/// ũƮ  
	sRegenGroupScript*	mpRegenGroup;

	unsigned long		mGroupIdx;
	///  ۼ     īƮ ϶ ÷
	bool				mIsRegen;		
	///   ð
	unsigned long		mRegenTime;		
	/// ׷쿡 شϴ   ִ 
	unsigned long		mMonsterAliveCnt;	

	tArray<void*>		mMonsterList;
};

struct sSwichGroup
{
	unsigned long		mSwitchGroup;
	///  õ ׷ε
	unsigned long		mGroupIdx;
	///   ð
	unsigned long		mRegenTime;
	///   
	bool				mRegenStop;

	tArray<unsigned long>*	mpGroupIdxAry;
};

struct sRegenGatherGroup
{
	/// ũƮ  
	const sGatheringRegenHeader*	mpGetheringRegenHeader;

	unsigned long		mGroupIdx;
	///   ð
	unsigned long		mRegenTime;		
	///  غ 
	bool				mRegenReady;
};


class cAIManager
{
public:

	static cAIManager*	mpAIManager;

public:

	/// Ҹ
	cAIManager();
	~cAIManager();

	/// ڿ
	bool				Init( int serverType );
	void				Release();
	void				Process( unsigned long elapsedTime, unsigned long accumTime );

	//////////////////////////////////////////////////////////////////////////
	/// 
	
	///   μ
	void				MonRegenProcess( unsigned long elapsedTime, unsigned long accumTime );

	void				BossSummonMonRegen( cMonster* pBoss, unsigned short mapNumber, float x , float y, unsigned long genRange, unsigned long genCnt, unsigned long monsterClassIdx );
	void				CheatSummonMonRegen( unsigned short mapNumber, float x , float y, unsigned long monsterClassIdx, unsigned long genCnt );
	unsigned long		QuestSummonMonRegen( unsigned short mapNumber, float x , float y, unsigned long monsterClassIdx, unsigned long destroyTime );

	/// ׾   Ѿ  
	void				InsertReadyMonster( unsigned long monsterIdx, unsigned long regenIdx, unsigned long groupIdx );

	void				SwitchRegenStart( unsigned long switchGroupIdx );
	void				SwitchRegenStop( unsigned long switchGroupIdx );

	//////////////////////////////////////////////////////////////////////////
	/// ä

	/// ä  μ
	void				GatRegenProcess( unsigned long elapsedTime, unsigned long accumTime );

	/// ׾   Ѿ ä 
	void				InsertReadyGathering( unsigned long objectIdx, unsigned long regenIdx );


	//////////////////////////////////////////////////////////////////////////
	/// ã

	///  
	float				GetPathMaxSideSize( unsigned int mapNum );
	///  ġ ̰
	bool				CalcHeight( unsigned short mapNumber, float* height, float x, float y ) const;
	/// ̵  üũ
	bool				IsPassible( unsigned short mapNumber, float x, float y, sObject object ) const;
	bool				IsPassible( unsigned short mapNumber, NiPoint2 start, NiPoint2 goal, sObject object ) const;

	/// ̵  ټ 
	unsigned long		CalcPathCnt( unsigned short mapNumber, NiPoint2 start, NiPoint2 goal );

private:
	void				RegenMonster( unsigned long groupIdx, sRegenMonster* pRM );

private:

	typedef tPointerHashMap<unsigned long, void*> cPointHashMap;
	typedef tArray<unsigned long> cArray;
	typedef tArray<void*> cVoidAry;

	/// ׷  ؾ ϴ   ü 
	/// typedef tPointerHashMap<unsigned long, sRegenGroup*> cPointerHashMap;
	cPointHashMap*		mpRegenGroupMap;

	cPointHashMap*		mpRegenSwitchMap;

	/// typedef tPointerHashMap<unsigned long, sRegenGatherGroup*> cPointerHashMap;
    cPointHashMap*		mpRegenGatherGroupMap;	

	/// ε 
	cIndexGenerator		mMonsterIdxGen;
	cIndexGenerator		mGatheringIdxGen;

	///  ٷ 
	bool				mServerOnRegen;

	///  μ  
	unsigned long		mNextCheckTime;

	/// ä
	cArray				mReadyGatheringAry;

	/// Ϲä / δ 
	int					mServerType;

	//////////////////////////////////////////////////////////////////////////
	/// ã
	cNaviField*			mNaviField[MAP_COUNT];		/// ׺ʵ
	cPathFinder*		mPathFinder[MAP_COUNT];		/// ã
	float				mMapSize[MAP_COUNT];
	
	/// 081106 PKH δ
	cNaviField*			mInstDgNaviField;
	cPathFinder*		mInstDgPathFinder;
	float				mInstDgMapSize;

	NiPoint2			mTempPathAry[MAX_PATH_COUNT];
};

#define AIMANAGER	cAIManager::mpAIManager
