#include "StdAfx.h"
#include "actionattack.h"

#include "../Common/Protocol.h"

#include "Monster.h"
#include "SkillManager.h"
#include "Player.h"
#include "gamesrv.h"
#include "SkillScript.h"



cActionAttack::cActionAttack(void) : cAction( eACT_ATTACK )
{
	mAttackEndTime = 0;
}



cActionAttack::~cActionAttack(void)
{
}



void cActionAttack::ActionInit( cMonster* pMonster, unsigned long accumTime )
{
	cAction::ActionInit( pMonster, accumTime );

	const sMonsterScript* pMonsterScript = pMonster->GetMonsterInfo();
	if( pMonsterScript == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("cActionAttack::ActionInit pMonsterScript == NULL");
		return;
	}

	///  õ     Ѵ
	cPlayer* pPlayer = (cPlayer*)pMonster->GetTarget();
	if( pPlayer == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("cActionAttack::ActionInit pPlayer == NULL");
		return;
	}

	if( pMonster->IsCantSkill() == true )
		return;

	/// ų  ð üũ
	if( pMonster->IsSkillWaitEnd() == false )
		return;

	///  ų ϸ 彺ų 
	eMONSTERATTACK_TYPE	attackType = pMonster->GetModeSkill();
	if( attackType == eMONSTERATTACK_MAX )
		attackType = pMonster->GetAttackType();

	sObject target = { pPlayer->GetObjectType(), pPlayer->GetObjectID() };
	if( SKILLMANAGER->MonsterAttack( pMonster->GetObjectID(), attackType, target ) == true )
	{
		///  ̸  ð 缳
		pMonster->SetFollowEndTime( accumTime + pMonsterScript->mFollowTime );

		/// ųindex üũ
		sMonsterSkillScript* pSkillInfo = SKILLSCRIPT->GetMonsterSkillInfo( pMonster->GetRaceGender(), pMonster->GetAttackType() );
		if( pSkillInfo == NULL )	
		{ 
			assert(NULL); 
			NETWORK2->PostServerEvent("MonsterAttack - GetMonsterSkillInfo[%d,%d]", pMonster->GetRaceGender(), pMonster->GetAttackType() );
			return; 
		}

		if( pMonster->GetAttackType() == eMONSTERATTACK_NORMAL1 ||
			pMonster->GetAttackType() == eMONSTERATTACK_NORMAL2 )
		{
            mAttackEndTime = accumTime + (unsigned long)( pSkillInfo->mAttackSpd * ( 2.0f - pMonster->GetAttackSpeed() ) );
		}
		else
			mAttackEndTime = accumTime + pSkillInfo->mAttackSpd;

		pMonster->CalcSkillWaitTime( mAttackEndTime );
	}
}



eACTION_CHANGE cActionAttack::Action( cMonster* pMonster, unsigned long /*deltaTime*/, unsigned long accumTime )
{
	const sMonsterScript* pMonsterScript = pMonster->GetMonsterInfo();
	if( pMonsterScript == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("cActionAttack::Action pMonsterScript == NULL");
		return eACTCH_ERROR;
	}

	/// ų    
	if( mAttackEndTime > accumTime )
		return eACTCH_CONTINUE;
	if( SKILLMANAGER->IsUsingSkill( eOBJECTTYPE_MONSTER, pMonster->GetObjectID() ) )
		return eACTCH_CONTINUE;

	/// ÷̾ ų ÷̾ ִ 
	cPlayer* pPlayer = (cPlayer*)pMonster->GetTarget();
	if( pPlayer == NULL ) 
	{
		/// 081205 PKH Ÿ 
		pMonster->ChangeActionTarget();
		return eACTCH_CONTINUE;
	}

	/// ų  ð üũ
	if( pMonster->IsSkillWaitEnd() == false )
	{
		float range; // = pMonster->CalcStatusSkillRange( pSkillInfo->mTargetDist, pSkillInfo->mRangeType );

		//range = OBJECTMANAGER->ObjectSizeRange( pMonster, pPlayer, range );
		range = OBJECTMANAGER->ObjectSizeRange( pMonster, pPlayer, 0 );
		
		cRangeCheck skillRangeCheck( range );

		NiPoint3 attackerPos( pMonster->GetXPos(), pMonster->GetYPos(), pMonster->Height() );
		NiPoint3 targetPos( pPlayer->GetXPos(), pPlayer->GetYPos(), pPlayer->Height() );

		/// ų Ÿ ۿ Ÿ ִ.
		if( skillRangeCheck.IsNotRange( attackerPos, targetPos ) == true )	
			return eATTCH_ATTACK_FOLLOW;
		else
			return eACTCH_CONTINUE; 
	}

	/// ų  Ұ 
	eMONSTERATTACK_TYPE attackType = pMonster->SelectSkill();
	if( attackType == eMONSTERATTACK_MAX )
		return eATTCH_ATTACK_FOLLOW;
	
	/// ųindex üũ
	sMonsterSkillScript* pSkillInfo = SKILLSCRIPT->GetMonsterSkillInfo( pMonster->GetRaceGender(), attackType );
	if( pSkillInfo == NULL )	
	{ 
		NETWORK2->PostServerEvent("MonsterAttack - GetMonsterSkillInfo[%d,%d]", pMonster->GetRaceGender(), attackType );
		return eACTCH_CONTINUE; 
	}

	sObject target = { pPlayer->GetObjectType(), pPlayer->GetObjectID() };
	if( SKILLMANAGER->MonsterAttack( pMonster->GetObjectID(), attackType, target ) == false )
		return eATTCH_ATTACK_FOLLOW;	/// ų  Ұ ̹Ƿ 

	if( pMonster->GetAttackType() == eMONSTERATTACK_NORMAL1 ||
		pMonster->GetAttackType() == eMONSTERATTACK_NORMAL2 )
	{
		mAttackEndTime = accumTime + (unsigned long)( pSkillInfo->mAttackSpd * ( 2.0f - pMonster->GetAttackSpeed() ) );
	}
	else
		mAttackEndTime = accumTime + pSkillInfo->mAttackSpd;

	pMonster->CalcSkillWaitTime( mAttackEndTime );
	///  ̸  ð 缳
	pMonster->SetFollowEndTime( accumTime + pMonsterScript->mFollowTime );

	///  μ  
	return eACTCH_CONTINUE;
}
