#include "StdAfx.h"
#include "actiondie.h"
#include "GameSrv.h"

#include "../Common/Protocol.h"

#include "GridManager.h"

#include "Monster.h"
#include "SkillManager.h"
#include "Player.h"
#include "ObjectManager.h"
#include "Drop.h"
#include "AIManager.h"
#include "QuestManager.h"

cActionDie::cActionDie(void) : cAction( eACT_DIE )
{
}



cActionDie::~cActionDie(void)
{
}



void cActionDie::ActionInit( cMonster* pMonster, unsigned long accumTime )
{
	cAction::ActionInit( pMonster, accumTime );
	/// ⼭ ͸ ϰԵǸ damage ޼ ߼ϱ Ǽ ߼ Ѵ.

	mDieEndTime = accumTime + 5000;
	mFirstRun = true;
}



eACTION_CHANGE cActionDie::Action( cMonster* pMonster, unsigned long /*deltaTime*/, unsigned long accumTime )
{
	if( mFirstRun == true )
	{
		mFirstRun = false;
		
		if( pMonster->IsOutsideDestroy() == true )
			Destroy( pMonster );
		else
			Die( pMonster );	
	}

	if( mDieEndTime < accumTime )
	{
		/// objectmanager   Ͽ 
		OBJECTMANAGER->InsertDeleteMonster( pMonster->GetObjectID() );

		///   μ  - 
		return eACTCH_DIE_END;
	}

	return eACTCH_CONTINUE;

}


void cActionDie::Die( cMonster* pMonster )
{
	if( pMonster->GetfirstAttack() == 0 )
	{
		NETWORK2->PostServerEvent("cActionDie::Action GetfirstAttack() == 0");
	}

	if( pMonster->IsCriDie() == true )
		pMonster->SendSpeech( eMONSTERTALK_DIE2 );
	else
		pMonster->SendSpeech( eMONSTERTALK_DIE1 );			

	unsigned long partyIdx = 0;
	cPlayer* player = pMonster->NearGridFindPlayer( pMonster->GetfirstAttack() );
	if( player )
	{
		partyIdx = player->GetPartyIndex();
		if( partyIdx > 0 )
		{
			/// Ƽ ü 
			PARTYMAN->SendToPartyHunt( pMonster, player, pMonster->GetRaceGender() );
		}
		else
		{
			/// ڱڽŸ 
			player->UpdateDutyHunt( pMonster->GetRaceGender() );
		}
	}

	///   
	unsigned long dropPlayerIdx = pMonster->GetfirstAttack();
	///   HP 20%   
	unsigned long damage = pMonster->GetTakeDamage( dropPlayerIdx );
	if( (float)damage < pMonster->GetMaxHP() * 0.2f )
	{
		///   20% ϸ   ū 
		TakeDamageRoot* pTakeDamageRoot = pMonster->GetTakeDamageRoot();
		if( pTakeDamageRoot != NULL )
		{
			PerTakeDamage* per = (PerTakeDamage*)pTakeDamageRoot->pool;
			while( per )
			{
				if( damage < per->takeDamage )
				{
					damage = per->takeDamage;
					dropPlayerIdx = per->playerIdx;
				}

				per = (PerTakeDamage*)per->next;
			}
		}
		else
			NETWORK2->PostServerEvent("cActionDie::Die pTakeDamageMap == NULL");
       
	}

	///  ý - 
	DROP->MonsterDrop( pMonster->GetObjectID(), dropPlayerIdx, partyIdx );
	DROP->MonsterQuestDrop( pMonster->GetObjectID(), dropPlayerIdx, partyIdx );

	return Destroy( pMonster );
}


void cActionDie::Destroy( cMonster* pMonster )
{
	pMonster->Release();

	/// ׸ ýۿ  
	GRIDMANAGER->RemoveMonster( pMonster );

	if( pMonster->IsCheatTempMonster() == false )
	{
		///    Ͽ 
		AIMANAGER->InsertReadyMonster( pMonster->GetObjectID(), pMonster->GetRegenMonsterInfo()->mRegenIdx,
			pMonster->GetRegenMonsterInfo()->mGroupNumber );
	}
}