#include "StdAfx.h"
#include "actionescape.h"
#include "GameSrv.h"

#include "Monster.h"
#include "SkillManager.h"
#include "Player.h"
#include "ObjectManager.h"
#include "AIManager.h"



cActionEscape::cActionEscape(void) : cAction( eACT_ESCAPE )
{
}



cActionEscape::~cActionEscape(void)
{
}



void cActionEscape::ActionInit( cMonster* pMonster, unsigned long accumTime )
{
	cAction::ActionInit( pMonster, accumTime );

	///   ð 
	mEscapeStartTime = accumTime;

	/// ߰ ڽ  
	mCourseChange = rand() % 2 == 0 ? true : false;

	/// ͸  ӵ 
	pMonster->SetMoveSpeed( pMonster->GetMonsterInfo()->mActionRunSpd, eMOVESPEED_RUN );

	/// ̵ ִ/ּ Ÿ 
	unsigned long escapeMaxRange = ESCAPE_MAXIMUM_TIME / SECOND_THOUSAND * pMonster->GetMoveSpeed();
	unsigned long escapeMinRange = ESCAPE_MINIMUM_TIME / SECOND_THOUSAND * pMonster->GetMoveSpeed();

	/// ̵ ǥ 
	mIsSetPath = EscapeTargetPos( pMonster, escapeMinRange, escapeMaxRange, pMonster->GetXPos(), pMonster->GetYPos() );

	pMonster->SendSpeech( eMONSTERTALK_ESCAPE );
}



eACTION_CHANGE cActionEscape::Action( cMonster* pMonster, unsigned long deltaTime, unsigned long accumTime )
{

	const sMonsterScript* pMonsterScript = pMonster->GetMonsterInfo();
	if( pMonsterScript == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("cActionEscape::Action pMonsterScript == NULL");
		return eACTCH_ERROR;
	}

	///     ð
	unsigned long elapseTime = 0;
	if( accumTime > mEscapeStartTime )
		elapseTime = accumTime - mEscapeStartTime;

	///   ð   
	if( ESCAPE_MAXIMUM_TIME < elapseTime )
	{
		/// 081205 PKH Ÿ 
		if( pMonster->GetTarget() == 0 )
			pMonster->ChangeActionTarget();
		else
			pMonster->ActionChange( eACT_FOLLOW );

		return eACTCH_CONTINUE;
	}

	/// ߰ ڽ 
	if( mCourseChange == true )
	{
		if( ESCAPE_CHANGE_TIME < elapseTime )
		{
			mCourseChange = false;

			/// ̵ 
			long escapeMaxRange = 0;
			if( ESCAPE_MAXIMUM_TIME > elapseTime )
				escapeMaxRange = ESCAPE_MAXIMUM_TIME - elapseTime;

			if( pMonster->GetMoveSpeed() != 0 )
				escapeMaxRange = escapeMaxRange / SECOND_THOUSAND * pMonster->GetMoveSpeed();

			if( escapeMaxRange > 0 )
				EscapeTargetPos( pMonster, 0, escapeMaxRange, pMonster->GetXPos(), pMonster->GetYPos() );
		}
	}

	///   ȵִ 
	if( mIsSetPath == false )
	{
		/// ̵ 
		long escapeMaxRange = 0;
		if( ESCAPE_MAXIMUM_TIME > elapseTime )
			escapeMaxRange = ESCAPE_MAXIMUM_TIME - elapseTime;

		long escapeMinRange = 0;
		if( ESCAPE_MINIMUM_TIME > elapseTime )
			escapeMinRange = ESCAPE_MINIMUM_TIME - elapseTime;

		if( pMonster->GetMoveSpeed() != 0 )
		{
			escapeMaxRange = escapeMaxRange / SECOND_THOUSAND * pMonster->GetMoveSpeed();
			escapeMinRange = escapeMinRange / SECOND_THOUSAND * pMonster->GetMoveSpeed();
		}

		if( escapeMaxRange > 0 )
		{
			if( EscapeTargetPos( pMonster, escapeMinRange, escapeMaxRange, pMonster->GetXPos(), pMonster->GetYPos() )  == true )
				mIsSetPath = true;
		}
	}

	///  ̵
	if( pMonster->MoveUpdate( deltaTime ) == false )
	{
		cBaseObject* pTarget = pMonster->GetTarget();
		if( pTarget == NULL )
		{
			return eACTCH_CONTINUE;
		}

		///  ð 缳 - ð + ð + ½ð
		pMonster->SetFollowEndTime( accumTime + pMonsterScript->mFollowTime + ( accumTime - mEscapeStartTime ) );

		NiPoint2 targetPos = pTarget->GetPos();
		/// ٽ Ѿư Ÿ   ΰ ̵
		if( AIMANAGER->IsPassible( pTarget->GetMapNumber(), targetPos.x, targetPos.y, pTarget->GetObject() ) == false )
		{
			pMonster->ChangeActionTarget();
			return eACTCH_ESCAPE_END;
		}
	}

	return eACTCH_CONTINUE;
}


bool cActionEscape::EscapeTargetPos( cMonster* pMonster, unsigned long escapeMinRange, unsigned long escapeMaxRange, float centerX, float centerY  )
{

	/// ȿ Ÿ
	long validityRange = escapeMaxRange - escapeMinRange;
	if( validityRange < 0 )
		validityRange = 0;

	/// ȿ  
	float escapePosX = centerX - validityRange + ( rand() % ( validityRange * 2 ) );
	float escapePosY = centerY - validityRange + ( rand() % ( validityRange * 2 ) );

	///   ּ  ŭ 
	if( escapePosX > centerX )
		escapePosX += escapeMinRange;
	else if( escapePosX < centerX )
		escapePosX -= escapeMinRange;
	if( escapePosY > centerY )
		escapePosY += escapeMinRange;
	else if( escapePosY < centerY )
		escapePosY -= escapeMinRange;

	///   ̸ ٽ 
	if( AIMANAGER->IsPassible( pMonster->GetMapNumber(), escapePosX, escapePosY, pMonster->GetObject() ) == false )
		return false;

	return pMonster->SetPath( escapePosX, escapePosY ) != 0;
}
