#include "StdAfx.h"
#include "GameSrv.h"
#include "actionfollow.h"

#include "Monster.h"
#include "Player.h"
#include "SkillManager.h"
#include "AIManager.h"



cActionFollow::cActionFollow(void) : cAction( eACT_FOLLOW )
{
	mRePathTime = 0;
}



cActionFollow::~cActionFollow(void)
{
}



void cActionFollow::ActionInit( cMonster* pMonster, unsigned long accumTime )
{
	cAction::ActionInit( pMonster, accumTime );

	/// Ÿ ˻
	cBaseObject* pTarget = pMonster->GetTarget();
	if( pTarget == NULL || pTarget->GetStateDie() == true )
		return;

	mFollowTargetPos.x = pTarget->GetXPos();
	mFollowTargetPos.y = pTarget->GetYPos();

	mFirstFollowMove = true;

	mDelayTime = accumTime;

	mCantFollowPos = 0;

	mIsTalk = true;

	mNextSelectSkill = 0;
}



eACTION_CHANGE cActionFollow::Action( cMonster* pMonster, unsigned long deltaTime, unsigned long accumTime )
{

	const sMonsterScript* pMonsterScript = pMonster->GetMonsterInfo();
	if( pMonsterScript == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("cActionFollow::Action pMonsterScript == NULL");
		return eACTCH_ERROR;
	}

	/// Ÿٿ  ų ߵ
	cPlayer* pPlayer = (cPlayer*)pMonster->GetTarget();
	if( pPlayer == NULL )
	{
		/// 081205 PKH Ÿ 
		pMonster->ChangeActionTarget();
		return eACTCH_CONTINUE;
	}

	/// ų 缱 üũ
	float skillrange = pMonsterScript->mSkillMinRange;
	if( pMonster->GetAttackType() == eMONSTERATTACK_MAX || mNextSelectSkill < accumTime )
	{
		/// ų  ð üũ
		if( pMonster->IsSkillWaitEnd() == true )
		{
			eMONSTERATTACK_TYPE attackType = pMonster->SelectSkill();
			if( attackType != eMONSTERATTACK_MAX )
			{
				///  
				mNextSelectSkill = accumTime + 100;

				sMonsterSkillScript* pMonsterSkillScript = SKILLSCRIPT->GetMonsterSkillInfo( pMonster->GetRaceGender(), attackType );
				if( pMonsterSkillScript != NULL )	/// ų ߵ Ÿ
					skillrange = pMonster->CalcStatusSkillRange( pMonsterSkillScript->mTargetDist, pMonsterSkillScript->mRangeType );
			}
		}
	}

	///  ǥ, Ÿ Ʈ  ǥ
	NiPoint3 monsterPos3( pMonster->GetXPos(), pMonster->GetYPos(), pMonster->Height() );
	NiPoint3 playerPos3( pPlayer->GetXPos(), pPlayer->GetYPos(), pPlayer->Height() );

	/// ݰŸ ȿ °
	float tempRange = OBJECTMANAGER->ObjectSizeRange( pMonster, pPlayer, skillrange );
	mRangechk.SetRadius( tempRange );
	if( mRangechk.IsRange( monsterPos3, playerPos3 ) )
		return eACTCH_FOLLOW_ATTACK;

	///  
	mRangechk.SetRadius( (float)pMonsterScript->mFollowRange );

	if( mRangechk.IsNotRange( pMonster->GetPos(), pMonster->GetFollowStartPos() ) &&	///   ġ Ÿ  
		pMonster->GetFollowEndTime() <= accumTime )										/// (/)ð 
	{		
		/// 081205 PKH Ÿ 
		pMonster->ChangeActionTarget();
		return eACTCH_CONTINUE;
	}

	/// ÷̾   ġ û -  ڸ    ̵
	pMonster->SetPlayerFollowPos( pPlayer->SelectFollowPos( pMonster->GetPlayerFollowPos() ) );

	///  ġ  nipoint2 -> nipoint3
	NiPoint2 tempfollowPos = OBJECTMANAGER->CalcFollowPos( pMonster->GetPlayerFollowPos(), pPlayer->GetPos() );
	NiPoint3 followPos3( tempfollowPos.x, tempfollowPos.y, 0.0f );
	AIMANAGER->CalcHeight( pPlayer->GetMapNumber(), &followPos3.z, followPos3.x, followPos3.y );

	///  ߺġ   ġ 
	bool playerRealPos = false;

	///   ġ ̵   üũ
	if( AIMANAGER->IsPassible( pPlayer->GetMapNumber(), followPos3.x, followPos3.y, pPlayer->GetObject() ) == true )
	{
		///   ġ   Ѱ  ġ 
		mRangechk.SetRadius( FOLLOW_POS_DIAGONAL );
		if( mRangechk.IsRange( pMonster->GetPos(), tempfollowPos ) == true )
		{
			playerRealPos = true;
			followPos3 = playerPos3;
		}

	}
	else	///  ġ  ̹Ƿ  ġ .
		playerRealPos = true;

	///  ġ ̵ ؾ ϴµ
	if( playerRealPos == true )
	{
		///   ΰ
		if( AIMANAGER->IsPassible( pPlayer->GetMapNumber(), playerPos3.x, playerPos3.y, pPlayer->GetObject() ) == false )
		{
			/// īƮ 
			++mCantFollowPos;

			///  ǥ 
			NiPoint2 randPos( playerPos3.x, playerPos3.y );

			float fixedSkillRange = pMonsterScript->mSkillMinRange;

			switch( mCantFollowPos )
			{
			case 1:	randPos.x -= fixedSkillRange / 2; break;	///  Ÿ  2 .
			case 2:	randPos.x += fixedSkillRange / 2; break;
			case 3:	randPos.y -= fixedSkillRange / 2; break;
			case 4:	randPos.y += fixedSkillRange / 2; break;
			case 5:	randPos.x -= fixedSkillRange / 3; randPos.y += fixedSkillRange / 3; break;	/// ̿ 밢 Ÿ  3 .
			case 6:	randPos.x += fixedSkillRange / 3; randPos.y += fixedSkillRange / 3; break;
			case 7:	randPos.x -= fixedSkillRange / 3; randPos.y -= fixedSkillRange / 3; break;
			case 8:	randPos.x += fixedSkillRange / 3; randPos.y -= fixedSkillRange / 3; break;
			}

			///   ΰ
			if( AIMANAGER->IsPassible( pPlayer->GetMapNumber(), randPos.x, randPos.y, pPlayer->GetObject() ) == false )
			{
				///   8 ǥ   ϰ 
				if( mCantFollowPos >= 8 )
				{
					NETWORK2->PostServerEvent("ActionFollow MoveIsNotPassable - playerIdx[%d], map[%d], x[%f], y[%f]",
						pPlayer->GetObjectID(), pPlayer->GetMapNumber(), playerPos3.x, playerPos3.y );
			
					//return eACTCH_ESCAPE;
					pMonster->ChangeActionTarget();
				}

				return eACTCH_CONTINUE;
			}
			else
			{
				followPos3.x = randPos.x;
				followPos3.y = randPos.y;
				mCantFollowPos = 0;
				skillrange = 0.0f;
			}
		}
	}


	///  ġ Ÿ Ÿ 
	float range = ( pMonster->GetPos() - pPlayer->GetPos() ).Length() * 0.1f;

	/// range  100  .
	if( range < 100 ) 
		range = 100; 

	///  Ÿ   ġ  ġ Ÿ 
	float objectLength = ( mFollowTargetPos - pPlayer->GetPos() ).Length();

	/// object ġ ġ range ū ġ objectġ  - 尻
	if( objectLength > range )
	{
		/// 0.5ʸ ˻ - ϸ ̱ 
		if( mDelayTime > accumTime )
		{
			sObject target;
			target.index = pPlayer->GetObjectID();
			target.type = pPlayer->GetObjectType();

			///   ӵ
			pMonster->SetMoveSpeed( pMonster->GetMonsterInfo()->mActionRunSpd, eMOVESPEED_RUN );

			/// ã  
			pMonster->SetPath( followPos3.x, followPos3.y, skillrange - 10 , pPlayer->GetObject() );

			/// ų   üũ
			if( pMonster->IsSkillWaitEnd() == true && mIsTalk == true )
			{
				mIsTalk = false;
				pMonster->SendSpeech( eMONSTERTALK_FOLLOW );
			}

			/// ÷̾ ̵   ã 缳  ÷̾ ġ 
			mFollowTargetPos.x = playerPos3.x;
			mFollowTargetPos.y = playerPos3.y;
		}
		else
			mDelayTime = mDelayTime + 500;

	}

	///  ̵ - ̵ falseΰ  ٽ 
	if( pMonster->MoveUpdate( deltaTime ) == false || mFirstFollowMove == true )
	{
		mFirstFollowMove = false;
		sObject target;
		target.index = pPlayer->GetObjectID();
		target.type = pPlayer->GetObjectType();

		///   ӵ
		pMonster->SetMoveSpeed( pMonster->GetMonsterInfo()->mActionRunSpd, eMOVESPEED_RUN );

		if(	mRePathTime < accumTime )
		{
			mRePathTime = accumTime + 300;
			/// ų  ̸ ٽ ̵ 
			pMonster->SetPath( followPos3.x, followPos3.y, skillrange - 10 , pPlayer->GetObject() );
		}

		/// ų   üũ
		if( pMonster->IsSkillWaitEnd() == true && mIsTalk == true )
		{
			mIsTalk = false;
			pMonster->SendSpeech( eMONSTERTALK_FOLLOW );
		}

		/// ÷̾ ̵   ã 缳  ÷̾ ġ 
		mFollowTargetPos.x = playerPos3.x;
		mFollowTargetPos.y = playerPos3.y;
	}

	/// ٸ ̺Ʈ ɸ   
	return eACTCH_CONTINUE;
}
