#include "stdafx.h"
#include "actionmove.h"
#include "gamesrv.h"

#include "../Common/Protocol.h"
#include "Monster_Common.h"

#include "MonsterScript.h"

#include "Monster.h"
#include "Player.h"
#include "AIManager.h"
#include "GridManager.h"
#include "ObjectManager.h"


cActionMove::cActionMove(void): cAction( eACT_MOVE )
{
}



cActionMove::~cActionMove(void)
{
}



void cActionMove::ActionInit( cMonster* pMonster, unsigned long accumTime )
{

	cAction::ActionInit( pMonster, accumTime );

	if( pMonster->IsFirstMove() == true )
	{
		///    ð  ϴ ð
		mRegenCantMoveEndTime = accumTime + FIRSTMOVE_WAIT_TIME;

		/// ̵  &   ð ߺ ǹǷ ū  ǰ 
		if( accumTime + MOVE_WAIT_TIME > accumTime + FIRSTMOVE_WAIT_TIME )
			mWaitEndTime = accumTime + MOVE_WAIT_TIME;
		else
			mWaitEndTime = accumTime + FIRSTMOVE_WAIT_TIME;

		/// ó̵ ÷   - ̵,  ð 
		pMonster->FirstMoveEnd();
	}
	else
		mWaitEndTime = accumTime + MOVE_WAIT_TIME;

	mDelayTime = accumTime;
	mDelayTime2 = accumTime;

	mSetPathErrCnd = 0;

	mIsIdle2Send = false;
	mIdle2SendTime = 0;

	mFirstMoveEndCheck = true;
}



eACTION_CHANGE cActionMove::Action( cMonster* pMonster, unsigned long deltaTime, unsigned long accumTime )
{
	const sMonsterScript* pMonsterScript = pMonster->GetMonsterInfo();
	if( pMonsterScript == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("cActionRegen::Action pRegenGroupScript == NULL");
		return eACTCH_ERROR;
	}

	/// Ͱ ΰ Ÿ ˻
	if( pMonsterScript->mIsPrecedeAttack == true && pMonster->GetFollowEndMove() == false )
	{
		/// 0.5Ŀ ˻ - Ϲ
		if( mDelayTime <= accumTime )
		{
			mDelayTime = accumTime + 500;

			///   ð   
			if( mRegenCantMoveEndTime < accumTime )
			{
				/// ȿ  ÷̾ 
				cPlayer* pPlayer = TargetSelect( pMonster, pMonsterScript->mSeekRange );
				if( pPlayer != NULL )
				{
					pMonster->AddTakeDamage( pPlayer->GetObject(), 0, 0, eTAKEDAMAGETYPE_ADDPLAYER );
					return eACTCH_MOVE_END;

				}
			}
		}
	}

	///  ̵
	if( pMonster->MoveUpdate( deltaTime ) == true )
	{
		mFirstMoveEndCheck = false;

		///  ̵ ð 3 
		mWaitEndTime = accumTime + MOVE_WAIT_TIME;
		return eACTCH_CONTINUE;
	}

	/// ̵ ڸ ѹ üũ
	if( mFirstMoveEndCheck == false )	
	{
		mFirstMoveEndCheck = true;
		pMonster->SendSpeech( eMONSTERTALK_MAX );
	}

	/// ̵  ̵ ȸʹ Ϸ
	pMonster->SetFollowEndMove( false );


	/// ⵿2 ߼ üũ
	if( mIsIdle2Send == true && accumTime < mIdle2SendTime )
	{
		/// ޼ ߼
		MSG_SYN_MONSTER_IDLE2ANI synMsg;
		synMsg.Category = NM_MONSTER;
		synMsg.Protocol = NM_MONSTER_IDLE2_ANI_SYN;
		synMsg.mMonsterIdx = pMonster->GetObjectID();
		NETWORK2->QuickSend( (cBaseObject*)pMonster, (char*)&synMsg, sizeof(MSG_SYN_MONSTER_IDLE2ANI) );

		mIdle2SendTime = false;
		mIdle2SendTime = 0;
	}


	/// ð 
	if( mWaitEndTime > accumTime )
	{
		return eACTCH_CONTINUE;
	}


	///    Ѱ ٸ ̵  ϰ  ̵ 
	if( mSetPathErrCnd == 0 )
	{
		/// ̵  ̵  
		unsigned long moveSpeed = 0;
		eMOVE_SPEED_TYPE moveSpeedType = RandMoveSpeed( pMonster, &moveSpeed );
		/// ൿ  
		if( moveSpeed == 0 )
		{
			/// ð ߰
			mWaitEndTime = accumTime + pMonsterScript->mActionStopTime;

			/// ð  ð ⵿2 ޼ ߼ 
			mIsIdle2Send = (rand() % 100) + 1 <= IDLE2_ANI_SEND_PER;
			if( mIsIdle2Send == true )
				mIdle2SendTime = accumTime + ( pMonsterScript->mActionStopTime / 3 );

			pMonster->SendSpeech( eMONSTERTALK_STAND );

			return eACTCH_CONTINUE;
		}

		///  ̵ ӵ 
		pMonster->SetMoveSpeed( moveSpeed, moveSpeedType );

		if( moveSpeedType == eMOVESPEED_WALK )
			pMonster->SendSpeech( eMONSTERTALK_WORK );
		else if( moveSpeedType == eMOVESPEED_RUN )
			pMonster->SendSpeech( eMONSTERTALK_RUN );
	}

	/// ȿ  ǥ  ġ 
	unsigned long freeRange = pMonsterScript->mFreeMoveRange;
	float targetPosX = pMonster->GetRegenPos().x + ( rand() % (int)freeRange ) - ( rand() % (int)freeRange );
	float targetPosY = pMonster->GetRegenPos().y + ( rand() % (int)freeRange ) - ( rand() % (int)freeRange );
	if( targetPosX < 0 )
		targetPosX = 0;
	if( targetPosY < 0 )
		targetPosY = 0;

	/// Ͱ ̵  
	if( pMonster->SetPath( targetPosX, targetPosY ) == 0 )
		++mSetPathErrCnd;
	else
		mSetPathErrCnd = 0;

	///   ӽ Ƚ ʹ   Ͱ ã    ɼ ũ.
	if( mSetPathErrCnd > 100 )
	{
		///  ̵
		pMonster->SetPos( targetPosX, targetPosY );
		mSetPathErrCnd = 0;
	}

	/// Ư ̺Ʈ ɸ ʴ   ̵
	return eACTCH_CONTINUE;
}



eMOVE_SPEED_TYPE cActionMove::RandMoveSpeed( cMonster* pMonster, unsigned long *moveSpeed )
{

	const sMonsterScript* pMonsterScript = pMonster->GetMonsterInfo();
	if( pMonsterScript == NULL )
	{
		assert(NULL);
		*moveSpeed = 0;
		return eMOVESPEED_RUN;
	}

	///  հ
	unsigned short totalRatio = pMonsterScript->mActionStopRatio + pMonsterScript->mActionWalkRatio + pMonsterScript->mActionRunRatio;

	///  ð
	unsigned short randSelect = (unsigned short)( rand() % totalRatio ) + 1;
	if( randSelect <= pMonsterScript->mActionStopRatio )
	{
		*moveSpeed = 0;
		///  
		return eMOVESPEED_STOP;
	}
	else if( randSelect <= pMonsterScript->mActionStopRatio + pMonsterScript->mActionWalkRatio  )
	{
		*moveSpeed = pMonsterScript->mActionWalkSpd;
		/// ȱ 
		return eMOVESPEED_WALK;
	}
	else
	{
		*moveSpeed = pMonsterScript->mActionRunSpd;
		/// ٱ 
		return eMOVESPEED_RUN;
	}
}



cPlayer* cActionMove::TargetSelect( cMonster* pMonster, unsigned long seekRange )
{

	float tempRange;

	/// ֺ ׸忡 ÷̾ ִ  üũ - Ϲ
	if( GRIDMANAGER->IsPlayer( pMonster ) == 0 )
		return NULL;

	cPlayer* pPlayer = GRIDMANAGER->FindFirstPlayer( pMonster );
	///  ÷̾ ˻
	while( pPlayer != NULL )
	{
		/// ÷̾ ִµ  
		if( pPlayer->GetStateDie() != true ) 
		{
			tempRange = OBJECTMANAGER->ObjectSizeRange( pMonster, pPlayer, (float)seekRange );

			///   
			mRangechk.SetRadius( tempRange );

			///  ġ
			NiPoint3 monsterpoint( pMonster->GetXPos(), pMonster->GetYPos(), pMonster->Height() );
			/// ÷̾ ġ
			NiPoint3 playerpoint( pPlayer->GetXPos(), pPlayer->GetYPos(), pPlayer->Height() );

			///  ΰ 
			if( AIMANAGER->IsPassible( pPlayer->GetMapNumber(), playerpoint.x, playerpoint.y, pPlayer->GetObject() ) == false )
			{
				pPlayer = GRIDMANAGER->FindNextPlayer();
				continue;
			}

			/// Ϳ ÷̾ 浹 üũ
			if( mRangechk.IsRange( monsterpoint, playerpoint ) )
			{
				return pPlayer;
			}
		}

		pPlayer = GRIDMANAGER->FindNextPlayer();
	}

	return NULL;
}