#include "stdafx.h"
#include "BaseObject.h"
#include "gamesrv.h"

#include "Monster_Common.h"

#include "ObjectManager.h"
#include "SkillManager.h"
#include "StatusCalc_Server.h"
#include "Aimanager.h"


cBaseObject::cBaseObject(unsigned char objectType)
{
	mObject.type = objectType;
	mMapNumber   = MAP_MIN;
	mGridPos     = DEF_GRID_POS;

	SetStateDie( false );
}

cBaseObject::~cBaseObject()
{
	SetStateDie( true );
}

cBaseObject* cBaseObject::GetTarget( )
{
	/// Ÿ  
	switch( mTarget.type )
	{
	case eOBJECTTYPE_PLAYER:
		/// ÷̾  ȯ
		return (cBaseObject*)OBJECTMANAGER->GetPlayer( mTarget.index );

	case eOBJECTTYPE_MONSTER:
		///   ȯ
		return (cBaseObject*)OBJECTMANAGER->GetMonster( mTarget.index );

	default:
		///  NULL ȯ
		return NULL;
	}
}

bool cBaseObject::SetTarget( unsigned char type, unsigned long idx )
{
	mTarget.index = idx;
	mTarget.type = type;
	return true;
}

float cBaseObject::Height()
{
	float height = 0.0f;
	AIMANAGER->CalcHeight( mMapNumber, &height, mObjectPos.x, mObjectPos.y );
	return height;
}