/* ==========================================================================
*      : SkillObject.h
*      : 
*    : ڰ
*    : 2007-06-07
* ǻ :
*===========================================================================*/
#pragma once

#include "Skill_Common.h"

enum eSkillCode
{
	NONUSESKILL,
	ACTIVESKILL,
	PASSIVESKILL,
};

enum eSKILLPROCESS
{
	eSKILLPROCESS_CASTING,			/// ĳ
    eSKILLPROCESS_ACTIVITY,			/// ߵ
	eSKILLPROCESS_PROJECTILE,		/// ߻ü
	eSKILLPROCESS_DAMAGE,			/// 
	eSKILLPROCESS_HP,				/// HP
	eSKILLPROCESS_DESTRUCTION,		/// Ҹ
};

enum eSKILLCREATE_TYPE
{
	eSKILLCREATETYPE_NORMAL,		/// Ϲ ų
	eSKILLCREATETYPE_MAPCHANGE,		/// ̵ ų
	eSKILLCREATETYPE_VEHICLE,		/// Ż  ų
};

class cBaseObject;
struct sDramaAction;

enum eOBJECTTYPE;

class cBaseSkillObject
{

public:

	cBaseSkillObject();
	virtual ~cBaseSkillObject();

	unsigned long	GetAttackerIdx()	{ return mAttacker.index; }
	unsigned char	GetAttackerType()	{ return mAttacker.type; }
	eSKILLPROCESS	GetSkillState()		{ return mSkillState; }
	unsigned long	GetUniqueIdx()		{ return mUniqueIdx; }
	bool			IsProjectile()		{ return mIsProjectile; }
	bool			IsDetailEnd()		{ return mDetailCnt <= mDetailPos + 1; }
	unsigned long	SkillEndTime();
	bool			IsChgMonsSkill()	{ return mIsChgMonsSkill; }

	void			Process( unsigned long elapsedTime, unsigned long accumTime );

protected:

	/// ĳý  / Ÿ ü üũ
	virtual bool	CastingObjectCheck( cBaseObject* pAttacker ) = 0;

	/// ų ߵ Ҹ׸ Ҹ
	virtual bool	RequireValue( cBaseObject* pAttacker ) = 0;

	/// ߻ü  
	virtual bool	SetCenterPos() = 0;

	/// ߻ü ̵
	bool			IsProjectileEndProcess( unsigned long elapsedTime );

	/// Ÿ 
	virtual void	TargetSelect( cBaseObject* pAttacker ) = 0;

	///  
	virtual void	ApplyDamage( cBaseObject* pAttacker ) = 0;
	/// ųŸԺ ó
	void			SendDamage( cBaseObject* pAttacker, 
		unsigned long shotType, eATTRIBUTETYPE attribType, eRANGETYPE rangeType,
		unsigned short applyType1, unsigned short applyType2, unsigned long applyValue1, unsigned long applyValue2,
		unsigned long influenceClassIdx, unsigned short accuracyValue, unsigned short criticalValue, bool applyHP );
	void			SendHeal( cBaseObject* pAttacker, unsigned long shotType,
		unsigned short applyType1, unsigned short applyType2, unsigned long applyValue1, unsigned long applyValue2,
		unsigned long influenceClassIdx );
	void			SendApply( cBaseObject* pAttacker, unsigned long shotType,
		unsigned short applyType1, unsigned short applyType2, 
		unsigned long applyValue1, unsigned long applyValue2, unsigned long influenceClassIdx );

	void			SendDelTarget( cBaseObject* pAttacker, unsigned short accuracyValue );

	void			AddTotem( cBaseObject* pAttacker, unsigned long partyIdx, eAPPLYTYPE applyType, eATTRIBUTETYPE attributeType, unsigned long influenceClassIdx );

	void			AttackerNullDamage();

	/// HP  ( true : ׸ , false : ׸  )
	virtual bool	ApplyHP( cBaseObject* pAttacker );

protected:

	typedef tHashSet<unsigned long> cHashSet;
	typedef tArray<sMultiTarget> cAry;

	///  ε
	unsigned long	mUniqueIdx;

	/// ų 
	eSKILLPROCESS	mSkillState;

	///	() 
	sObject			mAttacker;
	/// Ÿ  ų  Ʈ
	sObject			mCenterTarget;

	/// (=) ġ
	NiPoint3		mCenterPos;
	/// ʳѹ
	unsigned long	mMapNumber;

	/// ų  ( ð)
	unsigned long	mCreationTime;

	/// ߵ ð
	unsigned long	mActivityTime;
	/// ĳ ð
	unsigned long	mCastingTime;

	/// ߻ü 
	bool			mIsProjectile;
	/// ߻ü ӵ
	float			mProjectileSpeed;
	/// ߻ü ȿġ
	NiPoint2		mProjectilePos;

	///     о  Ʈ
	unsigned long	mDetailCnt;
	sDramaAction*	mpDetailBegin;
	sDramaAction*	mpDetailEnd;

	unsigned long	mDetailPos;

	unsigned long	mDetailStartTime;
	unsigned long	mDetailEndTime;

	/// Ϲݰ ӵ (:1.0)
	float			mSpeedFactor;

	unsigned long	mDramaKey;
	///ũƮ  ųε
	unsigned int	mSkillIdx;

	cHashSet		mSendTargetSet;

	bool			mIsFieldTarget;

	unsigned char	mAttackerDie;		/// 0 : , 1 : (ü), 2 : (miss)

	/// ߻ü ϴ Ÿ   ̽ó
	bool			mNoTargetNoDamage;

	/// ÷̾ ͷ   ų 
	bool			mIsChgMonsSkill;

	///  
	eBOUNDTYPE		boundType;
	///  Ÿ
	eAPPLYTYPE		applyType;
	///  Ÿ
	float			range;

	eSKILLCREATE_TYPE mCreateType;
	
	unsigned long	mUseItemIdx;

	long			mDistressPoint;

	/// Ÿ ϴ ų
	bool			mDelTarget;

	/// Ÿ 
	cAry			mTargetAry;
};
