/* ====================================================================
 *      :	CooltimePool.h
 *      :	
 *    :	ö
 *    :	08/10/02
 * ǻ :	
 * =================================================================== */
#ifndef __COOLTIME_POOL_H__
#define __COOLTIME_POOL_H__

///#ifndef WINVER
///#define WINVER          0x0500
///#endif
///
///#ifndef _WIN32_WINNT
///#define _WIN32_WINNT    0x0500
///#endif

#pragma once

#include "memorypool.h"

#define MIN_SAVE_ITEM_COOLTIME	15	//  Ÿ ð - ּҰ()

struct PerCooltime : PerNode
{
	long   index;					// K   ̺ ȹ/з
	long   cooltime1;				//   Ÿ -   ð
	long   cooltime2;				//   Ÿ -  ׷ȣ
	time_t validThru;				//   Ÿ - ð
};

struct CooltimeRoot : NodeRoot
{};

class cCooltimePool
{
private:
	PerCooltime* mNonPagedPoolUsage;	//  ȵ Ǯ.

public:
	cCooltimePool( );

	void         Shutdown        ( );

	bool         IsCooltime      ( CooltimeRoot* cooltimeRoot, long index );
	void         ApplyCooltime   ( CooltimeRoot* cooltimeRoot, TB_INVENTORY* inventory );

	bool         UpdateCooltime  ( PerCooltime* perCooltime, long cooltime1, long cooltime2, time_t* ltime );

	PerCooltime* GetCooltime     ( CooltimeRoot* cooltimeRoot, long index );
	void         ReleaseCooltime ( CooltimeRoot* cooltimeRoot, PerCooltime* perCooltime );

public:
	virtual ~cCooltimePool(void);

public:
	static cCooltimePool* mpCooltimePool;
};

#endif /// __COOLTIME_POOL_H__
