/* ==========================================================================
*      : DamageCalc.h
*      :  Ѵ.
*    : ڰ
*    : 2007-01-16
* ǻ : 
*===========================================================================*/
#pragma once

#include "Status_Common.h"
#include "Skill_Common.h"

class cBaseObject;
class cPlayer;
class cMonster;

enum eOBJECTTYPE;

struct sObject;

const float CRITICAL_RATE = 1.5f;
const unsigned long DEFENSE_RANDOM_PER = 80;

class cDamageCalc
{

public:

	static cDamageCalc* mpDamageCalc;

public:
	cDamageCalc(void);
	~cDamageCalc(void);

	bool				PlayerAttackSuccess( unsigned long playerIdx, sObject target, eATTRIBUTETYPE attributeType, long skillAccuracyValue );
	bool				PlayerCritical( unsigned long playerIdx, sObject target, eATTRIBUTETYPE attributeType, short skillCriticalValue );
	unsigned long		PlayerDamageCalc( unsigned long playerIdx, sObject target, eATTRIBUTETYPE attributeType, eRANGETYPE rangeType );

	bool				MonsterAttackSuccess( unsigned long monsterIdx, sObject target, eMONSTERATTACK_TYPE attackType, eATTRIBUTETYPE attributeType );
	bool				MonsterCritical( unsigned long monsterIdx, sObject target, eMONSTERATTACK_TYPE attackType, eATTRIBUTETYPE attributeType );
	unsigned long		MonsterDamageCalc( unsigned long monsterIdx, sObject target, eMONSTERATTACK_TYPE attackType, eATTRIBUTETYPE attributeType, eRANGETYPE rangeType );

	/// ȸ() 
	unsigned long		HealHPCalc( sObject attacker, long skillHeal );

	///  ̻  Ȯ
	unsigned long		PlayerConditionOdd( sObject target, sObject attacker, long influenceRate, unsigned long skillClassIdx );
	unsigned long		MonsterConditionOdd( sObject target, sObject attacker, long influenceRate, unsigned long skillClassIdx );

private:

	bool				SuccessCalcValue( cPlayer* pAttacker, cMonster* pTarget, eATTRIBUTETYPE attributeType, long skillRate );
	bool				CriticalCalcValue( cPlayer* pAttacker, cMonster* pTarget, eATTRIBUTETYPE attributeType, long skillCri );
	unsigned long		DamageCalcValue( cPlayer* pAttacker, cMonster* pTarget, eATTRIBUTETYPE attributeType, eRANGETYPE rangeType );

	bool				SuccessCalcValue( cMonster* pAttacker, cPlayer* pTarget, eMONSTERATTACK_TYPE attackType, eATTRIBUTETYPE attributeType );
	bool				CriticalCalcValue( cMonster* pAttacker, cPlayer* pTarget, eMONSTERATTACK_TYPE attackType, eATTRIBUTETYPE attributeType );
	unsigned long		DamageCalcValue( cMonster* pAttacker, cPlayer* pTarget, eMONSTERATTACK_TYPE attackType, eATTRIBUTETYPE attributeType, eRANGETYPE rangeType );

	bool				SuccessCalcValue( cPlayer* pAttacker, cPlayer* pTarget, eATTRIBUTETYPE attributeType, long skillRate );
	bool				CriticalCalcValue( cPlayer* pAttacker, cPlayer* pTarget, eATTRIBUTETYPE attributeType, long skillCri );
	unsigned long		DamageCalcValue( cPlayer* pAttacker, cPlayer* pTarget, eATTRIBUTETYPE attributeType, eRANGETYPE rangeType );

private:

	///   Ȯ
	unsigned long		PhyAttackSuccess100( unsigned long attackerStatusRate, unsigned char attackerLv,
		long skillRate, unsigned long targetStatusAvoid, unsigned char targetLv );
	unsigned long		MagAttackSuccess130( long skillRate, unsigned char attackerLv, unsigned char targetLv );

	/// ũƼ ߻ Ȯ
	unsigned long		PhyCritical200( unsigned long attackerStatusCri, long skillCri, unsigned char attackerLv, unsigned char targetLv );
	unsigned long		MagCritical230( unsigned long attackerStatusCri, long skillCri, unsigned char attackerLv, unsigned char targetLv );

	///  
	unsigned long		PhyDamage500( unsigned char attackerType, unsigned long attackerStatusPhyAttack, unsigned long targetStatusPhyDef, long skillAttackPlus,
		long skillAttackPer, unsigned char attackerLv, unsigned char targetLv );
	unsigned long		MagDamage530( unsigned char attackerType, unsigned long attackerStatusMagAttack, unsigned long targetStatusMagDef, long skillAttackPlus,
		long skillAttackPer, unsigned char attackerLv, unsigned char targetLv );

	///   Ȯ
	unsigned long		PhyConditionOdd900( long skillRate, unsigned long attackerAttack, unsigned long targetDef,
		unsigned char attackerLv, unsigned char targetLv );
	unsigned long		MagConditionOdd930( long skillRate, unsigned long attackerAttack, unsigned long targetDef,
		unsigned char attackerLv, unsigned char targetLv );

	/// ȸ()
	unsigned long		HealHP1200( long skillHeal, long statusPer, long statusHeal );

};

#define DAMAGECALC cDamageCalc::mpDamageCalc
