#include "StdAfx.h"
#include "gamesrv.h"

#include "Protocol.h"

#include "DropScript.h"
#include "Drop.h"
#include "Drop_Common.h"

#include "Monster.h"
#include "ObjectManager.h"
#include "AppTimer.h"
#include "Monster.h"
#include "Player.h"
#include "LevelManager.h"
#include "MonsterScript.h"
#include "item.h"
#include "TakeDamagePool.h"
#include "Gathering.h"


cDrop* cDrop::mpDrop = NULL;



cDrop::cDrop(void)
{
	/// ̱
	if( mpDrop )
	{
		Verbose->WriteLog( "Drop new error");
	}
	else
	{
		mpDrop = this;
	}
}



cDrop::~cDrop(void)
{
}



bool cDrop::Init()
{

	mpDropScript = new cDropScript;
	if( mpDropScript->Init() == false )
	{
		assert(NULL);
		return false;
	}	

	return true;
}



void cDrop::Release()
{
	SAFE_RELEASE_DELETE( mpDropScript );

}



void cDrop::MonsterDrop( unsigned long monsterIdx, unsigned long playerIdx, unsigned long partyIdx )
{

	cMonster* pMonster = OBJECTMANAGER->GetMonster( monsterIdx );
	if( pMonster == NULL )  
	{ 
		assert(NULL);
		NETWORK2->PostServerEvent("drop monster idx error[%d]", monsterIdx );
		return; 
	}

	unsigned long monsterClassIdx = pMonster->GetRaceGender();

	sMonsterScript* pMonsterScript = MONSTERSCRIPT->GetMonsterListInfo( monsterClassIdx );
	if( pMonsterScript == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("drop monsterScript idx error[%d]", monsterClassIdx );
		return;
	}

	/// money, exp, sxp 
	MonsterDropValue( pMonster );
	/// Ϲݵ -  ε mDropItemCntMap ƿ
	MonsterDropNType( monsterClassIdx );
	/// Ư -  ε mDropItemCntMap ƿ
	MonsterDropSType( monsterClassIdx ); 
	///  -  ε mDropItemCntMap ƿ
	MonsterDropWType( pMonster->GetLevel(), pMonster->GetMonsterInfo()->mType ); 

	if( mDropItemCntMap.GetSize() == 0 )
		return;

	cHashMap::cConstIterator begin = mDropItemCntMap.Begin();
	cHashMap::cConstIterator end = mDropItemCntMap.End();

	unsigned long ownerIdx[MAX_PARTY] = {0,};
	unsigned char ownerCnt = 0;

	cPlayer* pPlayer = NULL;

	///   Ƽ / 
	cParty* pParty = PARTYMAN->GetParty( partyIdx );
	if( pParty == NULL )
	{
		/// Ƽ   켱 ش.
		if( OBJECTMANAGER->GetPlayer( playerIdx ) != NULL )
		{
			ownerIdx[0] = playerIdx;
			++ownerCnt;
		}
	}
	else
	{
		switch( pParty->GetDivideType() )
		{
		case PARTY_DIVIDE_TURN:		/// 
			{
				ownerIdx[0] = pParty->GetTurnUser( pMonster->GetMapNumber(), pMonster->GetXPos(), pMonster->GetYPos() );
				ownerCnt = 1;
			}
			break;
		case PARTY_DIVIDE_RANDOM:	/// 
			{
				ownerIdx[0] = pParty->GetRandomUser( pMonster->GetMapNumber(), pMonster->GetXPos(), pMonster->GetYPos() );
				ownerCnt = 1;
			}
			break;
		case PARTY_DIVIDE_DAMAGE:	/// 
			{
				unsigned long* pUser = pParty->GetUserArr();
				unsigned int partyCnt = pParty->GetCount();
				unsigned long maxDamagePlayerIdx = playerIdx;
				unsigned long maxDamage = 0;
				unsigned long tempDamage = 0;

				for( unsigned int i = 0; i < partyCnt; ++i )
				{
					pPlayer = OBJECTMANAGER->GetPlayer( pUser[i] );
					if( pPlayer )
					{
						///  üũ
						if( MonsterCheckDrop( pMonster, pPlayer ) == false )
							continue;

						tempDamage = pMonster->GetTakeDamage( pUser[i] );
						if( tempDamage > maxDamage )
						{
							maxDamagePlayerIdx = pUser[i];
							maxDamage = tempDamage;
						}
					}
				}
				ownerIdx[0] = maxDamagePlayerIdx;
				ownerCnt = 1;
			}
			break;
		case PARTY_DIVIDE_FREE:		/// й (ȹ)
			{
				unsigned long* pUser = pParty->GetUserArr();
				unsigned int partyCnt = pParty->GetCount();

				for( unsigned int i = 0; i < partyCnt; ++i )
				{
					pPlayer = OBJECTMANAGER->GetPlayer( pUser[i] );
					if( pPlayer )
					{
						///  üũ
						if( MonsterCheckDrop( pMonster, pPlayer ) == false )
							continue;

						ownerIdx[ownerCnt] = pUser[i];
						++ownerCnt;
					}
				}

			}
			break;
		}
	}

	unsigned short applyCnt;
	bool isApply = false;

	unsigned itemIdx = ITEMMANAGER->MakeItemIdx( );
	cItem*   item    = OBJECTMANAGER->AddItem( itemIdx, pMonster );
	if ( item != NULL )
	{
		for( unsigned char i = 0 ; i < ownerCnt ; ++i )
			item->PushOwner( ownerIdx[i] );

		for( ; begin != end ; ++begin )
		{
			applyCnt = 0;

			while( applyCnt < (*begin).mSecond )
			{
				unsigned short cnt = item->PushItem( (*begin).mFirst, (unsigned short)(*begin).mSecond );
				if( cnt == 0 )
				{
					NETWORK2->PostServerEvent("cDrop::Drop item(%d,%d)->PushItem cnt == 0", (*begin).mFirst, (*begin).mSecond);
					break;
				}

				applyCnt = applyCnt + cnt;
				isApply = true;
			}
		}
	}

	if( isApply == true )
	{
		///   ǥ Ʈ  
		if( AIMANAGER->IsPassible( item->GetMapNumber(), item->GetXPos(), item->GetYPos(), item->GetObject() ) == false )
		{
			for( unsigned char i = 0 ; i < ownerCnt ; ++i )
			{
				///  ǥ Ʈ
				pPlayer = OBJECTMANAGER->GetPlayer( ownerIdx[i] );
				if( AIMANAGER->IsPassible( pPlayer->GetMapNumber(), pPlayer->GetXPos(), pPlayer->GetYPos(), pPlayer->GetObject()  ) == true )
				{
					item->SetMapNumber( pPlayer->GetMapNumber() );
					item->SetPos( pPlayer->GetXPos(), pPlayer->GetYPos() );
					break;
				}
			}
		}
		GRIDMANAGER->AddItem( item );
	}
	else
		OBJECTMANAGER->RemoveItem( itemIdx );

	mDropItemCntMap.Clear();
}


void cDrop::MonsterQuestDrop( unsigned long monsterIdx, unsigned long playerIdx, unsigned long partyIdx )
{

	cMonster* pMonster = OBJECTMANAGER->GetMonster( monsterIdx );
	if( pMonster == NULL )  
	{ 
		assert(NULL);
		NETWORK2->PostServerEvent("QuestDrop monster idx error[%d]", monsterIdx );
		return; 
	}

	unsigned long monsterClassIdx = pMonster->GetRaceGender();

	sMonsterScript* pMonsterScript = MONSTERSCRIPT->GetMonsterListInfo( monsterClassIdx );
	if( pMonsterScript == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("QuestDrop monsterScript idx error[%d]", monsterClassIdx );
		return;
	}

	cPlayer* pPlayer = NULL;

	/// Ƽ /
	cParty* pParty = PARTYMAN->GetParty( partyIdx );
	if( pParty == NULL )
	{
		/// Ƽ   ÷̾  Ѵ.
		pPlayer = OBJECTMANAGER->GetPlayer( playerIdx );
		if( pPlayer != NULL )
			MonsterDropQType( pMonster, pPlayer );
	}
	else
	{
		unsigned long* pUser = pParty->GetUserArr();
		unsigned int partyCnt = pParty->GetCount();

		/// Ƽ Ʈ 
		for( unsigned int i = 0; i < partyCnt; ++i )
		{
			pPlayer = OBJECTMANAGER->GetPlayer( pUser[i] );
			if( pPlayer != NULL )
			{
				///  üũ
				if( MonsterCheckDrop( pMonster, pPlayer ) == false )
					continue;

				MonsterDropQType( pMonster, pPlayer );
			}
		}
	}
}


void cDrop::MonsterDropValue( cMonster* pMonster )
{
	unsigned long monsterKind = pMonster->GetRaceGender();
	unsigned long maxMoney = 0;
	unsigned long minMoney = 0;
	int moneyDropPer = 0;

	///  ũƮ   شϴ  о 
	sDropNType* pDropNType = mpDropScript->GetDropNType( monsterKind );
	if( pDropNType != NULL ) 
	{ 
		maxMoney = pDropNType->mMaxMoney;
		minMoney = pDropNType->mMinMoney;
		moneyDropPer = FloatToInt( pDropNType->mMoneyPercent );
	}

	///  
	sMonsterScript* pMonsterScript = MONSTERSCRIPT->GetMonsterListInfo( monsterKind );
	if( pMonsterScript == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("cDrop::DropValue pMonsterScript[%d] == NULL", monsterKind);
		return;
	}

	/// Ȯ Ż 
	long moneyGap = maxMoney - minMoney;
	if( moneyGap > RANDOM_MAX )
	{
		NETWORK2->PostServerEvent("cDrop::GatherDropValue[%d] moneyGap > RANDOM_MAX", monsterKind, moneyGap );
		moneyGap = RANDOM_MAX;
	}

	/// ͸   
	TakeDamageRoot* pTakeDamageRoot = pMonster->GetTakeDamageRoot();
	if( pTakeDamageRoot == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("cDrop::DropValue pTakeDamageMap == NULL");
		return;
	}

	///  
	unsigned long randValue = (unsigned long)( RANDOMTABLE->Get( ) * 1000000 );
	int dropMoney = 0;
	unsigned long dropExp = pMonsterScript->mExp;
	unsigned long dropSxp = pMonsterScript->mSxp;

	///  ݾ  
	int droprand = ( rand() % 100 ) + 1;

	/// Ȯؼ   ΰ츸 ݾ 
	if( droprand <= moneyDropPer ) 
	{
		if( moneyGap > 0 )
			dropMoney = minMoney + ( randValue % moneyGap ); 
		else
			dropMoney = minMoney;
	}

	unsigned long playerIdx;		///  
	unsigned long damage;			/// ڰ 
	float partyTotalMoney;			/// /Ƽ й  ü
	float partyTotalExp;
	float partyTotalSxp;

	unsigned long partyIdx;			/// Ƽ ȣ

	cPlayer* pPlayer = NULL;
	cParty* pParty = NULL;

	unsigned long calcExp;
	unsigned long calcSxp;

	///  ÷̾()ü ջ
	unsigned long totalDamage = 0;

	/// Ͱ ݹ ü  
	PerTakeDamage* per = (PerTakeDamage*)pTakeDamageRoot->pool;
	while( per )
	{
		totalDamage += per->takeDamage;
		per = (PerTakeDamage*)per->next;
	}

	partyIdxSet.Clear();

	per = (PerTakeDamage*)pTakeDamageRoot->pool;
	while( per )
	{
		playerIdx = per->playerIdx;
		damage = per->takeDamage;

		///  ʴ  
		if( damage == 0 )
		{
			per = (PerTakeDamage*)per->next;
			continue;
		}

		/// ÷̾ ü  money  
		pPlayer = OBJECTMANAGER->GetPlayer( playerIdx );
		if( pPlayer == NULL )
		{
			per = (PerTakeDamage*)per->next;
			continue;
		}

		///   /Ƽ(ü)  ư money 
		partyTotalMoney = (float)(dropMoney * damage / totalDamage);
		/// ġ  ϱ  ġ
		partyTotalExp = (float)(dropExp * damage / totalDamage);
		partyTotalSxp = (float)(dropSxp * damage / totalDamage);

		bool IsParty = false;

		/// Ƽ о
		partyIdx = pPlayer->GetPartyIndex();
		if( partyIdx != 0 )
		{
			pParty = PARTYMAN->GetParty( partyIdx );
			if( pParty != NULL )
				IsParty = true;
		}

		/// Ƽ ƴ 
		if( IsParty == false )
		{
			if( pPlayer->GetStateDie() == true )
			{
				per = (PerTakeDamage*)per->next;
				continue;
			}

			///   30% ̸ΰ  
			if( pMonster->GetMaxHP() * (float)0.3 > damage )	
			{
				per = (PerTakeDamage*)per->next;
				continue; 
			}

			///   Ÿ üũ
			if( MonsterCheckDrop( pMonster, pPlayer ) == false )
			{
				per = (PerTakeDamage*)per->next;
				continue;
			}

			calcExp = FloatToInt( MonsterDropExpIncrease( partyTotalExp, pPlayer->GetLevel(), pMonsterScript->mLevel ) );
			calcSxp = FloatToInt( MonsterDropExpIncrease( partyTotalSxp, pPlayer->GetLevel(), pMonsterScript->mLevel ) );

			///------  ڷ ½ ּ
			pPlayer->AddExpSxp( calcExp, calcSxp );

			unsigned long money = FloatToInt( partyTotalMoney );
			if( money != 0 )
				pPlayer->AddMoney( pMonster->GetObject(), money );
			///---------------------------------

		}
		else
		{
			/// Ƽ ΰ Ƽó Set   ó
			///  Ƽ  ģ insert õ      1 
			partyIdxSet.Insert( partyIdx );

			/// Ƽ ü    Է
			pParty->AddDropValue( pMonster->GetMaxHP(), damage, partyTotalMoney,  partyTotalExp, partyTotalSxp );
		}

		per = (PerTakeDamage*)per->next;
	}

	cHashSet::cIterator setIter = partyIdxSet.Begin();
	cHashSet::cIterator setIterEnd = partyIdxSet.End();

	///  ó  Ƽ ġ й ó
	while( setIter != setIterEnd )
	{
		partyIdx = (*setIter++);
		pParty = PARTYMAN->GetParty( partyIdx );

		/// Ƽ money, exp, sxp й
		pParty->DivideDropValue( pMonster->GetObjectID(), pMonsterScript->mLevel );
	}
}



void cDrop::MonsterDropNType( unsigned long monsterClassIdx )
{

	///  ũƮ   شϴ  о 
	sDropNType* pDropNType = mpDropScript->GetDropNType( monsterClassIdx );
	if( pDropNType == NULL ) 
		return; 

	/// Ȯ 
	int droprand = ( rand() % 100 ) + 1;
	if( droprand > pDropNType->mDropPercent ) 
		return; 

	//   
	unsigned long dropCnt;

	unsigned long dropTotalPer = pDropNType->mDropClass1Per + pDropNType->mDropClass2Per + pDropNType->mDropClass3Per;

	/// Ȯ Ż  -  
	if( dropTotalPer == 0 || dropTotalPer > RANDOM_MAX )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("cDrop::DropNType dropTotalPer[%d] ERROR", dropTotalPer );
		return;
	}

	///  
	unsigned long randValue = (unsigned long)( RANDOMTABLE->Get( ) * 1000000 );

	unsigned long selectRand = ( randValue % dropTotalPer ) + 1;
	if( selectRand <= pDropNType->mDropClass1Per )
		dropCnt = pDropNType->mDropClass1Cnt;
	else if( selectRand <= pDropNType->mDropClass1Per + pDropNType->mDropClass2Per )
		dropCnt = pDropNType->mDropClass2Cnt;
	else
		dropCnt = pDropNType->mDropClass3Cnt;

	mDropItemCntMap.Clear();

	for( unsigned char i = 0 ; i < dropCnt ; ++i )
		MonsterDropNTypeSelect( pDropNType );
}


void cDrop::MonsterDropNTypeSelect( sDropNType* pDropNType )
{
	unsigned long totalPer = pDropNType->mItemTotalPer;

	/// Ȯ Ż  -  
	if( totalPer == 0 || totalPer > RANDOM_MAX )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("cDrop::DropNTypeSelect totalPer[%d] ERROR", totalPer );
		return;
	}

	/// Լ  Ȯ ü    1 Ѵ.
	unsigned long randValue = (unsigned long)( RANDOMTABLE->Get( ) * 1000000 );
	unsigned long randnum = ( randValue % totalPer ) + 1;

	cHashMap::cIterator hashIter;

	cAry* pAry = pDropNType->mpData;
	if( pAry == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("cDrop::DropNTypeSelect[%d] pDropNType->mpData == NULL", pDropNType->mClassIdx );   
		return;
	}

	sDropNTypeData* pData = NULL;
	///     شġ ´  ӸƮ Ѵ.
	for( unsigned long i = 0 ; i < pAry->GetSize() ; ++i )
	{
		pData = (sDropNTypeData*)(*pAry)[i];
		if( pData == NULL )
		{
			assert(NULL);
			NETWORK2->PostServerEvent("cDrop::DropNTypeSelect[%d] pData == NULL", pDropNType->mClassIdx );   
			return;
		}
		
		if( randnum <= pData->mItemPer )
		{
			/// Է ߴµ ̹ ִ ̸  + Ų
			if( mDropItemCntMap.Insert( pData->mItemIdx, pData->mItemCnt ) == false )
			{
				if( pData->mItemCnt == 0 )
				{
					assert(NULL);
					NETWORK2->PostServerEvent("cDrop::DropNTypeSelect itemCnt( %d, %d ) == 0", pData->mItemCnt, pData->mItemCnt );   
					return;
				}

				hashIter = mDropItemCntMap.Find( pData->mItemIdx );
				if( hashIter == mDropItemCntMap.End() )
				{
					assert(NULL);
					NETWORK2->PostServerEvent("cDrop::DropNTypeSelect hashIter == mDropItemCntMap.End()" );   
					return;
				}

				unsigned long* cnt = &(hashIter->mSecond);
				if( cnt == NULL )
				{
					assert(NULL);
					NETWORK2->PostServerEvent("DropNTypeSelect2 itemIdx[%d] cnt == NULL", pData->mItemIdx);   
					return;
				}

				*cnt += pData->mItemCnt;
			}
			return;
		}

		randnum = randnum - pData->mItemPer;
	}

	/// ٵҴµ ̾ȵǸ 
	if( randnum <= 0 )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("DropNTypeSelect2 randnum <= 0");        
	}
}


void cDrop::MonsterDropSType( unsigned long monsterClassIdx )
{
	sDropSWType* pSType = DROPSCRIPT->GetDropSType( monsterClassIdx );
	if( pSType == NULL )
		return;

	MonsterDropSWTypeSelect( pSType, true );
}


void cDrop::MonsterDropSWTypeSelect( sDropSWType* pDropSWType, bool isSType )
{

	unsigned long accunTime = NETWORK2->GetAccumTime();

	///  Ȯ üũ
	unsigned long randvalue = (unsigned long)( RANDOMTABLE->Get( ) * 1000000 );
	unsigned long randSelect = ( randvalue % 100 ) + 1;
	if( pDropSWType->mDropPercent < randSelect )
		return;

	float totalPer = pDropSWType->mItemTotalPer * DROP_PER_FLOAT_CONVERT;

	/// Ȯ Ż  -  
	if( totalPer == 0 || totalPer > RANDOM_MAX )
	{
		NETWORK2->PostServerEvent("cDrop::DropSWTypeSelect[%d] totalPer[%d][%d] ERROR", pDropSWType->mIdx, totalPer, isSType );
		return;
	}

	/// 100%̻   ǰ
	/// 100%̸ ΰ Ȯ   Ѱ  
	if( totalPer < 100.0f * DROP_PER_FLOAT_CONVERT )
		totalPer = 100.0f * DROP_PER_FLOAT_CONVERT;

	///  
	randvalue = (unsigned long)( RANDOMTABLE->Get( ) * 1000000 );

	/// Լ  Ȯ ü Ȯ   1 Ѵ.
	unsigned long randnum = ( randvalue % (unsigned long)totalPer ) + 1;

	cAry* pAry = pDropSWType->mpData;
	if( pAry == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("cDrop::DropSWTypeSelect[%d][%d] pAry == NULL", pDropSWType->mIdx, isSType );   
		return;
	}

	cHashMap::cIterator hashIter;
	sDropSWTypeData* pData = NULL;
	///     شġ ´  ӸƮ Ѵ.
	for( unsigned long i = 0 ; i < pAry->GetSize() ; ++i )
	{
		pData = (sDropSWTypeData*)(*pAry)[i];
		if( pData == NULL )
		{
			assert(NULL);
			NETWORK2->PostServerEvent("cDrop::DropSWTypeSelect[%d][%d] pData == NULL", pDropSWType->mIdx, isSType );   
			return;
		}

		/// õ   Ȯ ɸ
		if( randnum <= pData->mItemPer * DROP_PER_FLOAT_CONVERT )
		{
			/// ߰ Ȯ 
			if( pData->mEnoughCntNow < pData->mEnoughCnt )
				++pData->mEnoughCntNow;

			/// ð  ǿ ɸ
			if( pData->mEnoughTimeEnd > accunTime )
				return;

			/// ߰ Ȯ  
			randvalue = (unsigned long)( RANDOMTABLE->Get( ) * 1000000 );
            randSelect = ( randvalue % pData->mEnoughCnt ) + 1;
			if( pData->mEnoughCntNow < randSelect )
				return;

			/// Է ߴµ ̹ ִ ̸  + Ų
			if( mDropItemCntMap.Insert( pData->mItemIdx, pData->mItemCnt ) == false )
			{
				if( pData->mItemCnt == 0 )
				{
					assert(NULL);
					NETWORK2->PostServerEvent("cDrop::DropSTypeSelect itemCnt( %d, %d )[%d] == 0", pData->mItemIdx, pData->mItemCnt, isSType );   
					return;
				}

				hashIter = mDropItemCntMap.Find( pData->mItemIdx );
				if( hashIter == mDropItemCntMap.End() )
				{
					assert(NULL);
					NETWORK2->PostServerEvent("cDrop::DropNTypeSelect[%d] hashIter == mDropItemCntMap.End()", isSType );   
					return;
				}

				unsigned long* cnt = &(hashIter->mSecond);
				if( cnt == NULL )
				{
					assert(NULL);
					NETWORK2->PostServerEvent("cDrop::DropSTypeSelect itemIdx[%d] cnt == NULL[%d]", pData->mItemIdx, isSType);   
					return;
				}

				*cnt += pData->mItemCnt;
			}
			
			///  Ȱ  Ʈ
			pData->mEnoughCntNow = 0;
			pData->mEnoughTimeEnd = accunTime + pData->mEnoughTime;

			return;
		}

		randnum = randnum - FloatToInt( pData->mItemPer * DROP_PER_FLOAT_CONVERT );
	}
}


void cDrop::MonsterDropWType( unsigned char monsterLv, unsigned char monsterType )
{
	cAry* pAry = DROPSCRIPT->GetDropWType( monsterLv );
	if( pAry == NULL )
		return;
    
	sDropWTypeLink* pWTypeLink = NULL;
	sDropSWType* pWType = NULL;
	for( unsigned long i = 0 ; pAry->GetSize() > i ; ++i )
	{
		pWTypeLink = (sDropWTypeLink*)(*pAry)[i];

		if( pWTypeLink == NULL )
		{
			assert(NULL);
			NETWORK2->PostServerEvent("cDrop::DropWType pWType == NULL");
			continue;
		}

		if( pWTypeLink->mMonsterType != monsterType && pWTypeLink->mMonsterType != 0 )
			continue;

		pWType = pWTypeLink->mpWType;
		if( pWType == NULL )
		{
			assert(NULL);
			NETWORK2->PostServerEvent("cDrop::DropWType pSType == NULL");
			continue;
		}

        MonsterDropSWTypeSelect( pWType, false );
	}
}


void cDrop::MonsterDropQType( cMonster* pMonster, cPlayer* pPlayer )
{
	unsigned long monsterClassIdx = pMonster->GetRaceGender();

	TB_QUEST_PROGRESS* pQuest = NULL;
	cAry* pAry = NULL;
	sDropQType* pDropQ = NULL;
	unsigned long selectRand = 0;
	//	unsigned long itemIdx = 0;
	unsigned long dropNeedCnt = 0;

	/// Ʈ ü ˻
	for( unsigned long i = 0 ; i < MAX_KEEPQUEST ; ++i )
	{
		/// Ʈ  ε
		pQuest = pPlayer->GetQuest( i );
		if( pQuest == NULL )
			break;

		if( pQuest->idx == 0 )
			return;

		cQuestDefine* questDefine = QUESTMAN->GetQuestDefine( pQuest->questIdx );
		if( !questDefine )
		{
			assert(NULL);
			NETWORK2->PostServerEvent("DropQType questDefine[%d] == NULL", pQuest->questIdx );
			return;
		}

		/// Ʈ   üũ
		if( pQuest->check >= questDefine->mComplete )
			continue;

		/// Ͱ ÷̾ Ʈ شϴ Ӿ  о
		pAry = DROPSCRIPT->GetDropQtype( monsterClassIdx, pQuest->questIdx );
		if( pAry == NULL )
			continue;

		///   
		for( unsigned long itemI = 0 ; itemI < pAry->GetSize() ; ++itemI )
		{
			pDropQ = (sDropQType*)(*pAry)[itemI];

			if( pDropQ == NULL )
			{
				assert(NULL);
				NETWORK2->PostServerEvent("DropQType pDropQ == NULL [%d]", itemI );
				continue;
			}

			///  Ȯ 
			unsigned long randvalue = (unsigned long)( RANDOMTABLE->Get( ) * 1000000 );
			selectRand = ( randvalue % 100 ) + 1;
			if( selectRand > pDropQ->mDropPer )
				continue;

			///  ʿ  Ȯ
			dropNeedCnt = pPlayer->GetDropItemCount( i, pDropQ->mItemIdx );
			if( dropNeedCnt == 0 )
				continue;

			/// Ʈ  ˻ -  ˻
			if( pPlayer->IsEquipQuestItem( pQuest->questIdx ) == false )
				continue;

			/// ÷̾ ڵ 
			if( pPlayer->ItemGetQuest( pDropQ->mItemIdx, 1 ) == true )
			{
				/// Ʈ    Ʈ
				pPlayer->UpdateDutyItem();
			}
			else
			{
				assert(NULL);
				NETWORK2->PostServerEvent("Drop::DropQType ItemGetQuest[%d] ERROR", pDropQ->mItemIdx );
			}
		}
	}
}


float cDrop::MonsterDropExpIncrease( float takeExp, unsigned char playerLevel, unsigned char monsterLevel )
{

	char levelDifferent;
	float increase;
	float exp = 0.0f;

	/// 
	levelDifferent = monsterLevel - playerLevel;
	/// ĳͿ   -6  ġ  
	if( levelDifferent < DROPSCRIPT->GetMinLevelDifferent() )	
		return 0; 

	/// ĳͿ Ͱ  +5 ̻  +5 
	if( levelDifferent > DROPSCRIPT->GetMaxLevelDifferent() )
		levelDifferent = DROPSCRIPT->GetMaxLevelDifferent();

	///   ġ 
	increase = DROPSCRIPT->GetDropExpIncrease( levelDifferent );

	/// ġ * ġ
	exp = takeExp * increase;
	if( exp < 0.0f )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("cDrop::DropExpIncrease exp < 0.0f");
		return 0.0f;
	}
	return exp;
}



bool cDrop::MonsterCheckDrop( cMonster* pMonster, cPlayer* pPlayer )
{

	if( pMonster->GetMapNumber() != pPlayer->GetMapNumber() )
		return false;

	NiPoint2 monsterPos = pMonster->GetPos();
	NiPoint2 playerPos = pPlayer->GetPos();

	cRangeCheck rangeCheck( PARTY_RANGE );
	if( rangeCheck.IsRange( monsterPos, playerPos ) == false )
		return false;

	return true;
}


void cDrop::GatherDrop( cGathering* pGathering, unsigned long playerIdx )
{
	if( pGathering == NULL )
		return;

	cPlayer* pPlayer = OBJECTMANAGER->GetPlayer( playerIdx );
	if( pPlayer == NULL )
		return;

	/// money 
	GatherDropValue( pGathering, playerIdx );
	/// Ʈ
	GatherDropQType( pGathering, playerIdx );

	/// Ϲݵ -  ε mDropItemCntMap ƿ
	GatherDropNType( pGathering );
	/// Ư -  ε mDropItemCntMap ƿ
	GatherDropSType( pGathering ); 
	if( mDropItemCntMap.GetSize() == 0 )
		return;

	///   ó
	cHashMap::cConstIterator begin = mDropItemCntMap.Begin();
	cHashMap::cConstIterator end = mDropItemCntMap.End();
	bool                     apply = false;

	for( ; begin != end ; ++begin )
	{
		unsigned long itemIdx = (*begin).mFirst;
		unsigned long itemCnt = (*begin).mSecond;

		unsigned short applyCnt = 0;
		while( applyCnt < itemCnt )
		{
			unsigned short cnt = pPlayer->ItemGetAutoPush( itemIdx, (unsigned short)itemCnt );
			if( cnt == 0 )
			{
				assert(0);
				NETWORK2->PostServerEvent("cDrop::GatherDrop item(%d,%d)->ItemGetAutoPush cnt == 0", itemIdx, itemCnt);
				break;
			}

			applyCnt = applyCnt + cnt;
			apply    = true;
		}
	}
	pPlayer->ItemGetAutoEnd( apply );

	mDropItemCntMap.Clear();
}


void cDrop::GatherDropValue( cGathering* pGathering, unsigned long playerIdx )
{
	unsigned long gatherClassIdx = pGathering->GetClassIdx();

	unsigned long maxMoney = 0;
	unsigned long minMoney = 0;
	int moneyDropPer = 0;

	///  ũƮ ä شϴ  о
	sDropNTypeGather* pDropNTypeGather = mpDropScript->GetDropNTypeGather( gatherClassIdx );
	if( pDropNTypeGather != NULL ) 
	{ 
		maxMoney = pDropNTypeGather->mMaxMoney;
		minMoney = pDropNTypeGather->mMinMoney;
		moneyDropPer = FloatToInt( pDropNTypeGather->mMoneyPercent );
	}

	/// Ȯ Ż 
	unsigned long moneyGap = maxMoney - minMoney;
	if( moneyGap > RANDOM_MAX )
	{
		NETWORK2->PostServerEvent("cDrop::GatherDropValue[%d] moneyGap > RANDOM_MAX", gatherClassIdx, moneyGap );
		moneyGap = RANDOM_MAX;
	}

	///  ݾ  
	int droprand = ( rand() % 100 ) + 1;

	///  
	unsigned long randValue = (unsigned long)( RANDOMTABLE->Get( ) * 1000000 );
	unsigned long dropMoney = 0;
	/// Ȯؼ   ΰ츸 ݾ 
	if( droprand <= moneyDropPer ) 
	{
		if( moneyGap > 0 )
			dropMoney = minMoney + ( randValue % moneyGap ); 
		else
			dropMoney = minMoney;
	}

	cPlayer* pPlayer = NULL;
	pPlayer = OBJECTMANAGER->GetPlayer( playerIdx );
	if( pPlayer == NULL )
		return;

	if( dropMoney != 0 )
		pPlayer->AddMoney( pGathering->GetObject(), dropMoney );
}


void cDrop::GatherDropNType( cGathering* pGathering )
{
	unsigned long gatherClassIdx = pGathering->GetClassIdx();

	///  ũƮ   شϴ  о 
	sDropNTypeGather* pDropNTypeGather = mpDropScript->GetDropNTypeGather( gatherClassIdx );
	if( pDropNTypeGather == NULL ) 
		return; 

	/// Ȯ 
	int droprand = ( rand() % 100 ) + 1;
	if( droprand > pDropNTypeGather->mDropPercent ) 
		return; 

	//   
	unsigned long dropCnt;

	unsigned long dropTotalPer = pDropNTypeGather->mDropClass1Per + pDropNTypeGather->mDropClass2Per + pDropNTypeGather->mDropClass3Per;

	/// Ȯ Ż  -  
	if( dropTotalPer == 0 || dropTotalPer > RANDOM_MAX )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("cDrop::DropNType dropTotalPer[%d] ERROR", dropTotalPer );
		return;
	}

	///  
	unsigned long randValue = (unsigned long)( RANDOMTABLE->Get( ) * 1000000 );

	unsigned long selectRand = ( randValue % dropTotalPer ) + 1;
	if( selectRand <= pDropNTypeGather->mDropClass1Per )
		dropCnt = pDropNTypeGather->mDropClass1Cnt;
	else if( selectRand <= pDropNTypeGather->mDropClass1Per + pDropNTypeGather->mDropClass2Per )
		dropCnt = pDropNTypeGather->mDropClass2Cnt;
	else
		dropCnt = pDropNTypeGather->mDropClass3Cnt;

	mDropItemCntMap.Clear();

	for( unsigned char i = 0 ; i < dropCnt ; ++i )
		GatherDropNTypeSelect( pDropNTypeGather );
}


void cDrop::GatherDropNTypeSelect( sDropNTypeGather* pDropNTypeGather )
{
	unsigned long totalPer = pDropNTypeGather->mItemTotalPer;

	/// Ȯ Ż  -  
	if( totalPer == 0 || totalPer > RANDOM_MAX )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("cDrop::GatherDropNTypeSelect totalPer[%d] ERROR", totalPer );
		return;
	}

	/// Լ  Ȯ ü    1 Ѵ.
	unsigned long randValue = (unsigned long)( RANDOMTABLE->Get( ) * 1000000 );
	unsigned long randnum = ( randValue % totalPer ) + 1;

	cHashMap::cIterator hashIter;

	cAry* pAry = pDropNTypeGather->mpData;
	if( pAry == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("cDrop::DropNTypeSelectGather[%d] pDropNType->mpData == NULL", pDropNTypeGather->mClassIdx );   
		return;
	}

	sDropNTypeDataGather* pData = NULL;
	///     شġ ´  ӸƮ Ѵ.
	for( unsigned long i = 0 ; i < pAry->GetSize() ; ++i )
	{
		pData = (sDropNTypeDataGather*)(*pAry)[i];
		if( pData == NULL )
		{
			assert(NULL);
			NETWORK2->PostServerEvent("cDrop::GatherDropNTypeSelect[%d] pData == NULL", pDropNTypeGather->mClassIdx );   
			return;
		}

		if( randnum <= pData->mItemPer )
		{
			/// Է ߴµ ̹ ִ ̸  + Ų
			if( mDropItemCntMap.Insert( pData->mItemIdx, pData->mItemCnt ) == false )
			{
				if( pData->mItemCnt == 0 )
				{
					assert(NULL);
					NETWORK2->PostServerEvent("cDrop::GatherDropNTypeSelect itemCnt( %d, %d ) == 0", pData->mItemCnt, pData->mItemCnt );   
					return;
				}

				hashIter = mDropItemCntMap.Find( pData->mItemIdx );
				if( hashIter == mDropItemCntMap.End() )
				{
					assert(NULL);
					NETWORK2->PostServerEvent("cDrop::GatherDropNTypeSelect hashIter == mDropItemCntMap.End()" );   
					return;
				}

				unsigned long* cnt = &(hashIter->mSecond);
				if( cnt == NULL )
				{
					assert(NULL);
					NETWORK2->PostServerEvent("GatherDropNTypeSelect itemIdx[%d] cnt == NULL", pData->mItemIdx);   
					return;
				}

				*cnt += pData->mItemCnt;
			}
			return;
		}

		randnum = randnum - pData->mItemPer;
	}

	/// ٵҴµ ̾ȵǸ 
	if( randnum <= 0 )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("DropNTypeSelect randnum <= 0");        
	}
}


void cDrop::GatherDropSType( cGathering* pGathering )
{
	unsigned long gatherClassIdx = pGathering->GetClassIdx();

	sDropSTypeGather* pDropSTypeGather = DROPSCRIPT->GetDropSTypeGather( gatherClassIdx );
	if( pDropSTypeGather == NULL )
		return;

	unsigned long accunTime = NETWORK2->GetAccumTime();

	///  Ȯ üũ
	unsigned long randvalue = (unsigned long)( RANDOMTABLE->Get( ) * 1000000 );
	unsigned long randSelect = ( randvalue % 100 ) + 1;
	if( pDropSTypeGather->mDropPercent < randSelect )
		return;

	float totalPer = pDropSTypeGather->mItemTotalPer * DROP_PER_FLOAT_CONVERT;

	/// Ȯ Ż  -  
	if( totalPer == 0 || totalPer > RANDOM_MAX )
	{
		NETWORK2->PostServerEvent("cDrop::GatherDropSType[%d] totalPer[%d] ERROR", pDropSTypeGather->mIdx, totalPer );
		return;
	}

	/// 100%̻   ǰ
	/// 100%̸ ΰ Ȯ   Ѱ  
	if( totalPer < 100.0f * DROP_PER_FLOAT_CONVERT )
		totalPer = 100.0f * DROP_PER_FLOAT_CONVERT;

	///  
	randvalue = (unsigned long)( RANDOMTABLE->Get( ) * 1000000 );

	/// Լ  Ȯ ü Ȯ   1 Ѵ.
	unsigned long randnum = ( randvalue % (unsigned long)totalPer ) + 1;

	cAry* pAry = pDropSTypeGather->mpData;
	if( pAry == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("cDrop::GatherDropSType[%d] pAry == NULL", pDropSTypeGather->mIdx );   
		return;
	}

	cHashMap::cIterator hashIter;
	sDropSWTypeData* pData = NULL;
	///     شġ ´  ӸƮ Ѵ.
	for( unsigned long i = 0 ; i < pAry->GetSize() ; ++i )
	{
		pData = (sDropSTypeDataGather*)(*pAry)[i];
		if( pData == NULL )
		{
			assert(NULL);
			NETWORK2->PostServerEvent("cDrop::GatherDropSType[%d] pData == NULL", pDropSTypeGather->mIdx );   
			return;
		}

		/// õ   Ȯ ɸ
		if( randnum <= pData->mItemPer * DROP_PER_FLOAT_CONVERT )
		{
			/// ߰ Ȯ 
			if( pData->mEnoughCntNow < pData->mEnoughCnt )
				++pData->mEnoughCntNow;

			/// ð  ǿ ɸ
			if( pData->mEnoughTimeEnd > accunTime )
				return;

			/// ߰ Ȯ  
			randvalue = (unsigned long)( RANDOMTABLE->Get( ) * 1000000 );
			randSelect = ( randvalue % pData->mEnoughCnt ) + 1;
			if( pData->mEnoughCntNow < randSelect )
				return;

			/// Է ߴµ ̹ ִ ̸  + Ų
			if( mDropItemCntMap.Insert( pData->mItemIdx, pData->mItemCnt ) == false )
			{
				if( pData->mItemCnt == 0 )
				{
					assert(NULL);
					NETWORK2->PostServerEvent("cDrop::GatherDropSType itemCnt( %d, %d ) == 0", pData->mItemIdx, pData->mItemCnt );   
					return;
				}

				hashIter = mDropItemCntMap.Find( pData->mItemIdx );
				if( hashIter == mDropItemCntMap.End() )
				{
					assert(NULL);
					NETWORK2->PostServerEvent("cDrop::GatherDropSType hashIter == mDropItemCntMap.End()" );   
					return;
				}

				unsigned long* cnt = &(hashIter->mSecond);
				if( cnt == NULL )
				{
					assert(NULL);
					NETWORK2->PostServerEvent("cDrop::GatherDropSType itemIdx cnt == NULL", pData->mItemIdx );   
					return;
				}

				*cnt += pData->mItemCnt;
			}

			///  Ȱ  Ʈ
			pData->mEnoughCntNow = 0;
			pData->mEnoughTimeEnd = accunTime + pData->mEnoughTime;

			return;
		}

		randnum = randnum - FloatToInt( pData->mItemPer * DROP_PER_FLOAT_CONVERT );
	}
}


void cDrop::GatherDropQType( cGathering* pGathering, unsigned long playerIdx )
{
	unsigned long gatherClassIdx = pGathering->GetClassIdx();

	TB_QUEST_PROGRESS* pQuest = NULL;
	cAry* pAry = NULL;
	sDropQType* pDropQ = NULL;
	unsigned long selectRand = 0;
	unsigned long dropNeedCnt = 0;

	cPlayer* pPlayer = OBJECTMANAGER->GetPlayer( playerIdx );
	if( pPlayer == NULL )
		return;

	/// Ʈ ü ˻
	for( unsigned long i = 0 ; i < MAX_KEEPQUEST ; ++i )
	{
		/// Ʈ  ε
		pQuest = pPlayer->GetQuest( i );
		if( pQuest == NULL )
			break;

		if( pQuest->idx == 0 )
			return;

		cQuestDefine* questDefine = QUESTMAN->GetQuestDefine( pQuest->questIdx );
		if( !questDefine )
		{
			assert(NULL);
			NETWORK2->PostServerEvent("GatherDropQType questDefine[%d] == NULL", pQuest->questIdx );
			return;
		}

		/// Ʈ   üũ
		if( pQuest->check >= questDefine->mComplete )
			continue;

		/// Ͱ ÷̾ Ʈ شϴ Ӿ  о
		pAry = DROPSCRIPT->GetDropQtypeGather( gatherClassIdx, pQuest->questIdx );
		if( pAry == NULL )
			continue;

		///   
		for( unsigned long itemI = 0 ; itemI < pAry->GetSize() ; ++itemI )
		{
			pDropQ = (sDropQTypeGather*)(*pAry)[itemI];

			if( pDropQ == NULL )
			{
				assert(NULL);
				NETWORK2->PostServerEvent("GatherDropQType pDropQ == NULL [%d]", itemI );
				continue;
			}

			///  Ȯ 
			unsigned long randvalue = (unsigned long)( RANDOMTABLE->Get( ) * 1000000 );
			selectRand = ( randvalue % 100 ) + 1;
			if( selectRand > pDropQ->mDropPer )
				continue;

			///  ʿ  Ȯ
			dropNeedCnt = pPlayer->GetDropItemCount( i, pDropQ->mItemIdx );
			if( dropNeedCnt == 0 )
				continue;

			/// Ʈ  ˻ -  ˻
			if( pPlayer->IsEquipQuestItem( pQuest->questIdx ) == false )
				continue;

			/// ÷̾ ڵ 
			if( pPlayer->ItemGetQuest( pDropQ->mItemIdx, 1 ) == true )
			{
				/// Ʈ    Ʈ
				pPlayer->UpdateDutyItem();
			}
			else
			{
				assert(NULL);
				NETWORK2->PostServerEvent("Drop::GatherDropQType ItemGetQuest[%d] ERROR", pDropQ->mItemIdx );
			}
		}
	}
}
