#include "gamesrv.h"

#include "StdAfx.h"
#include "DropScript.h"
#include "Drop_Common.h"
#include "GameFile.h"
#include "AppTimer.h"
#include "FileLoader.h"
#include "Tokenizer.h"
#include "MonsterScript.h"
#include "Monster_Common.h"


cDropScript* cDropScript::mpDropScript = NULL;



cDropScript::cDropScript(void)
{
	/// ̱
	if( mpDropScript )
	{
		Verbose->WriteLog( "DropScript new error");
	}
	else
	{
		mpDropScript = this;
	}

}


bool cDropScript::Init()
{

	mpDropNTypeMap = new cPointrHashMap( 100 );
	mpDropSTypeMap = new cPointrHashMap( 100 );
	mpDropWTypeMap = new cPointrHashMap( 100 );
	mpDropExpIncreaseMap = new cDropExpIncrease( 20 );
	mpDropNTypeGatherMap = new cPointrHashMap( 100 );
	mpDropSTypeGatherMap = new cPointrHashMap( 100 );

	/// Ƽο ġ 
	if( !LoadPartyExpIncrease() )
		return false;

	/// NŸ   ε
	if( !LoadDropNType() )
		return false;

	/// SŸ   ε
	if( !LoadDropSType() )
		return false;

	/// Ÿ   ε
	if( !LoadDropWType() )
		return false;

	if( LoadDropQType() == false )
		return false;

	///   ġ ε
	if( !LoadDropExpIncrease() )
		return false;

	/// ä
	if( !LoadDropNTypeGather() )
		return false;
	if( !LoadDropSTypeGather() )
		return false;
	if( !LoadDropQTypeGather() )
		return false;
	
	return true;

}



void cDropScript::Release()
{

	sPartyExp* pInfo = NULL;
	cPointrHashMap::cIterator i = mPartyExpIncrease.Begin();
	cPointrHashMap::cIterator end = mPartyExpIncrease.End();
	for( ; i != end; ++i )
	{
		pInfo = (sPartyExp*)((*i).mSecond);
		if( pInfo )
		{
			delete pInfo;
		}
	}
	mPartyExpIncrease.Clear();

	if( mpDropNTypeGatherMap )
	{
		sDropNTypeGather* pInfo = NULL;
		cAry* pInfoDataAry = NULL;
		sDropNTypeDataGather* pData = NULL;
		cPointrHashMap::cIterator i = mpDropNTypeGatherMap->Begin();
		cPointrHashMap::cIterator end = mpDropNTypeGatherMap->End();
		for( ; i != end; ++i )
		{
			pInfo = (sDropNTypeGather*)((*i).mSecond);
			if( pInfo == NULL)
				continue;

			pInfoDataAry = pInfo->mpData;
			if( pInfoDataAry == NULL )
				continue;

			for( unsigned long j = 0 ; j < pInfoDataAry->GetSize() ; ++j )
			{
				pData = (sDropNTypeDataGather*)(*pInfoDataAry)[j];
				delete pData;
			}
			pInfoDataAry->Clear();
			SAFE_DELETE( pInfoDataAry );
			SAFE_DELETE( pInfo );
		}
		mpDropNTypeGatherMap->Clear();
		SAFE_DELETE( mpDropNTypeGatherMap );
	}

	if( mpDropSTypeGatherMap )
	{
		sDropSTypeGather* pInfo = NULL;
		cAry* pInfoDataAry = NULL;
		sDropSTypeDataGather* pData = NULL;
		cPointrHashMap::cIterator i = mpDropSTypeGatherMap->Begin();
		cPointrHashMap::cIterator end = mpDropSTypeGatherMap->End();
		for( ; i != end; ++i )
		{
			pInfo = (sDropSTypeGather*)((*i).mSecond);
			if( pInfo == NULL)
				continue;

			pInfoDataAry = pInfo->mpData;
			if( pInfoDataAry == NULL )
				continue;

			for( unsigned long j = 0 ; j < pInfoDataAry->GetSize() ; ++j )
			{
				pData = (sDropSTypeDataGather*)(*pInfoDataAry)[j];
				delete pData;
			}
			pInfoDataAry->Clear();
			SAFE_DELETE( pInfoDataAry );
			SAFE_DELETE( pInfo );
		}
		mpDropSTypeGatherMap->Clear();
		SAFE_DELETE( mpDropSTypeGatherMap );
	}
	//

	if( mpDropNTypeMap )
	{
		sDropNType* pInfo = NULL;
		cAry* pInfoDataAry = NULL;
		sDropNTypeData* pData = NULL;
		cPointrHashMap::cIterator i = mpDropNTypeMap->Begin();
		cPointrHashMap::cIterator end = mpDropNTypeMap->End();
		for( ; i != end; ++i )
		{
			pInfo = (sDropNType*)((*i).mSecond);
			if( pInfo == NULL)
				continue;

			pInfoDataAry = pInfo->mpData;
			if( pInfoDataAry == NULL )
				continue;

			for( unsigned long j = 0 ; j < pInfoDataAry->GetSize() ; ++j )
			{
				pData = (sDropNTypeData*)(*pInfoDataAry)[j];
				delete pData;
			}
			pInfoDataAry->Clear();
			SAFE_DELETE( pInfoDataAry );
			SAFE_DELETE( pInfo );
		}
		mpDropNTypeMap->Clear();
		SAFE_DELETE( mpDropNTypeMap );
	}

	if( mpDropSTypeMap )
	{
		sDropSWType* pInfo = NULL;
		cAry* pInfoDataAry = NULL;
		sDropSWTypeData* pData = NULL;
		cPointrHashMap::cIterator i = mpDropSTypeMap->Begin();
		cPointrHashMap::cIterator end = mpDropSTypeMap->End();
		for( ; i != end; ++i )
		{
			pInfo = (sDropSWType*)((*i).mSecond);
			if( pInfo == NULL)
				continue;

			pInfoDataAry = pInfo->mpData;
			if( pInfoDataAry == NULL )
				continue;

			for( unsigned long j = 0 ; j < pInfoDataAry->GetSize() ; ++j )
			{
				pData = (sDropSWTypeData*)(*pInfoDataAry)[j];
				delete pData;
			}
			pInfoDataAry->Clear();
			SAFE_DELETE( pInfoDataAry );
			SAFE_DELETE( pInfo );
		}
		mpDropSTypeMap->Clear();
		SAFE_DELETE( mpDropSTypeMap );
	}

	mpDropExpIncreaseMap->Clear();
	SAFE_DELETE( mpDropExpIncreaseMap );

	sDropSWType* pInfo2 = NULL;
	cAry* pInfoDataAry = NULL;
	sDropSWTypeData* pData = NULL;
	for( unsigned long i = 0 ; i < mpShutDownDeleteWAry.GetSize() ; ++i )
	{
		pInfo2 = (sDropSWType*)mpShutDownDeleteWAry[i];
		if( pInfo2 == NULL )
			continue;

		pInfoDataAry = pInfo2->mpData;
		if( pInfoDataAry == NULL )
			continue;

		for( unsigned long j = 0 ; j < pInfoDataAry->GetSize() ; ++j )
		{
			pData = (sDropSWTypeData*)(*pInfoDataAry)[j];
			delete pData;
		}
		pInfoDataAry->Clear();
		SAFE_DELETE( pInfoDataAry );
		SAFE_DELETE( pInfo2 );
	}
	mpShutDownDeleteWAry.Clear();

	if( mpDropWTypeMap )
	{
		cAry* pAry = NULL;
		cPointrHashMap::cIterator i = mpDropWTypeMap->Begin();
		cPointrHashMap::cIterator end = mpDropWTypeMap->End();
		for( ; i != end; ++i )
		{
			pAry = (cAry*)((*i).mSecond);
			if( pAry == NULL )
				continue;

			for( unsigned long i = 0 ; i < pAry->GetSize() ; ++i )
                delete (*pAry)[i];

			pAry->Clear();
			SAFE_DELETE( pAry );
		}

		mpDropWTypeMap->Clear();
		SAFE_DELETE( mpDropWTypeMap );
	}

}



bool cDropScript::LoadDropNType()
{

	cFileLoader loader;
	cString pathName = "./Script/resource/Item_DropN.txt";

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load Item_DropN.txt" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	while( tokenizer.IsEnd() == false )
	{

		///  
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long classIdx = str.ToInt();	

		///  Ȯ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		float moneyPercent = str.ToFloat();					

		///   ּ ݾ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long minMoney = str.ToInt();						

		///   ִ ݾ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long maxMoney = str.ToInt();						

		///  Ȯ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		float dropPercent = str.ToFloat();

		///   1
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long dropClass1Cnt = str.ToInt();					

		///   1 Ȯ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long dropClass1Per = str.ToInt();					

		///   2
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long dropClass2Cnt = str.ToInt();					

		///   2 Ȯ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long dropClass2Per = str.ToInt();					

		///   3
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long dropClass3Cnt = str.ToInt();					

		///   3 Ȯ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long dropClass3Per = str.ToInt();					

		sDropNType* pList = new sDropNType;

		pList->mClassIdx = classIdx;	
		pList->mMoneyPercent = moneyPercent;
		pList->mMinMoney = minMoney;
		pList->mMaxMoney = maxMoney;
		pList->mDropPercent = dropPercent;
		pList->mDropClass1Cnt = dropClass1Cnt;
		pList->mDropClass1Per = dropClass1Per;
		pList->mDropClass2Cnt = dropClass2Cnt;
		pList->mDropClass2Per = dropClass2Per;
		pList->mDropClass3Cnt = dropClass3Cnt;
		pList->mDropClass3Per = dropClass3Per;

		pList->mItemTotalPer = 0;
		cAry* pAry = new cAry;
		pList->mpData = pAry;

		/// ؽ   
		if( mpDropNTypeMap->Insert( pList->mClassIdx, pList ) == false )
		{
			assert(NULL);
			return false;
		}
	}

	return LoadDropNTypeData();
}


bool cDropScript::LoadDropNTypeData()
{
	cFileLoader loader;
	cString pathName = "./Script/resource/Item_DropNData.txt";

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load Item_DropNData.txt" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	sDropNType* pHead;
	while( tokenizer.IsEnd() == false )
	{
		///  
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long monsterClassIdx = str.ToInt();	

		///  Idx
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long itemIdx = str.ToInt();

		/// Ȯ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long itemPer = str.ToInt();

		/// 
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long itemCnt = str.ToInt();

		sDropNTypeData* pList = new sDropNTypeData;

		pList->mItemIdx = itemIdx;
		pList->mItemPer = itemPer;
		pList->mItemCnt = itemCnt;

		pHead = (sDropNType*)mpDropNTypeMap->GetAt( monsterClassIdx );
		if( pHead == NULL )
		{
			assert(NULL);
			return false;
		}

		cAry* pAry = pHead->mpData;
		if( pAry == NULL )
		{
			assert(NULL);
			return false;
		}

		pAry->PushBack( pList );
		pHead->mItemTotalPer = pHead->mItemTotalPer + itemPer;
	}

	return true;
}


sDropNType* cDropScript::GetDropNType( unsigned long idx )
{
	sDropNType*	pDropNType;
	pDropNType = (sDropNType*)mpDropNTypeMap->GetAt( idx );

	if( !pDropNType )
	{
		return NULL;
	}

	return pDropNType;
}


bool cDropScript::LoadDropSType()
{

	cFileLoader loader;
	cString pathName = "./Script/resource/Item_DropS.txt";

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load Item_DropS.txt" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	while( tokenizer.IsEnd() == false )
	{

		///  
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long monsterClassIdx = str.ToInt();	

		///   Ȯ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		float dropPercent = str.ToFloat();					

		sDropSWType* pList = new sDropSWType;

		pList->mIdx = monsterClassIdx;
		pList->mDropPercent = dropPercent;	

		pList->mItemTotalPer = 0;
		cAry* pAry = new cAry;
		pList->mpData = pAry;

		/// ؽ   
		if( mpDropSTypeMap->Insert( monsterClassIdx, pList ) == false )
		{
			assert(NULL);
			return false;
		}
	}

	return LoadDropSTypeData();
}


bool cDropScript::LoadDropSTypeData()
{

	cFileLoader loader;
	cString pathName = "./Script/resource/Item_DropSData.txt";

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load Item_DropSData.txt" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	sDropSWType* pHead;
	while( tokenizer.IsEnd() == false )
	{
		///  
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long monsterClassIdx = str.ToInt();	

		///  Idx
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long itemIdx = str.ToInt();

		/// Ȯ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		float itemPer = str.ToFloat();

		/// 
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long itemCnt = str.ToInt();

		///  Ȯ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long enoughCnt = str.ToInt();

		/// ð 
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long enoughTime = str.ToInt();

		sDropSWTypeData* pList = new sDropSWTypeData;

		pList->mIdx = monsterClassIdx;
		pList->mItemIdx = itemIdx;
		pList->mItemPer = itemPer;
		pList->mItemCnt = itemCnt;
		pList->mEnoughCnt = enoughCnt;
		pList->mEnoughTime = enoughTime;
		pList->mEnoughCntNow = 0;
		pList->mEnoughTimeEnd = 0;

		pHead = (sDropSWType*)mpDropSTypeMap->GetAt( monsterClassIdx );
		if( pHead == NULL )
		{
			assert(NULL);
			return false;
		}

		cAry* pAry = pHead->mpData;
		if( pAry == NULL )
		{
			assert(NULL);
			return false;
		}

		pAry->PushBack( pList );
		pHead->mItemTotalPer = pHead->mItemTotalPer + itemPer;
	}

	return true;
}


sDropSWType* cDropScript::GetDropSType( unsigned long monsterClassIdx )
{
	sDropSWType* pDropSType;
	pDropSType = (sDropSWType*)mpDropSTypeMap->GetAt( monsterClassIdx );

	if( !pDropSType )
	{
		return NULL;
	}

	return pDropSType;
}


bool cDropScript::LoadDropWType()
{

	if( LoadDropWTypeData() == false )
		return false;

	cFileLoader loader;
	cString pathName = "./Script/resource/Item_DropW.txt";

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load Item_DropW.txt" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	cAry* pHeadAry = NULL;
	while( tokenizer.IsEnd() == false )
	{
		///  ε - Item_DropWData ϰ ܼ   Ϸùȣ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long wIdx  = str.ToInt();

		///  ּҷ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned char monsterLvMin = (unsigned char)str.ToInt();

		///  ִ뷹
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned char monsterLvMax = (unsigned char)str.ToInt();

		///  
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned char monsterType = (unsigned char)str.ToInt();

		///   Ȯ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		float dropPercent = str.ToFloat();					

		/// ũƮ (,Ÿ ) ߰Ȯ, ߰ð Բ óȴ
		sDropSWType* pList = new sDropSWType;

		pList->mIdx = wIdx;
		pList->mDropPercent = dropPercent;	
		pList->mItemTotalPer = 0;
		pList->mpData = new cAry;

		sDropSWTypeData* pData;
		for( unsigned long i = 0 ; i < mpTempWData.GetSize() ; ++i )
		{
			pData = (sDropSWTypeData*)mpTempWData[i];
			if( pData == NULL )
			{
				assert(NULL);
				return false;
			}

			if( pData->mIdx == wIdx )
			{
				pList->mpData->PushBack( pData );
				pList->mItemTotalPer = pList->mItemTotalPer + pData->mItemPer;
			}
		}

		mpShutDownDeleteWAry.PushBack( pList );

		sDropWTypeLink* pWTypeLink = NULL;
		pHeadAry = NULL;

		for( unsigned char level = monsterLvMin ; level <= monsterLvMax ; ++level )
		{
			pHeadAry =(cAry*)mpDropWTypeMap->GetAt( level );
			if( pHeadAry == NULL )
			{
				pHeadAry = new cAry;

				/// ؽ   
				if( mpDropWTypeMap->Insert( level, pHeadAry ) == false )
				{
					assert(NULL);
					return false;
				}
			}

			pWTypeLink = new sDropWTypeLink;
			pWTypeLink->mMonsterType = monsterType;
			pWTypeLink->mpWType = pList;

			pHeadAry->PushBack( pWTypeLink );
		}
	}
	mpTempWData.Clear();

	return true;
}


bool cDropScript::LoadDropWTypeData()
{

	cFileLoader loader;
	cString pathName = "./Script/resource/Item_DropWData.txt";

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load Item_DropWData.txt" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	cPointrHashMap::cIterator headBegin;
	cPointrHashMap::cIterator headEnd;

	while( tokenizer.IsEnd() == false )
	{
		///  ε
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long wIdx = str.ToInt();	

		///  Idx
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long itemIdx = str.ToInt();

		/// Ȯ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		float itemPer = str.ToFloat();

		/// 
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long itemCnt = str.ToInt();

		///  Ȯ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long enoughCnt = str.ToInt();

		/// ð 
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long enoughTime = str.ToInt();

		sDropSWTypeData* pList = new sDropSWTypeData;

		pList->mIdx = wIdx;
		pList->mItemIdx = itemIdx;
		pList->mItemPer = itemPer;
		pList->mItemCnt = itemCnt;
		pList->mEnoughCnt = enoughCnt;
		pList->mEnoughTime = enoughTime;
		pList->mEnoughCntNow = 0;
		pList->mEnoughTimeEnd = 0;

		mpTempWData.PushBack( pList );
	}

	return true;
}


tArray<void*>* cDropScript::GetDropWType( unsigned long monsterLv )
{
	return (cAry*)mpDropWTypeMap->GetAt( monsterLv );
}


bool cDropScript::LoadDropQType()
{
	cFileLoader loader;
	cString pathName = "./Script/Resource/Item_DropQ.txt";

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load Item_DropQ.txt" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	sMonsterScript* pMonsterScript = NULL;
	///  ũƮ ǵ Ʈ۵ ؽ  
	cPointrHashMap** pMap = NULL;
	cAry* pAry = NULL;
	sDropQType* pList = NULL;

	while( tokenizer.IsEnd() == false )
	{
		/// Ʈ ȣ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long questIdx = str.ToInt();

		///   index
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long monsterClassIdx = str.ToInt();

		///  index
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long itemIdx = str.ToInt();

		///  Ȯ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long dropPer = str.ToInt();

		/// ش ͸ ã Ʈ   ִ´.
		pMonsterScript = MONSTERSCRIPT->GetMonsterListInfo( monsterClassIdx );
		if( pMonsterScript == NULL )
			return false;

		/// Ʈ ε Űϴ ؽ  .
		pMap = &((cPointrHashMap*)pMonsterScript->mpQuestItemDropMap);
		if( *pMap == NULL )
			*pMap = new cPointrHashMap( 999 );

		/// Ʈ ε Űϴ ؽʿ  item  ߰Ѵ.
		pAry = (cAry*)((*pMap)->GetAt( questIdx ));
		if( pAry == NULL )
		{
			pAry = new cAry;
			if( (*pMap)->Insert( questIdx, pAry ) == false )
				return false;
		}

		/// Ʈ    Ʈó
		pList = new sDropQType;

		pList->mItemIdx = itemIdx;
		pList->mDropPer = dropPer;

		pAry->PushBack( pList );
	}

	return true;
}



tArray<void*>* cDropScript::GetDropQtype( unsigned long monsterClassIdx, unsigned long questIdx )
{
	sMonsterScript* pMonsterScript = MONSTERSCRIPT->GetMonsterListInfo( monsterClassIdx );
	if( pMonsterScript == NULL )
		return NULL;

	cPointrHashMap* pMap = (cPointrHashMap*)pMonsterScript->mpQuestItemDropMap;
	if( pMap == NULL )
		return NULL;

	cAry* pAry = (cAry*)pMap->GetAt( questIdx );

	return pAry;
}


bool cDropScript::LoadDropNTypeGather()
{
	cFileLoader loader;
	cString pathName = "./Script/resource/item_gatheringn.txt";

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load item_gatheringn.txt" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	while( tokenizer.IsEnd() == false )
	{
		
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long classIdx = str.ToInt();	

		///  Ȯ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		float moneyPercent = str.ToFloat();					

		///   ּ ݾ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long minMoney = str.ToInt();						

		///   ִ ݾ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long maxMoney = str.ToInt();						

		///  Ȯ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		float dropPercent = str.ToFloat();

		///   1
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long dropClass1Cnt = str.ToInt();					

		///   1 Ȯ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long dropClass1Per = str.ToInt();					

		///   2
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long dropClass2Cnt = str.ToInt();					

		///   2 Ȯ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long dropClass2Per = str.ToInt();					

		///   3
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long dropClass3Cnt = str.ToInt();					

		///   3 Ȯ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long dropClass3Per = str.ToInt();					

		sDropNTypeGather* pList = new sDropNTypeGather;

		pList->mClassIdx = classIdx;	
		pList->mMoneyPercent = moneyPercent;
		pList->mMinMoney = minMoney;
		pList->mMaxMoney = maxMoney;
		pList->mDropPercent = dropPercent;
		pList->mDropClass1Cnt = dropClass1Cnt;
		pList->mDropClass1Per = dropClass1Per;
		pList->mDropClass2Cnt = dropClass2Cnt;
		pList->mDropClass2Per = dropClass2Per;
		pList->mDropClass3Cnt = dropClass3Cnt;
		pList->mDropClass3Per = dropClass3Per;

		pList->mItemTotalPer = 0;
		cAry* pAry = new cAry;
		pList->mpData = pAry;

		/// ؽ 
		if( mpDropNTypeGatherMap->Insert( pList->mClassIdx, pList ) == false )
		{
			assert(NULL);
			return false;
		}
	}

	return LoadDropNTypeDataGather();
}



bool cDropScript::LoadDropNTypeDataGather()
{
	cFileLoader loader;
	cString pathName = "./Script/resource/item_gatheringndata.txt";

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load item_gatheringndata.txt" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	sDropNTypeGather* pHead;
	while( tokenizer.IsEnd() == false )
	{
		/// Idx
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long classIdx = str.ToInt();	

		///  Idx
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long itemIdx = str.ToInt();

		/// Ȯ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long itemPer = str.ToInt();

		/// 
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long itemCnt = str.ToInt();

		sDropNTypeDataGather* pList = new sDropNTypeDataGather;

		pList->mItemIdx = itemIdx;
		pList->mItemPer = itemPer;
		pList->mItemCnt = itemCnt;

		pHead = (sDropNTypeGather*)mpDropNTypeGatherMap->GetAt( classIdx );
		if( pHead == NULL )
		{
			assert(NULL);
			return false;
		}

		cAry* pAry = pHead->mpData;
		if( pAry == NULL )
		{
			assert(NULL);
			return false;
		}

		pAry->PushBack( pList );
		pHead->mItemTotalPer = pHead->mItemTotalPer + itemPer;
	}

	return true;
}


sDropNTypeGather* cDropScript::GetDropNTypeGather( unsigned long idx )
{
	sDropNTypeGather*	pDropNTypeGather;
	pDropNTypeGather = (sDropNTypeGather*)mpDropNTypeGatherMap->GetAt( idx );

	if( !pDropNTypeGather )
	{
		return NULL;
	}

	return pDropNTypeGather;
}


bool cDropScript::LoadDropSTypeGather()
{

	cFileLoader loader;
	cString pathName = "./Script/resource/item_gatherings.txt";

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load item_gatherings.txt" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	while( tokenizer.IsEnd() == false )
	{

		/// IDX
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long classIdx = str.ToInt();	

		///   Ȯ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		float dropPercent = str.ToFloat();					

		sDropSTypeGather* pList = new sDropSTypeGather;

		pList->mIdx = classIdx;
		pList->mDropPercent = dropPercent;	

		pList->mItemTotalPer = 0;
		cAry* pAry = new cAry;
		pList->mpData = pAry;

		/// ؽ 
		if( mpDropSTypeGatherMap->Insert( classIdx, pList ) == false )
		{
			assert(NULL);
			return false;
		}
	}

	return LoadDropSTypeDataGather();
}


bool cDropScript::LoadDropSTypeDataGather()
{

	cFileLoader loader;
	cString pathName = "./Script/resource/item_gatheringsdata.txt";

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load item_gatheringsdata.txt" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	sDropSTypeGather* pHead;
	while( tokenizer.IsEnd() == false )
	{
		/// 
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long classIdx = str.ToInt();	

		///  Idx
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long itemIdx = str.ToInt();

		/// Ȯ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		float itemPer = str.ToFloat();

		/// 
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long itemCnt = str.ToInt();

		///  Ȯ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long enoughCnt = str.ToInt();

		/// ð 
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long enoughTime = str.ToInt();

		sDropSTypeDataGather* pList = new sDropSTypeDataGather;

		pList->mIdx = classIdx;
		pList->mItemIdx = itemIdx;
		pList->mItemPer = itemPer;
		pList->mItemCnt = itemCnt;
		pList->mEnoughCnt = enoughCnt;
		pList->mEnoughTime = enoughTime;
		pList->mEnoughCntNow = 0;
		pList->mEnoughTimeEnd = 0;

		pHead = (sDropSTypeGather*)mpDropSTypeGatherMap->GetAt( classIdx );
		if( pHead == NULL )
		{
			assert(NULL);
			return false;
		}

		cAry* pAry = pHead->mpData;
		if( pAry == NULL )
		{
			assert(NULL);
			return false;
		}

		pAry->PushBack( pList );
		pHead->mItemTotalPer = pHead->mItemTotalPer + itemPer;
	}

	return true;
}


sDropSTypeGather* cDropScript::GetDropSTypeGather( unsigned long classIdx )
{
	sDropSTypeGather* pDropSTypeGather;
	pDropSTypeGather = (sDropSTypeGather*)mpDropSTypeGatherMap->GetAt( classIdx );

	if( !pDropSTypeGather )
	{
		return NULL;
	}

	return pDropSTypeGather;
}


bool cDropScript::LoadDropQTypeGather()
{
	cFileLoader loader;
	cString pathName = "./Script/Resource/item_gatheringq.txt";

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load item_gatheringq.txt" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	sGatheringList* pGatheringInfo = NULL;
	/// ä ũƮ ǵ Ʈ۵ ؽ  
	cPointrHashMap** pMap = NULL;
	cAry* pAry = NULL;
	sDropQTypeGather* pList = NULL;

	while( tokenizer.IsEnd() == false )
	{
		/// Ʈ ȣ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long questIdx = str.ToInt();

		///  index
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long classIdx = str.ToInt();

		///  index
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long itemIdx = str.ToInt();

		///  Ȯ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long dropPer = str.ToInt();

		/// ش äƮ ã Ʈ   ִ´.
		pGatheringInfo = GATHERINGSCRIPT->GetGatheringInfo( classIdx );
		if( pGatheringInfo == NULL )
			return false;

		/// Ʈ ε Űϴ ؽ  .
		pMap = &((cPointrHashMap*)pGatheringInfo->mpQuestItemDropMap);
		if( *pMap == NULL )
			*pMap = new cPointrHashMap( 999 );

		/// Ʈ ε Űϴ ؽʿ  item  ߰Ѵ.
		pAry = (cAry*)((*pMap)->GetAt( questIdx ));
		if( pAry == NULL )
		{
			pAry = new cAry;
			if( (*pMap)->Insert( questIdx, pAry ) == false )
				return false;
		}

		/// Ʈ    Ʈó
		pList = new sDropQTypeGather;

		pList->mItemIdx = itemIdx;
		pList->mDropPer = dropPer;

		pAry->PushBack( pList );
	}

	return true;
}



tArray<void*>* cDropScript::GetDropQtypeGather( unsigned long classIdx, unsigned long questIdx )
{
	sGatheringList* pGatheringInfo = GATHERINGSCRIPT->GetGatheringInfo( classIdx );
	if( pGatheringInfo == NULL )
		return NULL;

	cPointrHashMap* pMap = (cPointrHashMap*)pGatheringInfo->mpQuestItemDropMap;
	if( pMap == NULL )
		return NULL;

	cAry* pAry = (cAry*)pMap->GetAt( questIdx );

	return pAry;
}


bool cDropScript::LoadDropExpIncrease()
{
	cFileLoader loader;
	cString pathName = "./Script/Resource/DropExpIncrease.txt";

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load DropExpIncrease.txt" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	mScriptMinLevelDifferent = 0;
	mScriptMaxLevelDifferent = 0;

	char levelDifference = 0;
	float expIncrease = 0;

	while( tokenizer.IsEnd() == false )
	{
		/// 
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		levelDifference = (unsigned char)str.ToInt();

		/// ġ ġ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		expIncrease = str.ToFloat();

		/// ؽ   
		if( mpDropExpIncreaseMap->Insert( levelDifference, expIncrease ) == NULL )
		{
			assert(0);
			return false;
		}

		/// ּ,ִ밪 
		if( mScriptMinLevelDifferent > levelDifference )	{ mScriptMinLevelDifferent = levelDifference; }
		if( mScriptMaxLevelDifferent < levelDifference )	{ mScriptMaxLevelDifferent = levelDifference; }

	}

	return true;

}



float cDropScript::GetDropExpIncrease( char levelDifference )
{

	cDropExpIncrease::cIterator key = mpDropExpIncreaseMap->Find( levelDifference );
	cDropExpIncrease::cIterator end = mpDropExpIncreaseMap->End();

	if( key == end )
	{
		return 0.0f;
	}

	return (*key).mSecond;
}



bool cDropScript::LoadPartyExpIncrease()
{

	cFileLoader loader;
	cString pathName = "./Script/Resource/Party_Exp.txt";

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load Party_Exp.txt" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	while( tokenizer.IsEnd() == false )
	{
		/// Ƽ ο
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned char partyMemberCnt = (unsigned char)str.ToInt();	

		/// exp ġ 
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		float expIncrease = str.ToFloat();

		/// sxp ġ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		float sxpIncrease = str.ToFloat();	

		sPartyExp* pList = new sPartyExp;

		pList->mPartyMemberCnt = partyMemberCnt;	
		pList->mExpIncrease = expIncrease / 100.0f;	
		pList->mSxpIncrease = sxpIncrease / 100.0f;	

		/// ؽ   
		if( mPartyExpIncrease.Insert( partyMemberCnt, pList ) == false )
		{
			return false;
		}
	}

	return true;

}



float cDropScript::GetPartyExpIncrease( unsigned char partyMemberCnt )
{
	cPointrHashMap::cIterator key = mPartyExpIncrease.Find( partyMemberCnt );
	cPointrHashMap::cIterator end = mPartyExpIncrease.End();

	if( key == end )
	{
		return 0.0f;
	}

	sPartyExp* pPartyExp = (sPartyExp*)((*key).mSecond);
	return pPartyExp->mExpIncrease;
}



float cDropScript::GetPartySxpIncrease( unsigned char partyMemberCnt )
{
	cPointrHashMap::cIterator key = mPartyExpIncrease.Find( partyMemberCnt );
	cPointrHashMap::cIterator end = mPartyExpIncrease.End();

	if( key == end )
	{
		return 0.0f;
	}

	sPartyExp* pPartyExp = (sPartyExp*)((*key).mSecond);
	return pPartyExp->mSxpIncrease;
}