/* ==========================================================================
*      : DuelManager.h
*      :  ý - 
*    : ڰ
*    : 2008-04-23
* ǻ :
*===========================================================================*/
#pragma once
#include "DuelObject.h"
#include "Duel_Common.h"

class cDuelManager
{
public:

	static cDuelManager* mpDuelManager;

public:

	cDuelManager();
	~cDuelManager();

	bool				Init();
	void				Release();
	void				Process( unsigned long elapsedTime, unsigned long accumTime );

	/// pool ó
	cDuelObject*		AllocDuelObject() { return mDuelObjectPool.Alloc(); }
	void				FreeDuelObject(cDuelObject* ptr) { mDuelObjectPool.Free(ptr); }

	///  û   üũ
	int					ReqDuel( unsigned long attackerIdx, unsigned long targetIdx );
	bool				IsDuel( cPlayer* pAttacker, cPlayer* pTarget );

	///  
	void				DuelAllReady( MSG_REQ_DUEL_ACCEPT* pMsg, cPlayer* pTarget );

	///  
	bool				CreateDuel( cPlayer* pAttacker, cPlayer* pTarget );

	///   
	bool				IsAttack( unsigned long duelIdx, unsigned long attackerIdx, unsigned long targetIdx );

	///  
	void				DuelGiveUp( unsigned long duelIdx, unsigned long playerIdx );

	///   ó
	bool				DuelLastAttack( sObject attacker, sObject target, unsigned long damage, bool isCri, unsigned long* appDamage );

	///  迭 ߰
	void				DelDuel( unsigned long duelIdx );

	///  ֺ شϴ ÷̾鿡 QuickSendExcept
	void				TwoPlayerQuickSend( cPlayer* pPlayer1, cPlayer* pPlayer2, char* msg, int length );

	///   Ұ(й/α׾ƿ) ó
	void				DuelObjectEnd( unsigned long attackerIdx, unsigned long targetIdx, unsigned long duelIdx, bool isAttackerEnd );

private:

	typedef tPointerHashMap<unsigned long, void*> cPHashMap;
	typedef tHashSet<unsigned long> cHashSet;
	typedef tArray<unsigned long> cAry;

	///  ü  pool
	typedef tPool<cDuelObject>	cDuelObjectPool;
	cDuelObjectPool		mDuelObjectPool;

	/// ε 
	cIndexGenerator		mDuelGen;

	///  ü  
	//typedef tPointerHashMap<unsigned long, cDuelObject*> cDuelMap;
	cPHashMap			mDuelMap;

	///  ü  迭
	cAry				mDelDuel;

	/// sync޼  
	cHashSet			mSendSet;

	cRangeCheck			mRangeCheck;

};

#define DUELMANAGER	cDuelManager::mpDuelManager

