#include "stdafx.h"
#include "gamesrv.h"
#include "Duelobject.h"
#include "Duel_Common.h"


cDuelObject::cDuelObject()
{
}


cDuelObject::~cDuelObject()
{
}


void* cDuelObject::operator new( size_t n )
{
	if( n != sizeof(cDuelObject) ) 
	{
		assert(0);
		return NULL;
	}

	return DUELMANAGER->AllocDuelObject();
}


void cDuelObject::operator delete( void* ptr, size_t n )
{
	/// NULL  ˻
	if( ptr == 0 )
	{
		assert(0);
		return;
	}

	if( n != sizeof(cDuelObject) ) 
	{
		assert(0);
		return;
	}

	DUELMANAGER->FreeDuelObject( static_cast<cDuelObject*>(ptr) );

	return;
}


bool cDuelObject::Init( unsigned long duelIdx, unsigned long attackerIdx, unsigned long targetIdx )
{
	mDuelIdx = duelIdx;
	mAttackerIdx = attackerIdx;
	mTargetIdx = targetIdx;

	mDuelProcess = eDUELPROCESS_FIGHT_COUNT;

	mDelayTime = 0;

	mAttackerOutTime = 0;
	mTargetOutTime = 0;

	mAttacerRangeIn = true;
	mTargetRangeIn = true;

	mDieIdx = 0;

	cPlayer* pAttacker = OBJECTMANAGER->GetPlayer( mAttackerIdx );
	if( pAttacker == NULL )
		return false;

	cPlayer* pTarget = OBJECTMANAGER->GetPlayer( mTargetIdx );
	if( pTarget == NULL )
		return false;

	pAttacker->SetDuelIdx( mDuelIdx );	
	pTarget->SetDuelIdx( mDuelIdx );

	/// ޼  
	pTarget->EndRequestRejection( eREQREJCT_REQWAIT );

	///  ߽ 
	mCenterPos = pAttacker->GetPos() - ( ( pAttacker->GetPos() - pTarget->GetPos() ) / 2);

	///   ð 
	mProcessWaitTime = NETWORK2->GetAccumTime() + DUEL_FIGHT_COUNT_TIME;

	::wcsncpy( mAttackerName, pAttacker->GetName(), MAX_NAME_SIZE ); 
	mAttackerName[MAX_NAME_SIZE] = 0;

	::wcsncpy( mTargetName, pTarget->GetName(), MAX_NAME_SIZE ); 
	mAttackerName[MAX_NAME_SIZE] = 0;

	return true;
}


void cDuelObject::Process( unsigned long elapsedTime, unsigned long accumTime )
{
	///    īƮ
	switch( mDuelProcess )
	{
	case eDUELPROCESS_FIGHT_COUNT:
		{
			///   īƮ
			if( mProcessWaitTime > accumTime )
				return;

			///   ó
			mDuelProcess = eDUELPROCESS_FIGHT;	
            FightStart();
		}
		break;
	case eDUELPROCESS_FIGHT:
		{
			/// μ   - DUEL_FIGHT_DELAY_TIME ð üũ
			if( mDelayTime > accumTime )
				return;
			
			///  üũð 
			mDelayTime = accumTime + DUEL_FIGHT_DELAY_TIME;

			///   üũ ׸
			FightProcess( elapsedTime, accumTime );
		}
		break;
	case eDUELPROCESS_FIGHT_END:
		{
			///  ᰡ ƴ    
			FightEnd( mDieIdx );
		}
		break;
	}

}


void cDuelObject::FightStart()
{
	cPlayer* pAttacker = OBJECTMANAGER->GetPlayer( mAttackerIdx );
	if( pAttacker == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("cDuelObject::Process pAttacker[%d] == NULL", mAttackerIdx );
		FightEnd( mAttackerIdx );
		return;
	}

	cPlayer* pTarget = OBJECTMANAGER->GetPlayer( mTargetIdx );
	if( pTarget == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("cDuelObject::Process pTarget[%d] == NULL", mTargetIdx );
		FightEnd( mTargetIdx );
		return;
	}

	HANDLE handle  = NULL;

	MSGROOT* sendMsg = (MSGROOT*)NETWORK2->GetMsgRoot( &handle, pAttacker->GetConnectionIdx(), NM_DUEL, NM_DUEL_START_RES );
	if ( sendMsg != NULL )
	{
		NETWORK2->SendMsgRoot( handle, sizeof(MSGROOT) );
	}

	sendMsg = (MSGROOT*)NETWORK2->GetMsgRoot( &handle, pTarget->GetConnectionIdx(), NM_DUEL, NM_DUEL_START_RES );
	if ( sendMsg != NULL )
	{
		NETWORK2->SendMsgRoot( handle, sizeof(MSGROOT) );
	}
}


void cDuelObject::FightProcess( unsigned long /*elapsedTime*/, unsigned long accumTime )
{
	///  Ÿ üũ
	mRangeCheck.SetRadius( DUEL_FIGHT_RANGE );

	cPlayer* pAttacker = OBJECTMANAGER->GetPlayer( mAttackerIdx );
	if( pAttacker == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("cDuelObject::Process pAttacker[%d] == NULL", mAttackerIdx );
		FightEnd( mAttackerIdx );
		return;
	}

	cPlayer* pTarget = OBJECTMANAGER->GetPlayer( mTargetIdx );
	if( pTarget == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("cDuelObject::Process pTarget[%d] == NULL", mTargetIdx );
		FightEnd( mTargetIdx );
		return;
	}

	HANDLE handle  = NULL;
	if( mRangeCheck.IsNotRange( mCenterPos, pAttacker->GetPos() ) == true )
	{
		/// ̹ ӿ ȿ ִٰ 
		if( mAttacerRangeIn == true )
		{
			/// ð 
			mAttackerOutTime = accumTime;
			mAttacerRangeIn = false;

			/// ޼ ߼
			MSGROOT* sendMsg = (MSGROOT*)NETWORK2->GetMsgRoot( &handle, 
				pAttacker->GetConnectionIdx(), NM_DUEL, NM_DUEL_FIGHT_OUTRANGE_RES );
			if ( sendMsg != NULL )
				NETWORK2->SendMsgRoot( handle, sizeof(MSGROOT) );
		}

		/// 10̻ 
		if( mAttackerOutTime + DUEL_FIGHT_RANGE_TIME <= accumTime )
		{
			/// ÷̾1 й
			FightEnd( mAttackerIdx );
		}
	}
	else
	{
		/// ̹ ӿ ۿ ִٰ 
		if( mAttacerRangeIn == false )
		{
			mAttacerRangeIn = true;

			/// ޼ ߼
			MSGROOT* sendMsg = (MSGROOT*)NETWORK2->GetMsgRoot( &handle, 
				pAttacker->GetConnectionIdx(), NM_DUEL, NM_DUEL_FIGHT_INRANGE_RES );
			if ( sendMsg != NULL )
				NETWORK2->SendMsgRoot( handle, sizeof(MSGROOT) );
		}
	}

	if( mRangeCheck.IsNotRange( mCenterPos, pTarget->GetPos() ) == true )
	{
		/// ̹ ӿ ȿ ִٰ 
		if( mTargetRangeIn == true )
		{
			/// ð 
			mTargetOutTime = accumTime;
			mTargetRangeIn = false;

			/// ޼ ߼
			MSGROOT* sendMsg = (MSGROOT*)NETWORK2->GetMsgRoot( &handle, 
				pTarget->GetConnectionIdx(), NM_DUEL, NM_DUEL_FIGHT_OUTRANGE_RES );
			if ( sendMsg != NULL )
				NETWORK2->SendMsgRoot( handle, sizeof(MSGROOT) );
		}

		/// 10̻ 
		if( mTargetOutTime + DUEL_FIGHT_RANGE_TIME <= accumTime )
		{
			/// ÷̾2 й
			FightEnd( mTargetIdx );
		}
	}
	else
	{
		/// ̹ ӿ ۿ ִٰ 
		if( mTargetRangeIn == false )
		{
			mTargetRangeIn = true;

			/// ޼ ߼
			MSGROOT* sendMsg = (MSGROOT*)NETWORK2->GetMsgRoot( &handle, 
				pTarget->GetConnectionIdx(), NM_DUEL, NM_DUEL_FIGHT_INRANGE_RES );
			if ( sendMsg != NULL )
				NETWORK2->SendMsgRoot( handle, sizeof(MSGROOT) );
		}
	}
}


void cDuelObject::LastAttack( unsigned long dieIdx )
{
	/// ų  ޼  ߼Ŀ μ ڿ  ó Ѵ.
	mDuelProcess = eDUELPROCESS_FIGHT_END;	
	mDieIdx = dieIdx;
}


void cDuelObject::FightEnd( unsigned long dieIdx )
{
	sObject player;
	player.type = eOBJECTTYPE_PLAYER;

	HANDLE handle  = NULL;

	/// 
	unsigned long straightWin = 0;

	/// ü   ⼭  ȣǹǷ ü NULLϼ .
	cPlayer* pTarget = OBJECTMANAGER->GetPlayer( mTargetIdx );
	if( pTarget == NULL )	
	{
		assert(NULL);	
		NETWORK2->PostServerEvent("cDuelObject::FightEnd pTarget[%d] == NULL", mTargetIdx );
		DUELMANAGER->DelDuel( mDuelIdx );
		return;
	}

	cPlayer* pAttacker = OBJECTMANAGER->GetPlayer( mAttackerIdx );
	if( pAttacker == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("cDuelObject::FightEnd pAttacker[%d] == NULL", mAttackerIdx );
		DUELMANAGER->DelDuel( mDuelIdx );
		return;
	}

	pTarget->EndRequestRejection( eREQREJCT_DUEL );	///   
	pTarget->SetDuelIdx( 0 );						///   
	pTarget->DuelEndDebuffClear( mAttackerIdx );	///  ޾Ҵ  
	pTarget->SetDuelPlayerIdx( 0, false );			///   Ŭ
	pTarget->MoveStop();
		
	pAttacker->EndRequestRejection( eREQREJCT_DUEL );
	pAttacker->SetDuelIdx( 0 );
	pAttacker->DuelEndDebuffClear( mTargetIdx );
	pAttacker->SetDuelPlayerIdx( 0, false );
	pAttacker->MoveStop();

	MSG_SYN_DUEL_END synMsg;

	/// ¸/й ó
	if( dieIdx == mAttackerIdx )
	{
		///  ¸
		pTarget->SetDuelWin();					/// ¸ 
		straightWin = pTarget->GetDuelWin();	/// 

		/// ¸  ߰
		player.index = mTargetIdx;
		SKILLMANAGER->AddInfluence( player, player, DUEL_WIN_ADD_INFLUENCEIDX, 0, true );		

		/// ¸ ޼ ߼
		MSG_SYN_DUEL_WINNER* winMsg = (MSG_SYN_DUEL_WINNER*)NETWORK2->GetMsgRoot( &handle, 
			pTarget->GetConnectionIdx(), NM_DUEL, NM_DUEL_WINNER_SYN );
		if ( winMsg != NULL )
		{
			winMsg->mWinnerIdx = mTargetIdx;
			::wcsncpy( winMsg->mWinnerName, mTargetName, MAX_NAME_SIZE ); 
			winMsg->mLoserIdx = mAttackerIdx;
			::wcsncpy( winMsg->mLoserName, mAttackerName, MAX_NAME_SIZE ); 
			winMsg->mStraightWin = straightWin;

			NETWORK2->SendMsgRoot( handle, sizeof(MSG_SYN_DUEL_WINNER) );
		}


		/// û й
		pAttacker->ClearDuelWin();	///   

		/// й  ߰
		player.index = mAttackerIdx;
		SKILLMANAGER->AddInfluence( player, player, DUEL_LOSE_ADD_INFLUENCEIDX, 0, true );		

		/// й ޼ ߼
		MSG_SYN_DUEL_LOSER* loseMsg = (MSG_SYN_DUEL_LOSER*)NETWORK2->GetMsgRoot( &handle, 
			pAttacker->GetConnectionIdx(), NM_DUEL, NM_DUEL_LOSER_SYN );
		if ( loseMsg != NULL )
		{
			loseMsg->mWinnerIdx = mTargetIdx;
			::wcsncpy( loseMsg->mWinnerName, mTargetName, MAX_NAME_SIZE ); 
			loseMsg->mLoserIdx = mAttackerIdx;
			::wcsncpy( loseMsg->mLoserName, mAttackerName, MAX_NAME_SIZE ); 
			loseMsg->mStraightWin = straightWin;

			NETWORK2->SendMsgRoot( handle, sizeof(MSG_SYN_DUEL_LOSER) );
		}

		synMsg.Category = NM_DUEL;
		synMsg.Protocol = NM_DUEL_END_SYN;
		synMsg.mWinnerIdx = mTargetIdx;
		::wcsncpy( synMsg.mWinnerName, mTargetName, MAX_NAME_SIZE ); 
		synMsg.mLoserIdx = mAttackerIdx;
		::wcsncpy( synMsg.mLoserName, mAttackerName, MAX_NAME_SIZE ); 
		synMsg.mStraightWin = straightWin;
	}
	else
	{
		/// û ¸
		pAttacker->SetDuelWin();				/// ¸ 
		straightWin = pAttacker->GetDuelWin();	/// 

		/// ¸  ߰
		player.index = mAttackerIdx;
		SKILLMANAGER->AddInfluence( player, player, DUEL_WIN_ADD_INFLUENCEIDX, 0, true );	

		/// ¸ ޼ ߼
		MSG_SYN_DUEL_WINNER* winMsg = (MSG_SYN_DUEL_WINNER*)NETWORK2->GetMsgRoot( &handle, 
			pAttacker->GetConnectionIdx(), NM_DUEL, NM_DUEL_WINNER_SYN );
		if ( winMsg != NULL )
		{
			winMsg->mWinnerIdx = mAttackerIdx;
			::wcsncpy( winMsg->mWinnerName, mAttackerName, MAX_NAME_SIZE ); 
			winMsg->mLoserIdx = mTargetIdx;
			::wcsncpy( winMsg->mLoserName, mTargetName, MAX_NAME_SIZE ); 
			winMsg->mStraightWin = straightWin;

			NETWORK2->SendMsgRoot( handle, sizeof(MSG_SYN_DUEL_WINNER) );
		}


		///  й
		pTarget->ClearDuelWin();				///   

		/// й  ߰
		player.index = mTargetIdx;
		SKILLMANAGER->AddInfluence( player, player, DUEL_LOSE_ADD_INFLUENCEIDX, 0, true );		

		/// й ޼ ߼
		MSG_SYN_DUEL_LOSER* loseMsg = (MSG_SYN_DUEL_LOSER*)NETWORK2->GetMsgRoot( &handle, 
			pTarget->GetConnectionIdx(), NM_DUEL, NM_DUEL_LOSER_SYN );
		if ( loseMsg != NULL )
		{
			loseMsg->mWinnerIdx = mAttackerIdx;
			::wcsncpy( loseMsg->mWinnerName, mAttackerName, MAX_NAME_SIZE ); 
			loseMsg->mLoserIdx = mTargetIdx;
			::wcsncpy( loseMsg->mLoserName, mTargetName, MAX_NAME_SIZE ); 
			loseMsg->mStraightWin = straightWin;

			NETWORK2->SendMsgRoot( handle, sizeof(MSG_SYN_DUEL_LOSER) );
		}

		synMsg.Category = NM_DUEL;
		synMsg.Protocol = NM_DUEL_END_SYN;
		synMsg.mWinnerIdx = mAttackerIdx;
		::wcsncpy( synMsg.mWinnerName, mAttackerName, MAX_NAME_SIZE ); 
		synMsg.mLoserIdx = mTargetIdx;
		::wcsncpy( synMsg.mLoserName, mTargetName, MAX_NAME_SIZE ); 
		synMsg.mStraightWin = straightWin;
	}

	///  θ  ü ʴ 
	NETWORK2->QuickSendExceptMap( pAttacker, pTarget, (char*)&synMsg, sizeof(synMsg) );

	///  迭 ߰
	DUELMANAGER->DelDuel( mDuelIdx );

	mDuelProcess = eDUELPROCESS_END;
}