#include "stdafx.h"
#include "gamesrv.h"
#include "Guild.h"
#include "Guild_Common.h"

cGuild::cGuild()
: mLastAccumTime(0)
, mDBLastAccumTime(0)
{
	memset( &mInfo, 0, sizeof(mInfo) );
}

cGuild::~cGuild()
{
	Clear();
}

void cGuild::Clear()
{
	/// Ʈ 
	cGuildUserMap::cIterator i = mGuildUserMap.Begin();
	cGuildUserMap::cIterator end = mGuildUserMap.End();
	for( ; i != end; ++i )
	{
		TB_GUILD_USER* p = (TB_GUILD_USER*)(i->mSecond);
		SAFE_DELETE( p );
	}
	mGuildUserMap.Clear();
}

///  ۽ 
bool cGuild::VerifyAddPlayer( TB_GUILD_USER* data )
{
	TB_GUILD_USER* p = new TB_GUILD_USER;

	/// 
	(*p) = (*data);

	///  
	return  mGuildUserMap.Insert( data->characterIdx, p );
}

///   ⺻  
void cGuild::SetInfo( long idx, long masterIdx, wchar_t* name, wchar_t* masterName )
{
	mInfo.idx			= idx;
	mInfo.masterIndex	= masterIdx;
	wcscpy( mInfo.name, name );
	wcscpy( mInfo.masterName, masterName );
}

/// ÷̾ ⺻ 
bool cGuild::AddPlayer( cPlayer* player, char position, DWORD channelNum )
{
	TB_GUILD_USER* p = new TB_GUILD_USER;
	p->characterIdx	= player->GetObjectID();
	p->level		= player->GetLevel();
	p->job			= player->GetJob();
	p->mapnum		= player->GetMapNumber();
	p->position		= position;
	p->channelNum   = channelNum;
	p->sendInfo		= false;
	wcscpy( p->name, player->GetName() );

	///  
	if( mGuildUserMap.Insert( p->characterIdx, p ) == false )
	{
		assert(0);
		return false;
	}
	return true;
}

bool cGuild::AddPlayer( long characterIdx, char level, long job, short mapnum, wchar_t* name, char position, DWORD channelNum )
{
	TB_GUILD_USER* p = new TB_GUILD_USER;
	p->characterIdx	= characterIdx;
	p->level		= level;
	p->job			= job;
	p->mapnum		= mapnum;
	p->position		= position;
	p->channelNum   = channelNum;
	p->sendInfo		= false;
	wcscpy( p->name, name );

	///  
	if( mGuildUserMap.Insert( p->characterIdx, p ) == false )
	{
		assert(0);
		return false;
	}
	return true;
}

/// ÷̾ 
bool cGuild::DeletePlayer( unsigned long characterIdx )
{
	cGuildUserMap::cIterator i = mGuildUserMap.Find( characterIdx );
	if( i != mGuildUserMap.End() )
	{
		TB_GUILD_USER* p = (TB_GUILD_USER*)(i->mSecond);
		SAFE_DELETE( p );
		mGuildUserMap.Erase(i);
	}
	else
	{
		NETWORK2->PostServerEvent("cGuild::DeletePlayer[%s]", characterIdx );
		return false;
	}
	return true;
}

void cGuild::SetMaster( unsigned long characterIdx, wchar_t* name )
{
	///  ϸ 
	if( (unsigned long)mInfo.masterIndex == characterIdx )
		return;

	///    
	TB_GUILD_USER* user = (TB_GUILD_USER*)mGuildUserMap.GetAt( mInfo.masterIndex );
	if( user )
	{
		user->position = eGUILD_GENERAL;
	}
	else
	{
		NETWORK2->PostServerEvent("cGuild::SetMaster[%d] - not exist master", mInfo.masterIndex );
	}

	///    
	TB_GUILD_USER* master = (TB_GUILD_USER*)mGuildUserMap.GetAt( characterIdx );
	if( master )
	{
		master->position = eGUILD_MASTER;
	}
	else
	{
		NETWORK2->PostServerEvent("cGuild::SetMaster[%d] - not exist new master", characterIdx );
	}

	mInfo.masterIndex = characterIdx;
	wcscpy( mInfo.masterName, name );
}

void cGuild::SetNotice( wchar_t* notice )
{
	wcscpy( mInfo.notice, notice );
}

void cGuild::UpdateMark( unsigned long markIdx, BYTE* mark, int size )
{
	mInfo.markIdx = markIdx;
	memcpy( &mInfo.mark, mark, size );
}