/* ==========================================================================
*      : GuildManager.h
*      : 
*    : 谡
*    : 2008-10-31
* ǻ :
*===========================================================================*/
#pragma once

///  Žð
const unsigned long GUILD_UPDATETIME = 10 * 1000;			// 10
const unsigned long GUILDDB_UPDATETIME = 60 * 60 * 1000;	// 1ð
const unsigned long	CONNECT_UPDATETIME = 2 * 60 * 60 * 1000;	// 2ð

class cGuild;
class cPlayer;

class cGuildManager
{
	static cGuildManager*	mpSingleton;

public:
	cGuildManager();
	~cGuildManager();

	bool Init();

	/// ش   
	void SendGuildInfo( ULONG_PTR socketContext, cPlayer* player, unsigned long idx );
	void SendGuildInfo( cPlayer* player, unsigned long idx );
	
	/// 忡 ߰   ֱ
	void SendGuildUserAdd( cGuild* guild, long characterIdx, char level, long job, short mapnum, wchar_t* name, char position, DWORD channelNum );

	/// 忡 Ż   ֱ
	void SendGuildUserOut( cGuild* guild, unsigned long characterIdx );

	/// 忡 ߹   ֱ
	void SendGuildUserCut( cGuild* guild, unsigned long characterIdx );

	/// ð   
	void SendGuildUpdateInfo( cGuild* guild );

	///   Ǿ ˷ش
	void SendGuildChangePosition( cGuild* guild, unsigned long characterIdx, char position );

	///    
	bool SendGuildNotice( unsigned long idx, wchar_t* notice );

	/// ũ ε  
	void SendGuildMarkUpdate( cGuild* guild, unsigned long markIdx );

	/// ũ ֱ
	bool SendGuildMark( unsigned long idx, cPlayer* player );

	/// ä
	void SendGuildChat( cPlayer* hero, wchar_t* message, unsigned short number );

	/// ü  
	bool SaveAllDB();

	/// ÷̾ 
	void PlayerMapOut( cPlayer* hero );

	/// ÷̾  (̵)
	void PlayerMapIn( cPlayer* hero );

	/// ä  
	bool GuildUpdateChannel( unsigned long idx, unsigned long characterIdx, DWORD channelNum );

	///   ˻
	TB_GUILD_USER* IsMyGuildUser( unsigned long idx, unsigned long characterIdx );

	///  ˻
	bool CheckChangePosition( cPlayer* hero, unsigned long characterIdx, char newposition );

	/// 帶ũ ε 
	unsigned long CreateMarkIndex();

	///      ÷
	bool RequestUpdateUser( unsigned long idx, unsigned long characterIdx, char level, long job );

public:
	void Release();
	void Process( unsigned long elasedTime, unsigned long accumTime );

	///  
	bool AddGuild( GUILD_CREATE* data, cPlayer* master );
	bool DeleteGuild( unsigned long idx );

	/// û  
	bool AddRequest( unsigned long recvIdx, unsigned long reqIdx );
	void DelRequest( unsigned long recvIdx );
	unsigned long GetRequest( unsigned long recvIdx );

	/// , ä SYN ޼
	bool SynAddGuild( void* msg, DWORD channelNum );
	bool SynAddGuildUser( void* msg, DWORD channelNum );
	bool SynCutGuilduser( void* msg );
	bool SynOutGuilduser( void* msg );
	bool SynUpdateMark( void* msg );
	bool SynUpdateGuildUserInfo( void* msg );
	bool SynGuildChat( void* msg );
	bool SynGuildNote( void* msg );
	bool SynGuildConnect( void* msg, DWORD channelNum );

	///   
	bool SendGuildConnect( DWORD reqChannelNum );
	void ClearGuildConnect();

	/// ʱ   
	void SetGuildTotalLength( DWORD length );
	void SetGuildLength( DWORD length );

	bool VerifyGuildSelect( TB_GUILD* guild );
	bool VerifyGuildUser( unsigned long idx, TB_GUILD_USER* user );

	///
	cGuild* GetGuild( unsigned long idx );
	wchar_t* GetGuildName( unsigned long idx );
	unsigned long GetGuildMarkIndex( unsigned long idx );
	bool FindGuildName( wchar_t* name );

	///  Ȯ ˻
	bool CheckGuildLength();
	bool CheckGuildTotal();
	bool CheckGuildSaveTotal();

protected:
	///  DB Ʈ
	void SaveDBGuild( cGuild* guild );

public:
	static cGuildManager* Get();

private:
	///  
	typedef tPointerHashMap<unsigned long, void*> cGuildMap;
	cGuildMap	mGuildMap;

	/// û 	
	typedef tHashMap<unsigned long, unsigned long> cJoinMap;	
	cJoinMap	mJoinMap;

	///  Ȯο
	DWORD mGuildTotalLength; ///  select ؾ   ( DB ڵ  )
	DWORD mGuildTotalOffset; ///  select ؾ   ( DB ڵ  )
	DWORD mGuildSaveOffset;	///   ؾ  

	DWORD mGuildSelectLength; ///  ϴ   ( DB ڵ  )

	///  ũ 
	unsigned long mMarkIndexGen;

	///  ۽ð
	long	mAccumTime;
};

inline unsigned long cGuildManager::CreateMarkIndex()
{
	if( mMarkIndexGen >= ULONG_MAX )
	{
		assert(0);
		return 0;
	}
	return ++mMarkIndexGen;
}

inline void cGuildManager::SetGuildTotalLength( DWORD length )
{
	mGuildTotalLength = length;
}

inline void cGuildManager::SetGuildLength( DWORD length )
{
	mGuildSelectLength = length;
}

inline cGuildManager* cGuildManager::Get()
{
	return mpSingleton;
}

#define GUILDMAN cGuildManager::Get()
