#include "stdafx.h"
#include "GameSrv.h"
#include "HaveSkillObject.h"
#include "SkillManager.h"
#include "SkillScript.h"
#include "StatusCalc_Server.h"
#include "ObjectManager.h"
#include "Protocol.h"
#include "Skill_Common.h"



cHaveSkillObject::cHaveSkillObject()
{
}



cHaveSkillObject::~cHaveSkillObject()
{
}



void* cHaveSkillObject::operator new( size_t n )
{
	if( n != sizeof(cHaveSkillObject) ) 
	{
		assert(0);
		return NULL;
	}

	return SKILLMANAGER->AllocHaveSkillObject();
}



void cHaveSkillObject::operator delete( void* ptr, size_t n )
{
	/// NULL  ˻
	if( ptr == 0 )
	{
		assert(0);
		return;
	}

	if( n != sizeof(cHaveSkillObject) ) 
	{
		assert(0);
		return;
	}

	SKILLMANAGER->FreeHaveSkillObject( static_cast<cHaveSkillObject*>(ptr) );

	return;
}



void cHaveSkillObject::Init( unsigned long skillIdx, unsigned char skillStep, unsigned long restCoolTime )
{
	mSkillIdx = skillIdx;
	mSkillStep = skillStep;
	mCreationTime = NETWORK2->GetAccumTime();
	mRestTime = restCoolTime;
}



void cHaveSkillObject::RestoreInit( unsigned long skillIdx, unsigned char skillStep, unsigned long restCoolTime )
{
	mSkillIdx = skillIdx;
	mSkillStep = skillStep;
	mCreationTime = NETWORK2->GetAccumTime();
	mRestTime = restCoolTime;
}


bool cHaveSkillObject::StepUp( unsigned char skillStep, unsigned long restCoolTime )
{
	if( mSkillStep + 1 != skillStep )	
	{ 
		NETWORK2->PostServerEvent("cHaveSkillObject::StepUp skillStep[%d] err", skillStep);
		return false; 
	}
	mSkillStep = skillStep;
	mCreationTime = NETWORK2->GetAccumTime();
	mRestTime = restCoolTime;
	return true;
}



void cHaveSkillObject::UpdateCoolTime( unsigned long restCoolTime )
{ 
	unsigned long thisSkillEndCooltime = mCreationTime + mRestTime;

	/// Ÿ  ʰ  
	if( thisSkillEndCooltime <= NETWORK2->GetAccumTime() )
	{
		sPlayerSkillBaseInfo* pSkillInfo = SKILLSCRIPT->GetPlayerSkillInfo( mSkillIdx );
		if( pSkillInfo == NULL )
		{
			NETWORK2->PostServerEvent("Skill CoolTime error - skillclassidx:%d", mSkillIdx );
			assert(NULL);
			mCreationTime = NETWORK2->GetAccumTime();
			mRestTime = restCoolTime; 
			return;
		}

		sPlayerSkillStepInfo* pSkillStep = &pSkillInfo->mpSetpInfoArray[mSkillStep];
		mCreationTime = NETWORK2->GetAccumTime();

		/// ڽŰ Է°   Ÿ .
		if( restCoolTime > pSkillStep->mCoolTime )
			mRestTime = pSkillStep->mCoolTime;
		else
			mRestTime = restCoolTime;
	}
	/// Ÿ   Է¹ Ÿ ū ű  
	else if( thisSkillEndCooltime < NETWORK2->GetAccumTime() + restCoolTime )
	{
		mCreationTime = NETWORK2->GetAccumTime();
		mRestTime = restCoolTime; 
	}

	///// Է¹ Ÿ   ū ű  
	//if( thisSkillEndCooltime < NETWORK2->GetAccumTime() + restCoolTime )
	//{
	//	mCreationTime = NETWORK2->GetAccumTime();
	//	mRestTime = restCoolTime; 
	//}
}



unsigned long cHaveSkillObject::GetEndCoolTime()	
{ 
	return mCreationTime + mRestTime; 
}


unsigned long cHaveSkillObject::GetRestTime()
{
	unsigned long restTime = 0;
	if( ( mCreationTime + mRestTime ) > NETWORK2->GetAccumTime() )
		restTime = ( mCreationTime + mRestTime ) - NETWORK2->GetAccumTime();

    return restTime; 
}