#include "gamesrv.h"

#include "stdafx.h"
#include "InfluenceObject.h"
#include "SkillManager.h"
#include "SkillScript.h"
#include "StatusCalc_Server.h"
#include "ObjectManager.h"
#include "Protocol.h"
#include "Skill_Common.h"
#include "Player.h"
#include "Totem.h"



cInfluenceObject::cInfluenceObject()
{
	mTime1 = 0;
	mTime2 = 0;

	mCopySkillClassIdx = 0;
	mSwitchType = eSWITCHTYPE_NONE;
	mParentUniqueIdx = 0;
	mCopyRange = 0;
	mCopyApplyType = eAPPLYTYPE_SELF;
	mAttriButeType = eATTRIBUTETYPE_PHYSICAL;
	mCopyCheckTime = 0;

	mInfluenceValue1 = 0;
	mInfluenceValue2 = 0;

	mProcessStart = true;
	mSendDelMsg = true;

	mIsTotem = false;

	mIsDelReady = false;
	mDistressPoint = 0;

	mItemIdx = 0;
	mDieDelete = true;
}



cInfluenceObject::~cInfluenceObject()
{
	SKILLMANAGER->DelInfluenceUniqueIdx( mUniqueIdx );
}



void* cInfluenceObject::operator new( size_t n )
{
	if( n != sizeof(cInfluenceObject) ) 
	{
		assert(0);
		return NULL;
	}

	return SKILLMANAGER->AllocInfluenceObject();
}



void cInfluenceObject::operator delete( void* ptr, size_t n )
{
	/// NULL  ˻
	if( ptr == 0 )
	{
		assert(0);
		return;
	}

	if( n != sizeof(cInfluenceObject) ) 
	{
		assert(0);
		return;
	}

	SKILLMANAGER->FreeInfluenceObject( static_cast<cInfluenceObject*>(ptr) );

	return;
}


bool cInfluenceObject::NormalInit( sObject attacker, sObject target, unsigned long uniqueIdx, unsigned long infClassIdx,
								  unsigned long skillClassIdx, unsigned long* plusTime )
{

	/// ȿ ũƮ  о
	sInfluenceScript* pInfluence = SKILLSCRIPT->GetInfluenceInfo( infClassIdx );
	if( !pInfluence )	
	{ 
		NETWORK2->PostServerEvent("influence init - GetInfluenceInfo(%d)", infClassIdx);
		return false; 
	}

	mUniqueIdx = uniqueIdx;
	mDBIdx = 0;
	mInfluenceClassIdx = infClassIdx;
	mTarget = target;
	mAttacker = attacker;
	mInfluenceCreationTime = NETWORK2->GetAccumTime();

	/// ų ũƮ ʿ ġ  Ѵ.
	sPlayerSkillBaseInfo* pSkillInfo = SKILLSCRIPT->GetPlayerSkillInfo( skillClassIdx );
	if( pSkillInfo != NULL )	
	{ 
		cHaveSkillObject* pPlayerHaveSkill = SKILLMANAGER->GetPlayerHaveSkill( mAttacker.index, skillClassIdx );
		if( pPlayerHaveSkill )	
		{ 
			unsigned char skillStep = pPlayerHaveSkill->GetSkillStep();
			if( skillStep < pSkillInfo->mStepCount )
			{
				sPlayerSkillStepInfo* pStepInfo = &pSkillInfo->mpSetpInfoArray[skillStep];

				/// ų ׷ ġ
				mDistressPoint = pStepInfo->mDistressValue;

				mAttriButeType = pSkillInfo->mAttributeType;
			}
		}
		else
		{
			sPlayerSkillStepInfo* pStepInfo = &pSkillInfo->mpSetpInfoArray[0];

			/// ų ׷ ġ
			mDistressPoint = pStepInfo->mDistressValue;

			mAttriButeType = pSkillInfo->mAttributeType;
		}
	}

	mIsSleep = false;
	if( pInfluence->mStatusPlusIdx1 == eSTATUSPLUS_SLEEP )
		mIsSleep = true;
	if( pInfluence->mStatusPlusIdx2 == eSTATUSPLUS_SLEEP )
		mIsSleep = true;
	if( pInfluence->mStatusPlusIdx3 == eSTATUSPLUS_SLEEP )
		mIsSleep = true;

	bool timeDelay = mIsSleep;
	if( pInfluence->mStatusPlusIdx1 == eSTATUSPLUS_STUN )
		timeDelay = true;
	if( pInfluence->mStatusPlusIdx2 == eSTATUSPLUS_STUN )
		timeDelay = true;
	if( pInfluence->mStatusPlusIdx3 == eSTATUSPLUS_STUN )
		timeDelay = true;

	///   ȿ() ΰ   ð 
	if( pInfluence->mTime1 != 0 )	
	{
		mTime1 = mInfluenceCreationTime + pInfluence->mTime1;

		/// ȿ ȣ     ̸ ؼ   ִ´
		///    ü   Ұϰ Ǵ 츦 
		if( pInfluence->mStatusPlusIdx1 == eSTATUSPLUS_DOT_HPCHANGE_CALC_PLUS )
		{
			/// +ġ  -ġ 
			if( pInfluence->mValue1 > 0 )
				mInfluenceValue1 = DAMAGECALC->HealHPCalc( attacker, pInfluence->mValue1 );
			else	///    
				mInfluenceValue1 = pInfluence->mValue1;
		}
		else
			mInfluenceValue1 = pInfluence->mValue1;
	}

	///   ȿ() ΰ   ð 
	if( pInfluence->mTime2 != 0 )	
	{
		mTime2 = mInfluenceCreationTime + pInfluence->mTime2;

		/// ȿ ȣ     ̸ ؼ   ִ´
		///    ü   Ұϰ Ǵ 츦 
		if( pInfluence->mStatusPlusIdx2 == eSTATUSPLUS_DOT_MPCHANGE_CALC_PLUS )
		{
			/// +ġ  -ġ 
			if( pInfluence->mValue2 > 0 )
				mInfluenceValue2 = DAMAGECALC->HealHPCalc( attacker, pInfluence->mValue2 );
			else	///    
				mInfluenceValue2 = pInfluence->mValue2;
		}
		else
			mInfluenceValue2 = pInfluence->mValue2;
	}

	if( pInfluence->mContinuanceTime == -1 )
	{
		mInfluenceRestTime = 0;
		mSwitchType = eSWITCHTYPE_PARENT;
	}
	else
		mInfluenceRestTime = pInfluence->mContinuanceTime;

	if( timeDelay == true && plusTime != NULL )
		mInfluenceRestTime = mInfluenceRestTime + *plusTime;
	else
		*plusTime = 0;

	return true;
}

bool cInfluenceObject::SwitchParentInit( sObject attacker, sObject target, unsigned long uniqueIdx, unsigned long infClassIdx,
                                        unsigned long skillClassIdx )
{
	/// ȿ ũƮ  о
	sInfluenceScript* pInfluence = SKILLSCRIPT->GetInfluenceInfo( infClassIdx );
	if( !pInfluence )	
	{ 
		NETWORK2->PostServerEvent("influence init - GetInfluenceInfo(%d)", infClassIdx);
		return false; 
	}

	mUniqueIdx = uniqueIdx;
	mDBIdx = 0;
	mInfluenceClassIdx = infClassIdx;
	mTarget = target;
	mAttacker = attacker;
	mInfluenceCreationTime = NETWORK2->GetAccumTime();
	mCopyCheckTime = NETWORK2->GetAccumTime();
	mDieDelete = pInfluence->mDieDelete;
	mSwitchType = eSWITCHTYPE_PARENT;

	/// ų ũƮ ʿ ġ  Ѵ.
	sPlayerSkillBaseInfo* pSkillInfo = SKILLSCRIPT->GetPlayerSkillInfo( skillClassIdx );
	if( pSkillInfo != NULL )	
	{ 
		cHaveSkillObject* pPlayerHaveSkill = SKILLMANAGER->GetPlayerHaveSkill( mAttacker.index, skillClassIdx );
		if( pPlayerHaveSkill )	
		{ 
			unsigned char skillStep = pPlayerHaveSkill->GetSkillStep();
			if( skillStep < pSkillInfo->mStepCount )
			{
				sPlayerSkillStepInfo* pStepInfo = &pSkillInfo->mpSetpInfoArray[skillStep];

				/// ų ׷ ġ
				mDistressPoint = pStepInfo->mDistressValue;

				mCopySkillClassIdx = skillClassIdx;
				mCopyRange = pStepInfo->mBoundDist;
				mCopyApplyType = pSkillInfo->mApplyType;
				mAttriButeType = pSkillInfo->mAttributeType;
			}
		}
		else
		{
			sPlayerSkillStepInfo* pStepInfo = &pSkillInfo->mpSetpInfoArray[0];

			/// ų ׷ ġ
			mDistressPoint = pStepInfo->mDistressValue;

			mAttriButeType = pSkillInfo->mAttributeType;
		}
	}

	///   ȿ() ΰ   ð 
	if( pInfluence->mTime1 != 0 )	
	{
		mTime1 = mInfluenceCreationTime + pInfluence->mTime1;

		/// ȿ ȣ     ̸ ؼ   ִ´
		///    ü   Ұϰ Ǵ 츦 
		if( pInfluence->mStatusPlusIdx1 == eSTATUSPLUS_DOT_HPCHANGE_CALC_PLUS )
		{
			/// +ġ  -ġ 
			if( pInfluence->mValue1 > 0 )
				mInfluenceValue1 = DAMAGECALC->HealHPCalc( attacker, pInfluence->mValue1 );
			else	///    
				mInfluenceValue1 = pInfluence->mValue1;
		}
		else
			mInfluenceValue1 = pInfluence->mValue1;
	}

	///   ȿ() ΰ   ð 
	if( pInfluence->mTime2 != 0 )	
	{
		mTime2 = mInfluenceCreationTime + pInfluence->mTime2;

		/// ȿ ȣ     ̸ ؼ   ִ´
		///    ü   Ұϰ Ǵ 츦 
		if( pInfluence->mStatusPlusIdx2 == eSTATUSPLUS_DOT_MPCHANGE_CALC_PLUS )
		{
			/// +ġ  -ġ 
			if( pInfluence->mValue2 > 0 )
				mInfluenceValue2 = DAMAGECALC->HealHPCalc( attacker, pInfluence->mValue2 );
			else	///    
				mInfluenceValue2 = pInfluence->mValue2;
		}
		else
			mInfluenceValue2 = pInfluence->mValue2;
	}

	///  ðǼ  ų ƴϴ!
	mInfluenceRestTime = 0;
	
	return true;
}

bool cInfluenceObject::SwitchChildAuraInit( sObject attacker, sObject target, unsigned long uniqueIdx, unsigned long infClassIdx,
                                       unsigned long skillClassIdx, unsigned long parenUniqueIdx )
{

	/// ȿ ũƮ  о
	sInfluenceScript* pInfluence = SKILLSCRIPT->GetInfluenceInfo( infClassIdx );
	if( !pInfluence )	
	{ 
		assert(NULL); 
		NETWORK2->PostServerEvent("influence init - GetInfluenceInfo(%d)", infClassIdx);
		return false; 
	}

	mUniqueIdx = uniqueIdx;
	mDBIdx = 0;
	mInfluenceClassIdx = infClassIdx;
	mTarget = target;
	mAttacker = attacker;
	mSwitchType = eSWITCHTYPE_CHILD;
	mInfluenceCreationTime = NETWORK2->GetAccumTime();
	mCopyCheckTime = NETWORK2->GetAccumTime();
	mParentUniqueIdx = parenUniqueIdx;
	mIsTotem = false;

	/// ų ũƮ ʿ ġ  Ѵ.
	sPlayerSkillBaseInfo* pSkillInfo = SKILLSCRIPT->GetPlayerSkillInfo( skillClassIdx );
	if( pSkillInfo != NULL )	
	{ 
		cHaveSkillObject* pPlayerHaveSkill = SKILLMANAGER->GetPlayerHaveSkill( mAttacker.index, skillClassIdx );
		if( pPlayerHaveSkill )	
		{ 
			unsigned char skillStep = pPlayerHaveSkill->GetSkillStep();
			if( skillStep < pSkillInfo->mStepCount )
			{
				sPlayerSkillStepInfo* pStepInfo = &pSkillInfo->mpSetpInfoArray[skillStep];

				/// ų ׷ ġ
				mDistressPoint = pStepInfo->mDistressValue;

				mCopyRange = pStepInfo->mBoundDist;
				mCopyApplyType = pSkillInfo->mApplyType;
				mAttriButeType = pSkillInfo->mAttributeType;
			}
		}
		else
		{
			sPlayerSkillStepInfo* pStepInfo = &pSkillInfo->mpSetpInfoArray[0];

			/// ų ׷ ġ
			mDistressPoint = pStepInfo->mDistressValue;

			mAttriButeType = pSkillInfo->mAttributeType;
		}
	}


	///   ȿ() ΰ   ð 
	if( pInfluence->mTime1 != 0 )	
	{
		mTime1 = mInfluenceCreationTime + pInfluence->mTime1;

		/// ȿ ȣ     ̸ ؼ   ִ´
		///    ü   Ұϰ Ǵ 츦 
		if( pInfluence->mStatusPlusIdx1 == eSTATUSPLUS_DOT_HPCHANGE_CALC_PLUS )
		{
			/// +ġ  -ġ 
			if( pInfluence->mValue1 > 0 )
				mInfluenceValue1 = DAMAGECALC->HealHPCalc( attacker, pInfluence->mValue1 );
			else	///    
				mInfluenceValue1 = pInfluence->mValue1;
		}
		else
			mInfluenceValue1 = pInfluence->mValue1;
	}

	///   ȿ() ΰ   ð 
	if( pInfluence->mTime2 != 0 )	
	{
		mTime2 = mInfluenceCreationTime + pInfluence->mTime2;

		/// ȿ ȣ     ̸ ؼ   ִ´
		///    ü   Ұϰ Ǵ 츦 
		if( pInfluence->mStatusPlusIdx2 == eSTATUSPLUS_DOT_MPCHANGE_CALC_PLUS )
		{
			/// +ġ  -ġ 
			if( pInfluence->mValue2 > 0 )
				mInfluenceValue2 = DAMAGECALC->HealHPCalc( attacker, pInfluence->mValue2 );
			else	///    
				mInfluenceValue2 = pInfluence->mValue2;
		}
		else
			mInfluenceValue2 = pInfluence->mValue2;
	}

	mInfluenceRestTime = 0;

	return true;
}


bool cInfluenceObject::SwitchChildTotemInit( sObject attacker, sObject target, unsigned long uniqueIdx, unsigned long infClassIdx,
										   unsigned long skillClassIdx, unsigned long parenUniqueIdx )
{

	/// ȿ ũƮ  о
	sInfluenceScript* pInfluence = SKILLSCRIPT->GetInfluenceInfo( infClassIdx );
	if( !pInfluence )	
	{ 
		assert(NULL); 
		NETWORK2->PostServerEvent("influence init - GetInfluenceInfo(%d)", infClassIdx);
		return false; 
	}

	mUniqueIdx = uniqueIdx;
	mDBIdx = 0;
	mInfluenceClassIdx = infClassIdx;
	mTarget = target;
	mAttacker = attacker;
	mSwitchType = eSWITCHTYPE_CHILD;
	mInfluenceCreationTime = NETWORK2->GetAccumTime();
	mCopyCheckTime = NETWORK2->GetAccumTime();
	mParentUniqueIdx = parenUniqueIdx;
	mIsTotem = true;

	/// ų ũƮ ʿ ġ  Ѵ.
	sPlayerSkillBaseInfo* pSkillInfo = SKILLSCRIPT->GetPlayerSkillInfo( skillClassIdx );
	if( pSkillInfo != NULL )	
	{ 
		cHaveSkillObject* pPlayerHaveSkill = SKILLMANAGER->GetPlayerHaveSkill( mAttacker.index, skillClassIdx );
		if( pPlayerHaveSkill )	
		{ 
			unsigned char skillStep = pPlayerHaveSkill->GetSkillStep();
			if( skillStep < pSkillInfo->mStepCount )
			{
				sPlayerSkillStepInfo* pStepInfo = &pSkillInfo->mpSetpInfoArray[skillStep];

				/// ų ׷ ġ
				mDistressPoint = pStepInfo->mDistressValue;

				mSwitchType = eSWITCHTYPE_PARENT;
				mCopyRange = pStepInfo->mBoundDist;
				mCopyApplyType = pSkillInfo->mApplyType;
				mAttriButeType = pSkillInfo->mAttributeType;
			}
		}
		else
		{
			sPlayerSkillStepInfo* pStepInfo = &pSkillInfo->mpSetpInfoArray[0];

			/// ų ׷ ġ
			mDistressPoint = pStepInfo->mDistressValue;

			mAttriButeType = pSkillInfo->mAttributeType;
		}
	}


	///   ȿ() ΰ   ð 
	if( pInfluence->mTime1 != 0 )	
	{
		mTime1 = mInfluenceCreationTime + pInfluence->mTime1;

		/// ȿ ȣ     ̸ ؼ   ִ´
		///    ü   Ұϰ Ǵ 츦 
		if( pInfluence->mStatusPlusIdx1 == eSTATUSPLUS_DOT_HPCHANGE_CALC_PLUS )
		{
			/// +ġ  -ġ 
			if( pInfluence->mValue1 > 0 )
				mInfluenceValue1 = DAMAGECALC->HealHPCalc( attacker, pInfluence->mValue1 );
			else	///    
				mInfluenceValue1 = pInfluence->mValue1;
		}
		else
			mInfluenceValue1 = pInfluence->mValue1;
	}

	///   ȿ() ΰ   ð 
	if( pInfluence->mTime2 != 0 )	
	{
		mTime2 = mInfluenceCreationTime + pInfluence->mTime2;

		/// ȿ ȣ     ̸ ؼ   ִ´
		///    ü   Ұϰ Ǵ 츦 
		if( pInfluence->mStatusPlusIdx2 == eSTATUSPLUS_DOT_MPCHANGE_CALC_PLUS )
		{
			/// +ġ  -ġ 
			if( pInfluence->mValue2 > 0 )
				mInfluenceValue2 = DAMAGECALC->HealHPCalc( attacker, pInfluence->mValue2 );
			else	///    
				mInfluenceValue2 = pInfluence->mValue2;
		}
		else
			mInfluenceValue2 = pInfluence->mValue2;
	}

	mInfluenceRestTime = 0;

	return true;
}


//bool cInfluenceObject::Init( unsigned long uniqueIdx, unsigned long influenceClassIdx, sObject target, sObject attacker, 
//							eAURATYPE auraType, unsigned short auraRange, eAPPLYTYPE auraCopyType, unsigned long skillClassIdx, 
//							eATTRIBUTETYPE attriButeType, bool loop, bool dieDelete, unsigned long* plusTime )
//{
//	mUniqueIdx = uniqueIdx;
//	mDBIdx = 0;
//	mInfluenceClassIdx = influenceClassIdx;
//	mTarget = target;
//	mAttacker = attacker;
//	mAuraType = auraType;
//	mAuraRange = auraRange;
//	mInfluenceCreationTime = NETWORK2->GetAccumTime();
//	mAuraCheckTime = mInfluenceCreationTime;
//	mAuraCopyType = auraCopyType;
//	mAttriButeType = attriButeType;
//	mDieDelete = dieDelete;
//	/// ų ȣ  ų ־ ش.
//	if( auraType == eSWITCHTYPE_PARENT )
//		mAuraSkillClassIdx = skillClassIdx;
//
//
//	/// ų ũƮ ʿ ġ  Ѵ.
//	sPlayerSkillBaseInfo* pSkillInfo = SKILLSCRIPT->GetPlayerSkillInfo( skillClassIdx );
//	if( pSkillInfo != NULL )	
//	{ 
//		cHaveSkillObject* pPlayerHaveSkill = SKILLMANAGER->GetPlayerHaveSkill( mAttacker.index, skillClassIdx );
//		if( pPlayerHaveSkill )	
//		{ 
//			unsigned char skillStep = pPlayerHaveSkill->GetSkillStep();
//			if( skillStep >= pSkillInfo->mStepCount )
//			{
//				sPlayerSkillStepInfo* pStepInfo = &pSkillInfo->mpSetpInfoArray[skillStep];
//
//				/// ų ׷ ġ
//				mDistressPoint = pStepInfo->mDistressValue;
//			}
//		}
//	}
//
//	/// ȿ ũƮ  о
//	sInfluenceScript* pInfluence = SKILLSCRIPT->GetInfluenceInfo( influenceClassIdx );
//	if( !pInfluence )	
//	{ 
//		assert(NULL); 
//		NETWORK2->PostServerEvent("influence init - GetInfluenceInfo(%d)", influenceClassIdx);
//		return false; 
//	}
//
//	mIsSleep = false;
//	if( pInfluence->mStatusPlusIdx1 == eSTATUSPLUS_SLEEP )
//		mIsSleep = true;
//	if( pInfluence->mStatusPlusIdx2 == eSTATUSPLUS_SLEEP )
//		mIsSleep = true;
//	if( pInfluence->mStatusPlusIdx3 == eSTATUSPLUS_SLEEP )
//		mIsSleep = true;
//
//	bool mIsStun = false;
//	if( pInfluence->mStatusPlusIdx1 == eSTATUSPLUS_STUN )
//		mIsStun = true;
//	if( pInfluence->mStatusPlusIdx2 == eSTATUSPLUS_STUN )
//		mIsStun = true;
//	if( pInfluence->mStatusPlusIdx3 == eSTATUSPLUS_STUN )
//		mIsStun = true;
//
//	///   ȿ() ΰ   ð 
//	if( pInfluence->mTime1 != 0 )	
//	{
//		mTime1 = mInfluenceCreationTime + pInfluence->mTime1;
//
//		/// ȿ ȣ     ̸ ؼ   ִ´
//		///    ü   Ұϰ Ǵ 츦 
//		if( pInfluence->mStatusPlusIdx1 == eSTATUSPLUS_DOT_HPCHANGE_CALC_PLUS )
//		{
//			/// +ġ  -ġ 
//			if( pInfluence->mValue1 > 0 )
//				mInfluenceValue1 = DAMAGECALC->HealHPCalc( attacker, pInfluence->mValue1 );
//			else	///    
//				mInfluenceValue1 = pInfluence->mValue1;
//		}
//		else
//			mInfluenceValue1 = pInfluence->mValue1;
//	}
//
//	///   ȿ() ΰ   ð 
//	if( pInfluence->mTime2 != 0 )	
//	{
//		mTime2 = mInfluenceCreationTime + pInfluence->mTime2;
//
//		/// ȿ ȣ     ̸ ؼ   ִ´
//		///    ü   Ұϰ Ǵ 츦 
//		if( pInfluence->mStatusPlusIdx2 == eSTATUSPLUS_DOT_MPCHANGE_CALC_PLUS )
//		{
//			/// +ġ  -ġ 
//			if( pInfluence->mValue2 > 0 )
//				mInfluenceValue2 = DAMAGECALC->HealHPCalc( attacker, pInfluence->mValue2 );
//			else	///    
//				mInfluenceValue2 = pInfluence->mValue2;
//		}
//		else
//			mInfluenceValue2 = pInfluence->mValue2;
//	}
//
//	mInfluenceRestTime = pInfluence->mContinuanceTime;
//
//	if( ( mIsSleep == true || mIsStun == true ) && plusTime != NULL )
//		mInfluenceRestTime = mInfluenceRestTime + *plusTime;
//	else
//		*plusTime = 0;
//
//	mLoop = loop;
//
//	return true;
//}



bool cInfluenceObject::RestorePlayerInfluence( unsigned long playerIdx, unsigned long uniqueidx, sInfluence* pInfluence )
{
	/// db о ڷ gamein ޼  μ  ʴ´.
	mProcessStart = false;

	mUniqueIdx = uniqueidx;
	mDBIdx = pInfluence->mDbIdx;

	mInfluenceClassIdx = pInfluence->mInfluenceClassIdx;

	///  DB  Ǿ 
	mCopySkillClassIdx = 0;

	sInfluenceScript* pPlayerInfluence = SKILLSCRIPT->GetInfluenceInfo( mInfluenceClassIdx );
	if( !pPlayerInfluence )	
	{ 
		assert(NULL); 
		NETWORK2->PostServerEvent("cInfluenceObject::RestorePlayerInfluence - pPlayer[%d]Influence[%d] == NULL", playerIdx, mInfluenceClassIdx );
		return false; 
	}

	mTarget.index = playerIdx;
	mTarget.type = eOBJECTTYPE_PLAYER;

	mAttacker = pInfluence->mAttacker;

	/// DB о ȿ Ŭ̾Ʈ gamein ޼   ȿ  ̴.
	mInfluenceCreationTime = NETWORK2->GetAccumTime();

	mInfluenceRestTime = pInfluence->mRestTime;// * SECOND_THOUSAND;

	mTime1 = 0; 
	mTime2 = 0; 

	///   ȿ() ΰ   ð 
	if( pInfluence->mTime1 != 0 )	
	{
		mTime1 = mInfluenceCreationTime + pInfluence->mTime1;
		mInfluenceValue1 = pInfluence->mInfluenceValue1;
	}

	///   ȿ() ΰ   ð 
	if( pInfluence->mTime2 != 0 )	
	{
		mTime2 = mInfluenceCreationTime + pInfluence->mTime2;
		mInfluenceValue2 = pInfluence->mInfluenceValue2;
	}

	mAttriButeType = (eATTRIBUTETYPE)pInfluence->mAttriButeType;

	mParentUniqueIdx = 0;
	mCopyRange = 0;
	mCopyCheckTime = 0;
	mCopyApplyType = eAPPLYTYPE_SELF;
	mCopySkillClassIdx = 0;

	return true;
}


void cInfluenceObject::ProcessStart()
{ 
	mInfluenceCreationTime = NETWORK2->GetAccumTime();
	mProcessStart = true; 
}


void cInfluenceObject::ProcessStop()
{ 
	if( mSwitchType == eSWITCHTYPE_NONE )
	{
		unsigned long accum = NETWORK2->GetAccumTime();

		if( accum - mInfluenceCreationTime >= mInfluenceRestTime )
			mInfluenceRestTime = 0;
		else
			mInfluenceRestTime = mInfluenceRestTime - (accum - mInfluenceCreationTime);
	}

	mProcessStart = false; 
}


void cInfluenceObject::SavePlayerInfluence( sInfluence* pInfluence )
{
	sInfluenceScript* pPlayerInfluence = SKILLSCRIPT->GetInfluenceInfo( mInfluenceClassIdx );
	if( !pPlayerInfluence )	
	{ 
		assert(NULL); 
		NETWORK2->PostServerEvent( "db Influence save - GetInfluenceInfo( %d )", mInfluenceClassIdx );
		return; 
	}

	unsigned long currenttime = NETWORK2->GetAccumTime();

	pInfluence->mInfluenceClassIdx = mInfluenceClassIdx;
	pInfluence->mAttacker = mAttacker;
	pInfluence->mIsRealTime = false;

	if( currenttime - mInfluenceCreationTime >= mInfluenceRestTime )
		pInfluence->mRestTime = 0;
	else
		pInfluence->mRestTime =  mInfluenceRestTime - (currenttime-mInfluenceCreationTime);

	if( !pInfluence->mIsRealTime )
	{
		pInfluence->mStartDate.year = 1753;
		pInfluence->mStartDate.month = 1;
		pInfluence->mStartDate.day = 1;
		pInfluence->mStartDate.hour = 0;
		pInfluence->mStartDate.minute = 0;
		pInfluence->mStartDate.second = 0;
		pInfluence->mStartDate.fraction = 0;
		pInfluence->mEndDate.year = 1753;
		pInfluence->mEndDate.month = 1;
		pInfluence->mEndDate.day = 1;
		pInfluence->mEndDate.hour = 0;
		pInfluence->mEndDate.minute = 0;
		pInfluence->mEndDate.second = 0;
		pInfluence->mEndDate.fraction = 0;
	}

	if( pPlayerInfluence->mTime1 != 0.0f )
		pInfluence->mTime1 = mTime1 - currenttime; 
	else					
		pInfluence->mTime1 = 0; 

	if( pPlayerInfluence->mTime2 != 0.0f )
		pInfluence->mTime2 = mTime2 - currenttime; 
	else					
		pInfluence->mTime2 = 0; 

	pInfluence->mInfluenceValue1 = mInfluenceValue1;
	pInfluence->mInfluenceValue2 = mInfluenceValue2;

	pInfluence->mAttriButeType = (unsigned char)mAttriButeType;
}



bool cInfluenceObject::Process( unsigned long /*elapsedTime*/, unsigned long accumTime )
{
	if( mIsDelReady	== true )
		return true;

	if( !mProcessStart ) 
		return true; 

	cBaseObject* pTarget = OBJECTMANAGER->GetObject( mTarget.type, mTarget.index );
	if( pTarget == NULL || ( pTarget->GetStateDie() == true && mDieDelete == true ) )
		return false;

	sInfluenceScript* pInfluence = SKILLSCRIPT->GetInfluenceInfo( mInfluenceClassIdx );
	if( pInfluence == NULL )
		return false;

	unsigned long scriptTime1 = pInfluence->mTime1;
	unsigned long scriptTime2 = pInfluence->mTime2;

	if( mTime1 != 0 )
	{
		if( mTime1 <= accumTime )
		{
			mTime1 = mTime1 + scriptTime1;

			///  ȿ ó
			DotInfluence( (eSTATUS_PLUS)pInfluence->mStatusPlusIdx1, mInfluenceValue1 );
		}
	}


	if( mTime2 != 0 )
	{
		if( mTime2 <= accumTime )
		{
			mTime2 = mTime2 + scriptTime2;

			///  ȿ ó
			DotInfluence( (eSTATUS_PLUS)pInfluence->mStatusPlusIdx2, mInfluenceValue2 );
		}
	}

	/// ȿ ð  
	if( mSwitchType == eSWITCHTYPE_NONE && mInfluenceCreationTime + mInfluenceRestTime <= accumTime  )
		return false;

	/// ȿ  ΰ ȿ  Ÿٿ ȿ 
	if( mSwitchType == eSWITCHTYPE_PARENT )
	{
		if( mCopyCheckTime <= accumTime )
		{
			CopyAuraInfluence();
			mCopyCheckTime = accumTime + AURA_CHECK_TIME;
		}
	}
	else if ( mSwitchType == eSWITCHTYPE_CHILD )
	{
		/// ۻ/ȿ 
		if( mIsTotem == true )
		{
			/// θȿ Ÿ üũ
			if( mCopyCheckTime <= accumTime )
			{
				cBaseObject* pTarget = OBJECTMANAGER->GetObject( mTarget.type, mTarget.index );
				if( pTarget == NULL )
				{
					CheckTotemInfluence();
					return false;
				}

				if( CheckTotemInfluence() == true )
					return false;

				mCopyCheckTime = accumTime + AURA_CHECK_TIME;
			}
		}
		else
		{
			/// θȿ Ÿ üũ
			if( mCopyCheckTime <= accumTime )
			{
				cBaseObject* pTarget = OBJECTMANAGER->GetObject( mTarget.type, mTarget.index );
				if( pTarget == NULL || pTarget->GetStateDie() == true )
				{
					/// ȿ 
					DeleteChildAuraInfluence();
					return false;
				}

				if( DeleteChildAuraInfluence() == true )
					return false;

				mCopyCheckTime = accumTime + AURA_CHECK_TIME;
			}
		}
	}

	return true;
}


bool cInfluenceObject::IsTotemEqual( unsigned long uniqueIdx )
{
	if( mIsTotem == true && mParentUniqueIdx == uniqueIdx )
		return true;

	return false;
}

void cInfluenceObject::DotInfluence( eSTATUS_PLUS statusPlusIdx, long influenceValue )
{

	cBaseObject* pTargetObject = OBJECTMANAGER->GetObject( mTarget.type, mTarget.index );
	if( pTargetObject == NULL || pTargetObject->GetStateDie() == true )
		return;

	long value = 0;

	switch( statusPlusIdx )
	{
	case eSTATUSPLUS_DOT_HPCHANGE_PLUS:
	case eSTATUSPLUS_DOT_HPCHANGE_CALC_PLUS:
		value = influenceValue;
		break;
	case eSTATUSPLUS_DOT_MPCHANGE_PLUS:
	case eSTATUSPLUS_DOT_MPCHANGE_CALC_PLUS:
		value = influenceValue;
		break;
	case eSTATUSPLUS_DOT_HPCHANGE_PER:
		value = FloatToInt( (float)pTargetObject->GetMaxHP() * influenceValue * 0.01f );
		break;
	case eSTATUSPLUS_DOT_MPCHANGE_PER:
		value = FloatToInt( (float)pTargetObject->GetMaxMP() * influenceValue * 0.01f );
		break;
	}

	switch( statusPlusIdx )
	{
	case eSTATUSPLUS_DOT_HPCHANGE_PER:
	case eSTATUSPLUS_DOT_HPCHANGE_PLUS:
		{
			bool die = false;
			unsigned long applyDamage = value;

			/// Է° 0 ũϱ healó
			if( value > 0 )
				pTargetObject->HPHeal( value, false, mAttacker.index, mDistressPoint, eTAKEDAMAGETYPE_HEAL );
			else
			{
				/// Է° 0   ó
				unsigned long damage = abs(value);

				///  
				unsigned long absorbPhyPer = pTargetObject->GetStateOddity( eODDITYTYPE_DAMAGE_ABSORB_PHY );
				unsigned long absorbMagPer = pTargetObject->GetStateOddity( eODDITYTYPE_DAMAGE_ABSORB_MAG );

				if( mAttriButeType == eATTRIBUTETYPE_PHYSICAL && absorbPhyPer != 0 )
				{
					if( absorbPhyPer < 0 )		absorbPhyPer = 0;
					if( absorbPhyPer > 100 )	absorbPhyPer = 100;
					damage = FloatToInt( damage * ( 100 - absorbPhyPer ) * 0.01f );
				}
				else if( mAttriButeType == eATTRIBUTETYPE_MAGIC && absorbMagPer != 0 )
				{
					if( absorbMagPer < 0 )		absorbMagPer = 0;
					if( absorbMagPer > 100 )	absorbMagPer = 100;
					damage = FloatToInt( damage * ( 100 - absorbMagPer ) * 0.01f );
				}

				if( damage == 0 )
					damage = 1;

				///  ó
				if( mAttriButeType == eATTRIBUTETYPE_PHYSICAL && pTargetObject->GetStateOddity( eODDITYTYPE_INVINCIBILITY_PHY ) != 0 )
					damage = 0;
				else if( mAttriButeType == eATTRIBUTETYPE_MAGIC && pTargetObject->GetStateOddity( eODDITYTYPE_INVINCIBILITY_MAG ) != 0 )
					damage = 0;

				///  ݻ
				unsigned long reflectionPhyPer = pTargetObject->GetStateOddity( eODDITYTYPE_DAMAGE_REFLECTION_PHY );
				unsigned long reflectionMagPer = pTargetObject->GetStateOddity( eODDITYTYPE_DAMAGE_REFLECTION_MAG );
				unsigned long reflection = 0;
				if( mAttriButeType == eATTRIBUTETYPE_PHYSICAL && reflectionPhyPer != 0 )
				{
					if( reflectionPhyPer < 0 )		reflectionPhyPer = 0;
					if( reflectionPhyPer > 100 )	reflectionPhyPer = 100;
					reflection = FloatToInt( damage * reflectionPhyPer * 0.01f );
					damage = damage - reflection;
				}
				else if( mAttriButeType == eATTRIBUTETYPE_MAGIC && reflectionMagPer != 0 )
				{
					if( reflectionMagPer < 0 )		reflectionMagPer = 0;
					if( reflectionMagPer > 100 )	reflectionMagPer = 100;
					reflection = FloatToInt( damage * reflectionMagPer * 0.01f );
					damage = damage - reflection;
				}

				///   üũ   hpdamage  ó
				if( DUELMANAGER->DuelLastAttack( mAttacker, mTarget, damage, false, &applyDamage ) == false )
					applyDamage = pTargetObject->HPDamage( damage, &die, false );

				///   ó
				pTargetObject->AddTakeDamage( mAttacker, applyDamage, mDistressPoint, eTAKEDAMAGETYPE_DAMAGE );	

				///  hp/mp ó
				cBaseObject* pAttacker = OBJECTMANAGER->GetObject( mAttacker.type, mAttacker.index );
				if( pAttacker != NULL )
				{
					///  ݻ Ѿ   
					long attackerDamage = reflection;
					unsigned long attackerApplyDamage = 0;

					unsigned long attkAbsorbHPPer = pAttacker->GetStateOddity( eODDITYTYPE_HP_ABSORB );	///  HP 
					unsigned long attkAbsorbMPPer = pAttacker->GetStateOddity( eODDITYTYPE_MP_ABSORB ); ///  MP 

					///   hp
					if( attkAbsorbHPPer != 0 )
					{
						if( attkAbsorbHPPer < 0 )	attkAbsorbHPPer = 0;
						if( attkAbsorbHPPer > 100 )	attkAbsorbHPPer = 100;
						unsigned long attkAbsorbHP = FloatToInt( applyDamage * attkAbsorbHPPer * 0.01f );
						/// hpŭ  ġ 
						attackerDamage = attackerDamage - attkAbsorbHP;

					}

					///   mp
					if( attkAbsorbMPPer != 0 )
					{
						if( attkAbsorbMPPer < 0 )	attkAbsorbMPPer = 0;
						if( attkAbsorbMPPer > 100 )	attkAbsorbMPPer = 100;
						unsigned long attkAbsorbMP = FloatToInt( applyDamage * attkAbsorbMPPer * 0.01f );

						pAttacker->MPHeal( attkAbsorbMP, false );

						MSG_SYN_SKILL_INFLUENCE_MPCHANGE msg; 
						msg.Category = NM_SKILL;
						msg.Protocol = NM_SKILL_INFLUENCE_MPCHAGNE_SYN;
						msg.mInfluenceIdx = mUniqueIdx;
						msg.mTarget = mAttacker;
						msg.mChangeValue = value;
						msg.mObjectMP = pAttacker->GetMP();
						msg.mObjectMaxMP = pAttacker->GetMaxMP();

						NETWORK2->QuickSend( pTargetObject, (char*)&msg, sizeof(msg) );
					}

					///   HP ó
					if( attackerDamage > 0 )
					{
						///   üũ   hpdamage  ó
						if( DUELMANAGER->DuelLastAttack( mTarget, mAttacker, attackerDamage, eDAMAGE_NORMAL, &attackerApplyDamage ) == false )
							attackerApplyDamage = pAttacker->HPDamage( attackerDamage, &die, false, eDAMAGE_NORMAL );

						///   ó
						pAttacker->AddTakeDamage( mTarget, attackerDamage, mDistressPoint, eTAKEDAMAGETYPE_DAMAGE );

						MSG_SYN_SKILL_INFLUENCE_HPCHANGE msg; 
						msg.Category = NM_SKILL;
						msg.Protocol = NM_SKILL_INFLUENCE_HPCHAGNE_SYN;
						msg.mInfluenceIdx = mUniqueIdx;
						msg.mTarget = mAttacker;
						msg.mChangeValue = value;
						msg.mObjectHP = pAttacker->GetHP();
						msg.mObjectMaxHP = pAttacker->GetMaxHP();
						msg.mDie = die;

						NETWORK2->QuickSend( pTargetObject, (char*)&msg, sizeof(msg) );
					}
					else if( attackerDamage < 0 )		///  ݻ
					{
						pAttacker->HPHeal( -attackerDamage, false, 0, 0, eTAKEDAMAGETYPE_NONE );

						MSG_SYN_SKILL_INFLUENCE_HPCHANGE msg; 
						msg.Category = NM_SKILL;
						msg.Protocol = NM_SKILL_INFLUENCE_HPCHAGNE_SYN;
						msg.mInfluenceIdx = mUniqueIdx;
						msg.mTarget = mAttacker;
						msg.mChangeValue = value;
						msg.mObjectHP = pAttacker->GetHP();
						msg.mObjectMaxHP = pAttacker->GetMaxHP();
						msg.mDie = die;

						NETWORK2->QuickSend( pTargetObject, (char*)&msg, sizeof(msg) );
					}
				}
			}

			/// ȿ  Ÿ HP ó
			MSG_SYN_SKILL_INFLUENCE_HPCHANGE msg; 
			msg.Category = NM_SKILL;
			msg.Protocol = NM_SKILL_INFLUENCE_HPCHAGNE_SYN;
			msg.mInfluenceIdx = mUniqueIdx;
			msg.mTarget = mTarget;
			msg.mChangeValue = applyDamage;
			msg.mObjectHP = pTargetObject->GetHP();
			msg.mObjectMaxHP = pTargetObject->GetMaxHP();
			msg.mDie = die;

			NETWORK2->QuickSend( pTargetObject, (char*)&msg, sizeof(msg) );

		}break;
	case eSTATUSPLUS_DOT_MPCHANGE_PER:
	case eSTATUSPLUS_DOT_MPCHANGE_PLUS:	/// MPȸ
		{

			if( value > 0 )
				pTargetObject->MPHeal( value, false );
			else
				pTargetObject->MPDamage( abs(value), false );

			MSG_SYN_SKILL_INFLUENCE_MPCHANGE msg; 
			msg.Category = NM_SKILL;
			msg.Protocol = NM_SKILL_INFLUENCE_MPCHAGNE_SYN;
			msg.mInfluenceIdx = mUniqueIdx;
			msg.mTarget = mTarget;
			msg.mChangeValue = value;
			msg.mObjectMP = pTargetObject->GetMP();
			msg.mObjectMaxMP = pTargetObject->GetMaxMP();

			NETWORK2->QuickSend( pTargetObject, (char*)&msg, sizeof(msg) );
		}break;
	}
}


///  ȿ  ȿ شǴ object  
void cInfluenceObject::CopyAuraInfluence()
{
	///  ȿ Ÿ  ȵȴ.
	if( mCopyRange == 0.0f )
		return;

	if( mTarget.type == eOBJECTTYPE_PLAYER )
	{
		///  ȿ θü
		cPlayer* pParentObejct = OBJECTMANAGER->GetPlayer( mTarget.index );
		if( pParentObejct == NULL )
			return;

		/// θü ġ Ÿ ġ
		NiPoint3 parentPos( pParentObejct->GetXPos(), pParentObejct->GetYPos(), pParentObejct->Height() );
		mRangeCheck.SetRadius( mCopyRange );

		switch( mCopyApplyType )
		{
		case eAPPLYTYPE_PARTY:
			{
				/// Ƽ  о
				cParty* pParty = PARTYMAN->GetParty( ((cPlayer*)pParentObejct)->GetPartyIndex() );
				if( pParty == NULL )	/// Ƽ  ִ
					return;

				unsigned long* userArr = pParty->GetUserArr();
				unsigned int partyCount = pParty->GetCount();

				for( unsigned int i = 0 ; i < partyCount ; ++i )
				{
					/// ڽ 
					if( userArr[i] == pParentObejct->GetObjectID() )
						continue;

					/// Ƽ о
					cPlayer* pChild = OBJECTMANAGER->GetPlayer( userArr[i] );
					if( pChild == NULL )
						continue;

					if( pChild->GetGameIn() == false )
						continue;

					/// Ÿȿ  
					NiPoint3 childPos( pChild->GetXPos(), pChild->GetYPos(), pChild->Height() );
					if( mRangeCheck.IsRange( childPos, parentPos ) )
					{
						///   ȿ Ǵ° 
						if( pChild->IsParentEqual( mUniqueIdx ) == true )
							continue;	

						auraTemp aura;
						aura.target = pChild->GetObject();
						aura.influenceClassIdx = mInfluenceClassIdx;
						aura.attacker = mTarget;
						aura.skillClassIdx = 0;
						aura.msgSend = true;
						aura.parentUniqueIdx = mUniqueIdx;

						SKILLMANAGER->AddAuraChild( aura );
					}
				}
			}
			break;
		case eAPPLYTYPE_BUDDY:
			{
				cPlayer* pChild = GRIDMANAGER->FindFirstPlayer( pParentObejct );
				while( pChild != NULL )
				{

					/// ڽ 
					if( pChild->GetObjectID() == mTarget.index && pChild->GetObjectType() == mTarget.type )
					{
						pChild = GRIDMANAGER->FindNextPlayer();
						continue;
					}

					NiPoint3 childPos( pChild->GetXPos(), pChild->GetYPos(), pChild->Height() );
					if( mRangeCheck.IsRange( childPos, parentPos ) )
					{
						///   ȿ Ǵ° 
						if( pChild->IsParentEqual( mUniqueIdx ) == true )
						{
							pChild = GRIDMANAGER->FindNextPlayer();
							continue;					
						}

						auraTemp aura;
						aura.target = pChild->GetObject();
						aura.influenceClassIdx = mInfluenceClassIdx;
						aura.attacker = mTarget;
						aura.skillClassIdx = 0;
						aura.msgSend = true;
						aura.parentUniqueIdx = mUniqueIdx;

						SKILLMANAGER->AddAuraChild( aura );
					}	
					pChild = GRIDMANAGER->FindNextPlayer();
				}
			}
			break;
		case eAPPLYTYPE_SELF:
			break;
		default:
			NETWORK2->PostServerEvent("cSkillManager::CopyAuraInfluence mAuraCopyType[%d,%d,%d,%d] ERROR ", 
				mCopyApplyType, pParentObejct->GetObjectID(), pParentObejct->GetState(), pParentObejct->GetStateStop() );
		}
	}
}


bool cInfluenceObject::DeleteChildAuraInfluence()
{

	cInfluenceObject* pInfluenceObject = SKILLMANAGER->GetInfluence( mParentUniqueIdx );
	if( pInfluenceObject == NULL )
		return true;

	cBaseObject* pParent = OBJECTMANAGER->GetObject( mAttacker.type, mAttacker.index );
	if( pParent == NULL || pParent->GetStateDie() == true )
		return true;

	cBaseObject* pChild = OBJECTMANAGER->GetObject( mTarget.type, mTarget.index );
	if( pChild == NULL || pChild->GetStateDie() == true )
		return true;

	if( pParent->GetMapNumber() != pChild->GetMapNumber() )
		return true;

	NiPoint3 parentPos( pParent->GetXPos(), pParent->GetYPos(), pParent->Height() );
	NiPoint3 childPos( pChild->GetXPos(), pChild->GetYPos(), pChild->Height() );

	cRangeCheck rangeCheck( pInfluenceObject->GetRange() );
	return rangeCheck.IsNotRange( parentPos, childPos );
}


bool cInfluenceObject::CheckTotemInfluence()
{
	/// θ  ü Ȯ
	cTotem* pTotemObject = OBJECTMANAGER->GetTotem( mParentUniqueIdx );
	if( pTotemObject == NULL )
		return true;

	cBaseObject* pTarget = OBJECTMANAGER->GetObject( mTarget.type, mTarget.index );
	if( pTarget == NULL )
	{
		pTotemObject->EraseTarget( mTarget );	/// θ ۿ Ÿ  
		return true;
	}

	/// θ  ȿ(Ÿ) Ÿ 
	NiPoint3 parentPos( pTotemObject->GetXPos(), pTotemObject->GetYPos(), pTotemObject->Height() );
	NiPoint3 childPos( pTarget->GetXPos(), pTarget->GetYPos(), pTarget->Height() );

	cRangeCheck rangeCheck( pTotemObject->GetRange() );
	if( rangeCheck.IsNotRange( parentPos, childPos ) == true )
	{
		pTotemObject->EraseTarget( mTarget );	/// θ ۿ Ÿ  
		return true;
	}

	return false;
}


void cInfluenceObject::TotemSetEraseTarget()
{
	/// θ  ü Ȯ
	cTotem* pTotemObject = OBJECTMANAGER->GetTotem( mParentUniqueIdx );
	if( pTotemObject != NULL )
		pTotemObject->EraseTarget( mTarget );
}
