/* ==========================================================================
*      : Item.h
*      : 
*    : ö
*    : 2007-11-05
* ǻ :
*===========================================================================*/
#pragma once

#include "Item_Common.h"
#include "BaseObject.h"

class cItem : public cBaseObject
{
private:
	sObject       mFromObject;
	sObject       mOpenObject;

	bool          mGetAuto;
	bool          mOpen;
	bool          mOwn;
	unsigned long mTimeToLive;
	unsigned long mTimeToOwn;

	BYTE          mOwnerCount;
	unsigned long mOwner[ MAX_OWNER ];

	BYTE          mRowCount;
	sItemData     mItemData[ MAX_ITEMS ];

public:
	cItem(void);
	virtual ~cItem(void);

	void* operator new                ( size_t n ); 
	void  operator delete             ( void* ptr, size_t n );

	//  ʱȭ
	bool           Init               ( unsigned long itemIdx, cBaseObject* baseObject, bool getAuto );

	bool           IsGetAuto          ( ) { return mGetAuto; }
	bool           IsOwner            ( cBaseObject* baseObject );
	bool           IsOpen             ( cBaseObject* baseObject );

	bool           PushOwner          ( unsigned long ownerIndex );

	void           GetOwnerInfo       ( unsigned long* owner, int ownerLen, unsigned long& timeToOwn );

	unsigned short PushItem           ( unsigned long itemDefineIndex, unsigned short count );
	unsigned short PopItem            ( unsigned long itemDefineIndex, unsigned short count );

	BYTE           GetItemData        ( sItemData* itemData );
	sItemData*     GetItemData        ( BYTE& rowCount );

	void           Open               ( cBaseObject* baseObject );
	bool           Close              ( );

	bool           Update             ( unsigned long elapsedTime, unsigned long accumTime );

	// cBaseObject   Լ - .
	unsigned long  GetHP              ( ) { return 0; }
	unsigned long  GetMP              ( ) { return 0; }
	unsigned long  GetMaxHP           ( ) { return 0; }
	unsigned long  GetMaxMP           ( ) { return 0; }

	float          GetFixedObjectSize ( ) { return 0.0f; }

public:
	bool           SendSightIn        ( char category, char protocol, unsigned long connectionIdx );
	bool           SendSightOut       ( char category, char protocol, unsigned long connectionIdx );
};
