/* ====================================================================
 *      :	ItemCountPool.h
 *      :	
 *    :	ö
 *    :	09/01/19
 * ǻ :	
 * =================================================================== */
#ifndef __ITEM_COUNT_POOL_H__
#define __ITEM_COUNT_POOL_H__

///#ifndef WINVER
///#define WINVER          0x0500
///#endif
///
///#ifndef _WIN32_WINNT
///#define _WIN32_WINNT    0x0500
///#endif

#pragma once

#include "memorypool.h"

struct PerItemCount : PerNode
{
	long index;							// K   ̺ ȹ/з
	long bag;							//   "                  -
	long etc;						    //   "                  -Ÿ
	long sum;							//   "                  -հ
};

struct ItemCountRoot : NodeRoot
{};

class cItemCountPool
{
private:
	PerItemCount* mNonPagedPoolUsage;	//  ȵ Ǯ.

public:
	cItemCountPool( );

	void          Shutdown         ( );

	PerItemCount* SearchItemCount  ( ItemCountRoot* root, long index );
	PerItemCount* UpdateItemCount  ( ItemCountRoot* root, long index, short number, short count );

	PerItemCount* GetItemCount     ( ItemCountRoot* root, long index, short number, short count );
	void          ReleaseItemCount ( ItemCountRoot* root, PerItemCount* perItemCount );

public:
	virtual ~cItemCountPool(void);

public:
	static cItemCountPool* mpItemCountPool;
};

#define ITEMCOUNTPOOL     cItemCountPool::mpItemCountPool

#endif /// __ITEM_COUNT_POOL_H__
