/* ====================================================================
 *      :	ItemManager.h
 *      :	
 *    :	ö
 *    :	07/11/02
 * ǻ :	
 * =================================================================== */
#ifndef __ITEM_MANAGER_H__
#define __ITEM_MANAGER_H__

///#ifndef WINVER
///#define WINVER          0x0500
///#endif
///
///#ifndef _WIN32_WINNT
///#define _WIN32_WINNT    0x0500
///#endif

#pragma once

#include "gamesrvdefines.h"

///  Npc  
const int NPCSTORE_TAB_COUNT = 5;
const int NPCSTORESHEET_SLOT_COUNT = 25;

/// 080402 PKH Npc
class cItemNpcStore
{
typedef tHashSet<unsigned int> cHashSet;

private:
	cHashSet	mItemIndex;

public:
	bool Load      ( cParser& parser );
	bool LoadTab   ( cParser& parser );

	bool IsItemIdx ( unsigned int itemIdx ) { return ( mItemIndex.Find( itemIdx ) == mItemIndex.End() ) ? false : true; }
};

class cItemManager
{
typedef tPointerHashMap<unsigned long, TB_ITEM_DEFINE*> ItemDefineMap;

private:
	TB_ITEM_DEFINE*        mItemDefine;
	DWORD                  mItemDefineOffset;
	DWORD                  mItemDefineLength;

	TB_ITEM_ABILITY*       mItemAbility;
	DWORD                  mItemAbilityOffset;
	DWORD                  mItemAbilityLength;

	TB_ITEM_COOLTIME2*     mItemCooltime2;
	DWORD                  mItemCooltime2Offset;
	DWORD                  mItemCooltime2Length;

	TB_ITEM_LIMIT*         mItemLimit;
	DWORD                  mItemLimitOffset;
	DWORD                  mItemLimitLength;

	TB_ITEM_CARD*          mItemCard;
	DWORD                  mItemCardOffset;
	DWORD                  mItemCardLength;

	TB_ITEM_CARD_SLOT*     mItemCardSlot;
	DWORD                  mItemCardSlotOffset;
	DWORD                  mItemCardSlotLength;

	TB_ITEM_TAROT*         mItemTarot;
	DWORD                  mItemTarotOffset;
	DWORD                  mItemTarotLength;

	TB_ITEM_ENHANCED*      mItemEnhanced;
	DWORD                  mItemEnhancedOffset;
	DWORD                  mItemEnhancedLength;

	TB_ITEM_ENHANCED_RATE* mItemEnhancedRate;
	DWORD                  mItemEnhancedRateOffset;
	DWORD                  mItemEnhancedRateLength;

	TB_ITEM_DISJOINT*      mItemDisjoint;
	DWORD                  mItemDisjointOffset;
	DWORD                  mItemDisjointLength;

	TB_ITEM_CHANGE*        mItemChange;
	DWORD                  mItemChangeOffset;
	DWORD                  mItemChangeLength;

	ItemDefineMap*         mItemDefineMap;

	unsigned long          mItemDropIdx;
	unsigned long          mLastDropIdx;

	/// 080402 PKH Npc
	typedef tHashMap<unsigned int, void*> cNpcStoreMap;
	cNpcStoreMap mNpcStoreMap;

public:
	cItemManager(void);

	bool                   Init                  ( );

	void                   AllocItemDefine       ( DWORD length );
	void                   FreeItemDefine        ( );

	void                   AllocItemAbility      ( DWORD length );
	void                   FreeItemAbility       ( );

	void                   AllocItemCooltime2    ( DWORD length );
	void                   FreeItemCooltime2     ( );

	void                   AllocItemLimit        ( DWORD length );
	void                   FreeItemLimit         ( );

	void                   AllocItemCard         ( DWORD length );
	void                   FreeItemCard          ( );

	void                   AllocItemCardSlot     ( DWORD length );
	void                   FreeItemCardSlot      ( );

	void                   AllocItemTarot        ( DWORD length );
	void                   FreeItemTarot         ( );

	void                   AllocItemEnhanced     ( DWORD length );
	void                   FreeItemEnhanced      ( );

	void                   AllocItemEnhancedRate ( DWORD length );
	void                   FreeItemEnhancedRate  ( );

	void                   AllocItemDisjoint     ( DWORD length );
	void                   FreeItemDisjoint      ( );

	void                   AllocItemChange       ( DWORD length );
	void                   FreeItemChange        ( );

	bool                   CheckItemDefine       ( ) { return mItemDefineOffset == mItemDefineLength; }
	bool                   CheckItemAbility      ( ) { return mItemAbilityOffset == mItemAbilityLength; }
	bool                   CheckItemCooltime2    ( ) { return mItemCooltime2Offset == mItemCooltime2Length; }
	bool                   CheckItemLimit        ( ) { return mItemLimitOffset == mItemLimitLength; }
	bool                   CheckItemCard         ( ) { return mItemCardOffset == mItemCardLength; }
	bool                   CheckItemCardSlot     ( ) { return mItemCardSlotOffset == mItemCardSlotLength; }
	bool                   CheckItemTarot        ( ) { return mItemTarotOffset == mItemTarotLength; }
	bool                   CheckItemEnhanced     ( ) { return mItemEnhancedOffset == mItemEnhancedLength; }
	bool                   CheckItemEnhancedRate ( ) { return mItemEnhancedRateOffset == mItemEnhancedRateLength; }
	bool                   CheckItemDisjoint     ( ) { return mItemDisjointOffset == mItemDisjointLength; }
	bool                   CheckItemChange       ( ) { return mItemChangeOffset == mItemChangeLength; }

	bool                   IsItemDefineIndex     ( long idx );
	bool                   IsItemDefineType      ( long idx, ITEM_TYPE type );
	bool                   IsItemDefineType      ( long idx, ITEM_TYPE type, ITEM_TYPE subType );

	ITEM_TYPE              GetItemDefineType     ( long itemDefineIdx );
	ITEM_TYPE              GetItemDefineSubType  ( long itemDefineIdx );

	TB_ITEM_DEFINE*        GetItemDefineByIndex  ( long itemDefineIndex ) { return mItemDefineMap->GetAt( itemDefineIndex ); }
	TB_ITEM_DEFINE*        GetItemDefine         ( long itemDefineIdx );
	TB_ITEM_ABILITY*       GetItemAbility        ( long itemDefineIdx );
	TB_ITEM_COOLTIME2*     GetItemCooltime2      ( long itemDefineIdx );
	TB_ITEM_LIMIT*         GetItemLimit          ( long itemDefineIdx );
	TB_ITEM_CARD*          GetItemCard           ( long itemDefineIdx );
	TB_ITEM_CARD_SLOT*     GetItemCardSlot       ( long itemDefineIdx );
	TB_ITEM_TAROT*         GetItemTarot          ( long itemDefineIdx );
	TB_ITEM_ENHANCED*      GetItemEnhanced       ( long itemDefineIdx );
	TB_ITEM_ENHANCED_RATE* GetItemEnhancedRate   ( long itemDefineIdx );
	TB_ITEM_DISJOINT*      GetItemDisjoint       ( long itemDefineIdx );
	TB_ITEM_CHANGE*        GetItemChange         ( long itemDefineIdx );

	void                   SetItemDefine         ( TB_ITEM_DEFINE* itemDefine );
	void                   SetItemAbility        ( TB_ITEM_ABILITY* itemAbility );
	void                   SetItemCooltime2      ( long idx, long rowCount, TB_ITEM_COOLTIME1* itemCooltime1 );
	void                   SetItemLimit          ( TB_ITEM_LIMIT* itemLimit );
	void                   SetItemCard           ( TB_ITEM_CARD* itemCard );
	void                   SetItemCardSlot       ( TB_ITEM_CARD_SLOT* itemCardSlot );
	void                   SetItemTarot          ( TB_ITEM_TAROT* itemTarot );
	void                   SetItemEnhanced       ( TB_ITEM_ENHANCED* itemEnhanced );
	void                   SetItemEnhancedRate   ( TB_ITEM_ENHANCED_RATE* itemEnhancedRate );
	void                   SetItemDisjoint       ( TB_ITEM_DISJOINT* itemDisjoint );
	void                   SetItemChange         ( TB_ITEM_CHANGE* itemChange );

	unsigned long          MakeItemIdx           ( );

	/// 080402 PKH npc
	cItemNpcStore*         GetItemNpcStore( unsigned int npcIndex ) const;

private:
	/// 080402 PKH npc
	bool                   LoadNpcStore( const cString& pathName );

public:
	virtual ~cItemManager(void);

public:
	static cItemManager* mpItemManager;
};

#define ITEMMANAGER	cItemManager::mpItemManager
#define COOLTIMEPOOL cCooltimePool::mpCooltimePool

void Inventory2sInventory( sInventory* sinventory, TB_INVENTORY* inventory );
BYTE ItemCardType2Mtr( BYTE type );
BYTE ItemSlotType2Mtr( BYTE type );

#endif /// __ITEM_MANAGER_H__
