#include "gamesrv.h"

#include "stdafx.h"
#include "Protocol.h"

#include "Level_Common.h"
#include "LevelScript.h"

#include "levelmanager.h"
#include "ObjectManager.h"
#include "Player.h"
#include "StatusCalc_Server.h"


cLevelManager* cLevelManager::mpLevelManager = NULL;



cLevelManager::cLevelManager(void)
{
	/// ̱
	if( mpLevelManager )
	{
		Verbose->WriteLog( "mLevelManager new error");
	}
	else
	{
		mpLevelManager = this;
	}
}



cLevelManager::~cLevelManager(void)
{
}



bool cLevelManager::Init()
{

	mpLevelScript = new cLevelScript;
	if( mpLevelScript->Init() == false )
	{
		Verbose->WriteLog("ASSERT-070515-LevelScript::Init ERROR");
		MessageBox(NULL,_T("LevelScript::Init ERROR"),_T("ERROR"),MB_OK);
		assert(NULL);
	}

	return true;
}



void cLevelManager::Release()
{
	SAFE_RELEASE_DELETE( mpLevelScript );
}


void cLevelManager::AddExp( unsigned long playerIdx, unsigned int addExp )
{
	cPlayer* pPlayer = OBJECTMANAGER->GetPlayer( playerIdx );

	///  ġ ġ 
	pPlayer->GetHeroInfo()->Exp += addExp;

	///   Ѿ  ʿ ġ 
	sExpTable* pExpTable = mpLevelScript->GetExpTable( pPlayer->GetLevel() );
	/// ġ      - 
	if( pExpTable == NULL )
		return; 

	///   ġ ִ  
	unsigned long maxExp = pExpTable->mExp;
	/// ÷̾  ġ
	unsigned long playerExp = pPlayer->GetHeroInfo()->Exp;
	///  ġ
	unsigned char levelUp = 0;

	/// ġ    Ѿ  ġ  ũ 
	while( playerExp >= maxExp )
	{
		///  ġ  ŭ ġ 
		playerExp -= maxExp;
		pPlayer->GetHeroInfo()->Exp = playerExp;

		++levelUp;

		///  Ĵ  Ѿ   ġ ִ 
		pExpTable = mpLevelScript->GetExpTable( pPlayer->GetLevel() + levelUp );
		maxExp = pExpTable->mExp;
	}

	/// ÷̾ 
	if( levelUp > 0 )
		pPlayer->LevelUp( levelUp );

}

void cLevelManager::AddSxp( unsigned long playerIdx, unsigned int addSxp )
{
	cPlayer* pPlayer = OBJECTMANAGER->GetPlayer( playerIdx );

	///  ġ ġ 
	pPlayer->GetHeroInfo()->SkillExp += addSxp;

	///   Ѿ  ʿ ġ 
	sSxpTable* pSxpTable = mpLevelScript->GetSxpTable( pPlayer->GetSkillLevel() );
	/// ġ      - 
	if( pSxpTable == NULL )	
		return; 

	///   ġ ִ  
	unsigned long maxSxp = pSxpTable->mSxp;
	/// ÷̾  ġ
	unsigned long playerSxp = pPlayer->GetHeroInfo()->SkillExp;
	///  ġ
	unsigned char levelUp = 0;

	/// ġ    Ѿ  ġ  ũ 
	while( playerSxp >= maxSxp )
	{
		///  ġ  ŭ ġ 
		playerSxp -= maxSxp;
		pPlayer->GetHeroInfo()->SkillExp = playerSxp;

		++levelUp;

		///   Ѿ   ġ ִ 
		pSxpTable = mpLevelScript->GetSxpTable( pPlayer->GetSkillLevel() + levelUp );
		maxSxp = pSxpTable->mSxp;
	}

	/// ÷̾ ų 
	if( levelUp > 0 )
		pPlayer->SkillLevelUp( levelUp );
}
