/* ==========================================================================
*      : Monster.h
*      :  Ŭ
*    : ڰ
*    : 2006-09-20
* ǻ : ʹ Ǯ ޸𸮸 Ҵ ޱ⶧ ü Ҹ override
*===========================================================================*/

#pragma once

#include "BaseObject.h"

#include "actionmove.h"
#include "ActionDie.h"
#include "ActionAttack.h"
#include "ActionEscape.h"
#include "ActionFollow.h"
#include "ActionIdle.h"
#include "Monster_Common.h"
#include "RangeCheck.h"
#include "Skill_Common.h"

#include "TakeDamagePool.h"

class cPathFinder;
enum eOBJECTTYPE;

class cModeAgent;
class cMode;

const unsigned long TARGET_CHECK_RANGE = 5000;		/// Ÿ  ȿ
const unsigned long	ESCAPE_HP50 = 50;				///  
const unsigned long	ESCAPE_HP30 = 30;
const unsigned long SKILL_USE_HP40 = 40;			/// ų  
const unsigned long SKILL_USE_HP80 = 80;
const unsigned long TALK_DELAY = 1000;				/// 簣 ּ 
const unsigned long SKILL_WAIT_TIME = 500;			/// ų   ð

struct sMonsterTakeDamageInfo
{
	unsigned long takeDamage;
	unsigned long distressPoint;
};

class cMonster : public cBaseObject
{

public:
	/// Ҹ
	cMonster( void );
	~cMonster( void );

	/// objectmanager ޸Ǯ   Ҵ
	void* operator new ( size_t n ); 
	/// ޸Ǯ Ҵ  ͸ 
	void operator delete ( void* ptr, size_t n );


	/// Ϲ 
	bool				Init( unsigned long uniqueidx, unsigned long classIdx, unsigned long regenIdx );
	void				Release();

	///  ũƮ  Ͱ ƴ ܺ ȯ  
	void				SetSummonInfo( cMonster* pParent, unsigned short mapNumber, float regenX, float regenY, unsigned long regenRange, unsigned long destroyTime );

	unsigned long		GetfirstAttack()	{ return mFirstAttackCharacter; }
	void				SetFirstAttack( unsigned long playerIdx )	{ mFirstAttackCharacter = playerIdx; }

	cBaseObject*		GetTarget();
	bool				SetTarget ( unsigned char kind, unsigned long idx );

	void				OutsideDestroyTrue()	{ mOutsideDestroy = true; }
	bool				IsOutsideDestroy()	{ return mOutsideDestroy; }
	bool				IsCheatTempMonster()	{ return mOutsideAddMonster; }

	///*--------------- ũƮ   Ÿ ---------------*/
	const sMonsterScript*	GetMonsterInfo()	{ return mpMonsterInfo; }
	const sRegenScript*	GetRegenMonsterInfo()	{ return mpRegenMonsterInfo; }


	/*--------------- ⺻  ---------------*/
	unsigned int		GetRaceGender()	{ return mpMonsterInfo->mMonsterClassIdx; }
	unsigned long		GetRegenGroupNum()	{ return mpRegenMonsterInfo->mGroupNumber; }
	float				GetDirection()	{ return mDirection; }
	unsigned char		GetLevel( ) { return mpMonsterInfo->mLevel; }


	/*--------------- ų  ---------------*/
	/// ȿ  ߰
	bool				AddInfluence( unsigned long /*uniqueIdx*/, unsigned long /*influenceClassIdx*/ );
	tHashSet<unsigned long>* GetInfluenceSet() { return &mInfluenceSet; }
	void				ReleaseInfluenceSet(); 
	void				DeleteInfluence( unsigned long influenceIdx );

	void				StatusCalc();

	bool				IsParentEqual( unsigned long parentUniqueIdx );

	///    

	/// Ϳ ظ ִ ü   
	void AddTakeDamage( sObject attacker, unsigned long damage, long distressPoint, eTAKEDAMAGE_TYPE type );
	void DelTakeDamagePlayer( unsigned long playerIdx );
	void ClearDistressPointPlayer( unsigned long playerIdx );
	void ClearDistressPoint();
	void ClearTakeDamage();

	//void				AddTakeDamage( unsigned long playerIdx, unsigned long takeDamage );
	unsigned long		GetTakeDamage( unsigned long playerIdx );
	TakeDamageRoot*		GetTakeDamageRoot() { return &mTakeDamageRoot; }

	/// ų 
	eMONSTERATTACK_TYPE	SelectSkill();
	/// ų Ÿ 
	void				UpdateSkillCoolTime( eMONSTERATTACK_TYPE attackType );

	/// ų ߵ  ð
	void				CalcSkillWaitTime( unsigned long skillEndTime );
	bool				IsSkillWaitEnd();

	/// AI  ݴ Ǿ ϴ° ȣ
	void				ChangeActionTarget();

	/// Ÿ  ų  Ÿ 
	void				ChangeTargetDeleteSkill();

	/*--------------- ͽ  ---------------*/
	sMonsterStatus*		GetStatusPlus()	{ return &mStatusPlus; }
	sMonsterStatus*		GetStatusPer()	{ return &mStatusPer; }

	long				CalcPhysicAttack( unsigned long physicAttack );
	long				CalcPhysicRangeAttack( unsigned long physicRangeAttack );
	long				CalcMagicAttack( unsigned long magicAttack );
	long				GetPhysicDefense();
	long				GetMagicDefense();
	long				GetAvoid();
	long				CalcPhysicAttackRate( unsigned long physicAttackRate );
	long				CalcMagicAttackRate( unsigned long magicAttackRate );
	long				CalcPhysicCritical( unsigned long physicCritical );
	long				CalcMagicCritical( unsigned long magicCritical );
	float				GetAttackSpeed();

	float				CalcStatusSkillRange( float skillRange, eRANGETYPE rangeType );

	///   ̵ӵ
	long				GetMoveSpeed();
	long				SetMoveSpeed( unsigned long moveSpeed, eMOVE_SPEED_TYPE mMoveSpeedType );
	void				SendMoveSpeed();

	/// ִ hp/mp
	unsigned long		GetMaxHP()	{ return (unsigned long)( mpMonsterInfo->mMaxHp + ( mpMonsterInfo->mMaxHp * mStatusPer.mMaxHP ) + mStatusPlus.mMaxHP ); }
	unsigned long		GetMaxMP()	{ return (unsigned long)( mpMonsterInfo->mMaxMp + ( mpMonsterInfo->mMaxMp * mStatusPer.mMaxMP ) + mStatusPlus.mMaxMP ); }

	/*--------------- ͽ  Ÿ---------------*/
	/// HP/MP 
	unsigned long		GetHP()	{ return mHP; }
	unsigned long		GetMP()	{ return mMP; }

	/// HP/MP 
	unsigned long		HPDamage( unsigned long damage, bool *die, bool msgSend, bool cri = false );
	void				HPHeal( unsigned long hp, bool msgSend, unsigned long healerIdx, long distressPoint, eTAKEDAMAGE_TYPE type );
	void				MPDamage( unsigned long damage, bool msgSend );
	void				MPHeal( unsigned long heal, bool msgSend );

	///  ó
	unsigned long		DamageCalc( sObject target, unsigned long skillIdx, unsigned long aType, unsigned long rType );
	bool				AttackSuccess( sObject target, unsigned long skillIdx, unsigned long aType, unsigned short accuracyValue );
	bool				CriticalSuccess( sObject target, unsigned long skillIdx, unsigned long aType, unsigned short criticalValue );

	/*---------------   ---------------*/
	/// ׼  - ׼ / ° 
	eACTION_CHANGE		Update( unsigned long elapsedTime, unsigned long accumTime );
	void				UpdateMode( unsigned long elapsedTime, unsigned long accumTime );

	void				ActionChange( eACTION_ID state );
	eACTION_ID			GetActionID()	{ return mpAction->GetActionID(); }

	void				SetGroupRegen( bool groupRegen )	{ mGroupRegen = groupRegen; }
	bool				IsGroupRegen()	{ return mGroupRegen; };

	///  ݹ ° 
	void				SetAttackType( eMONSTERATTACK_TYPE attackType ) { mAttackType = attackType; }
	eMONSTERATTACK_TYPE	GetAttackType() { return mAttackType; }

	void				SetEscape();

	void				Comeback();

	///   
	bool				GetStateDie();

	/// ܺ   
	void				OutsideDestroy();

	///   ð
	unsigned long		GetIdleEndTime()	{ return mIdleEndTime; }

	/*---------------  ̻ ---------------*/
	void				StateOddity( long* pOddity );
	void				SendOddity( eODDITYTYPE pos, bool apply );
	unsigned long		GetStateOddity( eODDITYTYPE oddityType )	{ return mODDITY[oddityType]; }

	bool				IsCantSkill();
	bool				IsCantMove()	{ return mODDITY[eODDITYTYPE_CANTMOVE] != 0 || mODDITY[eODDITYTYPE_SLEEP] != 0 || mODDITY[eODDITYTYPE_STUN] != 0; }

	void				TargetChange( sObject attacker, long distressPoint );

	/*--------------- ̵  ---------------*/
	/// ̵ μ
	bool				MoveUpdate( unsigned long deltaTime );

	/// ̵  
	unsigned int		SetPath( float targetX, float targetY );
	unsigned int		SetPath( float targetX, float targetY, float range , sObject target );

	/// Ͱ ̵Ϸ  ѳ 
	const NiPoint2&		GetNextPos() const { return mNextPos; }
	void				SetNextPos( const NiPoint2& pos ) { mNextPos = pos; }

	/// ̵ǥ     
	float				GetMoveStopRange() { return mMoveStopRange; }
	void				SetMoveStopRange( float moveStopRange ) { mMoveStopRange = moveStopRange; }

	/// Ͱ   ǥ
	const NiPoint2&		GetRegenPos() const	{ return mRegenPos; }

	///  ۽  
	NiPoint2			GetFollowStartPos()	{ return mFollowStartPos; }
	void				SetFollowEndTime( unsigned long followEndTime )	{ mFollowEndTime = followEndTime; }
	unsigned long		GetFollowEndTime()	{ return mFollowEndTime; }		

	/// ϴٰ  ̵  ̵
	bool				GetFollowEndMove()	{ return mFollowEndMove; }
	void				SetFollowEndMove( bool followEndMove )	{ mFollowEndMove = followEndMove; }

	/// ̵ 
	void				MoveStop();

	/// ó ̵
	bool				IsFirstMove()	{ return mIsFirstMove; }
	bool				FirstMoveEnd()	{ return mIsFirstMove = false; }

	unsigned char		GetPlayerFollowPos()	{ return mPlayerFollowPos; }
	void				SetPlayerFollowPos( unsigned char playerFollowPos )	{ mPlayerFollowPos = playerFollowPos; }

	/// ã
	bool				FindPath( const NiPoint2& goal );
	void				SetPathFinder( cPathFinder* pathFinder );
	unsigned int		GetPathCount() const;
	const NiPoint2*		GetPathArray() const;

	/// Ʈ Ÿ üũ  Ÿ -  
	float				GetFixedObjectSize()	{ return mFixedObjectSize; }


	/*---------------   ---------------*/
	///   ߼
	void				SendSpeech( unsigned long talkState );
	void				SpeechProcess();
	bool				IsCriDie()	{ return mCriDie; }

	
	/*--------------- (Ʈ)  ---------------*/
	/// ȯ  ߰
	void				AddSummonMonster( unsigned long monsterIdx );
	void				DieSummonMonster( unsigned long monsterIdx );

	void				ModeSkillEnd();
	eMONSTERATTACK_TYPE	GetModeSkill() { return mModeSkillIdx; }

public:
	bool                SendSightIn     ( char category, char protocol, unsigned long connectionIdx );
	bool                SendSightOut    ( char category, char protocol, unsigned long connectionIdx );
	bool			    SendMonsterMove ( unsigned long connectionIdx );

	///  ֺ ׸忡 ش ÷̾ ϴ ˻
	cPlayer*			NearGridFindPlayer( unsigned long playerIdx );

	///  
	void SetCombatFlag( bool set );
	inline bool IsCombat() { return mIsCombat; }

	long				CalcSkillRate( cBaseObject* pTarget, eMONSTERATTACK_TYPE attackType, long scriptRate );

private:

	/// ׼  
	void				SetAction( cAction& pNewAtion );

	/// ʱȭ
	bool				MonsterInit( unsigned long monsterClassIdx );

	///  /
	void CombatStart();
	void CombatEnd();

	///  ȯ
	void ChangeCurrentMode( long modeIdx );

	bool ConditionValueCheck( unsigned char type, unsigned long value );

private:

	typedef tArray<void*>	cArray;
	typedef tArray<unsigned long> cLongAry;
	typedef tHashSet<unsigned long> cHashSet;
	typedef tHashMap<unsigned long, unsigned long> cHashMap;


	///  ˻
	cRangeCheck			mRangeCheck;
	///  ÷̾
	unsigned long		mFirstAttackCharacter;
	unsigned long		mFirstAttackParty;
	/// Ʈ Ÿ üũ  Ÿ -  
	float				mFixedObjectSize;
	///   ƴ ܺλ  (ġ  Ӿ)
	bool				mOutsideDestroy;
	///  ũƮ ƴ ܺ ȣ  
	bool				mOutsideAddMonster;

	///*--------------- ũƮ   Ÿ ---------------*/
	sMonsterScript*		mpMonsterInfo;		/// ũƮ   ⺻
	sRegenScript*		mpRegenMonsterInfo;	///  

	unsigned char		mFollowImportance;
	/*--------------- ų  ---------------*/
	///  ȿ 
	typedef tHashSet<unsigned long> cSkillInfluenceSet;
	cSkillInfluenceSet	mInfluenceSet;

	///  
	TakeDamageRoot mTakeDamageRoot;

	///  Ÿ  ð
	unsigned long		mNextTargetChangeTime;
	/// Ÿ
	typedef tHashMap<unsigned long, unsigned long> cCoolTime;
	cCoolTime			mSkillCoolTimeMap;
	cCoolTime			mEliteCoolTimeMap;

	/// ų  Ÿ
	eMONSTERATTACK_TYPE	mAttackType;
	/// ų   ð
	unsigned long		mSkillWaitEndTime;

	/// ų   ų  Ƶ ӽ 
	cHashMap			mTempSelectSkill;

	/*--------------- ͽ  ---------------*/
	unsigned long		mHP;
	unsigned long		mMP;

	///   ⺻
	sMonsterStatus		mStatusBase;
	///   Ȯ尪
	sMonsterStatus		mStatusPlus;		
	sMonsterStatus		mStatusPer;

	float				mMoveSpeed;	


	/*---------------   ---------------*/
	cAction*			mpAction;			///  ׼ 
	bool				mGroupRegen;		/// ׷   

	///  ݹ ° 
	eMONSTERATTACK_TYPE	attackType;

	/// Ϳ  ൿ
	cActionMove			mActionMove;
	cActionDie			mActionDie;
	cActionAttack		mActionAttack;
	cActionEscape		mActionEscape;
	cActionFollow		mActionFollow;
	cActionIdle			mActionIdle;

	unsigned long		mDestroyTime;
	unsigned long		mIdleEndTime;

	/*---------------  ̻ ---------------*/
	long				mODDITY[eODDITYTYPE_MAX];
	//sObject				mCantTargetChange;		/// Ÿ  Ұ
	//unsigned long		mCantTChangeInfluenceIdx;	/// Ÿ  Ұ ȿ ȣ - ڽ ȿ   


	/*--------------- ̵  ---------------*/
	NiPoint2			mLastPos;			/// ̵ н  
	NiPoint2			mNextPos;			/// ̵ н   ġ
	float				mMoveStopRange;		///    

	NiPoint2			mRegenPos;			/// Ͱ   ǥ

	NiPoint2			mFollowStartPos;	///   ġ
	unsigned long		mFollowEndTime;		///   ð

	bool				mFollowEndMove;		/// ϴٰ  ̵  ̵

	float				mMoveOverTime;		///   ̵ μ ݿ Ѿ ð

	eMOVE_SPEED_TYPE	mMoveSpeedType;		/// ̵ 

	bool				mIsFirstMove;		/// ó ̵  

	unsigned char		mPlayerFollowPos;

	float				mDirection;			/// Ⱚ

	/// ã
	cPathFinder*		mPathFinder;
	NiPoint2			mPathArray[MAX_PATH_COUNT];
	unsigned int		mPathCount;
	unsigned int		mPathIndex;

	/*---------------   ---------------*/
	unsigned long		mTalkDealyEndTime;
	unsigned char		mTalkState;
	unsigned long		mTalkProcessCheckTime;
	bool				mCriDie;

	/*---------------     ---------------*/
	bool mIsCombat;

	eMONSTERATTACK_TYPE	mModeSkillIdx;

	unsigned long mTotalTime;
	unsigned long mModeTime;

	cModeAgent* mModeAgent;
	cMode*		mCurrentMode;

	/// θ Ͱ ִ  ó
	bool mIsParentLink;
	unsigned long mParentMonsterIdx;

	/// ȯ  
	cHashSet			mSummonListSet;

	/// GenMonster cooltime
	/// typedef tHashMap<unsigned long orderNumMon, unsigned long nextGenTime> cGenMonCoolTimeMap;
	cHashMap			mGenMonCoolTimeMap;

	/// GenTotem CoolTime
	/// typedef tHashMap<unsigned long orderNumMon, unsigned long nextGenTime> cGenTotemCoolTimeMap;
	cHashMap			mGenTotemCoolTimeMap;

};

inline
void cMonster::SetPathFinder( cPathFinder* pathFinder )
{
	mPathFinder = pathFinder;
}

inline
unsigned int cMonster::GetPathCount() const
{
	int c = mPathCount - mPathIndex;

	if( c >= 0 )
	{
		return c;
	}
	else
	{
		assert( 0 );
		return 0;
	}
}

inline
const NiPoint2* cMonster::GetPathArray() const
{
	if( mPathIndex < mPathCount )
	{
		return &mPathArray[mPathIndex];
	}
	else
	{
		assert( 0 );
		return &mPathArray[0];
	}
}
