#include "stdafx.h"
#include "Player_Common.h"
#include "ObjectManager.h"
#include "SkillManager.h"
#include "BaseObject.h"
#include "DamageCalc.h"
#include "Protocol.h"
#include "Player.h"
#include "Monster.h"
#include "gamesrv.h"
#include "Drop.h"



cMonsterSkillObject::cMonsterSkillObject()
{
	mMonsterClassIdx = 0;
}



cMonsterSkillObject::~cMonsterSkillObject()
{
}



void* cMonsterSkillObject::operator new( size_t n )
{
	if( n != sizeof(cMonsterSkillObject) ) 
	{
		assert(0);
		return NULL;
	}

	return SKILLMANAGER->AllocMonsterSkillObject();
}



void cMonsterSkillObject::operator delete( void* ptr, size_t n )
{
	/// NULL  ˻
	if( ptr == 0 )
	{
		assert(0);
		return;
	}

	if( n != sizeof(cMonsterSkillObject) ) 
	{
		assert(0);
		return;
	}

	SKILLMANAGER->FreeMonsterSkillObject( static_cast<cMonsterSkillObject*>(ptr) );

	return;
}



bool cMonsterSkillObject::InitMonsterAttack( unsigned long monsterIdx, unsigned long monsterClassIdx, eMONSTERATTACK_TYPE attackType,
											sObject target, unsigned long uniqueIdx, bool casting, float speedFactor, unsigned long mapNumber )
{
	///  idx 
	mUniqueIdx = uniqueIdx;

	///  ε
	mMonsterClassIdx = monsterClassIdx;

	mDramaKey = monsterClassIdx;
	/// ųidx  .
	mSkillIdx = attackType;

	mMapNumber = mapNumber;

	///  
	mAttacker.index = monsterIdx;
	mAttacker.type = eOBJECTTYPE_MONSTER;

	mSpeedFactor = speedFactor;

	/// Ÿ 
	mCenterTarget = target;

	/// ų Ʈ  ð
	mCreationTime = NETWORK2->GetAccumTime();

	cMonster* pMonster = OBJECTMANAGER->GetMonster( monsterIdx );
	if( pMonster == NULL )
	{
		/// ų 
		assert(NULL);
		NETWORK2->PostServerEvent("InitMonsterAttack - pMonster == NULL");
		return false;
	}

	///  ũƮ Ͽ ð  о
	cDramaturgyInfo* pDramaInfo = DRAMATURGYMAN->GetMonsterDramaturgyInfo( mMonsterClassIdx, (eMONSTERATTACK_TYPE)mSkillIdx );
	if( pDramaInfo == NULL )
	{
		/// ų 
		assert(NULL);
		NETWORK2->PostServerEvent("InitMonsterAttack - pDramaInfo == NULL");
		return false;
	}
	sDramaState* pDramaState = pDramaInfo->GetDramaState();
	if( pDramaState == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("InitMonsterAttack, GetDramaState error [%d,%d]", mMonsterClassIdx, (eMONSTERATTACK_TYPE)mSkillIdx );
		return false;
	}

	mDetailCnt = pDramaState->GetDamageCount();
	mpDetailBegin = (sDramaAction*)pDramaState->GetDamageBegin();
	mpDetailEnd = (sDramaAction*)pDramaState->GetDamageEnd();


	/// ߻ü 
	mIsProjectile = pDramaInfo->IsBullet();
	/// ߻ü ӵ
	mProjectileSpeed = pDramaInfo->GetBulletSpeed();
	/// ߵ ð
	mActivityTime = pDramaInfo->GetActivityEndTime();
	///  ġ = ߻繰 ġ
	mProjectilePos = pMonster->GetPos();

	/// ߻繰 Ÿġ    ߻繰 óҴ  ٲ۴.
	mCenterPos.x = pMonster->GetXPos();
	mCenterPos.y = pMonster->GetYPos();
	mCenterPos.z = pMonster->Height();

	sMonsterSkillScript* pMonsterSkill = SKILLSCRIPT->GetMonsterSkillInfo( mMonsterClassIdx, attackType );
	if( pMonsterSkill == NULL )
	{
		NETWORK2->PostServerEvent("cMonsterSkillObject::InitMonsterAttack pMonsterSkill[%d,%d] == NULL", mMonsterClassIdx, attackType);
		return false;
	}

	/// Ÿ  ų
	if( pMonsterSkill->mApplyValueType1 == eSTATUSPLUS_DELETE_TARGETING || pMonsterSkill->mApplyValueType2 == eSTATUSPLUS_DELETE_TARGETING )
		mDelTarget = true;

	if( pMonsterSkill->mShotType == eMONSTERSHOTTYPE_SPOT )
		mCastingTime = 0;
	else
		mCastingTime = pMonsterSkill->mCastingTime;		

	if( casting == true )
		mSkillState = eSKILLPROCESS_CASTING;
	else
		mSkillState = eSKILLPROCESS_ACTIVITY;

	///  ׸忡 شϴ ÷̾  о  ߼ ܿ ִ´.
	cPlayer* pPlayer = GRIDMANAGER->FindFirstPlayer( pMonster, true );
	while( pPlayer != NULL )
	{
		mSendTargetSet.Insert( pPlayer->GetConnectionIdx() );
		pPlayer = GRIDMANAGER->FindNextPlayer( true );
	}

	return true;
}



bool cMonsterSkillObject::CastingObjectCheck( cBaseObject* pAttacker )
{
	unsigned char errorCode = FAIL_SKILL_CASTING_DONT_TARGET;

	///   Ȯ
	if( pAttacker->GetStateDie() == false && pAttacker->IsCantSkill() == false )
	{
		sMonsterSkillScript* pSkillInfo = SKILLSCRIPT->GetMonsterSkillInfo( mMonsterClassIdx, (eMONSTERATTACK_TYPE)mSkillIdx );
		if( pSkillInfo == NULL )
		{
			assert(NULL);
			NETWORK2->PostServerEvent("cMonsterSkillObject[%d]::CastingObjectCheck pSkillInfo[%d,%d] == NULL", pAttacker->GetObjectID(), mMonsterClassIdx, mSkillIdx);
			SKILLMANAGER->InsertDeleteSkillObject( mAttacker, mUniqueIdx );
			return false;
		}

		///  Ŀ  Ÿ ü Ȯ 
		switch( pSkillInfo->mBoundType )
		{
		case eBOUNDTYPE_SELF_NOTARGET:
		case eBOUNDTYPE_FIELD:
			return true;
		case eBOUNDTYPE_NONE:			///  
		case eBOUNDTYPE_TARGET:			/// Ÿ ع
		case eBOUNDTYPE_SELF_TARGET:	/// (ڽ) ع - ߵ Ÿ 
			{
				/// ڽ  ̸ 
				if( pSkillInfo->mApplyType == eAPPLYTYPE_SELF ) 
					return true;
			}
		}

		/// Ÿ ü üũ
		cBaseObject* pTarget = OBJECTMANAGER->GetObject( mCenterTarget.type, mCenterTarget.index );
		if( pTarget != NULL && pTarget->GetStateDie() == false )	
			return true;
	}
	else
		errorCode = FAIL_SKILL_CASTING_DONT_ATTACKER;

	/// ĳ ߵ  ޼ 
	MSG_SYN_SKILL_CAST_ACTIVITY_FAIL failMsg;
	failMsg.Category = NM_SKILL;
	failMsg.Protocol = NM_SKILL_CAST_ACTIVITY_FAIL_SYN;
	failMsg.mAttacker = mAttacker;
	failMsg.mSkillIndex = mUniqueIdx;
	failMsg.mFailCode = errorCode;

	NETWORK2->QuickSend( pAttacker, (char*)&failMsg, sizeof(failMsg) );

	///  ϴ  ܿ return true   °   ϴ 
	return false;
}



///  : ĳ ϴ 츸 Լ 
bool cMonsterSkillObject::RequireValue( cBaseObject* pAttacker )
{	
	sMonsterSkillScript* pSkillInfo = SKILLSCRIPT->GetMonsterSkillInfo( mMonsterClassIdx, (eMONSTERATTACK_TYPE)mSkillIdx );

	/// Ҹ üũ
	if( pAttacker->GetMP() < pSkillInfo->mUseMP )	
	{ 
		/// ĳ ߵ  ޼ 
		MSG_SYN_SKILL_CAST_ACTIVITY_FAIL failMsg;
		failMsg.Category = NM_SKILL;
		failMsg.Protocol = NM_SKILL_CAST_ACTIVITY_FAIL_SYN;
		failMsg.mSkillIndex = mUniqueIdx;
		failMsg.mFailCode = FAIL_SKILL_CASTING_MP_EMPTY;

		NETWORK2->QuickSend( pAttacker, (char*)&failMsg, sizeof(failMsg) );

		return false; 
	}

	/// MP Ҹ ϴ ų
	if( pSkillInfo->mUseMP != 0 )
		pAttacker->MPDamage( pSkillInfo->mUseMP, false );

	/// ĳ ų ߵ ˸ ũ 
	MSG_SYN_SKILL_CAST_ACTIVE msgEtc;
	msgEtc.Category = NM_SKILL;
	msgEtc.Protocol = NM_SKILL_CAST_ACTIVE_SYN;	
	msgEtc.mSkillIndex = mUniqueIdx;
	msgEtc.mAttacker = mAttacker;
	msgEtc.mAttackerPosX = pAttacker->GetXPos();
	msgEtc.mAttackerPosY = pAttacker->GetYPos();

	NETWORK2->QuickSendExcept( pAttacker, (char*)&msgEtc, sizeof(msgEtc) );

	return true;
}



bool cMonsterSkillObject::SetCenterPos()
{
	sMonsterSkillScript* pSkillInfo = SKILLSCRIPT->GetMonsterSkillInfo( mMonsterClassIdx, (eMONSTERATTACK_TYPE)mSkillIdx );
	///     ġǥ 
	switch( pSkillInfo->mBoundType )
	{
	case eBOUNDTYPE_NONE:			///   ƴ
	case eBOUNDTYPE_TARGET:			/// Ÿ ع
		{
			/// Ÿ üũ  ΰ ʿ 
			if( pSkillInfo->mApplyType != eAPPLYTYPE_SELF )
			{ 
				cBaseObject* pObject = OBJECTMANAGER->GetObject( mCenterTarget.type, mCenterTarget.index );
				/// ߵ  Ÿ   ̽
				if( pObject == NULL || pObject->GetMapNumber() != mMapNumber )	
					return false;

				mCenterPos.x = pObject->GetXPos();
				mCenterPos.y = pObject->GetYPos();
				mCenterPos.z = pObject->Height();

				/// ! TODO mtarget ݰ  üũ
			}
		}break;
	}

	return true;
}


void cMonsterSkillObject::TargetSelect( cBaseObject* pAttacker )
{
	sMonsterSkillScript* pSkillInfo = SKILLSCRIPT->GetMonsterSkillInfo( mMonsterClassIdx, (eMONSTERATTACK_TYPE)mSkillIdx );
	if( pSkillInfo == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("cMonsterSkillObject[%d]::TargetSelect pSkillInfo[%d,%d] == NULL", 
			pAttacker->GetObjectID(), mMonsterClassIdx, mSkillIdx );
		SKILLMANAGER->InsertDeleteSkillObject( mAttacker, mUniqueIdx );
		return;
	}

	/// ߻ü Ÿ    Ÿ   ̽ó 
	if( mNoTargetNoDamage == true )
		return;

	bool applyHP = pSkillInfo->mType == eMONSTERSKILLTYPE_MPDAMAGE ? false : true;

	/// Ÿ 
	if( pSkillInfo->mBoundType != eBOUNDTYPE_NONE )
	{
		switch( pSkillInfo->mApplyType )
		{
		case eAPPLYTYPE_SELF:
			{
				sMultiTarget multiTarget;
				multiTarget.mTarget.type = eOBJECTTYPE_PLAYER;
				multiTarget.mTarget.index = pAttacker->GetObjectID();
				multiTarget.mApplyHP = applyHP;
				mTargetAry.PushBack( multiTarget );
			}
			break;
		case eAPPLYTYPE_BUDDY:
			{
				mTargetAry.Clear();

				float tempRange = OBJECTMANAGER->ObjectSizeRange( pAttacker, NULL, pSkillInfo->mBoundDist );
				///  ΰ
				OBJECTMANAGER->MonsterInCenterPoint( mCenterPos, tempRange, &mTargetAry, applyHP );
			}break;
		case eAPPLYTYPE_ENEMY:
			{
				mTargetAry.Clear();

				float tempRange = OBJECTMANAGER->ObjectSizeRange( pAttacker, NULL, pSkillInfo->mBoundDist );
				///  ΰ
				OBJECTMANAGER->PlayerInCenterPoint( mCenterPos, tempRange, &mTargetAry, applyHP );
			}break;
		}
	}
	else
	{
		sMultiTarget multiTarget;
		multiTarget.mTarget = mCenterTarget;
		multiTarget.mApplyHP = applyHP;
		mTargetAry.PushBack( multiTarget );
	}
}

void cMonsterSkillObject::ApplyDamage( cBaseObject* pAttacker )
{

	sMonsterSkillScript* pSkillInfo = SKILLSCRIPT->GetMonsterSkillInfo( mMonsterClassIdx, (eMONSTERATTACK_TYPE)mSkillIdx );
	if( pSkillInfo == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("cMonsterSkillObject[%d]::ApplyDamage pSkillInfo[%d,%d] == NULL", 
			pAttacker->GetObjectID(), mMonsterClassIdx, mSkillIdx );
		SKILLMANAGER->InsertDeleteSkillObject( mAttacker, mUniqueIdx );
		return;
	}



	/// ŸԺ  ó
	switch( pSkillInfo->mType )
	{
	case eMONSTERSKILLTYPE_DAMAGE:
		{
			SendDamage( pAttacker, pSkillInfo->mShotType, pSkillInfo->mAttributeType, pSkillInfo->mRangeType,
				pSkillInfo->mApplyValueType1, pSkillInfo->mApplyValueType2, pSkillInfo->mApplyValue1, pSkillInfo->mApplyValue2,
				pSkillInfo->mInfulenceIdx, pSkillInfo->mAccuracyValue, pSkillInfo->mCriticalValue, true );	
		}
		break;
	case eMONSTERSKILLTYPE_HEAL:
		{
			SendHeal( pAttacker, pSkillInfo->mShotType,
				pSkillInfo->mApplyValueType1, pSkillInfo->mApplyValueType2, pSkillInfo->mApplyValue1, pSkillInfo->mApplyValue2,
				pSkillInfo->mInfulenceIdx );
		}
		break;
	case eMONSTERSKILLTYPE_NONACTIVE:
		{
			if( mDelTarget )
			{
				SendDelTarget( pAttacker, pSkillInfo->mAccuracyValue );
			}
			else
			{
				SendApply( pAttacker, pSkillInfo->mShotType, 
					pSkillInfo->mApplyValueType1, pSkillInfo->mApplyValueType2, 
					pSkillInfo->mApplyValue1, pSkillInfo->mApplyValue2, pSkillInfo->mInfulenceIdx );
			}
		}
		break;
	case eMONSTERSKILLTYPE_MPDAMAGE:
		{
			SendDamage( pAttacker, pSkillInfo->mShotType, pSkillInfo->mAttributeType, pSkillInfo->mRangeType,
				pSkillInfo->mApplyValueType1, pSkillInfo->mApplyValueType2, pSkillInfo->mApplyValue1, pSkillInfo->mApplyValue2,
				pSkillInfo->mInfulenceIdx, pSkillInfo->mAccuracyValue, pSkillInfo->mCriticalValue, false );	
		}
		break;
	case eMONSTERSKILLTYPE_TOTEM:
		{
			AddTotem( pAttacker, 0, pSkillInfo->mApplyType, pSkillInfo->mAttributeType, pSkillInfo->mInfulenceIdx );
		}
		break;
	}
}