#include "gamesrv.h"

#include "stdafx.h"
#include "Npc.h"
#include "ObjectManager.h"
#include "NpcScript.h"

#include "player.h"

cNpc::cNpc(void) : cBaseObject( eOBJECTTYPE_NPC )
{
}

cNpc::~cNpc(void)
{
}

void* cNpc::operator new( size_t n )
{
	if( n != sizeof(cNpc) ) 
	{
		assert(0);
		return NULL;
	}

	return OBJECTMANAGER->AllocNpc();
}

void cNpc::operator delete( void* ptr, size_t n )
{
	/// NULL  ˻
	if( ptr == 0 )
	{
		assert(0);
		return;
	}

	if( n != sizeof(cNpc) ) 
	{
		assert(0);
		return;
	}

	OBJECTMANAGER->FreeNpc( static_cast<cNpc*>(ptr) );

	return;
}

bool cNpc::Init( int uniqueIdx )
{
	/// NPC   
	sNPCRegen* pNpcRegenScript = NPCSCRIPT->GetNPCRegen( uniqueIdx );
	if ( !pNpcRegenScript )	
	{ 
		assert(NULL);
		NETWORK2->PostServerEvent( "cNpc::Init GetNPCRegen( %d ) = NULL", uniqueIdx );
		return false; 
	}

	mNpcRegen = *pNpcRegenScript;

	/// ȣ 
	mObject.index = uniqueIdx;

	SetMapNumber( pNpcRegenScript->mMapNumber );

	///  Ʈ 
	sNPCList* pNpcListScript = NPCSCRIPT->GetNPCList( pNpcRegenScript->mNpcClassIdx );
	if ( !pNpcListScript )	
	{ 
		assert(NULL);
		NETWORK2->PostServerEvent( "cNpc::Init GetNPCList( %d ) = NULL", pNpcRegenScript->mNpcClassIdx );
		return false; 
	}

	mpNpcList = pNpcListScript;

	SetPos( mNpcRegen.mPosX, mNpcRegen.mPosY );
	return true;
}

// GetNpcData Method
void cNpc::GetNpcData( cPlayer* player, sNpcData* npcData )
{
	npcData->mNpcIdx      = mObject.index;						// 070627 PKH NPC ȣ
	npcData->mNpcClassIdx = mpNpcList->mNpcClassIdx;			// 070627 PKH NPC 
	npcData->mPosX        = mObjectPos.x;						// 070627 PKH NPC xǥ
	npcData->mPosY        = mObjectPos.y;						// 070627 PKH NPC yǥ
	npcData->mDirection   = mNpcRegen.mDirection;				// 070627 PKH NPC 

	eNpcQuestStatus status = eNPCQUEST_NONE;
	player->GetQuestStatus( status, mObject.index );
	npcData->mQuestStatus = status;
}

// SendSightIn Method
bool cNpc::SendSightIn(char category, char protocol, cPlayer* player )
{
	HANDLE        handle  = NULL;
	MSG_NPC_INFO* sendMsg = (MSG_NPC_INFO*)NETWORK2->GetMsgRoot( &handle, player->GetConnectionIdx( ) );
	if ( sendMsg != NULL )
	{
		sNpcData* npcData = sendMsg->mNpcInfo;

		sendMsg->Category = category;
		sendMsg->Protocol = protocol;
		sendMsg->mCount   = 1;

		GetNpcData( player, npcData );

		return NETWORK2->SendMsgRoot( handle, sendMsg->GetMsgLength( ) );
	}
	return false;
}

// SendSightOut Method
bool cNpc::SendSightOut(char category, char protocol, unsigned long connectionIdx)
{
	HANDLE      handle  = NULL;
	MSG_NPCIDX* sendMsg = (MSG_NPCIDX*)NETWORK2->GetMsgRoot( &handle, connectionIdx );
	if ( sendMsg != NULL )
	{
		sendMsg->Category = category;
		sendMsg->Protocol = protocol;
		sendMsg->mNpcIdx  = mObject.index; // GetObjectID Method

		return NETWORK2->SendMsgRoot( handle, sizeof(MSG_NPCIDX) );
	}
	return false;
}
