/* ====================================================================
 *      :	
 *      :	
 *    :	
 *    :	2006.08.29
 *
 * ߰ :
 *		߰¥	۾	߰
 *		2006.08.29		
 * 
 * ǻ :	
 * =================================================================== */
#pragma once

#include "Player.h"
#include "Npc_Common.h"
#include "IndexGenerator.h"
#include "Gathering_Common.h"
#include "Monster_Common.h"
#include "PlayerNamePool.h"

class cBaseObject;
class cMonster;
class cNpc;
class cItem;
class cTotem;
class cGridManager;
class cStatusCalc_Server;
class cDamageCalc;
class cStatusScript;
class cMonsterScript;
class cDrop;
class cLevelManager;
class cNPCScript;
class cTotemScript;
class cPvPScript;
class cVehicleScript;
class cGathering;
class cShortCutScript;

struct PerSocketContext;
struct sObject;

enum eOBJECTTYPE;

const float FOLLOW_POS_DIAGONAL = 141.0f;	/// ġ 밢 Ÿ
const float FOLLOW_POW_BEELINE = 100.0f;		/// ġ , Ÿ

///  ġ ȣ ġ
const NiPoint2 FOLLOW_POS_VALUE[FOLLOW_POS_MAX] =
{
	NiPoint2( -FOLLOW_POW_BEELINE, FOLLOW_POW_BEELINE ),	NiPoint2( 0, FOLLOW_POW_BEELINE ),	NiPoint2( FOLLOW_POW_BEELINE, FOLLOW_POW_BEELINE ),
	NiPoint2( -FOLLOW_POS_DIAGONAL, 0 ),					NiPoint2( 0, 0 ),					NiPoint2( FOLLOW_POW_BEELINE, 0 ),
    NiPoint2( -FOLLOW_POW_BEELINE, -FOLLOW_POW_BEELINE ),	NiPoint2( 0, -FOLLOW_POW_BEELINE ),	NiPoint2( FOLLOW_POW_BEELINE, -FOLLOW_POW_BEELINE )
};

class cObjectManager
{
/// pool
typedef	tPool<cPlayer>	cPlayerPool;
typedef	tPool<cMonster>	cMonsterPool;
typedef	tPool<cNpc>		cNpcPool;
typedef	tPool<cItem>	cItemPool;
typedef	tPool<cTotem>	cTotemPool;
typedef	tPool<cGathering>	cGatheringPool;

/// hashmap
typedef tPointerHashMap<unsigned long, cPlayer*>	cPlayerMap;
typedef tPointerHashMap<unsigned long, void*>		cMonsterMap;
typedef tPointerHashMap<unsigned long, cNpc*>		cNpcMap;
typedef tPointerHashMap<unsigned long, cItem*>		cItemMap;
typedef tPointerHashMap<unsigned long, cTotem*>		cTotemMap;
typedef tPointerHashMap<unsigned long, void*>		cGatheringMap;
typedef tPointerHashMap<unsigned long, void*>		cPointHashMap;

public:
	static cObjectManager*	mpObjectManager;

public:
	cObjectManager(void);
	~cObjectManager(void);

	bool			Init( int serverType );
	void			Release();
	void			Process( unsigned long elapsedTime, unsigned long accumTime );

	/// pool alloc & free
	cPlayer*		AllocPlayer();
	void			FreePlayer( cPlayer* ptr );

	cMonster*		AllocMonster();
	void		    FreeMonster( cMonster* ptr );

	cNpc*			AllocNpc();
	void			FreeNpc( cNpc* ptr );

	cItem*          AllocItem( );
	void			FreeItem( cItem* ptr );

	cTotem*         AllocTotem( );
	void			FreeTotem( cTotem* ptr );

	cGathering*     AllocGathering( );
	void			FreeGathering( cGathering* ptr );

	/// add & remove functions
	cPlayer*		GetPlayer    ( unsigned long playerIdx ) { return mpPlayerMap->GetAt( playerIdx ); }
	cPlayer*		GetPlayer    ( wchar_t* charName );
	cPlayer*		AddPlayer    ( unsigned long connectionIdx, unsigned long playerIdx, wchar_t* playerName, unsigned long money, unsigned long deposit );
	bool			RemovePlayer ( unsigned long playerIdx );

	/// 061201 PKH  ߰
	cMonster*		GetMonster    ( unsigned long monsterIdx ) { return (cMonster*)mpMonsterMap->GetAt( monsterIdx ); }
	cMonster*		AddMonster    ( unsigned long monsterIdx, unsigned long calssIdx, unsigned long regenIdx );
	bool			RemoveMonster ( unsigned long monsterIdx );
	void			InsertDeleteMonster( unsigned long monsterIdx );
	void			MonJobProcess( cMonster* pMonster, eACTION_ID actionid, eACTION_CHANGE actionstate );

	cNpc*			GetNpc        ( unsigned long npcIdx ) { return mpNpcMap->GetAt( npcIdx ); }
	cNpc*			AddNpc        ( unsigned long npcIdx );
	bool			RemoveNpc     ( unsigned long npcIdx );

	cItem*			GetItem       ( unsigned long itemIdx ) { return mpItemMap->GetAt( itemIdx ); }
	cItem*			AddItem       ( unsigned long itemIdx, cBaseObject* baseObject, bool getAuto=false );
	bool			RemoveItem    ( unsigned long itemIdx );

	cTotem*			GetTotem		( unsigned long totemIdx ) { return mpTotemMap->GetAt( totemIdx ); }
	cTotem*			AddTotem		( unsigned long calssIdx, unsigned long partyIdx, NiPoint2 pos, sObject attacker, eAPPLYTYPE applyType, eATTRIBUTETYPE attributeType );
	cTotem*			PvPAddTotem		( unsigned char teamType, unsigned long calssIdx, unsigned short pvpIdx, NiPoint2 pos, eAPPLYTYPE applyType, eATTRIBUTETYPE attributeType );
	bool			RemoveTotem		( unsigned long totemIdx );
	void			InsertDeleteTotem( unsigned long totemIdx );

	cGathering*		GetGathering		( unsigned long gatheringIdx ) { return (cGathering*)mpGatheringMap->GetAt( gatheringIdx ); }
	cGathering*		AddGathering		( unsigned long objectIdx, unsigned long regenIdx );
	bool			RemoveGathering		( unsigned long gatheringIdx );
	void			InsertDeleteGathering( unsigned long gatheringIdx );

	/// 070622 PKH  ÷̾Ը    ش.
	void			SendMsgMonsterModelNumberToPlayer( unsigned long connectionIdx, unsigned long mapNum );
	/// 070622 PKH  ÷̾Ը NPC   ش.
	void			SendMsgNpcModelNumberToPlayer( unsigned long connectionIdx, unsigned long mapNum );

	cBaseObject*	GetObject( unsigned char objectType, unsigned long idx );

	/// 071029 KCJ NPC ȯ
	void* GetNpcMap  ( ) { return mpNpcMap;  }

	/// 071113 KCJ ITEM ȯ
	void* GetItemMap ( ) { return mpItemMap; }

	/// 070627 PKH NPC͸ pool Ѵ.
	void			LoadNpcInfo();

	/// 070817 PKH ǥ   ȿ شϴ ÷̾  ˷
	void			PlayerInCenterPoint( NiPoint3 centerPoint, float range,	tArray<sMultiTarget>* targetAry, bool applyHP );
	/// 080429 PKH  ý۵ player player ϴ 
	void			PlayerInCenterPoint( NiPoint3 centerPoint, float range, tArray<sMultiTarget>* targetAry,
		unsigned long attackerIdx, bool applyHP );
	/// 070817 PKH ǥ   ȿ شϴ Ϳ  ˷
	void			MonsterInCenterPoint( NiPoint3 centerPoint, float range, tArray<sMultiTarget>* targetAry, bool applyHP );

	float			ObjectSizeRange( cBaseObject* object1, cBaseObject* object2, float range );

	///   ġ ǥ 
	NiPoint2		CalcFollowPos( unsigned char followPos, NiPoint2 centerPos );

	/// npc ȭ  θ Ǻ ش.
	unsigned long	IsNpcTalk( unsigned long npcIdx, cPlayer* pPlayer, eNPC_TALK_TYPE npcTalkType, unsigned long value );

	void			SendNotice( char* msg, unsigned long size );

	/// ġƮ
	void			CheatRemoveItemRange( cBaseObject* obj, float radius );
	void			CheatRemoveMonsterRange( cBaseObject* pCenter, float size );
	void			CheatRemoveMonster( unsigned long monsterIdx );
	void			CheatKillMonster( unsigned long monsterIdx, unsigned long playerIdx );

	void			QuestRemoveMonster( unsigned long monsterIdx );

	//
	void            SendMsgSynPVPJoin( );
	void			SendPVPNotice( unsigned char leftMinute );

protected:
	// Memory Pool - cPlayerNamePool class.
	cPlayerNamePool*    mpPlayerNamePool;

	/// Objects Pool & Map
	cPlayerPool*		mpPlayerPool;
	cMonsterPool*		mpMonsterPool;
	cNpcPool*			mpNpcPool;
	cItemPool*			mpItemPool;
	cTotemPool*			mpTotemPool;
	cGatheringPool*		mpGatheringPool;

	cPlayerMap*			mpPlayerMap;
	cMonsterMap*		mpMonsterMap;
	cNpcMap*			mpNpcMap;
	cItemMap*			mpItemMap;
	cTotemMap*			mpTotemMap;
	cGatheringMap*		mpGatheringMap;

	typedef tArray<unsigned long> cArray;
	typedef tHashSet<unsigned long> cHashSet;
    
	/// 070115 PKH  
	cStatusCalc_Server*	mpStatusCalc;
	cDamageCalc*		mpDamageCalc;
	cStatusScript*		mpStatusScript;

	/// 070130 PKH 
	cMonsterScript*		mpMonsterScript;
	cArray				mDelMonster;

	/// 070220 PKH 
	cDrop*				mpDrop;

	/// 070515 PKH levelý
	cLevelManager*		mpLevelManager;

	cNPCScript*			mpNpcScript;

	/// 081212 PKH 
	cTotemScript*		mpTotemScript;
	cIndexGenerator		mTotemIdxGen;
	cArray				mDelTotem;

	/// 081212 PKH ä
	cIndexGenerator		mGatheringIdxGen;
	cArray				mDelGathering;

	/// 090106 PKH Ż
	cVehicleScript*		mpVehicleScript;

	/// 081114 PKH PvPũƮ
	cPvPScript*			mpPvPScript;

	///  Ʈ 
	cShortCutScript*	mpShortCutScript;
};

#define OBJECTMANAGER	cObjectManager::mpObjectManager
