/* ==========================================================================
*      : PVPManager.h
*      : 
*    : ڰ
*    : 2008-09-04
* ǻ :
*===========================================================================*/
#pragma once
#include "DeathMatchObject.h"

enum ePVP_PROCESS
{
	ePVPPROCESS_WAIT,				/// pvp 
	ePVPPROCESS_NOTICE,				///  ߼ۻ
	ePVPPROCESS_OBJECTRUN_OPEN,		/// dm  Ʈ μ 
	ePVPPROCESS_OBJECTRUN_CLOSE,

};

class cPVPManager
{
public:

	static cPVPManager* mpPVPManager;

public:

	cPVPManager();
	~cPVPManager();

	bool				Init();
	void				Release();
	void				Process( unsigned long elapsedTime, unsigned long accumTime );
	void				ObjectProcess( unsigned long elapsedTime, unsigned long accumTime );

	/// pool ó
	cDeathMatchObject*	AllocDMObject() { return mDMObjectPool.Alloc(); }
	void				FreeDMObject(cDeathMatchObject* ptr) { mDMObjectPool.Free(ptr); }

	cDeathMatchObject*	GetPvPDMObject( unsigned long dmIdx )	{ return (cDeathMatchObject*)mDMMap.GetAt(dmIdx); }

	unsigned char		JoinDeathMatch( unsigned long playerIdx, ePVPDM_TEAM_TYPE teamType, sDMInfo* pDMInfo );

	void				Ready();

	///  迭 ߰
	void				DelAryInsertPVP( unsigned long pvpDMIdx );

	void				MemberOut( unsigned long pvpIdx, unsigned long playerIdx, ePVPDM_TEAM_TYPE teamType );

	bool				IsAttack( unsigned long playerIdx, unsigned long targetIdx );

private:

	typedef tPool<cDeathMatchObject> cDMObjectPool;
	cDMObjectPool		mDMObjectPool;


	typedef tPointerHashMap<unsigned long, void*> cPHashMap;
	typedef tHashSet<unsigned long> cHashSet;
	typedef tArray<unsigned long> cAry;

	ePVP_PROCESS		mProcess;			/// μ 
	unsigned long		mStartTime;			/// pvp  ð
	unsigned long		mNextEventTime;		///  ̺Ʈ  ð

	///  ü  
	//typedef tPointerHashMap<unsigned long, cDeathMatchObject*> cDMMap;
	cPHashMap			mDMMap;

	///  ü  迭
	cAry				mDelDMAry;

	unsigned char		mNoticeCount;
	unsigned long		mNoticeSendTime;


	/// sync޼  
	cHashSet			mMsgSendSet;

	unsigned char		mDMObjectIdx;

	cRangeCheck			mRangeCheck;

};

#define PVPMANAGER	cPVPManager::mpPVPManager

