#include "stdafx.h"
#include "Party.h"
#include "PartyManager.h"
#include "RangeCheck.h"
#include "ObjectManager.h"
#include "Player.h"
#include "Monster.h"
#include "Drop.h"
#include "DropScript.h"

cParty::cParty()
: mIndex(0)
, mDivideType( PARTY_DIVIDE_NONE )
, mLevel(0)
, mCount(0)
, mLeaderIndex(0)
, mOwnUserNum(-1)
, mDropMoney(0)
, mDropExp(0)
, mDropSxp(0)
, mLastAccumTime(0)
{
	///  ε ʱȭ
	memset( mUserArr, 0, sizeof(unsigned long)*MAX_PARTY );
}

cParty::~cParty()
{}

bool cParty::IsUser( unsigned long userIdx )
{
	unsigned long* ptr = mUserArr;
	for ( unsigned int i = 0; i < mCount; ++i, ++ptr )
	{
		if ( (*ptr) == userIdx )
			return true;
	}
	return false;
}

bool cParty::AddUser( unsigned long userIdx )
{
	if ( !(mCount > MAX_PARTY) )
	{
		mUserArr[mCount] = userIdx;	/// 
		mCount++;					/// 
		return true;				/// Ƽ ٽ ϱ.
	}
	return false;
}

bool cParty::DeleteUser( unsigned long userIdx )
{
	if ( mCount > 0 )
	{
		int index = -1;
		for ( unsigned int i = 0; i < mCount; ++i )
		{
			if ( mUserArr[i] == userIdx )
			{
				index = i;
				break;
			}
		}
		if ( index > -1 )
		{
			mCount--;	/// 
			for ( unsigned int i = index; i < mCount; ++i )
			{
				mUserArr[i] = mUserArr[i+1];
			}
			mUserArr[mCount] = 0;
			return true;
		}
	}
	return false;
}

unsigned long cParty::GetTurnUser( unsigned short mapNumber, float x, float y )
{
	NiPoint2 monPos( x, y );

	for( unsigned int i = 0; i < mCount; ++i )
	{
		/// ״  
		mOwnUserNum++;	

		if( mOwnUserNum >= (int)mCount )
			mOwnUserNum = 0;
	
		/// ش ã
		cPlayer* user = OBJECTMANAGER->GetPlayer( mUserArr[ mOwnUserNum ] );
		if( user )	
		{
			if( mapNumber != user->GetMapNumber() )
			{
				continue;
			}

			NiPoint2 playerPos( user->GetXPos(), user->GetYPos() );

			cRangeCheck rangeCheck( PARTY_RANGE );
			bool check = rangeCheck.IsRange( monPos, playerPos );
			if( check )
				return mUserArr[ mOwnUserNum ];
		}
	}

	return 0;
}

unsigned long cParty::GetRandomUser( unsigned short mapNumber, float x, float y )
{
	cPlayer* user = 0;
	unsigned long tempArr[MAX_PARTY] = {0,};
	int count = 0;

	NiPoint2 monPos( x, y );

	/// Ÿȿ ִ   
	for( unsigned int i = 0; i < mCount; ++i )
	{
		user = OBJECTMANAGER->GetPlayer( mUserArr[i] );
		if( user )
		{
			if( mapNumber != user->GetMapNumber() )
			{
				continue;
			}

			NiPoint2 playerPos( user->GetXPos(), user->GetYPos() );

			cRangeCheck rangeCheck( PARTY_RANGE );
			bool check = rangeCheck.IsRange( monPos, playerPos );
			if( check == true )
			{
				tempArr[count] = mUserArr[i];
				count++;
			}
		}
	}

	if( count == 0 )
	{
		assert(0);
		return 0;
	}

	///  ̱
	int random = rand()%count;
	mOwnUserNum = tempArr[random];
	return mOwnUserNum;
}
///
void* cParty::operator new( size_t n )
{
	if( n != sizeof(cParty) )
	{
		assert(0);
		return NULL;
	}

	/// Ҵ
	return PARTYMAN->AllocParty();
}

///
void cParty::operator delete( void* ptr, size_t n )
{
	if( ptr == NULL )
	{
		assert(0);
		return;
	}

	if( n != sizeof(cParty) )
	{
		assert(0);
		return;
	}

	/// 
    PARTYMAN->FreeParty( static_cast<cParty*>(ptr) );
	return;
}

void cParty::DivideDropValue( unsigned long monsterIdx, unsigned char monsterLevel )
{

	unsigned long dropMoney = FloatToInt( mDropMoney );
	unsigned long dropExp = FloatToInt( mDropExp );
	unsigned long dropSxp = FloatToInt( mDropSxp );
	unsigned long damage = mDamage;
	unsigned long monsterMaxHP = mMonsterMaxHP;

	mDropMoney = 0;
	mDropExp = 0;
	mDropSxp = 0;
	mMonsterMaxHP = 0;
	mDamage = 0;

	cMonster* pMonster = OBJECTMANAGER->GetMonster( monsterIdx );
	if( pMonster == NULL )
	{
		assert(NULL);
		return;
	}

	/// Ϳ Ƽü   hp 30%̸̸  
	if( monsterMaxHP * 0.3f > damage )
		return;

	unsigned short mapNumber = pMonster->GetMapNumber();
	NiPoint2 monPos = pMonster->GetPos();

	/// ġ й Ƽ 
	unsigned long dropUserIdx[MAX_PARTY] = {0,};
	unsigned char dropUserCnt = 0;

	unsigned char maxLevel = 0;		/// Ƽ 
	float averageLevel = 0;			/// Ƽ  

	NiPoint2 playerPos = NiPoint2::ZERO;
	cRangeCheck rangeCheck( PARTY_RANGE );

	cPlayer* pPlayer = NULL;
	/// ü Ƽ ˻ - ġ,   ش Ƽ Ʈ ߷
	for( unsigned int i = 0; i < mCount; ++i )
	{
		pPlayer = OBJECTMANAGER->GetPlayer( mUserArr[i] );
		if( pPlayer == NULL )
			continue;

		playerPos = pPlayer->GetPos();

		/// ġ Ȯ
		if( mapNumber != pPlayer->GetMapNumber() || rangeCheck.IsRange( monPos, playerPos ) != true )
		{
			/// ġ Ʋ ݵ ߴٸ Ӵ󿡼 
			if( pMonster->GetTakeDamage( mUserArr[i] ) == 0 )
				continue;
		}

		///  ش  īƮ Ƽ  
		dropUserIdx[dropUserCnt] = mUserArr[i];
		++dropUserCnt;
		averageLevel = averageLevel + pPlayer->GetLevel();
		if( maxLevel < pPlayer->GetLevel() )
			maxLevel = pPlayer->GetLevel();
	}

	/// ͸  ߴ Ƽ Ͱ ױ  
	if( dropUserCnt == 0 )
		return;

	if( averageLevel == 0 )
	{
		assert(NULL);
		return;
	}

	averageLevel = averageLevel / dropUserCnt;

	///  ġ 
	float calcExp = DROP->MonsterDropExpIncrease( (float)dropExp, maxLevel, monsterLevel );
	float calcSxp = DROP->MonsterDropExpIncrease( (float)dropSxp, maxLevel, monsterLevel );

	/// Ƽ ġ 
	float partyIncrease = DROPSCRIPT->GetPartyExpIncrease( dropUserCnt );
	calcExp = calcExp * partyIncrease;
	partyIncrease = DROPSCRIPT->GetPartySxpIncrease( dropUserCnt );
	calcSxp = calcSxp * partyIncrease;

	///  ġ
	unsigned long eachExp;
	unsigned long eachSxp;
	///  ÷̾ 
	for( unsigned char i = 0 ; dropUserCnt > i ; ++i )
	{
		pPlayer = OBJECTMANAGER->GetPlayer( dropUserIdx[i] );
		if( pPlayer == NULL || pPlayer->GetStateDie() == true )
			continue;

		playerPos.x = pPlayer->GetXPos();
		playerPos.y = pPlayer->GetYPos();

		///     й  ָ  󿡼 
		if( mapNumber != pPlayer->GetMapNumber() || rangeCheck.IsRange( monPos, playerPos ) != true )
			continue;

		/// [κ ȹ ġ] = [Ƽ йǴ ü ġ] * [ڽ  / Ƽ  ] / [Ƽ]
		eachExp = FloatToInt( calcExp * ( pPlayer->GetLevel() / averageLevel ) / dropUserCnt );
		eachSxp = FloatToInt( calcSxp * ( pPlayer->GetLevel() / averageLevel ) / dropUserCnt );

		pPlayer->AddExpSxp( eachExp, eachSxp );

		unsigned long money = dropMoney;
		money = money / dropUserCnt;
		/// money յ й
		if( money != 0 )
			pPlayer->AddMoney( pMonster->GetObject(), money );
	}
}

void cParty::AddDropValue( unsigned long maxHP, unsigned long damage, float money, float exp, float sxp )
{
	mDropMoney = mDropMoney + money;
	mDropExp = mDropExp + exp;
	mDropSxp = mDropSxp + sxp;
	mMonsterMaxHP = maxHP;
	mDamage = mDamage + damage;
}
