/* ==========================================================================
*      : Party.h
*      : 
*    : 谡
*    : 2007-11-05
* ǻ :
*===========================================================================*/
#pragma once
#include "Party_Common.h"

const int MAX_PARTY = 6;
const float PARTY_RANGE = 4000; // 40M

class cParty
{
public:
	cParty();
	~cParty();

	/// ޸Ǯ ̿ϹǷ new, delete ε
	void* operator new( size_t n );
	void operator delete( void* ptr, size_t n );

	void SetIndex( unsigned long index );
	void SetLevel( unsigned char level );
	void SetDivideType( PARTY_DIVIDE_TYPE type );

	unsigned long* GetUserArr();
	unsigned int   GetCount();

	bool IsUser( unsigned long userIdx );
	bool AddUser( unsigned long userIdx );
	bool DeleteUser( unsigned long userIdx );

	void SetLeader( unsigned long userIdx );
	unsigned long GetLeader();

	/// [й] ε ȹ
	unsigned long GetTurnUser( unsigned short mapNumber, float x, float y );

	/// [й] ε ȹ
	unsigned long GetRandomUser( unsigned short mapNumber, float x, float y );

	void SetOwnUserNum( unsigned int num );
	unsigned int GetOwnUserNum();

	unsigned long GetIndex();
	PARTY_DIVIDE_TYPE	GetDivideType();
	unsigned char GetLevel();

	/// ġ drop ó
	void AddDropValue( unsigned long maxHP, unsigned long damage, float money, float exp, float sxp );
	///  ϴ Ƽ  ο  ġ й
	void DivideDropValue( unsigned long monsterIdx, unsigned char monsterLevel );

	///  ð 
	void SetLastAccumTime( unsigned long accumTime ) { mLastAccumTime = accumTime; }
	unsigned long GetLastAccumTime() { return mLastAccumTime; }

private:
	/// Ƽ ε
	unsigned long mIndex;

	/// Ƽ й
	PARTY_DIVIDE_TYPE mDivideType;

	/// Ƽ 
	unsigned char mLevel;

	/// Ƽ ε
	unsigned long mUserArr[MAX_PARTY];

	/// Ƽο
	unsigned int mCount;

	/// Ƽ ε
	unsigned long mLeaderIndex;

	///    迭 ȣ
	int mOwnUserNum;

	/// Ƽ drop money
	float mDropMoney;
	float mDropExp;
	float mDropSxp;

	/// Ӻ  ִ hp
	unsigned long mMonsterMaxHP;
	/// Ͱ  
	unsigned long mDamage;

	/// Ƽ  ð
	unsigned long mLastAccumTime;
};

inline void cParty::SetLeader( unsigned long userIdx )
{
	mLeaderIndex = userIdx;
}

inline unsigned long cParty::GetLeader()
{
	return mLeaderIndex;
}

inline unsigned long* cParty::GetUserArr()
{
	return mUserArr;
}

inline unsigned int cParty::GetCount()
{
	return mCount;
}

inline void cParty::SetIndex( unsigned long index )
{
	mIndex = index;
}

inline void cParty::SetLevel( unsigned char level )
{
	mLevel = level;
}

inline void cParty::SetDivideType( PARTY_DIVIDE_TYPE type )
{
	mDivideType = type;
}

inline unsigned long cParty::GetIndex()
{
	return mIndex;
}

inline PARTY_DIVIDE_TYPE cParty::GetDivideType()
{
	return mDivideType;
}

inline unsigned char cParty::GetLevel()
{
	return mLevel;
}

inline void cParty::SetOwnUserNum( unsigned int num )
{
	mOwnUserNum = num;
}

inline unsigned int cParty::GetOwnUserNum()
{
	return mOwnUserNum;
}
