#include "stdafx.h"
#include "gamesrv.h"
#include "PartyManager.h"
#include "Player.h"

cPartyManager* cPartyManager::mpSingleton = NULL;

cPartyManager::cPartyManager()
{
	mpSingleton = this;
}

cPartyManager::~cPartyManager()
{
	Release();
	mpSingleton = 0;
}

bool cPartyManager::Init()
{
	mPartyPool.Reserve( 100, 10 );
	return true;
}

void cPartyManager::Release()
{
	mJoinMap.Clear();
}

void cPartyManager::Process( unsigned long /*elapsedTime*/, unsigned long accumTime )
{
	if( mPartyMap.GetSize() == 0 )
		return;

	/// ð Ƽ  send
	cPartyMap::cIterator i = mPartyMap.Begin();
	cPartyMap::cIterator end = mPartyMap.End();
	for( ; i != end; ++i )
	{
		cParty* party = (cParty*)(i->mSecond);
		if( party && accumTime - party->GetLastAccumTime() > PARTY_UPDATETIME )
		{
			SendUpdateParty( party );
			party->SetLastAccumTime( accumTime );
		}
	}
}	

/// Ƽ   -  ð Ÿ 
///  ׸忡   ʴ    
void cPartyManager::SendUpdateParty( cParty* party )
{
	if( !party )
		return;

	int count = party->GetCount();
	unsigned long* userArr1 = party->GetUserArr();
	unsigned long* userArr2 = party->GetUserArr();

	typedef tHashSet<unsigned long> cSkillInfluenceSet;

	for( int i = 0; i < count; ++i )
	{
		for( int j = 0; j < count; ++j )
		{
			/// ڱ⿡ Ⱥ.
			if( i == j )
				continue;

			cPlayer* player1 = OBJECTMANAGER->GetPlayer( *(userArr1+i) );
			cPlayer* player2 = OBJECTMANAGER->GetPlayer( *(userArr2+j) );
			if( player1 && player2 )
			{
				/// 1.  ġ ˻
				if( player1->GetMapNumber() != player2->GetMapNumber() )
					continue;

				/// 2. ׸ ˻ -  ׸ȿ  Ը  Ѵ
				if( GRIDMANAGER->IsSight( player1, player2 ) == false )
				{
					HANDLE				handle = NULL;
					MSG_SYN_PARTY_DATA*	sendMsg = (MSG_SYN_PARTY_DATA*)NETWORK2->GetMsgRoot( &handle, player2->GetConnectionIdx() );

					sendMsg->Category	= NM_PARTY;
					sendMsg->Protocol	= NM_PARTY_DATA_SYN;
					sendMsg->userIndex	= player1->GetObjectID();
					sendMsg->level		= player1->GetLevel();
					sendMsg->maxHP		= player1->GetMaxHP();
					sendMsg->hp			= player1->GetHP();
					sendMsg->maxMP		= player1->GetMaxMP();
					sendMsg->mp			= player1->GetMP();
					sendMsg->posX		= player1->GetXPos();
					sendMsg->posY		= player1->GetYPos();
					sendMsg->RowCount	= 0;

					/// Ʈ 
					cSkillInfluenceSet* influenceSet = player1->GetInfluenceSet();
					if( influenceSet && influenceSet->GetSize() > 0  )
					{
						cSkillInfluenceSet::cIterator i = influenceSet->Begin();
						cSkillInfluenceSet::cIterator end = influenceSet->End();

						long& buffCount = sendMsg->RowCount;
						cInfluenceObject* pObj = 0;
						for( ; i != end; ++i )
						{
							pObj = SKILLMANAGER->GetInfluence( (unsigned long)(*i) );
							if( !pObj )
							{
								assert(0);
								NETWORK2->PostServerEvent("cPartyManager::SendUpdateParty[%d,%d,%d]", NM_PARTY_DATA_SYN, player2->GetConnectionIdx(), (*userArr1));
								continue;
							}

							sendMsg->mTable[buffCount].mInfluenceClassIdx = pObj->GetInfluenceClassIdx();
							sendMsg->mTable[buffCount].mUniqueIdx = pObj->GetUniqueIdx();
							sendMsg->mTable[buffCount].mRestTime = 0;

							buffCount++;
						}
					}
					
					NETWORK2->SendMsgRoot( handle, sendMsg->GetMsgLength() );
				}
			}
		}
	}
}

bool cPartyManager::ResPartyMsgError( unsigned long connectionIdx, char protocol, long error )
{
	HANDLE	   handle  = NULL;
	MSG_ERROR* sendMsg = (MSG_ERROR*)NETWORK2->GetMsgRoot( &handle, connectionIdx );

	if ( sendMsg != NULL )
	{
		sendMsg->Category  = NM_PARTY;
		sendMsg->Protocol  = protocol;
		sendMsg->ErrorCode = error;
		return NETWORK2->SendMsgRoot( handle, sizeof(MSG_ERROR) );
	}
	return false;
}

bool cPartyManager::ResPartyList( cPlayer* player, cParty* party )
{
	HANDLE						handle = NULL;
	MSG_SYN_PARTY_LIST*			sendMsg = (MSG_SYN_PARTY_LIST*)NETWORK2->GetMsgRoot( &handle, player->GetConnectionIdx() );
	unsigned long				length  = sizeof(MSG_SYN_PARTY_LIST) - sizeof(sendMsg->party);

	sendMsg->Category = NM_PARTY;
	sendMsg->Protocol = NM_PARTY_LIST_SYN;
	sendMsg->mIndex = party->GetIndex();
	sendMsg->mLevel = party->GetLevel();
	sendMsg->mLeaderIndex = party->GetLeader();
	sendMsg->mDivideType = party->GetDivideType();
	sendMsg->RowCount = 0;

	long& cnt = sendMsg->RowCount;
	unsigned long* userArr = party->GetUserArr();
	for( unsigned int i = 0; i < party->GetCount(); ++i, ++userArr )
	{
		/// ڱڽ 
		if( player->GetObjectID() == (*userArr) )
			continue;

		cPlayer* user = OBJECTMANAGER->GetPlayer( (*userArr) );
		if( user )
		{
			sendMsg->party[cnt].UserIndex = (*userArr);
			wcscpy( sendMsg->party[cnt].Name, user->GetName() );

			sendMsg->party[cnt].Job			= user->GetJob();
			sendMsg->party[cnt].Level		= user->GetLevel();
			sendMsg->party[cnt].MapNum		= (user->IsPvPJoin() == true ) ? user->GetPvPMapDataNumber() : user->GetMapNumber();
			sendMsg->party[cnt].InitX		= user->GetXPos();
			sendMsg->party[cnt].InitY		= user->GetYPos();
			sendMsg->party[cnt].HP			= user->GetHP();
			sendMsg->party[cnt].MaxHP		= user->GetMaxHP();
			sendMsg->party[cnt].MP			= user->GetMP();
			sendMsg->party[cnt].MaxMP		= user->GetMaxMP();
			cnt++;
		}
		else
		{
			NETWORK2->PostServerEvent( "Error cPartyManager::ResPartyList : not exist partyuser %d", (*userArr) );
			continue;
		}
	}

	length += (sendMsg->RowCount * sizeof(sendMsg->party));
	return NETWORK2->SendMsgRoot( handle, length );
}

/// Ƽ ߰  
bool cPartyManager::ResPartyAddOne( unsigned long characterIdx, cParty* party )
{
	HANDLE		handle = NULL;

	cPlayer*	partyUser = 0;
	cPlayer*	addUser = OBJECTMANAGER->GetPlayer( characterIdx );
	if( !addUser )
	{
		NETWORK2->PostServerEvent( "Error cPartyManager::ResPartyAddOne : not exist add user(%d)", characterIdx );
		return false;
	}

	unsigned long*  userArr    = party->GetUserArr();
	unsigned int	partyCount = party->GetCount();

	/// ߰    Ƽ 
	for( unsigned int i = 0; i < partyCount; ++i, ++userArr )
	{
		if( characterIdx == (*userArr) )
			continue;

		partyUser = OBJECTMANAGER->GetPlayer( (*userArr));
		if( !partyUser )
		{
			NETWORK2->PostServerEvent( "Error cPartyManager::ResPartyAddOne : not exist partyuser %d", (*userArr) );
			continue;
		}

		MSG_SYN_PARTY_ADDONE*		sendMsg = (MSG_SYN_PARTY_ADDONE*)NETWORK2->GetMsgRoot( &handle, partyUser->GetConnectionIdx() );
		sendMsg->Category = NM_PARTY;
		sendMsg->Protocol = NM_PARTY_ADDONE_SYN;

		sendMsg->mPartyLevel	= party->GetLevel();
		sendMsg->UserIndex		= characterIdx;
		wcscpy( sendMsg->Name, addUser->GetName() );
		sendMsg->Level			= addUser->GetLevel();
		sendMsg->Job			= addUser->GetJob();
		sendMsg->HP				= addUser->GetHP();
		sendMsg->MaxHP			= addUser->GetMaxHP();
		sendMsg->MP				= addUser->GetMP();
		sendMsg->MaxMP			= addUser->GetMaxMP();
		sendMsg->MapNum			= (addUser->IsPvPJoin() == true ) ? addUser->GetPvPMapDataNumber() : addUser->GetMapNumber();
		sendMsg->InitX			= addUser->GetXPos();
		sendMsg->InitY			= addUser->GetYPos();

		NETWORK2->SendMsgRoot( handle, sizeof(MSG_SYN_PARTY_ADDONE) );
	}

	return true;
}

///// Ƽ  ü
//void cPartyManager::PartyBreak( cPlayer* player )
//{
//	if( !player )
//	{
//		NETWORK2->PostServerEvent( "Error cPartyManager::PartyBreak : not exist party out user" );
//		assert(0);
//		return;
//	}
//
//	ePLAYER_PARTYSTATE state = player->GetPartyState();
//	if( state == ePARTY_NONE )
//		return;
//
//	/// Ƽû ޴̾ ûڿ ˷	
//	if( state == ePARTY_RECVJOIN )
//	{
//		/// Ƽ û 
//		DelRequest( player->GetObjectID() );
//
//		///
//		unsigned long fromIndex = GetRequest( player->GetObjectID() );
//		cPlayer* fromPlayer = OBJECTMANAGER->GetPlayer( fromIndex );
//		if( fromPlayer )
//		{
//			HANDLE				handle = NULL;
//			MSG_RES_PARTY_ADD*	sendMsg = (MSG_RES_PARTY_ADD*)NETWORK2->GetMsgRoot( &handle, fromPlayer->GetConnectionIdx(), NM_PARTY, NM_PARTY_ADD_RES );
//			if( sendMsg != NULL )
//			{
//				sendMsg->ErrorCode = ERROR_PARTY_ADD_USEROUT;
//				NETWORK2->SendMsgRoot( handle, sizeof(MSG_RES_PARTY_ADD) );
//			}
//		}
//	}
//	else
//	{
//		///  Ƽ ػ
//		unsigned long partyIndex = player->GetPartyIndex();
//		cParty* party = GetParty( partyIndex );
//		if( party )
//		{
//			/// Ƽ ػ
//			HANDLE			handle = NULL;
//			cPlayer*		partyUser = 0;
//			unsigned long*  userArr = party->GetUserArr();
//			unsigned int	partyCount = party->GetCount();
//
//			for( unsigned int i = 0; i < partyCount; ++i, ++userArr )
//			{
//				partyUser = OBJECTMANAGER->GetPlayer( (*userArr) );
//				if( partyUser )
//				{
//					///  Ƽ Ƽ ʱȭ 
//					partyUser->SetPartyIndex( 0 );
//					partyUser->SetPartyState( ePARTY_NONE );
//
//					if( NETWORK2->GetMsgRoot( &handle, partyUser->GetConnectionIdx(), NM_PARTY, NM_PARTY_BREAK_SYN ) != NULL )
//					{
//						NETWORK2->SendMsgRoot( handle, sizeof(MSG_SYN_PARTY_BREAK) );
//					}
//				}
//				else
//				{
//					NETWORK2->PostServerEvent( "Error cPartyManager::PartyOutPlayer : not exist party out user" );
//					continue;
//				}
//			}
//
//			/// Ƽ 
//			DeleteParty( partyIndex );
//		}
//		else
//		{
//			assert(0);
//			return;
//		}
//	}
//}

// û ޴° Ƽΰ츦 зؼ ó
// û ϴ°쿡  óʾƵ  ( ûڰ  ־ ڵ ó )
void cPartyManager::PartyOutPlayer( cPlayer* player )
{
	if( !player )
	{
		NETWORK2->PostServerEvent( "Error cPartyManager::PartyOutPlayer : not exist party out user" );
		assert(0);
		return;
	}
	
	ePLAYER_PARTYSTATE state = player->GetPartyState();
	if( state == ePARTY_NONE )
		return;

	// û ޴ 
	if( state == ePARTY_RECVJOIN )
	{
		/// û  ޼ 
		unsigned long reqIdx = GetRequest( player->GetObjectID() );
		if( reqIdx > 0 )
		{
			cPlayer* requester = OBJECTMANAGER->GetPlayer( reqIdx );
			if( requester )
			{
				ePLAYER_PARTYSTATE state = ( requester->GetPartyIndex() > 0 ) ? ePARTY_COMPLETE : ePARTY_NONE;
				requester->SetPartyState( state );

				HANDLE     handle  = NULL;
				MSG_RES_PARTY_ADD* sendMsg = (MSG_RES_PARTY_ADD*)NETWORK2->GetMsgRoot( &handle, requester->GetConnectionIdx(), NM_PARTY, NM_PARTY_ADD_RES );
				if( sendMsg != NULL )
				{
					sendMsg->ErrorCode = ERROR_PARTY_ADD_REFUSE;
					NETWORK2->SendMsgRoot( handle, sizeof(MSG_RES_PARTY_ADD) );
				}
			}

			///   
			player->SetPartyState( ePARTY_NONE );

			/// Ʈ 
			DelRequest( player->GetObjectID() );

			player->EndRequestRejection( eREQREJCT_PARTY );
		}
		else
		{
			NETWORK2->PostServerEvent("cPartyManager::PartyOutPlayer[%d]", player->GetObjectID() );
		}
	}
	else
	{
		/// ƼŻ Ȥ Ƽػ ó 
		unsigned long partyIndex = player->GetPartyIndex();
		cParty* party = GetParty( partyIndex );
		if( party )
		{
			/// 3̸ Ѹ 
			///  ƼŻ ˸
			if( party->GetCount() > 2 )
			{
				HANDLE			handle = NULL;
				cPlayer*		partyUser = 0;
				unsigned long*  userArr = party->GetUserArr();
				unsigned int	partyCount = party->GetCount();

				for( unsigned int i = 0; i < partyCount; ++i, ++userArr )
				{
					/// Ż 
					if( (*userArr) == player->GetObjectID() )
						continue;

					partyUser = OBJECTMANAGER->GetPlayer( (*userArr) );
					if( partyUser )
					{
						MSG_SYN_PARTY_OUT*	sendMsg = (MSG_SYN_PARTY_OUT*)NETWORK2->GetMsgRoot( &handle, partyUser->GetConnectionIdx(), NM_PARTY, NM_PARTY_OUT_SYN );
						if( sendMsg != NULL )
						{
							sendMsg->UserIndex = player->GetObjectID();
							NETWORK2->SendMsgRoot( handle, sizeof(MSG_SYN_PARTY_OUT) );
						}
					}
					else
					{
						NETWORK2->PostServerEvent( "Error cPartyManager::PartyOutPlayer : not exist party out user" );
						continue;
					}
				}
				
				/// Żڰ Ƽ̾  ü ó
				if( party->GetLeader() == player->GetObjectID() )
				{
					/// Ƽ̸   ε ã
					unsigned long nextIndex = FindNext( party, player->GetObjectID() );
					PartyChangeLeader( player, nextIndex );
				}

				/// ƼŻ û  Ż
				if ( NETWORK2->GetMsgRoot( &handle, player->GetConnectionIdx(), NM_PARTY, NM_PARTY_OUT_RES ) != NULL )
				{
					NETWORK2->SendMsgRoot( handle, sizeof(MSG_RES_PARTY_OUT) );
				}

				/// ƼŻ û  .
				party->DeleteUser( player->GetObjectID() );

				player->SetPartyIndex( 0 );
				player->SetPartyState( ePARTY_NONE );
			}
			/// 2ϸ Ƽ ػ
			else
			{
				/// Ƽ ػ
				HANDLE			handle = NULL;
				cPlayer*		partyUser = 0;
				unsigned long*  userArr = party->GetUserArr();
				unsigned int	partyCount = party->GetCount();

				for( unsigned int i = 0; i < partyCount; ++i, ++userArr )
				{
					partyUser = OBJECTMANAGER->GetPlayer( (*userArr) );
					if( !partyUser )
					{
						NETWORK2->PostServerEvent( "Error cPartyManager::PartyOutPlayer : not exist party out user" );
						continue;
					}

					///  Ƽ Ƽ ʱȭ 
					partyUser->SetPartyIndex( 0 );
					partyUser->SetPartyState( ePARTY_NONE );

					/// ƼŻ û Դ Ƽ ػ޼  ʴ´
					if( player != partyUser )
					{
						if ( NETWORK2->GetMsgRoot( &handle, partyUser->GetConnectionIdx(), NM_PARTY, NM_PARTY_DELETE_SYN ) != NULL )
						{
							NETWORK2->SendMsgRoot( handle, sizeof(MSG_SYN_PARTY_DELETE) );
						}
					}
				}

				/// ƼŻ û  Ż
				if ( NETWORK2->GetMsgRoot( &handle, player->GetConnectionIdx(), NM_PARTY, NM_PARTY_OUT_RES ) != NULL )
				{
					NETWORK2->SendMsgRoot( handle, sizeof(MSG_RES_PARTY_OUT) );
				}

				/// Ƽ 
				DeleteParty( partyIndex );
			}
		}
	}
}

/// Ƽ  
void cPartyManager::PartyChangeLeader( cPlayer* fromPlayer, unsigned long toUserIdx )
{
	cPlayer* toPlayer = OBJECTMANAGER->GetPlayer( toUserIdx );

	try
	{
		if( fromPlayer && toPlayer )
		{
			if( fromPlayer == toPlayer )
				throw ERROR_PARTY_CHANGELEADER_FAIL;

			/// Ƽ ų,  Ƽ ƴ϶ 
			if( (fromPlayer->GetPartyIndex() == 0 || toPlayer->GetPartyIndex() == 0) )
				throw ERROR_PARTY_CHANGELEADER_FAIL;

			if( fromPlayer->GetPartyIndex() != toPlayer->GetPartyIndex() )
				throw ERROR_PARTY_CHANGELEADER_FAIL;

			/// Ƽ 
			cParty* party = GetParty( fromPlayer->GetPartyIndex() );
			if( party )
			{
				/// Ѿ.
				if( party->GetLeader() != fromPlayer->GetObjectID() )						
					throw ERROR_PARTY_CHANGELEADER_LEADER;

				/// Ƽ  缼
				party->SetLeader( toUserIdx );

				/// Ƽ  û Ϸ res
				ResPartyMsgError( fromPlayer->GetConnectionIdx(), NM_PARTY_CHANGELEADER_RES, ERROR_PARTY_CHANGELEADER_SUCESS );

				/// Ƽ  ˸ 
				HANDLE			handle = NULL;
				cPlayer*		partyUser = 0;
				unsigned long*  userArr = party->GetUserArr();
				unsigned int	partyCount = party->GetCount();

				for( unsigned int i = 0; i < partyCount; ++i, ++userArr )
				{
					partyUser = OBJECTMANAGER->GetPlayer( (*userArr) );
					if( partyUser )
					{
						MSG_SYN_PARTY_CHANGELEADER*	sendMsg = (MSG_SYN_PARTY_CHANGELEADER*)NETWORK2->GetMsgRoot( &handle, partyUser->GetConnectionIdx(), NM_PARTY, NM_PARTY_CHANGELEADER_SYN );
						if( sendMsg != NULL )
						{
							sendMsg->UserIndex = toUserIdx;
							NETWORK2->SendMsgRoot( handle, sizeof(MSG_SYN_PARTY_CHANGELEADER) );
						}
					}
					else
					{
						NETWORK2->PostServerEvent( "Error cPartyManager::PartyChangeLeader : not exist party out user" );
						continue;
					}
				}
			}
			else
				throw ERROR_PARTY_CHANGELEADER_FAIL;
		}
	}
	catch ( int error )
	{
		ResPartyMsgError( fromPlayer->GetConnectionIdx(), NM_PARTY_CHANGELEADER_RES, error );
	}
}

/// Ƽй 
void cPartyManager::PartyChangeDivide( cPlayer* fromPlayer, PARTY_DIVIDE_TYPE type )
{
	try
	{
		if( fromPlayer )
		{
			cParty* party = GetParty( fromPlayer->GetPartyIndex() );
			if( party )
			{
				if( party->GetDivideType() == type )
					throw ERROR_PARTY_CHANGEDIVIDE_LEADER;

				/// Ѿ.
				if( party->GetLeader() != fromPlayer->GetObjectID() )						
					throw ERROR_PARTY_CHANGEDIVIDE_LEADER;

				party->SetDivideType( type );

				/// Ƽ忡 й  ˸
				ResPartyMsgError( fromPlayer->GetConnectionIdx(), NM_PARTY_CHANGEDIVIDE_RES, ERROR_PARTY_CHANGEDIVIDE_SUCESS );

				/// й  ˸
				HANDLE			handle = NULL;
				cPlayer*		partyUser = 0;
				unsigned long*  userArr = party->GetUserArr();
				unsigned int	partyCount = party->GetCount();

				for( unsigned int i = 0; i < partyCount; ++i, ++userArr )
				{
					partyUser = OBJECTMANAGER->GetPlayer( (*userArr) );
					if( partyUser )
					{
						MSG_SYN_PARTY_CHANGEDIVDE*	sendMsg = (MSG_SYN_PARTY_CHANGEDIVDE*)NETWORK2->GetMsgRoot( &handle, partyUser->GetConnectionIdx(), NM_PARTY, NM_PARTY_CHANGEDIVIDE_SYN );
						if( sendMsg != NULL )
						{
							sendMsg->type = type;
							NETWORK2->SendMsgRoot( handle, sizeof(MSG_SYN_PARTY_CHANGEDIVDE) );
						}
					}
					else
					{
						NETWORK2->PostServerEvent( "Error cPartyManager::PartyChangeDivide : not exist party out user" );
						continue;
					}
				}
			}
			else
				throw ERROR_PARTY_CHANGEDIVIDE_FAIL;
		}
	}
	catch ( int error )
	{
		ResPartyMsgError( fromPlayer->GetConnectionIdx(), NM_PARTY_CHANGEDIVIDE_RES, error );
	}
}

// û :  Ƽκ Żó
// û޴ : ʾƿ,  ڵ  óѴ
void cPartyManager::PartyMapOut( cPlayer* hero )
{
	ePLAYER_PARTYSTATE state = hero->GetPartyState();

	/// Ƽʴ븦 ޴̾ٸ
	if( state == ePARTY_RECVJOIN )
	{
		/// û  ޼ 
		unsigned long reqIdx = GetRequest( hero->GetObjectID() );
		if( reqIdx > 0 )
		{
			cPlayer* requester = OBJECTMANAGER->GetPlayer( reqIdx );
			if( requester )
			{
				ePLAYER_PARTYSTATE state = ( requester->GetPartyIndex() > 0 ) ? ePARTY_COMPLETE : ePARTY_NONE;
				requester->SetPartyState( state );

				HANDLE     handle  = NULL;
				MSG_RES_PARTY_ADD* sendMsg = (MSG_RES_PARTY_ADD*)NETWORK2->GetMsgRoot( &handle, requester->GetConnectionIdx(), NM_PARTY, NM_PARTY_ADD_RES );
				if( sendMsg != NULL )
				{
					sendMsg->ErrorCode = ERROR_PARTY_ADD_REFUSE;
					NETWORK2->SendMsgRoot( handle, sizeof(MSG_RES_PARTY_ADD) );
				}
			}

			/// ü   
			hero->SetPartyState( ePARTY_NONE );
			
			/// Ʈ 
			DelRequest( hero->GetObjectID() );

			hero->EndRequestRejection( eREQREJCT_PARTY );
		}
		else
		{
			NETWORK2->PostServerEvent("cPartyManager::PartyMapOut[%d]", hero->GetObjectID() );
		}
	} 
}

/// Ƽ ü
void cPartyManager::PartyMapIn( cPlayer* player )
{
	ePLAYER_PARTYSTATE state = player->GetPartyState();
	
	/// Ƽ̶
	if( state == ePARTY_COMPLETE )
	{
		cParty* party = GetParty( player->GetPartyIndex() );
		if( party )
		{
			/// ٸ鿡  ü ˸
			HANDLE			handle = NULL;
			cPlayer*		partyUser = 0;
			unsigned long*  userArr = party->GetUserArr();
			unsigned int partyCount = party->GetCount();

			for( unsigned int i = 0; i < partyCount; ++i, ++userArr )
			{
				///  ü   .
				if( (*userArr) == player->GetObjectID() )
					continue;

				partyUser = OBJECTMANAGER->GetPlayer( (*userArr) );
				if( partyUser )
				{
					MSG_SYN_PARTY_MAPCHANGE* sendMsg = (MSG_SYN_PARTY_MAPCHANGE*)NETWORK2->GetMsgRoot( &handle, partyUser->GetConnectionIdx(), NM_PARTY, NM_PARTY_MAPCHANGE_SYN );
					if( sendMsg != NULL )
					{
						sendMsg->UserIndex = player->GetObjectID();
						sendMsg->MapNum = player->GetMapNumber();
						NETWORK2->SendMsgRoot( handle, sizeof(MSG_SYN_PARTY_MAPCHANGE) );
					}
				}
				else
				{
					NETWORK2->PostServerEvent( "Error cPartyManager::PartyMapIn : not exist party out user" );
					continue;
				}
			}

			/// ̵鿡 Ƽ   
			ResPartyList( player, party );
		}
		else
		{
			NETWORK2->PostServerEvent( "Error cPartyManager::PartyMapIn : not exist party" );
		}
	}
}

///   
void cPartyManager::SendToPartyChangeJob( cPlayer* player )
{
	cParty* party = GetParty( player->GetPartyIndex() );
	if( player && party )
	{
		cPlayer*	 partyUser = 0;
		unsigned long* userArr = party->GetUserArr();
		unsigned int partyCount = party->GetCount();

		for( unsigned int i = 0; i < partyCount; ++i, ++userArr )
		{
			if( (*userArr) == player->GetObjectID() )
				continue;

			partyUser = OBJECTMANAGER->GetPlayer( (*userArr) );
			if( partyUser )
			{
				HANDLE					 handle = NULL;
				MSG_SYN_PARTY_CHANGEJOB* sendMsg = (MSG_SYN_PARTY_CHANGEJOB*)NETWORK2->GetMsgRoot( &handle, partyUser->GetConnectionIdx(), NM_PARTY, NM_PARTY_JOBCHANGE_SYN );
				if( sendMsg != NULL )
				{
					sendMsg->userIndex = player->GetObjectID();
					sendMsg->job = player->GetJob();
					NETWORK2->SendMsgRoot( handle, sizeof(NM_PARTY_JOBCHANGE_SYN) );
				}
			}
			else
			{
				NETWORK2->PostServerEvent( "Error cPartyManager::SendToPartyChangeJob : not exist party user" );
				continue;
			}
		}
	}
}

/// Ƽ     (Ʈ Ʈ)
void cPartyManager::SendToPartyHunt( cMonster* monster, cPlayer* hero, unsigned int racegender )
{
	cParty* party = GetParty( hero->GetPartyIndex() );
	if( party )
	{
		cPlayer*	 partyUser = 0;
		unsigned long* userArr = party->GetUserArr();
		unsigned int partyCount = party->GetCount();

		for( unsigned int i = 0; i < partyCount; ++i, ++userArr )
		{
			partyUser = OBJECTMANAGER->GetPlayer( (*userArr) );
			if( partyUser )
			{
				/// Ÿ üũ
				if( monster->GetMapNumber() == partyUser->GetMapNumber() )
				{
					NiPoint2 monPos = monster->GetPos();
					NiPoint2 userPos = partyUser->GetPos();

					///  ȿ  Ʈ  
					cRangeCheck range( PARTY_RANGE );
					if( range.IsRange( monPos, userPos ) == true )
					{
						/// Ƽ Ʈ  
						partyUser->UpdateDutyHunt( racegender );
					}
				}
			}
			else
			{
				NETWORK2->PostServerEvent( "Error cPartyManager::SendToPartyHunt : not exist party user" );
				continue;
			}
		}
	}
}

///
unsigned long cPartyManager::AddParty( unsigned long leaderIdx, unsigned long userIdex )
{
	/// Ƽ 
	cParty* pParty = new cParty;
	if( !pParty )
	{
		SAFE_DELETE( pParty );
		NETWORK2->PostServerEvent( "Error cPartyManager::AddParty : failed to create party" );

		assert(0);
		return 0;
	}

	/// Ƽ ⺻ 
	unsigned long index = mPartyIndexGen.GeneratIdx();
	pParty->SetIndex( index );
	pParty->SetLevel( 0 );
	pParty->SetDivideType( PARTY_DIVIDE_TURN );
	pParty->SetLastAccumTime( NETWORK2->GetAccumTime() );

	/// Ƽ 
	pParty->AddUser( leaderIdx );
	pParty->AddUser( userIdex );

	/// Ƽ 
	pParty->SetLeader( leaderIdx );

	/// Ƽ  
	if( mPartyMap.Insert( index, pParty ) == false )
	{
		SAFE_DELETE( pParty );
		NETWORK2->PostServerEvent( "Error cPartyManager::AddParty : failed to insert party map" );
		assert(0);
		return 0;
	}
	
	return index;
}

bool cPartyManager::DeleteParty( unsigned long partyIdx )
{
	cParty* party = (cParty*)mPartyMap.GetAt( partyIdx );
	if( party )
	{
		mPartyMap.Erase( partyIdx );
		mPartyIndexGen.DelIdx( partyIdx );
		SAFE_DELETE( party );
	}
	else
	{
		NETWORK2->PostServerEvent( "Error cPartyManager::DeleteParty : failed to find party" );
		return false;
	}

	return true;
}

unsigned long cPartyManager::FindNext( cParty* party, unsigned long userIndex )
{
	unsigned long*  userArr = party->GetUserArr();
	unsigned int arrIndex = 0;
	unsigned int count = party->GetCount();
	for( unsigned int i = 0; i < count; ++i )
	{
		if( userIndex == userArr[i] )
		{
			arrIndex = i + 1;
			break;
		}
	}

	/// ο Ѿ ù°  ٱ
	arrIndex = arrIndex % count;
	return userArr[arrIndex];
}

cParty*	cPartyManager::GetParty( unsigned int partyIdx )
{
	return ( partyIdx > 0 ) ? (cParty*)mPartyMap.GetAt( partyIdx ) : NULL;
}

bool cPartyManager::AddRequest( unsigned long recvIdx, unsigned long reqIdx )
{
	/// û ε Ű ִ´.
	return mJoinMap.Insert( recvIdx, reqIdx );
}

void cPartyManager::DelRequest( unsigned long recvIdx )
{
	mJoinMap.Erase( recvIdx );
}

/// Ƽ û  ε ˻
unsigned long cPartyManager::GetRequest( unsigned long recvIdx )
{
	cJoinMap::cIterator i = mJoinMap.Find( recvIdx );
	return ( i != mJoinMap.End() ) ? (unsigned long)(*i).mSecond : 0;
}
