/* ==========================================================================
*      : PartyManager.h
*      : 
*    : 谡
*    : 2007-11-05
* ǻ :
*===========================================================================*/
#pragma once
#include "Player.h"
#include "Monster.h"
#include "Party.h"
#include "IndexGenerator.h"

const unsigned long PARTY_UPDATETIME = 5000;

class cPartyManager
{
	static cPartyManager*	mpSingleton;

public:
	cPartyManager();
	~cPartyManager();

	///
	bool Init();
	void Process( unsigned long elapsedTime, unsigned long accumTime );
	void Release();

	///
	cParty* AllocParty();
	void FreeParty( cParty* party );

	/// Ƽ
	unsigned long AddParty( unsigned long leaderIdx, unsigned long userIdex );
	bool DeleteParty( unsigned long partyIdx );
	cParty*	GetParty( unsigned int partyIdx );

	/// Ƽû    ˻ϱ .
	/// û  ( û , û  ε )
	bool AddRequest( unsigned long recvIdx, unsigned long reqIdx );
	void DelRequest( unsigned long recvIdx );
		
	/// Ƽ  send
	void SendUpdateParty( cParty* party );

	///
	void SendToPartyHunt( cMonster* monster, cPlayer* hero, unsigned int racegender );	///   : Ƽ 
	void SendToPartyChangeJob( cPlayer* player );

	bool ResPartyList( cPlayer* player, cParty* party );
	bool ResPartyAddOne( unsigned long characterIdx, cParty* party );

	/// Ƽ Żó ( ƼŻ,  )
	void PartyOutPlayer( cPlayer* player );
	void PartyChangeLeader( cPlayer* fromPlayer, unsigned long toUserIdx );
	void PartyChangeDivide( cPlayer* fromPlayer, PARTY_DIVIDE_TYPE type );
	void PartyMapOut( cPlayer* hero );		/// Ƽ  ƿ( ü  )
	void PartyMapIn( cPlayer* player );		/// Ƽ   ( ü Ϸ )

	///// Ƽ ü (  )
	//void PartyBreak( cPlayer* player );
    
	// Ƽ û  ε ˻.
	unsigned long GetRequest( unsigned long recvIdx );

	///  ε ã
	unsigned long FindNext( cParty* party, unsigned long userIndex );
    
protected:
	///
	bool ResPartyMsgError( unsigned long connectionIdx, char protocol, long error );

public:
	static cPartyManager* Get();

private:
	/// Ƽε ʷ
	cIndexGenerator	mPartyIndexGen;
    
	/// üƼ Ǯ
	typedef tPool<cParty> cPartyPool;
	cPartyPool mPartyPool;
	
	/// ü Ƽ 
	typedef tPointerHashMap<unsigned long, void*> cPartyMap;
	cPartyMap mPartyMap;

	/// Ƽû
	typedef tHashMap<unsigned long, unsigned long> cJoinMap;
	cJoinMap mJoinMap;
};

inline cPartyManager* cPartyManager::Get()
{
	return mpSingleton;
}

inline cParty* cPartyManager::AllocParty()
{
	return mPartyPool.Alloc();
}

inline void cPartyManager::FreeParty( cParty* party )
{
	mPartyPool.Free( party );
}

#define PARTYMAN cPartyManager::Get()
